/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.autotrack.page;

import android.text.TextUtils;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class Page<T> {
    private static final int MAX_PAGE_LEVEL = 3;
    private final T mCarrier;
    private Page<?> mParent;
    private long mShowTimestamp;
    private boolean mIsIgnored = false;
    private String mAlias;
    private String mTitle;
    private String mPath;
    private Map<String, String> mAttributes;
    private final List<Page<?>> mChildren = new ArrayList();

    Page(T carrier) {
        this.mCarrier = carrier;
        this.mShowTimestamp = System.currentTimeMillis();
    }

    public T getCarrier() {
        return this.mCarrier;
    }

    public void refreshShowTimestamp() {
        this.mShowTimestamp = System.currentTimeMillis();
    }

    public boolean isIgnored() {
        return this.mIsIgnored;
    }

    public void setIgnored(boolean ignored) {
        this.mIsIgnored = ignored;
    }

    public long getShowTimestamp() {
        return this.mShowTimestamp;
    }

    public Map<String, String> getAttributes() {
        return this.mAttributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.mAttributes = attributes;
    }

    public abstract String getName();

    public abstract View getView();

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public String getAlias() {
        return this.mAlias;
    }

    public void setAlias(String alias) {
        this.mAlias = alias;
    }

    public void assignParent(Page<?> parent) {
        this.mParent = parent;
    }

    public Page<?> getParent() {
        return this.mParent;
    }

    abstract String getTag();

    public void addChildren(Page<?> page) {
        this.mChildren.add(page);
    }

    public List<Page<?>> getAllChildren() {
        return this.mChildren;
    }

    void removeChildren(Page<?> child) {
        this.mChildren.remove(child);
    }

    public String path() {
        if (!TextUtils.isEmpty((CharSequence)this.mPath)) {
            return this.mPath;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAlias)) {
            this.mPath = "/" + this.mAlias;
            return this.mPath;
        }
        ArrayList pageTree = new ArrayList();
        pageTree.add(this);
        int pageLevel = 1;
        boolean hasMoreParent = false;
        for (Page<?> parent = this.getParent(); parent != null; parent = parent.getParent()) {
            pageTree.add(parent);
            if (++pageLevel >= 3) {
                hasMoreParent = parent.getParent() != null;
                break;
            }
            if (!TextUtils.isEmpty((CharSequence)parent.getAlias())) break;
        }
        StringBuilder path = new StringBuilder();
        for (int i = pageTree.size() - 1; i >= 0; --i) {
            Page page = (Page)pageTree.get(i);
            if (hasMoreParent && i == pageTree.size() - 1) {
                path.append("*/");
            } else {
                path.append("/");
            }
            path.append(page.getName());
        }
        this.mPath = path.toString();
        return this.mPath;
    }
}

