/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.autotrack.page;

import android.content.res.Resources;
import android.text.TextUtils;
import android.view.View;
import com.growingio.android.sdk.autotrack.page.Page;
import com.growingio.android.sdk.autotrack.page.SuperFragment;

public class FragmentPage
extends Page<SuperFragment<?>> {
    public FragmentPage(SuperFragment<?> carrier) {
        super(carrier);
    }

    @Override
    public String getName() {
        if (!TextUtils.isEmpty((CharSequence)this.getAlias())) {
            return this.getAlias();
        }
        String tag = this.getTag();
        if (TextUtils.isEmpty((CharSequence)tag)) {
            tag = "-";
        }
        return "" + ((SuperFragment)this.getCarrier()).getRealFragment().getClass().getSimpleName() + "[" + tag + "]";
    }

    @Override
    public View getView() {
        return ((SuperFragment)this.getCarrier()).getView();
    }

    @Override
    String getTag() {
        String tag = ((SuperFragment)this.getCarrier()).getTag();
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            return this.transformSwitcherTag(tag);
        }
        int id2 = ((SuperFragment)this.getCarrier()).getId();
        if (id2 > 0) {
            try {
                return ((SuperFragment)this.getCarrier()).getResources().getResourceEntryName(id2);
            }
            catch (Resources.NotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String transformSwitcherTag(String tag) {
        String[] e = tag.split(":");
        if (e.length == 4) {
            try {
                e[2] = ((SuperFragment)this.getCarrier()).getResources().getResourceEntryName(Integer.parseInt(e[2]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            StringBuilder stringBuilder = new StringBuilder(e[0]);
            for (int i = 1; i < e.length; ++i) {
                stringBuilder.append(":").append(e[i]);
            }
            return stringBuilder.toString();
        }
        return tag;
    }
}

