/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.autotrack.inject;

import android.view.View;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.modelloader.ModelLoader;
import com.growingio.android.sdk.track.modelloader.data.HybridBridge;
import com.growingio.sdk.inject.annotation.Before;
import com.tencent.smtt.sdk.WebView;
import java.util.Map;

public class WebViewInjector {
    private static final String TAG = "WebViewInjector";

    private static void bridgeForWebView(View view) {
        if (!TrackerContext.initializedSuccessfully()) {
            Logger.e((String)TAG, (String)"Autotracker do not initialized successfully", (Object[])new Object[0]);
            return;
        }
        boolean result = false;
        ModelLoader modelLoader = TrackerContext.get().getRegistry().getModelLoader(HybridBridge.class, Boolean.class);
        if (modelLoader != null) {
            result = (Boolean)modelLoader.buildLoadData((Object)new HybridBridge((View)view)).fetcher.executeData();
        }
        Logger.d((String)TAG, (String)("bridgeForWebView: webView = " + view.getClass().getName() + ", result = " + result), (Object[])new Object[0]);
    }

    private WebViewInjector() {
    }

    @Before(clazz=android.webkit.WebView.class, method="loadUrl", parameterTypes={String.class})
    public static void webkitWebViewLoadUrl(android.webkit.WebView webView, String url) {
        Logger.d((String)TAG, (String)("webkitWebViewLoadUrl: webView = " + webView.getClass().getName() + ", url = " + url), (Object[])new Object[0]);
        WebViewInjector.bridgeForWebView((View)webView);
    }

    @Before(clazz=android.webkit.WebView.class, method="loadUrl", parameterTypes={String.class, Map.class})
    public static void webkitWebViewLoadUrl(android.webkit.WebView webView, String url, Map<String, String> additionalHttpHeaders) {
        Logger.d((String)TAG, (String)("webkitWebViewLoadUrl: webView = " + webView.getClass().getName() + ", url = " + url + ", additionalHttpHeaders = " + additionalHttpHeaders), (Object[])new Object[0]);
        WebViewInjector.bridgeForWebView((View)webView);
    }

    @Before(clazz=android.webkit.WebView.class, method="loadData", parameterTypes={String.class, String.class, String.class})
    public static void webkitWebViewLoadData(android.webkit.WebView webView, String data, String mimeType, String encoding) {
        Logger.d((String)TAG, (String)("webkitWebViewLoadData: webView = " + webView.getClass().getName()), (Object[])new Object[0]);
        WebViewInjector.bridgeForWebView((View)webView);
    }

    @Before(clazz=android.webkit.WebView.class, method="loadDataWithBaseURL", parameterTypes={String.class, String.class, String.class, String.class, String.class})
    public static void webkitWebViewLoadDataWithBaseURL(android.webkit.WebView webView, String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        Logger.d((String)TAG, (String)("webkitWebViewLoadDataWithBaseURL: webView = " + webView.getClass().getName()), (Object[])new Object[0]);
        WebViewInjector.bridgeForWebView((View)webView);
    }

    @Before(clazz=android.webkit.WebView.class, method="postUrl", parameterTypes={String.class, byte[].class})
    public static void webkitWebViewPostUrl(android.webkit.WebView webView, String url, byte[] postData) {
        Logger.d((String)TAG, (String)("webkitWebViewPostUrl: webView = " + webView.getClass().getName()), (Object[])new Object[0]);
        WebViewInjector.bridgeForWebView((View)webView);
    }

    @Before(clazz=WebView.class, method="loadUrl", parameterTypes={String.class})
    public static void x5WebViewLoadUrl(View webView, String url) {
        Logger.d((String)TAG, (String)("x5WebViewLoadUrl: webView = " + webView.getClass().getName() + ", url = " + url), (Object[])new Object[0]);
        WebViewInjector.bridgeForWebView(webView);
    }

    @Before(clazz=WebView.class, method="loadUrl", parameterTypes={String.class, Map.class})
    public static void x5WebViewLoadUrl(View webView, String url, Map<String, String> additionalHttpHeaders) {
        Logger.d((String)TAG, (String)("x5WebViewLoadUrl: webView = " + webView.getClass().getName() + ", url = " + url + ", additionalHttpHeaders = " + additionalHttpHeaders), (Object[])new Object[0]);
        WebViewInjector.bridgeForWebView(webView);
    }

    @Before(clazz=WebView.class, method="loadData", parameterTypes={String.class, String.class, String.class})
    public static void x5WebViewLoadData(View webView, String data, String mimeType, String encoding) {
        Logger.d((String)TAG, (String)("x5WebViewLoadData: webView = " + webView.getClass().getName()), (Object[])new Object[0]);
        WebViewInjector.bridgeForWebView(webView);
    }

    @Before(clazz=WebView.class, method="loadDataWithBaseURL", parameterTypes={String.class, String.class, String.class, String.class, String.class})
    public static void x5WebViewLoadDataWithBaseURL(View webView, String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        Logger.d((String)TAG, (String)("x5WebViewLoadDataWithBaseURL: webView = " + webView.getClass().getName()), (Object[])new Object[0]);
        WebViewInjector.bridgeForWebView(webView);
    }

    @Before(clazz=WebView.class, method="postUrl", parameterTypes={String.class, byte[].class})
    public static void x5WebViewPostUrl(View webView, String url, byte[] postData) {
        Logger.d((String)TAG, (String)("x5WebViewPostUrl: webView = " + webView.getClass().getName()), (Object[])new Object[0]);
        WebViewInjector.bridgeForWebView(webView);
    }

    @Before(clazz=com.uc.webview.export.WebView.class, method="loadUrl", parameterTypes={String.class})
    public static void ucWebViewLoadUrl(View webView, String url) {
        Logger.d((String)TAG, (String)("ucWebViewLoadUrl: webView = " + webView.getClass().getName() + ", url = " + url), (Object[])new Object[0]);
        WebViewInjector.bridgeForWebView(webView);
    }

    @Before(clazz=com.uc.webview.export.WebView.class, method="loadUrl", parameterTypes={String.class, Map.class})
    public static void ucWebViewLoadUrl(View webView, String url, Map<String, String> additionalHttpHeaders) {
        Logger.d((String)TAG, (String)("ucWebViewLoadUrl: webView = " + webView.getClass().getName() + ", url = " + url + ", additionalHttpHeaders = " + additionalHttpHeaders), (Object[])new Object[0]);
        WebViewInjector.bridgeForWebView(webView);
    }

    @Before(clazz=com.uc.webview.export.WebView.class, method="loadData", parameterTypes={String.class, String.class, String.class})
    public static void ucWebViewLoadData(View webView, String data, String mimeType, String encoding) {
        Logger.d((String)TAG, (String)("ucWebViewLoadData: webView = " + webView.getClass().getName()), (Object[])new Object[0]);
        WebViewInjector.bridgeForWebView(webView);
    }

    @Before(clazz=com.uc.webview.export.WebView.class, method="loadDataWithBaseURL", parameterTypes={String.class, String.class, String.class, String.class, String.class})
    public static void ucWebViewLoadDataWithBaseURL(View webView, String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        Logger.d((String)TAG, (String)("ucWebViewLoadDataWithBaseURL: webView = " + webView.getClass().getName()), (Object[])new Object[0]);
        WebViewInjector.bridgeForWebView(webView);
    }

    @Before(clazz=com.uc.webview.export.WebView.class, method="postUrl", parameterTypes={String.class, byte[].class})
    public static void ucWebViewPostUrl(View webView, String url, byte[] postData) {
        Logger.d((String)TAG, (String)("ucWebViewPostUrl: webView = " + webView.getClass().getName()), (Object[])new Object[0]);
        WebViewInjector.bridgeForWebView(webView);
    }
}

