/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.autotrack.impression;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.Nullable;
import com.growingio.android.sdk.autotrack.AutotrackConfig;
import com.growingio.android.sdk.autotrack.impression.ViewImpression;
import com.growingio.android.sdk.autotrack.page.Page;
import com.growingio.android.sdk.autotrack.page.PageProvider;
import com.growingio.android.sdk.autotrack.view.ViewHelper;
import com.growingio.android.sdk.track.TrackMainThread;
import com.growingio.android.sdk.track.events.PageLevelCustomEvent;
import com.growingio.android.sdk.track.events.base.BaseEvent;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;
import com.growingio.android.sdk.track.providers.ConfigurationProvider;
import com.growingio.android.sdk.track.utils.ActivityUtil;
import com.growingio.android.sdk.track.view.OnViewStateChangedListener;
import com.growingio.android.sdk.track.view.ViewStateChangedEvent;
import com.growingio.android.sdk.track.view.ViewTreeStatusProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class ImpressionProvider
implements OnViewStateChangedListener {
    private static final String TAG = "ImpressionProvider";
    private static final int CHECK_IMPRESSION_ANTI_SHAKE_TIME = 500;
    private static final Map<Activity, List<ViewImpression>> ACTIVITY_SCOPE = new WeakHashMap<Activity, List<ViewImpression>>();
    private final float mImpressionScale;
    private final Handler mUiHandler;
    private volatile boolean mStarted = false;
    private final Runnable mCheckImpressionRunnable = new Runnable(){

        @Override
        public void run() {
            ImpressionProvider.this.checkImpression();
        }
    };

    private ImpressionProvider() {
        AutotrackConfig configuration = (AutotrackConfig)ConfigurationProvider.get().getConfiguration(AutotrackConfig.class);
        this.mImpressionScale = configuration.getImpressionScale();
        this.mUiHandler = new Handler(Looper.getMainLooper());
    }

    public static ImpressionProvider get() {
        return SingleInstance.INSTANCE;
    }

    public void onViewStateChanged(ViewStateChangedEvent changedEvent) {
        this.delayCheckImpression();
    }

    private void delayCheckImpression() {
        this.mUiHandler.removeCallbacks(this.mCheckImpressionRunnable);
        this.mUiHandler.postDelayed(this.mCheckImpressionRunnable, 500L);
    }

    private void checkImpression() {
        Activity activity = ActivityStateProvider.get().getResumedActivity();
        List<ViewImpression> viewImpressions = ACTIVITY_SCOPE.get(activity);
        if (activity == null || viewImpressions == null || viewImpressions.isEmpty()) {
            Logger.e((String)TAG, (String)"ResumedActivity is NULL or This activity has nothing impression", (Object[])new Object[0]);
            return;
        }
        for (ViewImpression impression : viewImpressions) {
            View trackedView = impression.getTrackedView();
            if (trackedView == null) continue;
            boolean lastVisible = impression.isLastVisible();
            boolean currentVisible = this.isVisibility(trackedView);
            if (currentVisible && !lastVisible) {
                this.sendViewImpressionEvent(impression);
            }
            impression.setLastVisible(currentVisible);
        }
    }

    private boolean isVisibility(View view) {
        if (ViewHelper.viewVisibilityInParents(view)) {
            if (this.mImpressionScale <= 0.0f) {
                return true;
            }
            Rect rect = new Rect();
            view.getLocalVisibleRect(rect);
            return (float)(rect.right * rect.bottom) >= (float)(view.getMeasuredHeight() * view.getMeasuredWidth()) * this.mImpressionScale;
        }
        return false;
    }

    private void sendViewImpressionEvent(ViewImpression impression) {
        View trackedView = impression.getTrackedView();
        if (trackedView == null) {
            return;
        }
        Page<?> page = PageProvider.get().findPage(trackedView);
        if (page == null) {
            Logger.e((String)TAG, (String)"sendViewImpressionEvent trackedView Activity is NULL", (Object[])new Object[0]);
            return;
        }
        TrackMainThread.trackMain().postEventToTrackMain((BaseEvent.BaseBuilder)new PageLevelCustomEvent.Builder().setEventName(impression.getImpressionEventName()).setAttributes(impression.getEventAttributes()).setPath(page.path()).setPageShowTimestamp(page.getShowTimestamp()));
    }

    private void start() {
        if (this.mStarted) {
            Logger.e((String)TAG, (String)"ImpressionProvider is running", (Object[])new Object[0]);
            return;
        }
        this.mStarted = true;
        ViewTreeStatusProvider.get().register((Object)this);
        Logger.d((String)TAG, (String)"ImpressionProvider started", (Object[])new Object[0]);
    }

    public void trackViewImpression(View view, String impressionEventName, Map<String, String> attributes) {
        Activity activity;
        if (view == null || TextUtils.isEmpty((CharSequence)impressionEventName)) {
            return;
        }
        if (ViewHelper.isIgnoredView(view)) {
            Logger.e((String)TAG, (String)"Current view is set to ignore", (Object[])new Object[0]);
            return;
        }
        if (!this.mStarted) {
            this.start();
        }
        if ((activity = this.findViewActivity(view)) == null) {
            Logger.e((String)TAG, (String)"View context activity is NULL", (Object[])new Object[0]);
            return;
        }
        List<ViewImpression> viewImpressions = ACTIVITY_SCOPE.get(activity);
        if (viewImpressions == null) {
            viewImpressions = new ArrayList<ViewImpression>();
            ACTIVITY_SCOPE.put(activity, viewImpressions);
        }
        for (int i = 0; i < viewImpressions.size(); ++i) {
            if (viewImpressions.get(i).getTrackedView() != view) continue;
            viewImpressions.remove(i);
            break;
        }
        viewImpressions.add(new ViewImpression(view, impressionEventName, attributes));
        this.delayCheckImpression();
    }

    public boolean hasTrackViewImpression(View trackedView) {
        if (trackedView == null) {
            return false;
        }
        Activity activity = this.findViewActivity(trackedView);
        if (activity == null) {
            Logger.e((String)TAG, (String)"TrackedView context activity is NULL", (Object[])new Object[0]);
            return false;
        }
        List<ViewImpression> viewImpressions = ACTIVITY_SCOPE.get(activity);
        if (viewImpressions == null || viewImpressions.isEmpty()) {
            Logger.e((String)TAG, (String)"ViewImpressions is NULL", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    public void stopTrackViewImpression(View trackedView) {
        if (trackedView == null) {
            return;
        }
        Activity activity = this.findViewActivity(trackedView);
        if (activity == null) {
            Logger.e((String)TAG, (String)"TrackedView context activity is NULL", (Object[])new Object[0]);
            return;
        }
        List<ViewImpression> viewImpressions = ACTIVITY_SCOPE.get(activity);
        if (viewImpressions == null || viewImpressions.isEmpty()) {
            Logger.e((String)TAG, (String)"ViewImpressions is NULL", (Object[])new Object[0]);
            return;
        }
        for (int i = 0; i < viewImpressions.size(); ++i) {
            if (viewImpressions.get(i).getTrackedView() != trackedView) continue;
            viewImpressions.remove(i);
            break;
        }
    }

    @Nullable
    private Activity findViewActivity(View view) {
        Activity activity = ActivityUtil.findActivity((View)view);
        if (activity == null) {
            Logger.e((String)TAG, (String)"View context activity is NULL", (Object[])new Object[0]);
            activity = ActivityStateProvider.get().getResumedActivity();
        }
        return activity;
    }

    private static class SingleInstance {
        private static final ImpressionProvider INSTANCE = new ImpressionProvider();

        private SingleInstance() {
        }
    }
}

