/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.autotrack.click;

import android.app.Activity;
import android.app.AlertDialog;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.ListView;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.autotrack.page.Page;
import com.growingio.android.sdk.autotrack.page.PageProvider;
import com.growingio.android.sdk.autotrack.shadow.AlertControllerShadow;
import com.growingio.android.sdk.autotrack.util.ClassUtil;
import com.growingio.android.sdk.autotrack.view.ViewAttributeUtil;
import com.growingio.android.sdk.autotrack.view.ViewHelper;
import com.growingio.android.sdk.autotrack.view.ViewNode;
import com.growingio.android.sdk.track.TrackMainThread;
import com.growingio.android.sdk.track.events.ViewElementEvent;
import com.growingio.android.sdk.track.events.base.BaseEvent;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;
import com.growingio.android.sdk.track.utils.ThreadUtils;

class ViewClickProvider {
    private static final String TAG = "ViewClickProvider";
    private static final int[] DIALOG_BUTTON_IDS = new int[]{-3, -2, -1};
    private static final String[] DIALOG_BUTTON_NAMES = new String[]{"BUTTON_NEUTRAL", "BUTTON_NEGATIVE", "BUTTON_POSITIVE"};

    private ViewClickProvider() {
    }

    public static void alertDialogOnClick(AlertDialog dialog, int which) {
        Logger.d((String)TAG, (String)("alertDialogOnClick: which = " + which), (Object[])new Object[0]);
        if (which < 0) {
            Button button = dialog.getButton(which);
            if (button != null) {
                ViewClickProvider.viewOnClick((View)button);
            }
        } else {
            ListView listView = dialog.getListView();
            if (listView != null) {
                ViewClickProvider.viewOnClick(listView.getChildAt(which - listView.getFirstVisiblePosition()));
            }
        }
    }

    public static void alertDialogShow(final AlertDialog dialog) {
        if (!TrackerContext.initializedSuccessfully()) {
            Logger.e((String)TAG, (String)"Autotracker do not initialized successfully", (Object[])new Object[0]);
            return;
        }
        if (dialog == null) {
            Logger.d((String)TAG, (String)"alertDialogShow: dialog is NULL", (Object[])new Object[0]);
            return;
        }
        Logger.d((String)TAG, (String)("alertDialogShow: " + dialog), (Object[])new Object[0]);
        for (int i = 0; i < DIALOG_BUTTON_IDS.length; ++i) {
            final Button button = dialog.getButton(DIALOG_BUTTON_IDS[i]);
            if (button == null || !TextUtils.isEmpty((CharSequence)ViewAttributeUtil.getCustomId((View)button))) continue;
            final String dialogButtonName = DIALOG_BUTTON_NAMES[i];
            ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ViewAttributeUtil.setCustomId((View)button, ViewClickProvider.getAlertDialogName(dialog) + "/" + dialogButtonName);
                }
            });
        }
    }

    private static String getAlertDialogName(AlertDialog dialog) {
        String className = ClassUtil.getSimpleClassName(dialog.getClass());
        try {
            AlertControllerShadow alertControllerShadow = new AlertControllerShadow(dialog);
            CharSequence title = alertControllerShadow.getTitle();
            if (!TextUtils.isEmpty((CharSequence)title)) {
                return className + "/" + title;
            }
            CharSequence message = alertControllerShadow.getMessage();
            if (!TextUtils.isEmpty((CharSequence)message)) {
                return className + "/" + message;
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (Throwable)e);
        }
        return className;
    }

    public static void viewOnClick(View view) {
        if (!TrackerContext.initializedSuccessfully()) {
            Logger.e((String)TAG, (String)"Autotracker do not initialized successfully", (Object[])new Object[0]);
            return;
        }
        ViewNode viewNode = ViewHelper.getClickViewNode(view);
        if (viewNode != null) {
            Page<?> page = PageProvider.get().findPage(view);
            ViewClickProvider.sendClickEvent(page, viewNode);
        } else {
            Logger.e((String)TAG, (String)"ViewNode is NULL", (Object[])new Object[0]);
        }
    }

    public static void menuItemOnClick(Activity activity, MenuItem menuItem) {
        if (!TrackerContext.initializedSuccessfully()) {
            Logger.e((String)TAG, (String)"Autotracker do not initialized successfully", (Object[])new Object[0]);
            return;
        }
        if (activity == null || menuItem == null) {
            Logger.e((String)TAG, (String)"menuItemOnClick: activity or menuItem is NULL", (Object[])new Object[0]);
            return;
        }
        Page<?> page = PageProvider.get().findPage(activity);
        ViewNode viewNode = ViewHelper.getMenuItemViewNode(page, menuItem);
        if (viewNode != null) {
            ViewClickProvider.sendClickEvent(page, viewNode);
        } else {
            Logger.e((String)TAG, (String)"MenuItem ViewNode is NULL", (Object[])new Object[0]);
        }
    }

    public static void menuItemOnClick(MenuItem menuItem) {
        if (!TrackerContext.initializedSuccessfully()) {
            Logger.e((String)TAG, (String)"Autotracker do not initialized successfully", (Object[])new Object[0]);
            return;
        }
        Activity activity = ActivityStateProvider.get().getForegroundActivity();
        ViewClickProvider.menuItemOnClick(activity, menuItem);
    }

    private static void sendClickEvent(Page<?> page, ViewNode viewNode) {
        if (page == null) {
            Logger.e((String)TAG, (String)"sendClickEvent page Activity is NULL", (Object[])new Object[0]);
            return;
        }
        TrackMainThread.trackMain().postEventToTrackMain((BaseEvent.BaseBuilder)new ViewElementEvent.Builder().setEventType("VIEW_CLICK").setPath(page.path()).setPageShowTimestamp(page.getShowTimestamp()).setXpath(viewNode.getXPath()).setIndex(viewNode.getIndex()).setTextValue(viewNode.getViewContent()));
    }
}

