/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.autotrack.change;

import android.app.Activity;
import android.view.View;
import android.widget.EditText;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.autotrack.page.Page;
import com.growingio.android.sdk.autotrack.page.PageProvider;
import com.growingio.android.sdk.autotrack.view.ViewHelper;
import com.growingio.android.sdk.autotrack.view.ViewNode;
import com.growingio.android.sdk.track.TrackMainThread;
import com.growingio.android.sdk.track.events.ViewElementEvent;
import com.growingio.android.sdk.track.events.base.BaseEvent;
import com.growingio.android.sdk.track.listener.IActivityLifecycle;
import com.growingio.android.sdk.track.listener.event.ActivityLifecycleEvent;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;
import com.growingio.android.sdk.track.view.OnViewStateChangedListener;
import com.growingio.android.sdk.track.view.ViewStateChangedEvent;
import com.growingio.android.sdk.track.view.ViewTreeStatusProvider;

public class ViewChangeProvider
implements IActivityLifecycle,
OnViewStateChangedListener {
    private static final String TAG = "ViewChangeProvider";

    public void setup() {
        ActivityStateProvider.get().registerActivityLifecycleListener((IActivityLifecycle)this);
        ViewTreeStatusProvider.get().register((Object)this);
    }

    public void onActivityLifecycle(ActivityLifecycleEvent event) {
        if (event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_PAUSED) {
            Activity activity = event.getActivity();
            if (activity == null) {
                return;
            }
            View focusView = activity.getWindow().getDecorView().findFocus();
            if (focusView instanceof EditText) {
                Logger.d((String)TAG, (String)"onActivityPaused, and focus view is EditText", (Object[])new Object[0]);
                ViewChangeProvider.viewOnChange(focusView);
            }
        }
    }

    public void onViewStateChanged(ViewStateChangedEvent changedEvent) {
        View oldFocus;
        if (changedEvent.getStateType() == ViewStateChangedEvent.StateType.FOCUS_CHANGED && (oldFocus = changedEvent.getOldFocus()) instanceof EditText) {
            Logger.d((String)TAG, (String)"onViewStateChanged, and oldFocus view is EditText", (Object[])new Object[0]);
            ViewChangeProvider.viewOnChange(oldFocus);
        }
    }

    public static void viewOnChange(View view) {
        ViewNode viewNode;
        if (!TrackerContext.initializedSuccessfully()) {
            Logger.e((String)TAG, (String)"Autotracker do not initialized successfully", (Object[])new Object[0]);
        }
        if ((viewNode = ViewHelper.getChangeViewNode(view)) != null) {
            ViewChangeProvider.sendChangeEvent(viewNode);
        } else {
            Logger.e((String)TAG, (String)"ViewNode is NULL", (Object[])new Object[0]);
        }
    }

    private static void sendChangeEvent(ViewNode viewNode) {
        Page<?> page = PageProvider.get().findPage(viewNode.getView());
        if (page == null) {
            Logger.e((String)TAG, (String)"sendChangeEvent page Activity is NULL", (Object[])new Object[0]);
            return;
        }
        TrackMainThread.trackMain().postEventToTrackMain((BaseEvent.BaseBuilder)new ViewElementEvent.Builder().setEventType("VIEW_CHANGE").setPath(page.path()).setPageShowTimestamp(page.getShowTimestamp()).setXpath(viewNode.getXPath()).setIndex(viewNode.getIndex()).setTextValue(viewNode.getViewContent()));
    }
}

