/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.autotrack;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.support.annotation.CallSuper;
import android.text.TextUtils;
import android.view.View;
import com.growingio.android.sdk.Tracker;
import com.growingio.android.sdk.autotrack.IgnorePolicy;
import com.growingio.android.sdk.autotrack.change.ViewChangeProvider;
import com.growingio.android.sdk.autotrack.impression.ImpressionProvider;
import com.growingio.android.sdk.autotrack.page.PageProvider;
import com.growingio.android.sdk.autotrack.page.SuperFragment;
import com.growingio.android.sdk.autotrack.view.ViewAttributeUtil;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.utils.ThreadUtils;
import java.util.HashMap;
import java.util.Map;

public class Autotracker
extends Tracker {
    private static final String TAG = "Autotracker";

    public Autotracker(Application application) {
        super(application);
    }

    @CallSuper
    protected void setup(Application application) {
        super.setup(application);
        PageProvider.get().setup();
        ViewChangeProvider mViewChangeProvider = new ViewChangeProvider();
        mViewChangeProvider.setup();
    }

    public void setUniqueTag(final View view, final String tag) {
        if (!this.isInited) {
            return;
        }
        if (view == null || TextUtils.isEmpty((CharSequence)tag)) {
            Logger.e((String)TAG, (String)"setUniqueTag: view or tag is NULL", (Object[])new Object[0]);
            return;
        }
        ThreadUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ViewAttributeUtil.setCustomId(view, tag);
            }
        });
    }

    private void trackCustomEvent(String eventName, Activity page) {
    }

    private void trackCustomEvent(String eventName, Fragment page) {
    }

    private void trackCustomEventSupport(String eventName, android.support.v4.app.Fragment page) {
    }

    private void trackCustomEventX(String eventName, androidx.fragment.app.Fragment page) {
    }

    private void trackCustomEvent(String eventName, Map<String, String> attributes, Activity page) {
    }

    private void trackCustomEvent(String eventName, Map<String, String> attributes, Fragment page) {
    }

    private void trackCustomEventSupport(String eventName, Map<String, String> attributes, android.support.v4.app.Fragment page) {
    }

    private void trackCustomEventX(String eventName, Map<String, String> attributes, androidx.fragment.app.Fragment page) {
    }

    public void setPageAttributes(Activity page, Map<String, String> attributes) {
        if (!this.isInited) {
            return;
        }
        if (page == null || attributes == null || attributes.isEmpty()) {
            Logger.e((String)TAG, (String)"page or attributes is NULL", (Object[])new Object[0]);
            return;
        }
        ThreadUtils.runOnUiThread(() -> PageProvider.get().setPageAttributes(page, new HashMap<String, String>(attributes)));
    }

    public void setPageAttributes(final Fragment page, final Map<String, String> attributes) {
        if (!this.isInited) {
            return;
        }
        if (page == null || attributes == null || attributes.isEmpty()) {
            Logger.e((String)TAG, (String)"page or attributes is NULL", (Object[])new Object[0]);
            return;
        }
        ThreadUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PageProvider.get().setPageAttributes(SuperFragment.make(page), new HashMap<String, String>(attributes));
            }
        });
    }

    public void setPageAttributesSupport(final android.support.v4.app.Fragment page, final Map<String, String> attributes) {
        if (!this.isInited) {
            return;
        }
        if (page == null || attributes == null || attributes.isEmpty()) {
            Logger.e((String)TAG, (String)"page or attributes is NULL", (Object[])new Object[0]);
            return;
        }
        ThreadUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PageProvider.get().setPageAttributes(SuperFragment.makeSupport(page), new HashMap<String, String>(attributes));
            }
        });
    }

    public void setPageAttributesX(final androidx.fragment.app.Fragment page, final Map<String, String> attributes) {
        if (!this.isInited) {
            return;
        }
        if (page == null || attributes == null || attributes.isEmpty()) {
            Logger.e((String)TAG, (String)"page or attributes is NULL", (Object[])new Object[0]);
            return;
        }
        ThreadUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PageProvider.get().setPageAttributes(SuperFragment.makeX(page), new HashMap<String, String>(attributes));
            }
        });
    }

    public void trackViewImpression(View view, String impressionEventName) {
        if (!this.isInited) {
            return;
        }
        this.trackViewImpression(view, impressionEventName, null);
    }

    public void trackViewImpression(View view, String impressionEventName, Map<String, String> attributes) {
        if (!this.isInited) {
            return;
        }
        if (view == null || TextUtils.isEmpty((CharSequence)impressionEventName)) {
            Logger.e((String)TAG, (String)"view or impressionEventName is NULL", (Object[])new Object[0]);
            return;
        }
        HashMap<String, String> attributesCopy = attributes == null ? null : new HashMap<String, String>(attributes);
        ThreadUtils.runOnUiThread(() -> ImpressionProvider.get().trackViewImpression(view, impressionEventName, attributesCopy));
    }

    public void stopTrackViewImpression(View trackedView) {
        if (!this.isInited) {
            return;
        }
        if (trackedView == null) {
            Logger.e((String)TAG, (String)"trackedView is NULL", (Object[])new Object[0]);
            return;
        }
        ThreadUtils.runOnUiThread(() -> ImpressionProvider.get().stopTrackViewImpression(trackedView));
    }

    public void setPageAlias(Activity page, String alias) {
        if (!this.isInited) {
            return;
        }
        if (page == null || TextUtils.isEmpty((CharSequence)alias)) {
            Logger.e((String)TAG, (String)"activity or alias is NULL", (Object[])new Object[0]);
            return;
        }
        ThreadUtils.runOnUiThread(() -> PageProvider.get().setActivityAlias(page, alias));
    }

    public void setPageAlias(final Fragment page, final String alias) {
        if (!this.isInited) {
            return;
        }
        if (page == null || TextUtils.isEmpty((CharSequence)alias)) {
            Logger.e((String)TAG, (String)"fragment or alias is NULL", (Object[])new Object[0]);
            return;
        }
        ThreadUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PageProvider.get().setFragmentAlias(SuperFragment.make(page), alias);
            }
        });
    }

    public void setPageAliasSupport(final android.support.v4.app.Fragment page, final String alias) {
        if (!this.isInited) {
            return;
        }
        if (page == null || TextUtils.isEmpty((CharSequence)alias)) {
            Logger.e((String)TAG, (String)"fragment or alias is NULL", (Object[])new Object[0]);
            return;
        }
        ThreadUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PageProvider.get().setFragmentAlias(SuperFragment.makeSupport(page), alias);
            }
        });
    }

    public void setPageAliasX(final androidx.fragment.app.Fragment page, final String alias) {
        if (!this.isInited) {
            return;
        }
        if (page == null || TextUtils.isEmpty((CharSequence)alias)) {
            Logger.e((String)TAG, (String)"fragment or alias is NULL", (Object[])new Object[0]);
            return;
        }
        ThreadUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PageProvider.get().setFragmentAlias(SuperFragment.makeX(page), alias);
            }
        });
    }

    public void ignorePage(final Activity page, final IgnorePolicy policy) {
        if (!this.isInited) {
            return;
        }
        if (page == null || policy == null) {
            Logger.e((String)TAG, (String)"activity or policy is NULL", (Object[])new Object[0]);
            return;
        }
        ThreadUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PageProvider.get().addIgnoreActivity(page, policy);
            }
        });
    }

    public void ignorePage(final Fragment page, final IgnorePolicy policy) {
        if (!this.isInited) {
            return;
        }
        if (page == null || policy == null) {
            Logger.e((String)TAG, (String)"fragment or policy is NULL", (Object[])new Object[0]);
            return;
        }
        ThreadUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PageProvider.get().addIgnoreFragment(SuperFragment.make(page), policy);
            }
        });
    }

    public void ignorePageSupport(final android.support.v4.app.Fragment page, final IgnorePolicy policy) {
        if (!this.isInited) {
            return;
        }
        if (page == null || policy == null) {
            Logger.e((String)TAG, (String)"fragment or policy is NULL", (Object[])new Object[0]);
            return;
        }
        ThreadUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PageProvider.get().addIgnoreFragment(SuperFragment.makeSupport(page), policy);
            }
        });
    }

    public void ignorePageX(final androidx.fragment.app.Fragment page, final IgnorePolicy policy) {
        if (!this.isInited) {
            return;
        }
        if (page == null || policy == null) {
            Logger.e((String)TAG, (String)"fragment or policy is NULL", (Object[])new Object[0]);
            return;
        }
        ThreadUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PageProvider.get().addIgnoreFragment(SuperFragment.makeX(page), policy);
            }
        });
    }

    public void ignoreView(View view, IgnorePolicy policy) {
        if (!this.isInited) {
            return;
        }
        if (view == null || policy == null) {
            Logger.e((String)TAG, (String)"view or policy is NULL", (Object[])new Object[0]);
            return;
        }
        ThreadUtils.runOnUiThread(() -> ViewAttributeUtil.setIgnorePolicy(view, policy));
    }
}

