/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.autotrack;

import com.growingio.android.sdk.Configurable;
import com.growingio.android.sdk.CoreConfiguration;
import com.growingio.android.sdk.LibraryGioModule;
import com.growingio.android.sdk.autotrack.AutotrackConfig;
import com.growingio.android.sdk.autotrack.CdpAutotrackConfig;
import com.growingio.android.sdk.track.events.helper.EventExcludeFilter;
import com.growingio.android.sdk.track.events.helper.FieldIgnoreFilter;
import java.util.HashMap;

public final class CdpAutotrackConfiguration {
    private final CoreConfiguration coreConfiguration;
    private final HashMap<Class<? extends Configurable>, Configurable> MODULE_CONFIGURATIONS = new HashMap();

    public CdpAutotrackConfiguration(String projectId, String urlScheme) {
        this.coreConfiguration = new CoreConfiguration(projectId, urlScheme);
        this.addConfiguration((Configurable)new AutotrackConfig());
        this.addConfiguration(new CdpAutotrackConfig());
    }

    public CoreConfiguration core() {
        return this.coreConfiguration;
    }

    public HashMap<Class<? extends Configurable>, Configurable> getConfigModules() {
        return this.MODULE_CONFIGURATIONS;
    }

    public CdpAutotrackConfiguration addConfiguration(Configurable config) {
        if (config != null) {
            this.MODULE_CONFIGURATIONS.put(config.getClass(), config);
        }
        return this;
    }

    private <T> T getConfiguration(Class<T> clazz) {
        return (T)this.MODULE_CONFIGURATIONS.get(clazz);
    }

    public final CdpAutotrackConfiguration setImpressionScale(float scale) {
        this.getConfiguration(AutotrackConfig.class).setImpressionScale(scale);
        return this;
    }

    public final float getImpressionScale() {
        return this.getConfiguration(AutotrackConfig.class).getImpressionScale();
    }

    public final CdpAutotrackConfiguration setProject(String projectId, String urlScheme) {
        this.core().setProject(projectId, urlScheme);
        return this;
    }

    public final String getProjectId() {
        return this.core().getProjectId();
    }

    public final boolean isDataCollectionEnabled() {
        return this.core().isDataCollectionEnabled();
    }

    public final CdpAutotrackConfiguration setDataCollectionEnabled(boolean dataCollectionEnabled) {
        this.core().setDataCollectionEnabled(dataCollectionEnabled);
        return this;
    }

    public final String getUrlScheme() {
        return this.core().getUrlScheme();
    }

    public final String getChannel() {
        return this.core().getChannel();
    }

    public final CdpAutotrackConfiguration setChannel(String channel) {
        this.core().setChannel(channel);
        return this;
    }

    public final boolean isUploadExceptionEnabled() {
        return this.core().isUploadExceptionEnabled();
    }

    public final CdpAutotrackConfiguration setUploadExceptionEnabled(boolean uploadExceptionEnabled) {
        this.core().setUploadExceptionEnabled(uploadExceptionEnabled);
        return this;
    }

    public final boolean isDebugEnabled() {
        return this.core().isDebugEnabled();
    }

    public final CdpAutotrackConfiguration setDebugEnabled(boolean enabled) {
        this.core().setDebugEnabled(enabled);
        return this;
    }

    public final int getCellularDataLimit() {
        return this.core().getCellularDataLimit();
    }

    public final CdpAutotrackConfiguration setCellularDataLimit(int cellularDataLimit) {
        this.core().setCellularDataLimit(cellularDataLimit);
        return this;
    }

    public final int getDataUploadInterval() {
        return this.core().getDataUploadInterval();
    }

    public final CdpAutotrackConfiguration setDataUploadInterval(int dataUploadInterval) {
        this.core().setDataUploadInterval(dataUploadInterval);
        return this;
    }

    public final int getSessionInterval() {
        return this.core().getSessionInterval();
    }

    public final CdpAutotrackConfiguration setSessionInterval(int sessionInterval) {
        this.core().setSessionInterval(sessionInterval);
        return this;
    }

    public final String getDataCollectionServerHost() {
        return this.core().getDataCollectionServerHost();
    }

    public final CdpAutotrackConfiguration setDataCollectionServerHost(String dataCollectionServerHost) {
        this.core().setDataCollectionServerHost(dataCollectionServerHost);
        return this;
    }

    public final CdpAutotrackConfiguration setExcludeEvent(@EventExcludeFilter.EventFilterLimit int arg0) {
        this.core().setExcludeEvent(arg0);
        return this;
    }

    public final int getExcludeEvent() {
        return this.core().getExcludeEvent();
    }

    public final CdpAutotrackConfiguration setIgnoreField(@FieldIgnoreFilter.FieldFilterType int arg0) {
        this.core().setIgnoreField(arg0);
        return this;
    }

    public final int getIgnoreField() {
        return this.core().getIgnoreField();
    }

    @Deprecated
    public final CdpAutotrackConfiguration setPreloadComponent(LibraryGioModule component) {
        this.core().setPreloadComponent(component);
        return this;
    }

    public final CdpAutotrackConfiguration addPreloadComponent(LibraryGioModule component) {
        this.core().addPreloadComponent(component);
        return this;
    }

    public final boolean isIdMappingEnabled() {
        return this.core().isIdMappingEnabled();
    }

    public final CdpAutotrackConfiguration setIdMappingEnabled(boolean enabled) {
        this.core().setIdMappingEnabled(enabled);
        return this;
    }

    public final boolean isRequireAppProcessesEnabled() {
        return this.core().isRequireAppProcessesEnabled();
    }

    public final CdpAutotrackConfiguration setRequireAppProcessesEnabled(boolean enabled) {
        this.core().setRequireAppProcessesEnabled(enabled);
        return this;
    }

    public final String getDataSourceId() {
        return this.getConfiguration(CdpAutotrackConfig.class).getDataSourceId();
    }

    public final CdpAutotrackConfiguration setDataSourceId(String dataSourceId) {
        this.getConfiguration(CdpAutotrackConfig.class).setDataSourceId(dataSourceId);
        return this;
    }
}

