/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.removal.varargs;

import com.groupcdg.arcmutate.mutators.MethodLocation;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.Type;

public class VarArgsVisitor
extends MethodVisitor {
    private final MethodMutatorFactory factory;
    private final MutationContext context;

    public VarArgsVisitor(MutationContext context, MethodVisitor writer, MethodMutatorFactory factory) {
        super(589824, writer);
        this.factory = factory;
        this.context = context;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        Type lastArg = this.getLastArgumentType(desc);
        if (lastArg != null && lastArg.getSort() == 9 && !this.isMultiDimensional(lastArg)) {
            MethodLocation location = MethodLocation.location(ClassName.fromString((String)owner), name, desc);
            MutationIdentifier newId = this.context.registerMutation(this.factory, "removed last varargs argument in call to " + location.methodName());
            if (this.context.shouldMutate(newId)) {
                this.mv.visitInsn(89);
                this.mv.visitInsn(190);
                this.mv.visitInsn(4);
                this.mv.visitInsn(100);
                this.resizeArray(lastArg);
            }
        }
        this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    private Type getLastArgumentType(String desc) {
        Type[] args = Type.getArgumentTypes((String)desc);
        if (args.length == 0) {
            return null;
        }
        return args[args.length - 1];
    }

    private boolean isMultiDimensional(Type type) {
        return type.getDescriptor().startsWith("[[");
    }

    private void resizeArray(Type type) {
        if (type.getElementType().getSort() == 10) {
            String desc = "[Ljava/lang/Object;";
            this.mv.visitMethodInsn(184, "java/util/Arrays", "copyOf", "(" + desc + "I)" + desc, false);
            this.mv.visitTypeInsn(192, type.getDescriptor());
        } else {
            String desc = type.getDescriptor();
            this.mv.visitMethodInsn(184, "java/util/Arrays", "copyOf", "(" + desc + "I)" + desc, false);
        }
    }
}

