/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.removal.varargs;

import com.groupcdg.arcmutate.AnalysingInterceptor;
import com.groupcdg.arcmutate.mutators.removal.varargs.VarargsMutator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MutationDetails;

public class VarArgsInterceptor
extends AnalysingInterceptor {
    private final ClassByteArraySource source;
    private final Map<Location, Boolean> varArgsMethods = new HashMap<Location, Boolean>();

    public VarArgsInterceptor(ClassByteArraySource source) {
        this.source = source;
    }

    @Override
    public Stream<MutationDetails> intercept(Collection<MutationDetails> mutants) {
        return mutants.stream().filter(this.isJunkVarargsMutant().negate());
    }

    private Predicate<MutationDetails> isJunkVarargsMutant() {
        return mutant -> this.isFor(VarargsMutator.VARARGS).test((MutationDetails)mutant) && this.isJunk((MutationDetails)mutant);
    }

    private boolean isJunk(MutationDetails mutant) {
        Optional<MethodTree> method = this.mutatedMethod(mutant);
        if (!method.isPresent()) {
            return false;
        }
        AbstractInsnNode instruction = method.get().instruction(mutant.getInstructionIndex());
        MethodInsnNode call = (MethodInsnNode)instruction;
        Location loc = Location.location((ClassName)ClassName.fromString((String)call.owner), (String)call.name, (String)call.desc);
        return this.arrayIsEmpty(mutant, method.get()) || !this.isVarArgs(loc);
    }

    private boolean arrayIsEmpty(MutationDetails mutant, MethodTree method) {
        if (mutant.getInstructionIndex() == 0) {
            return true;
        }
        return !this.isArrayStore(((AbstractInsnNode)method.instructions().get(mutant.getInstructionIndex() - 1)).getOpcode());
    }

    private boolean isArrayStore(int opcode) {
        switch (opcode) {
            case 58: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                return true;
            }
        }
        return false;
    }

    private boolean isVarArgs(Location loc) {
        return this.varArgsMethods.computeIfAbsent(loc, this::analyseIsVarArgs);
    }

    private boolean analyseIsVarArgs(Location loc) {
        ClassTree owner = ClassTree.fromBytes((byte[])((byte[])this.source.getBytes(loc.getClassName().asInternalName()).get()));
        return owner.method(loc).map(m -> (m.rawNode().access & 0x80) != 0).orElse(false);
    }
}

