/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.removal.stream;

import com.groupcdg.arcmutate.AnalysingInterceptor;
import com.groupcdg.arcmutate.mutators.removal.stream.RemoveLimitMutator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.MutationDetails;

class InfiniteStreamFilter
extends AnalysingInterceptor {
    private static final Set<String> STREAM_SPECIALISATIONS = InfiniteStreamFilter.streams();

    InfiniteStreamFilter() {
    }

    @Override
    protected Stream<MutationDetails> intercept(Collection<MutationDetails> mutations) {
        return mutations.stream().filter(this.isFor(RemoveLimitMutator.REMOVE_LIMIT).and(this::isInfinite).negate());
    }

    private boolean isInfinite(MutationDetails mutant) {
        Optional<MethodTree> method = this.mutatedMethod(mutant);
        if (!method.isPresent()) {
            return false;
        }
        return method.get().instructions().stream().limit(mutant.getInstructionIndex()).anyMatch(this::isCallToIterate);
    }

    private boolean isCallToIterate(AbstractInsnNode node) {
        if (node instanceof MethodInsnNode) {
            MethodInsnNode call = (MethodInsnNode)node;
            return this.generatesInfiniteStream(call.name) && STREAM_SPECIALISATIONS.contains(call.owner);
        }
        return false;
    }

    private boolean generatesInfiniteStream(String method) {
        return method.equals("iterate") || method.equals("generate");
    }

    private static Set<String> streams() {
        HashSet<String> s = new HashSet<String>();
        s.add(ClassName.fromClass(Stream.class).asInternalName());
        s.add(ClassName.fromClass(IntStream.class).asInternalName());
        s.add(ClassName.fromClass(LongStream.class).asInternalName());
        s.add(ClassName.fromClass(DoubleStream.class).asInternalName());
        return s;
    }
}

