/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.removal.chained;

import com.groupcdg.arcmutate.AnalysingInterceptor;
import com.groupcdg.arcmutate.mutators.removal.chained.RemoveChainedCallsMutator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.mutationtest.engine.MutationDetails;

class JunkChainedCallInterceptor
extends AnalysingInterceptor {
    private final ClassByteArraySource source;
    private final Map<String, Boolean> genericClasses = new HashMap<String, Boolean>();

    public JunkChainedCallInterceptor(ClassByteArraySource source) {
        this.source = source;
    }

    @Override
    public Stream<MutationDetails> intercept(Collection<MutationDetails> mutants) {
        return mutants.stream().filter(this.isJunkChainedCallMutant().negate());
    }

    private Predicate<MutationDetails> isJunkChainedCallMutant() {
        return mutant -> this.isFor(RemoveChainedCallsMutator.CHAINED_CALLS).test((MutationDetails)mutant) && this.isJunk((MutationDetails)mutant);
    }

    private boolean isJunk(MutationDetails mutant) {
        Optional<MethodTree> method = this.mutatedMethod(mutant);
        if (!method.isPresent()) {
            return false;
        }
        AbstractInsnNode instruction = method.get().instruction(mutant.getInstructionIndex());
        MethodInsnNode call = (MethodInsnNode)instruction;
        if (call.owner.equals("java/lang/StringBuilder") && call.name.equals("append")) {
            return true;
        }
        return this.isGeneric(call);
    }

    private boolean isGeneric(MethodInsnNode call) {
        return this.genericClasses.computeIfAbsent(call.owner, this::isGeneric);
    }

    private boolean isGeneric(String clazz) {
        Optional maybeBytes = this.source.getBytes(clazz);
        if (maybeBytes.isPresent()) {
            ClassTree owner = ClassTree.fromBytes((byte[])((byte[])maybeBytes.get()));
            String signature = owner.rawNode().signature;
            return signature != null && signature.contains(":");
        }
        return true;
    }
}

