/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.reactive;

import com.groupcdg.arcmutate.mutators.reactive.ReactiveReturnMethodVisitor;
import com.groupcdg.arcmutate.mutators.reactive.ReactiveReturnsMutator;
import com.groupcdg.arcmutate.mutators.reactive.ReturnReplacement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.bytecode.analysis.OpcodeMatchers;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.intercept.Region;
import org.pitest.mutationtest.build.intercept.RegionInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotRead;
import org.pitest.sequence.SlotWrite;

class ReactiveReturnsInterceptor
extends RegionInterceptor {
    private static final Slot<AbstractInsnNode> MUTATED_INSTRUCTION = Slot.create(AbstractInsnNode.class);
    private static final Slot<Integer> LOCAL_VAR = Slot.create(Integer.class);
    private final SequenceQuery<AbstractInsnNode> ZERO_VALUES_DIRECT = QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match((Match)InstructionMatchers.anyInstruction())).then(ReactiveReturnsInterceptor.loadsEmptyReturnOntoStack()).then(OpcodeMatchers.ARETURN.and(ReactiveReturnsInterceptor.store((SlotWrite<AbstractInsnNode>)MUTATED_INSTRUCTION.write()))).zeroOrMore(QueryStart.match((Match)InstructionMatchers.anyInstruction()));
    private final SequenceQuery<AbstractInsnNode> INDIRECT_ZERO_VALUES = QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match((Match)InstructionMatchers.anyInstruction())).then(ReactiveReturnsInterceptor.loadsEmptyReturnOntoStack()).then(ReactiveReturnsInterceptor.aStoreTo((SlotWrite<Integer>)LOCAL_VAR.write())).zeroOrMore(QueryStart.match((Match)ReactiveReturnsInterceptor.aStoreTo((SlotRead<Integer>)LOCAL_VAR.read()).negate())).then(OpcodeMatchers.ALOAD.and(InstructionMatchers.variableMatches((SlotRead)LOCAL_VAR.read()))).then(OpcodeMatchers.ARETURN.and(ReactiveReturnsInterceptor.store((SlotWrite<AbstractInsnNode>)MUTATED_INSTRUCTION.write()))).zeroOrMore(QueryStart.match((Match)InstructionMatchers.anyInstruction()));
    private final SequenceMatcher<AbstractInsnNode> ZERO_VALUES = this.ZERO_VALUES_DIRECT.or(this.INDIRECT_ZERO_VALUES).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction().or(InstructionMatchers.isA(LabelNode.class))));

    ReactiveReturnsInterceptor() {
    }

    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater unused) {
        List targets = mutations.stream().filter(m -> m.getMutator().equals(ReactiveReturnsMutator.REACTIVE_RETURNS.getGloballyUniqueId())).collect(Collectors.toList());
        if (targets.isEmpty()) {
            return mutations;
        }
        ArrayList<MutationDetails> toReturn = new ArrayList<MutationDetails>(mutations);
        toReturn.removeAll(targets);
        toReturn.addAll(super.intercept(targets, unused));
        return toReturn;
    }

    protected List<Region> computeRegions(MethodTree method) {
        Context context = Context.start();
        return this.ZERO_VALUES.contextMatches(method.instructions(), context).stream().map(c -> new Region((AbstractInsnNode)c.retrieve(MUTATED_INSTRUCTION.read()).get(), (AbstractInsnNode)c.retrieve(MUTATED_INSTRUCTION.read()).get())).collect(Collectors.toList());
    }

    private static Match<AbstractInsnNode> store(SlotWrite<AbstractInsnNode> slot) {
        return (c, n) -> Result.result((boolean)true, (Context)c.store(slot, n));
    }

    private static Match<AbstractInsnNode> aStoreTo(SlotWrite<Integer> variable) {
        return OpcodeMatchers.ASTORE.and(InstructionMatchers.aVariableAccess(variable));
    }

    private static Match<AbstractInsnNode> aStoreTo(SlotRead<Integer> variable) {
        return OpcodeMatchers.ASTORE.and(InstructionMatchers.variableMatches(variable));
    }

    private static Match<AbstractInsnNode> loadsEmptyReturnOntoStack() {
        Match combined = (c, n) -> Result.result((boolean)false, (Context)c);
        for (ReturnReplacement each : ReactiveReturnMethodVisitor.HANDLED.values()) {
            combined = combined.or(InstructionMatchers.methodCallTo((ClassName)each.owner(), (String)each.method()));
        }
        return combined;
    }
}

