/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.overloads;

import com.groupcdg.arcmutate.AnalysingInterceptor;
import com.groupcdg.arcmutate.mutators.MethodLocation;
import com.groupcdg.arcmutate.mutators.overloads.OneLessParamOverloadMutator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.MutationDetails;

public class OneLessParamInterceptor
extends AnalysingInterceptor {
    private final ClassByteArraySource source;
    private final Map<MethodLocation, Boolean> computeCache = new ConcurrentHashMap<MethodLocation, Boolean>();

    public OneLessParamInterceptor(ClassByteArraySource source) {
        this.source = source;
    }

    @Override
    public Stream<MutationDetails> intercept(Collection<MutationDetails> mutants) {
        return mutants.stream().filter(this.isJunkChainedCallMutant().negate());
    }

    private Predicate<MutationDetails> isJunkChainedCallMutant() {
        return mutant -> this.isFor(OneLessParamOverloadMutator.ONE_LESS_PARAM).test((MutationDetails)mutant) && this.isJunk((MutationDetails)mutant);
    }

    private boolean isJunk(MutationDetails mutant) {
        Optional<MethodTree> method = this.mutatedMethod(mutant);
        if (!method.isPresent()) {
            return true;
        }
        AbstractInsnNode instruction = method.get().instruction(mutant.getInstructionIndex());
        MethodInsnNode call = (MethodInsnNode)instruction;
        Optional<MethodLocation> mutatedCall = MethodLocation.location(ClassName.fromString((String)call.owner), call.name, call.desc).removeLastParam();
        return mutatedCall.map(c -> this.computeCache.computeIfAbsent((MethodLocation)c, this::isJunkLocation)).orElse(true);
    }

    private Boolean isJunkLocation(MethodLocation mutatedCall) {
        Optional maybeBytes = this.source.getBytes(mutatedCall.className().asJavaName());
        if (!maybeBytes.isPresent()) {
            return true;
        }
        ClassTree target = ClassTree.fromBytes((byte[])((byte[])maybeBytes.get()));
        if (!target.method(mutatedCall.asLocation()).isPresent()) {
            return true;
        }
        return false;
    }
}

