/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators.extreme;

import com.groupcdg.arcmutate.mutators.Mutator;
import com.groupcdg.arcmutate.mutators.UnifiedType;
import com.groupcdg.arcmutate.mutators.extreme.ExtremeMutator;
import com.groupcdg.arcmutate.mutators.extreme.RemovalVisitor;
import java.util.function.Consumer;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.Type;

public enum ExtremeEmptyMutator implements ExtremeMutator
{
    EXTREME_EMPTY;


    @Override
    public Mutator mutator() {
        return Mutator.EXTREME_EMPTY;
    }

    @Override
    public RemovalVisitor pickVisitor(String methodDesc, MethodVisitor mv) {
        Type type = Type.getReturnType((String)methodDesc);
        if (type.getSort() == 9) {
            return this.handleArray(type, mv);
        }
        UnifiedType returnType = UnifiedType.parseMethodDescriptor(methodDesc);
        return this.pickVisitor(returnType, mv);
    }

    private RemovalVisitor handleArray(Type type, MethodVisitor mv) {
        int dimension = type.getDimensions();
        if (dimension == 1 && this.typeFor(type.getElementType().getSort()) < 0) {
            return null;
        }
        return new RemovalVisitor(this.zeroArray(dimension, type), mv, "empty array");
    }

    private Consumer<MethodVisitor> zeroArray(int dimension, Type type) {
        return mv -> {
            for (int i = 0; i != dimension; ++i) {
                mv.visitInsn(3);
            }
            if (dimension == 1) {
                int opcodeType = this.typeFor(type.getElementType().getSort());
                if (opcodeType == 0) {
                    mv.visitTypeInsn(189, type.getElementType().getInternalName());
                } else {
                    mv.visitIntInsn(188, opcodeType);
                }
            } else {
                mv.visitMultiANewArrayInsn(type.getDescriptor(), dimension);
            }
            mv.visitInsn(176);
        };
    }

    private int typeFor(int sort) {
        switch (sort) {
            case 5: {
                return 10;
            }
            case 3: {
                return 8;
            }
            case 2: {
                return 5;
            }
            case 1: {
                return 4;
            }
            case 6: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 7: {
                return 11;
            }
            case 4: {
                return 9;
            }
            case 10: {
                return 0;
            }
        }
        return -1;
    }
}

