/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.mutators;

import com.groupcdg.arcmutate.mutators.UnifiedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class MethodDesc {
    private final List<UnifiedType> params;
    private final UnifiedType returnType;

    private MethodDesc(UnifiedType returnType, List<UnifiedType> params) {
        this.returnType = returnType;
        this.params = params;
    }

    public static MethodDesc returning(UnifiedType t) {
        return new MethodDesc(t, Collections.emptyList());
    }

    public static MethodDesc returning(Class<?> t) {
        return new MethodDesc(UnifiedType.object(t), Collections.emptyList());
    }

    public MethodDesc withParam(Class t) {
        return this.withParam(UnifiedType.object(t));
    }

    public MethodDesc withParams(UnifiedType t, int number) {
        ArrayList<UnifiedType> params = new ArrayList<UnifiedType>(this.params);
        for (int i = 0; i != number; ++i) {
            params.add(t);
        }
        return new MethodDesc(this.returnType, params);
    }

    public MethodDesc withParam(UnifiedType t) {
        ArrayList<UnifiedType> params = new ArrayList<UnifiedType>(this.params);
        params.add(t);
        return new MethodDesc(this.returnType, params);
    }

    public MethodDesc withReturn(Class<?> t) {
        return new MethodDesc(UnifiedType.object(t), this.params);
    }

    public String build() {
        return "(" + this.params() + ")" + this.returnType;
    }

    public String toString() {
        return this.build();
    }

    private String params() {
        return this.params.stream().map(UnifiedType::symbol).collect(Collectors.joining());
    }
}

