/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.exclusions.analysis;

import com.groupcdg.arcmutate.exclusions.analysis.Exclusion;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.util.Glob;

public final class TextExclusion {
    private final String file;
    private final String clazz;
    private final String method;
    private final String mutator;
    private final int lineStart;
    private final int lineEnd;

    TextExclusion(String file, String clazz, String method, String mutator, int lineStart, int lineEnd) {
        this.file = file.trim();
        this.clazz = clazz.trim();
        this.method = method.trim();
        this.mutator = mutator.trim();
        this.lineStart = lineStart;
        this.lineEnd = lineEnd;
    }

    public static TextExclusion emptyLocation() {
        return new TextExclusion("*", "*", "*", "*", 0, Integer.MAX_VALUE);
    }

    public Exclusion asExclusion() {
        return new Exclusion(TextExclusion.glob(this.file), c -> TextExclusion.glob(this.clazz).test(c.asJavaName()), TextExclusion.glob(this.method), TextExclusion.glob(this.mutator), TextExclusion.range(this.lineStart, this.lineEnd));
    }

    public TextExclusion withLine(int lineStart, int lineEnd) {
        return new TextExclusion(this.file, this.clazz, this.method, this.mutator, lineStart, lineEnd);
    }

    public TextExclusion withFileName(String file) {
        return new TextExclusion(file, this.clazz, this.method, this.mutator, this.lineStart, this.lineEnd);
    }

    public String toString() {
        return Stream.of(this.file, this.clazz, this.method, this.mutator, this.intAsString(this.lineStart), this.intAsString(this.lineEnd)).collect(Collectors.joining(","));
    }

    private String intAsString(int i) {
        if (i == 0 || i == Integer.MAX_VALUE) {
            return "*";
        }
        return "" + i;
    }

    private static Predicate<String> glob(String part) {
        String trimmed = part.trim();
        if (trimmed.equals("*")) {
            return s -> true;
        }
        return new Glob(trimmed);
    }

    private static IntPredicate range(int start, int end) {
        return i -> i >= start && i <= end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextExclusion that = (TextExclusion)o;
        return this.lineStart == that.lineStart && this.lineEnd == that.lineEnd && Objects.equals(this.file, that.file) && Objects.equals(this.clazz, that.clazz) && Objects.equals(this.method, that.method) && Objects.equals(this.mutator, that.mutator);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.clazz, this.method, this.mutator, this.lineStart, this.lineEnd);
    }
}

