/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk.vast.util;

import com.xad.sdk.utils.Logger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import mf.javax.xml.transform.Source;
import mf.javax.xml.transform.stream.StreamSource;
import mf.javax.xml.validation.Schema;
import mf.javax.xml.validation.Validator;
import mf.org.apache.xerces.jaxp.validation.XMLSchemaFactory;

public class XmlValidation {
    private static String TAG = "XmlTools";

    public static boolean validate(InputStream schemaStream, String xml) {
        Logger.logInfo(TAG, "Beginning XSD validation.");
        XMLSchemaFactory factory = new XMLSchemaFactory();
        StreamSource schemaSource = new StreamSource(schemaStream);
        StreamSource xmlSource = new StreamSource((InputStream)new ByteArrayInputStream(xml.getBytes()));
        try {
            Schema schema = factory.newSchema((Source)schemaSource);
            Validator validator = schema.newValidator();
            validator.validate((Source)xmlSource);
        }
        catch (Exception e) {
            Logger.logError(TAG, e.getMessage(), e);
            return false;
        }
        Logger.logInfo(TAG, "Completed XSD validation..");
        return true;
    }
}

