/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk.vast.util;

import android.content.Context;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.xad.sdk.utils.Logger;
import com.xad.sdk.vast.model.VASTMediaFile;
import com.xad.sdk.vast.processor.VASTMediaPicker;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class DefaultMediaPicker
implements VASTMediaPicker {
    private static final String TAG = "DefaultMediaPicker";
    private static final int maxPixels = 5000;
    String SUPPORTED_VIDEO_TYPE_REGEX = "video/.*(?i)(mp4|3gpp|mp2t|webm|matroska)";
    private int deviceWidth;
    private int deviceHeight;
    private int deviceArea;
    private Context context;

    public DefaultMediaPicker(Context context) {
        this.context = context;
        this.setDeviceWidthHeight();
    }

    public DefaultMediaPicker(int width, int height) {
        this.setDeviceWidthHeight(width, height);
    }

    @Override
    public VASTMediaFile pickVideo(List<VASTMediaFile> mediaFiles) {
        if (mediaFiles == null || this.prefilterMediaFiles(mediaFiles) == 0) {
            return null;
        }
        Collections.sort(mediaFiles, new AreaComparator());
        VASTMediaFile mediaFile = this.getBestMatch(mediaFiles);
        return mediaFile;
    }

    private int prefilterMediaFiles(List<VASTMediaFile> mediaFiles) {
        Iterator<VASTMediaFile> iter = mediaFiles.iterator();
        while (iter.hasNext()) {
            VASTMediaFile mediaFile = iter.next();
            String type = mediaFile.getType();
            if (TextUtils.isEmpty((CharSequence)type)) {
                Logger.logDebug(TAG, "Validator error: mediaFile type empty");
                iter.remove();
                continue;
            }
            BigInteger height = mediaFile.getHeight();
            if (null == height) {
                Logger.logDebug(TAG, "Validator error: mediaFile height null");
                iter.remove();
                continue;
            }
            int videoHeight = height.intValue();
            if (0 >= videoHeight || videoHeight >= 5000) {
                Logger.logDebug(TAG, "Validator error: mediaFile height invalid: " + videoHeight);
                iter.remove();
                continue;
            }
            BigInteger width = mediaFile.getWidth();
            if (null == width) {
                Logger.logDebug(TAG, "Validator error: mediaFile width null");
                iter.remove();
                continue;
            }
            int videoWidth = width.intValue();
            if (0 >= videoWidth || videoWidth >= 5000) {
                Logger.logDebug(TAG, "Validator error: mediaFile width invalid: " + videoWidth);
                iter.remove();
                continue;
            }
            String url = mediaFile.getValue();
            if (!TextUtils.isEmpty((CharSequence)url)) continue;
            Logger.logDebug(TAG, "Validator error: mediaFile url empty");
            iter.remove();
        }
        return mediaFiles.size();
    }

    private void setDeviceWidthHeight() {
        DisplayMetrics metrics = this.context.getResources().getDisplayMetrics();
        this.deviceWidth = metrics.widthPixels;
        this.deviceHeight = metrics.heightPixels;
        this.deviceArea = this.deviceWidth * this.deviceHeight;
    }

    private void setDeviceWidthHeight(int width, int height) {
        this.deviceWidth = width;
        this.deviceHeight = height;
        this.deviceArea = this.deviceWidth * this.deviceHeight;
    }

    private boolean isMediaFileCompatible(VASTMediaFile media) {
        return media.getType().matches(this.SUPPORTED_VIDEO_TYPE_REGEX);
    }

    private VASTMediaFile getBestMatch(List<VASTMediaFile> list) {
        Logger.logDebug(TAG, "getBestMatch");
        for (VASTMediaFile media : list) {
            if (!this.isMediaFileCompatible(media)) continue;
            return media;
        }
        return null;
    }

    private class AreaComparator
    implements Comparator<VASTMediaFile> {
        private AreaComparator() {
        }

        @Override
        public int compare(VASTMediaFile obj1, VASTMediaFile obj2) {
            int obj1Area = obj1.getWidth().intValue() * obj1.getHeight().intValue();
            int obj2Area = obj2.getWidth().intValue() * obj2.getHeight().intValue();
            int obj1Diff = Math.abs(obj1Area - DefaultMediaPicker.this.deviceArea);
            int obj2Diff = Math.abs(obj2Area - DefaultMediaPicker.this.deviceArea);
            Logger.logVerbose(DefaultMediaPicker.TAG, "AreaComparator: obj1:" + obj1Diff + " obj2:" + obj2Diff);
            if (obj1Diff < obj2Diff) {
                return -1;
            }
            if (obj1Diff > obj2Diff) {
                return 1;
            }
            return 0;
        }
    }
}

