/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk.vast.processor;

import android.text.TextUtils;
import com.xad.sdk.utils.Logger;
import com.xad.sdk.vast.model.VASTMediaFile;
import com.xad.sdk.vast.model.VASTModel;
import com.xad.sdk.vast.processor.VASTMediaPicker;
import java.util.List;

public class VASTModelPostValidator {
    private static final String TAG = "VASTModelPostValidator";

    public static boolean validate(VASTModel model, VASTMediaPicker mediaPicker) {
        Logger.logDebug(TAG, "validate");
        if (!VASTModelPostValidator.validateModel(model)) {
            Logger.logDebug(TAG, "Validator returns: not valid (invalid model)");
            return false;
        }
        boolean isValid = false;
        if (mediaPicker != null) {
            String url;
            List<VASTMediaFile> mediaFiles = model.getMediaFiles();
            VASTMediaFile mediaFile = mediaPicker.pickVideo(mediaFiles);
            if (mediaFile != null && !TextUtils.isEmpty((CharSequence)(url = mediaFile.getValue()))) {
                isValid = true;
                model.setPickedMediaFileURL(url);
                Logger.logDebug(TAG, "mediaPicker selected mediaFile with URL " + url);
            }
        } else {
            Logger.logWarning(TAG, "mediaPicker: We don't have a compatible media file to play.");
        }
        Logger.logDebug(TAG, "Validator returns: " + (isValid ? "valid" : "not valid (no media file)"));
        return isValid;
    }

    private static boolean validateModel(VASTModel model) {
        List<VASTMediaFile> mediaFiles;
        Logger.logDebug(TAG, "validateModel");
        boolean isValid = true;
        List<String> impressions = model.getImpressions();
        if (impressions == null || impressions.size() == 0) {
            isValid = false;
        }
        if ((mediaFiles = model.getMediaFiles()) == null || mediaFiles.size() == 0) {
            Logger.logDebug(TAG, "Validator error: mediaFile list invalid");
            isValid = false;
        }
        return isValid;
    }
}

