/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk.vast.activity;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.customtabs.CustomTabsIntent;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.xad.sdk.mraid.Assets;
import com.xad.sdk.utils.ErrorPosting;
import com.xad.sdk.utils.Logger;
import com.xad.sdk.vast.VASTPlayer;
import com.xad.sdk.vast.model.TRACKING_EVENTS_TYPE;
import com.xad.sdk.vast.model.VASTModel;
import com.xad.sdk.vast.util.HttpTools;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class VASTActivity
extends Activity
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
SurfaceHolder.Callback {
    private static final String TAG = "VASTActivity";
    private static final float CLOSE_REGION_SIZE = 50.0f;
    private static final float CLOSE_REGION_PADDING = 25.0f;
    private static final long SHOW_CLOSE_BUTTON_DELAYED_IN_MS = 5000L;
    private static final long QUARTILE_TIMER_INTERVAL_IN_MS = 250L;
    private static final long VIDEO_PROGRESS_TIMER_INTERVAL_IN_MS = 250L;
    private static final int SHOW_CLOSE_BUTTON = 0;
    private static final int QUARTILE_TRACKING = 1;
    private static final int VIDEO_PROGRESS_TRACKING = 2;
    private String creativeString;
    private String adGroupId;
    private LinkedList<Integer> mVideoProgressTracker = null;
    private final int mMaxProgressTrackingPoints = 20;
    private Handler mHandler;
    private VASTModel mVastModel = null;
    private HashMap<TRACKING_EVENTS_TYPE, List<String>> mTrackingEventMap;
    private MediaPlayer mMediaPlayer;
    private SurfaceView mSurfaceView;
    private SurfaceHolder mSurfaceHolder;
    private RelativeLayout mOverlay;
    private RelativeLayout mRootLayout;
    private DisplayMetrics mDisplayMetrics;
    private ImageButton mCloseButton;
    private int mVideoHeight;
    private int mVideoWidth;
    private int mScreenWidth;
    private int mScreenHeight;
    private boolean mIsPlayBackError = false;
    private boolean mIsProcessedImpressions = false;
    private boolean mIsCompleted = false;
    private int mCurrentVideoPosition;
    private boolean mCloseButtonIsVisible = false;
    private int mQuartile = 0;
    private ProgressBar mProgressBar;
    BroadcastReceiver ringModeChangeReceiver;
    private static final String COMPLETE_STATUS = "com.xad.sdk.displaysdk.vastactivity.complete";
    private static final String POSITION_STATUS = "com.xad.sdk.displaysdk.vastactivity.position";
    private static final String CLOSE_BUTTON_VISIBLE_STATUS = "com.xad.sdk.displaysdk.vastactivity.closebuttonvisible";

    protected void onCreate(Bundle savedInstanceState) {
        Logger.logDebug(TAG, "entered onCreate --(life cycle event)");
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mIsCompleted = savedInstanceState.getBoolean(COMPLETE_STATUS);
            this.mCurrentVideoPosition = savedInstanceState.getInt(POSITION_STATUS);
            this.mCloseButtonIsVisible = savedInstanceState.getBoolean(CLOSE_BUTTON_VISIBLE_STATUS);
        }
        int currentOrientation = this.getResources().getConfiguration().orientation;
        Logger.logDebug(TAG, "currentOrientation:" + currentOrientation);
        if (currentOrientation != 2) {
            Logger.logDebug(TAG, "Orientation is not landscape.....forcing landscape");
            this.setRequestedOrientation(0);
        } else {
            Logger.logDebug(TAG, "orientation is landscape");
            Intent i = this.getIntent();
            Bundle extras = i.getExtras();
            this.mVastModel = (VASTModel)extras.getSerializable("com.xad.displaysdk.vastmodel");
            this.creativeString = extras.getString("com.xad.displaysdk.creatievstring");
            this.adGroupId = extras.getString("com.xad.displaysdk.adgroupid");
            if (this.mVastModel == null) {
                Logger.logError(TAG, "vastModel is null. Stopping activity.");
                ErrorPosting.sendError((Context)this, 7, this.creativeString, this.adGroupId);
                this.finishVAST();
            } else {
                this.hideTitleStatusBars();
                this.mHandler = new Handler(new Handler.Callback(){

                    public boolean handleMessage(Message msg) {
                        switch (msg.what) {
                            case 0: {
                                if (VASTActivity.this.mCloseButton == null) break;
                                VASTActivity.this.mCloseButton.setVisibility(0);
                                VASTActivity.this.mCloseButtonIsVisible = true;
                                break;
                            }
                            case 1: {
                                VASTActivity.this.quartileTracker();
                                break;
                            }
                            case 2: {
                                VASTActivity.this.videoProgressTracker();
                            }
                        }
                        return true;
                    }
                });
                this.mDisplayMetrics = this.getResources().getDisplayMetrics();
                this.mScreenWidth = this.mDisplayMetrics.widthPixels;
                this.mScreenHeight = this.mDisplayMetrics.heightPixels;
                this.mTrackingEventMap = this.mVastModel.getTrackingUrls();
                this.createUIComponents();
                this.registerSilentMode();
            }
        }
    }

    private void registerSilentMode() {
        this.ringModeChangeReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                AudioManager manager = (AudioManager)VASTActivity.this.getSystemService("audio");
                Logger.logDebug(VASTActivity.TAG, "Ring mode changed: " + manager.getRingerMode());
                if (manager.getRingerMode() == 2) {
                    VASTActivity.this.processEvent(TRACKING_EVENTS_TYPE.unmute);
                } else {
                    VASTActivity.this.processEvent(TRACKING_EVENTS_TYPE.mute);
                }
            }
        };
        IntentFilter filter = new IntentFilter("android.media.RINGER_MODE_CHANGED");
        this.registerReceiver(this.ringModeChangeReceiver, filter);
    }

    private void unregisterSilentMode() {
        if (this.ringModeChangeReceiver != null) {
            this.unregisterReceiver(this.ringModeChangeReceiver);
        }
    }

    protected void onStart() {
        Logger.logDebug(TAG, "entered onStart --(life cycle event)");
        super.onStart();
    }

    protected void onResume() {
        Logger.logDebug(TAG, "entered on onResume --(life cycle event)");
        super.onResume();
        if (this.mCloseButton != null && this.mCloseButton.getVisibility() != 0 && this.mHandler != null) {
            this.mHandler.sendEmptyMessageDelayed(0, 5000L);
        }
    }

    protected void onStop() {
        Logger.logDebug(TAG, "entered on onStop --(life cycle event)");
        super.onStop();
    }

    protected void onRestart() {
        Logger.logDebug(TAG, "entered on onRestart --(life cycle event)");
        super.onRestart();
        this.createMediaPlayer();
    }

    protected void onPause() {
        Logger.logDebug(TAG, "entered on onPause --(life cycle event)");
        super.onPause();
        if (this.mMediaPlayer != null) {
            this.mCurrentVideoPosition = this.mMediaPlayer.getCurrentPosition();
            this.processEvent(TRACKING_EVENTS_TYPE.pause);
        }
        this.cleanActivityUp();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(COMPLETE_STATUS, this.mIsCompleted);
        outState.putInt(POSITION_STATUS, this.mCurrentVideoPosition);
        outState.putBoolean(CLOSE_BUTTON_VISIBLE_STATUS, this.mCloseButtonIsVisible);
    }

    protected void onDestroy() {
        Logger.logDebug(TAG, "entered on onDestroy --(life cycle event)");
        this.unregisterSilentMode();
        super.onDestroy();
    }

    private void hideTitleStatusBars() {
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
    }

    private void createUIComponents() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.createRootLayout(params);
        this.createSurface(params);
        this.createMediaPlayer();
        this.createOverlay(params);
        this.createCloseButton();
        this.setContentView((View)this.mRootLayout);
        this.createProgressBar();
    }

    private void createProgressBar() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(13);
        this.mProgressBar = new ProgressBar((Context)this);
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mRootLayout.addView((View)this.mProgressBar);
        this.mProgressBar.setVisibility(8);
    }

    private void showProgressBar() {
        this.mProgressBar.setVisibility(0);
    }

    private void hideProgressBar() {
        this.mProgressBar.setVisibility(8);
    }

    private void createRootLayout(RelativeLayout.LayoutParams params) {
        this.mRootLayout = new RelativeLayout((Context)this);
        this.mRootLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mRootLayout.setPadding(0, 0, 0, 0);
        this.mRootLayout.setBackgroundColor(-16777216);
        this.processEvent(TRACKING_EVENTS_TYPE.fullscreen);
    }

    private void createSurface(RelativeLayout.LayoutParams params) {
        this.mSurfaceView = new SurfaceView((Context)this);
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mSurfaceHolder = this.mSurfaceView.getHolder();
        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.mRootLayout.addView((View)this.mSurfaceView);
    }

    private void createMediaPlayer() {
        this.mMediaPlayer = new MediaPlayer();
        this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mMediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
        this.mMediaPlayer.setAudioStreamType(3);
        this.mMediaPlayer.setScreenOnWhilePlaying(true);
        this.processEvent(TRACKING_EVENTS_TYPE.creativeView);
    }

    private void createOverlay(RelativeLayout.LayoutParams params) {
        this.mOverlay = new RelativeLayout((Context)this);
        this.mOverlay.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mOverlay.setPadding(0, 0, 0, 0);
        this.mOverlay.setBackgroundColor(0);
        this.mOverlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VASTActivity.this.overlayClicked();
            }
        });
        this.mRootLayout.addView((View)this.mOverlay);
    }

    private void createCloseButton() {
        int size = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.mDisplayMetrics);
        int padding = (int)TypedValue.applyDimension((int)1, (float)25.0f, (DisplayMetrics)this.mDisplayMetrics) / 2;
        this.mCloseButton = new ImageButton((Context)this);
        Drawable closeButtonNormalDrawable = Assets.getDrawableFromBase64(this.getResources(), "iVBORw0KGgoAAAANSUhEUgAAAIAAAACACAYAAADDPmHLAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goHFBQe/AkWfQAADBBJREFUeNrtXUFIW1kUPT9VqyKM 0qqYQS2tuIwwCwOl0NW46SI44PJvymxaaIesxqXdSGVWA0JdTMCFSDaxCK4cswiB0NWM3XSVStQ2 4wiDCplYnJg7C38kDZr/3v/v/f/eNxcuZKHJ/++cd9999917n4EAChG1A+gFEAZwD8B9AA+sz98C GATwDYBO61++ADgB8DeAzwAKAD4C2LE+FwEcG4bxX9DGyggA2LcsoL8D8D2AHwAMSfq5vwCsAfgd wB8AioZhnKMlnoN+h4hiRJQi/yVlPcudFjJyQe8noqdEtEPqyo71jP0txMSA3kFEU0T0jvSTd9az d7R8AAcmHsCPAF4HhMuzAH4zDOOf1rRuDnyYiBYpuLJIROEW0lev70EG/ioiKOEnGD4D3wngJxmm /vT0FIeHh9jd3UU+n7/Uvb09FItFHB0doVwuAwC6u7vR19eHcDiMkZERjI2NXero6CgGBgbQ1dUl a2n41TCMLzdx1k+Jmk6VSoUKhQIlk0kyTZPa2toIgFBta2sj0zQpmUxSoVCgSqUi0iJM3TRzv+F2 xEqlEqXTaTJNUzjYrGqaJqXTaSqVSiJIsBH47aMVMHEsZ2dnlMlkKBaL+Qb6dRqLxSiTydDZ2Zlb IsSCCHw3ES07HZGDgwOan59XDvTrdH5+ng4ODtyQYJmIuoMC/jgRnTsZhXw+76uJF7FE5PN5pyQ4 J6Jx3cF/4uTNC4UCzczMaAt8o87MzFChUHBKhCe6gh/nfdPj42OKx+OBAb5R4/E4HR8fOyFBXCfg Q7xBnWq1SslkMrDAN2oymaRqteokeBRSHfx23iPa/f19ikajNwb8mkajUdrf33dy9Nyu8sndJs/b 3KRZ38wacMqmcieM1sxnBr9cLmvt3cvYLZTLZV4StKu05qd4PPyenp4W8A3a09PDu1NIKeET8Dh8 uVyuBbaN5nI5LsdQm63e2tpaC2BGXVtbU3+LyBPkSSQSLWA5NZFIqBssssK7TLK0tNQC1KEuLS3x kGDcK/C7WWP7rZnvqSU49+QAifVUr7Xm++ITLCtxni/C23/9+jWFQiHtwYtEIhSPx2l8fNyr3UFM Fvj9rPt8Ny86Pj5Oq6url1YkEoloDX5t9q6urromAUecoF8GATZYInxugzzr6+tffWc2m9XSEhiG Qdls9qt3WV9fdx0sYowYbogGnymB0214txF8XUlQP/Mbxa0lME3T20RTIur04mDnOvB1I8FVM79R 3FoCjgOkThEE+JnlSFcm+LqQoNnMF20JGI+Sf5bu+FWrVVfn+azgq04CHvBFkCAajbImlfS7IcCi LNNf7+3zimokYDH7MkjAuBQsOgU/zJLD5zX49YEmFbaITma+SBIw5hiGpcx+JwmcIsBXhQRuZr4o EsTjcfFWwGrBIiXgs7m5SSLFr+VAxMwXRQLGANEdoZ6/k7z9jo4OevHihZNkSKVIIAP8eqt6+/Zt 7roDYTsCK7nTtmLH6eB1dXVpTQKRZv+qJW1iYsLRczFWIHWwEMA26uc24ieLBLJ9Apkz3w34HBHC KRYCvLMr1BQxmLpZAlVnfr0yFKS+cx34EV2l++zZMykDKtISqDzz0VCV7CowRBc97prW54ueWaov B7qAX1OG/gRPmxGgaRPGTCYjZW1VdTnQwew3aiaTsfvpHcd7f5mdOVSzBLrNfNR1KnEUE7BL9yqV StK3WDUSiBZeS6DjzK9Xhp5FsasI0LS8K51OexZo8dMx1HXm12s6nbZ7lFQj+Ldk7/11IEEQwOeI CdyqJ8Bws7+sVCqex9q99gmCAn5NGfoYDjOv/24zfVXfHchc87PZLBmG4fnYMRwQxZiPfv1u5CBj Ochms5ffr7PD5yJZZLGeAEWV1n+vSLC1tUVbW1uBA5/RDyjWd/doKjJ676pCgiCCD6u3MYO028b/ y+WyMrl3snyCoIFfU4Yikn4Q0YSKDqCOJPDL4XPhCE7Y7gBkxf+DthyoNPM5zgViIVxcqnit5PN5 qChv3rzB8+fPlXiWt2/f4tWrV3j//r1SY8SA3f0QLm7U1I4AqpBAVfAZsXsQwsV1qloSAACWl5fx 8uVLfPr0qQU+P3b3QER/NlskdGjj6odjqJrDd135mI38aRsEGh4e1qYs2yvHUEWH7yodHh62DwYR 0b/N/kKnrp41S+Dyto5AgF9rKGEj/4JsOn7p1p1jcnKStre3pYCfTqe1AR8AhUIhu1c6V7v/PKdE IhHMzs5iYmJCyvcTEYgIgZKgLAEyz/O9qDvwcwnQ3gmUeZ7vRd2B306g1ttAr8HXiQQs28AQgM/N loiRkRGl1/xUKoVHjx55/tvT09OYm5tDJBJRdnwYsPscAlBo9hdjY2PKgj83N4fp6WnfnkF1EjBg V2gD8FE3AqgAfj0J+vv78fjxY1SrVd0I8FG742C/1nwdfQKW42CtEkJUBV9VErAmhGiREqY6+CqS gDUlTPmkUJlBnu3tbeFnByqQgDkp1IoGKpsWLrtiZ3JyUst2NXbKnBZuEUDJwhCvqnR17VkEgYUh ypWGeV2rFzQS8JaGKVUc6metnqwyNK8PkHiLQ5UpD/e7Slf3PoaM6z9RfXm4RQLfG0SoUqKtOwm4 G0Sw+AGyW8SoWKKt63LgtEWMb02iVG3OoKNj6LhJlEUCz9vEyQRfVOq2TpbAcZs4iwCeNorUpS2L Tj6B20aRnrWK1a0njw4kcN0q1iKB9GbROph9HZcD182iLQJIbRevezcuVR1Dke3ipV0YITu272Wt nmqWQNiFERYJhF8ZE7Q+fCr5BEKvjGGNCfAcEA0NDdHKykpgwJdNgu3tbS5rJvzSKJYjYiL2a+N6 e3tpYWGBTk5OAgO+LBKcnJzQwsIC9fb2+ndtnEUAoRdHDg4OCiWBSlW6okhQA39wcND/iyNZrQBP sogoEqhYou2WBE7Al3p1LGtgiPfyaLckULk+3w0JfvnlF/Uuj2bdEfBeH++UBDo0Z3BCAl7w4dX1 8RYBOll+iTdvkJcEOnXmYCWBE7PPYfqJiDpF9RCYYvk13gghKwl0Ap+VBE7BZ4z4sUX9OEmwYfeL 5XKZu6GEHQl0BN+OBE7B7+npYSn2ICLaEF5oyOIQ8gaI7EigM/jXkcAp+BwBH/eOXxMSMKWb5HI5 1yQIAviNJPjw4YNj8HO5HCv4Maklx0S0zOq0OSXByspKYMCvaWdnJz18+JDu3r3L/b8cZyjL0mvO iaibbFrL1SSRSHC/bG9vLw0NDQUKfDeaSCRYwT8nom5PGg8Q0TjrUy0tLbWAdKhLS0s8YZJxT7tP ENET1idzYglaMz/BA/4TX1qQEFGcJ4rXAlb4mk9EFPe1Dw3LgZGb3cFNUw5v391Bj0AChMimrKwx TqBTA2qvtKenh2efT9aYq9Hqly66jGyyPnm5XFbiLkJV1DRN1ghfTTap1t1DFbGSSTd53sLvG0lV UI6DnXrwO6CiWJYgxfM2+/v7WtxKIlqj0aiTvIGUcjP/Gp9gkeetqtXqjbIGyWSSNZnjK4dPmTVf 9BaxPseQNdFUR43H46w5fGpt9bwIFjXuFHjrDlTWmZkZXg/f/yCP4LDxuZM3z+fzWu8WTNNkrdi5 LrY/jiCIdYC07HQkDg4OhFUle6Hz8/Num08ue3aw4zERYm5G5ezsjDKZjLROJW40FotRJpNhqc/3 9zxfARL0s6SX2UmpVKJ0Ou3rEmGaJqXTaZaePExpXNIyeRQlwhQJkkqlQoVCgZLJJJmmKaW3cVtb G5mmSclkkgqFAksfPh6Z8gsHw2cSdAL4CcBr0d99enqKw8ND7O7uIp/PX+re3h6KxSKOjo5QLpcB AN3d3ejr60M4HMbIyAjGxsYudXR0FAMDA+jq6pIxBLMAfjUM4wtusljLwiLdHFm8UeaegwjhgBNh 0XGhZhCXgCZEuAPgRxlLg08yC+A3wzD+aU1z/hPGKbJpXKWovLOevaOFpDg/4SnZNLP0WXasZ2yt 77KXCCuolFIA9JT1LHd0HEsjAGS4BSAM4DsA3wP4AcCQpJ/7C8AagN8B/AGgaBjGuc7jZwTUQrQD 6LWIcQ/AfQAPrM/fAhgE8A2AWvn0FwAnAP7GxVW6BVxcqLljfS4CODYM47+gjdX/V+LYxXLzNfgA AAAASUVORK5CYII=");
        Drawable closeButtonPressedDrawable = Assets.getDrawableFromBase64(this.getResources(), "iVBORw0KGgoAAAANSUhEUgAAAIAAAACACAYAAADDPmHLAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goHFBQxV9grJAAAEwRJREFUeNrtnXtsVVW+xz89fdBC y6mUcqA9oFIeJbWUqjg0YLoTLBpbg5HeopMMkwYSE+ZexfnLa7y65Bpn5p8ZNJeaeCcxPpLxcpEM AurQEHcvaG1AWkJLKUQh9iGlWPu0j9PH/aOnnQrt3mvvs/fp3qf9JU0OZa11dvf3u36P9fj9oohA EULEAslAGnAPsBLICH5OB3yAF4gPdukHOoFWoBm4DnwLfBf83AJ0CCECkfauoiIA7Ogg0PcDBcBT wDKbvu4H4AhQDpwHWoQQw3MECD/oKcAWYFcQ8JmUI8D7wBkhxI9zBLAP9FTgCeBl4F6HPuY14HXg mBCibY4AoYMeByjAfuBXLptcVcArgCqEGJwjgHEVvwf4Y4T4Wi8Cf3WiiYhyGPBpwEvA74hMOQi8 IYRomSPAnfb91QgGfioivOYEPyFqhoGPB563Q9UHAgF6e3vp7Oykvb194qezs5Pu7m76+voIBMbC +tjYWBISEkhKSsLr9bJo0aKJH6/Xy4IFC4iNjbXLNLwphOifdQQQQmwD/mHFWCMjI3R1ddHU1MTV q1e5ePEiIyMjlj6vx+MhOzub1atX4/f7WbhwIR6Px6rhHxVCnJwVBAiq+3eBwlDGGRwcpLm5mZqa Gi5cuDAjJM7JyWHDhg2kp6cTFxcX6nAngNJwm4WoMIO/Hfi72f7Dw8M0NTVRWVnJ5cuXHWXUMzMz ycvLw+/3Ex0dHcpQTwohjkYUAYQQ84Ey4Ldm+vf09FBdXc2pU6dc4eFt3bqV3NxcEhMTzQ7xHrBX CPGz6wkghFgD1AOGDWZ7ezsVFRUzpuKtMBH5+fksWrTIlGsDrBNCXHEtAYQQhcBxo/06OjooLy+n rq4uImK+rKwsCgoKSE5ONtO9SAhxwnUEEEK8APzZSJ/+/n4qKiqorKyMyOA/Ly+P/Px84uPjjXb9 vRDiL64ggBDCA7xlZFFndHSUuro6Dh8+PCtWgYqLi8nKyiIqytDrPwg8J4QYcSwBggcxPsLAFm1X VxeHDh2iqamJ2SR+v5+SkhIWLlxopNsR4GkrD6ZEWQh+XNDeF8j2qa2tnTWzXksb3HfffUa6lAf9 gkHHECA480/Igh8IBDh+/LhrvXs7ooWioiIjy83lQKEVmiDKAvA9wP/Kqv2Ojg7KysoYHBycQ36S xMXFsXfvXiORwhHgX0L1CaxYzH5LFvzGxkYOHDgwB/4UMjg4yIEDB2hsbJTt8lTw3Yck0SHO/heA /5BpW19fzwcffDCHtI5UV1fj8/lITU2Vaf6Qoihdqqp+HXYCBBd53pP9oz7++OM5dCWlrq4Or9fL smVSh5sfVRTlnKqqV8NGgODyrtRqzblz5zh27NgcqgaloaGBxMRE0tLSZJr/WlGUv6mqavjIWZQJ 8OcD3TL+Q3V1NUePHp1DMwTZvn07ubm5Mk1HgCSjG0hmnMAymX719fVz4FsgR48epb6+XhbLMltN QHA/X/f4VmNjY8gO3yOPPMK1a9dcD6DP52P9+vX09fXR19dn2ifIyMjA6/XqNd2gKEqNqqoNlhMg eJLnG5k4/+233zb9wlJSUnj88cfZuHEjPp+PW7du0dvb61rwFUVh06ZNzJ8/n5s3b5omQXV1NRs2 bJDZSHpaUZQyVVV/llUbsvKuXoNAIEBZWVlIL23btm1kZ2cDsG7dOgoLC41umjhCoqKiKCwsZN26 dQBkZ2ezbdu2kMYsKyubOMgaKlaGNEDwAOd+vXaffPIJLS3mj7w/88wzrF279he/83q9rFy5kpqa GlfN/MLCQlatWvWL3y9evJiUlBTTmmB4eJiurq4JUmnIGkVRKlVV/TZkAgSPbusewKutreWLL76w FHw3kiAqKoqSkpI7wJ9MjuTkZGpra02N39rayuLFi1myZIle098oivInVVWHQjUBz+s16OrqCmlX Twv8cVmxYgWlpaWONgc+n4+SkhJWrFih2W7t2rXs2LGDlJQUU99z+PBhurq6sAK7aAnHT/Ps/ujo KB9++KHsA5kC3w2aYNzhk1DPE+1DcQwbGxvJzc3VmxCP6DmEehrgVZkQxcxhjpSUFHbs2CENvpM1 we0On6xkZ2ejKIopTdDU1CR7ZvJVUxogeFHzI63O/f39vPPOO6bAVxRlwts3Kl6v1zEh4nQOn5H+ ZjXBpUuX2LRpEzExMVrNHlIU5b9VVe02qgFe0nuAioqKsIM/LuvWrUNRFHw+n+tmvpWaQBKDlwxp gOD9/MN6Cz5mHL/i4mIyMzMtASA1NRWfzzcjPkGoM98qTdDU1CSzQPSQoij/papqn6wG2KP3xeXl 5Yb/yOjoaK5cuWLaYXSKT2DU4TOiCdasWaOn0s1isUdKAwQPd2rqlfb2do4fN3zfg9HRUW7evMnQ 0BA+n4958+ZZ8uLCGR3oxfmhSH19PTU1NYYnSFtbG+vXrychIUEvIviDqqrDehpAscP2j0sgEOD8 +fN8+eWXlmuCkpISW30C2TjfLPgVFRXcuHHDVH9JTBQZE6C55NvT0xPyaV67SGDn3oFVDp8d4ANc uHCBnp4evWb7NU1AcOHnTa0RqqqqLNmmHRkZobm5maGhIdasWWPZy7QjRLTa4bMa/HFJSEjg7rvv 1mriv31h6HYN8IRW7+HhYcuvaNfU1PDZZ59ZrgmsChHtcvisBh/g1KlTDA/rJi59QssEvKwXclgt TjYHTlf7JjF6eUoTEIz9/6DV8/PPP+fWrVuWv4yRkRHbogOz5sAtav926e/v17tqdtfkNYHJGmCL Vq/BwUFb07JM1gRWihlN4MaZPy6XL1+WuXizZSoTsEurR3Nzs+0xdiAQoKqqihMnrM2HYCREdHKo JysSWO36hQkIplz/m1YPVVVpbW0lHNLS0kJvb6+l0UFqaiqJiYma5sBNDp+M5tP6b0VRXldVdXRc A6Tp2ehw3+QNd3QQSeBfuHBBJk9i2mQTcL9WSytBcGJ0YKfN//777zl06FDYwDeA2f2TCVAQ7vDP iE9w+vRpy32C0tLSiX+XlpbaZvM//fRTRkdHw/7uJDArABjfdtK83n316lVmUs6ePQtAYWGhpSTY tWvXxGe3q/2pMNMJB58C/jUqmN1DM27Yv3+/5bl3zcjGjRstJYFdMtPgw1hu41deeUWvWVwMY9W1 NNWwE8Afdww9Hg+bN282mlxpVoE/7rgHAgG9tDPJMXoRgJOuZY07hoAjSTDu8M2EzZ8OO52UM2ke xmrpTSudnZ2Oesl2OYZudvhCwO4eD2NFFaeV9vZ2R6ras2fPWr5i6Ha1bwK7lR7GKmq6jgBOIYFT wZfELiNGzwQ4mQAz7Rg6GXxJ7O6JYayWrmt8AKc4hk5z+Exil+5hrJDytNLd3e34uDvcjqETHT6T 2PliGKuiPa2YzWgxk+bg4YcfDqVah6vVvkHsvB7+WUJ92tnlFgkEAjQ1NcmcjjUl165dcw34ktjF e4gg8fl8bNmyhaVLl9oy/ujoqOPVvlHxAJpFC20qmGgL+Hbt508EzStXuipnkQR2/R5A01XUuW7k CLFzP/92CccNJKtEArtOD6B5zispKcnx4Nu1nz+dOOFquoxIYNfqATRPEEokJ5xRtW/XAc5IIIEE ds0e4LpWC5M17yLC5rudBBLYXfcA37qNAE4AfzIJnOoYSmD3rQf4zk0ECKfD53bHUAK773RNgJN8 gJlw+NxsDiSwu+4BNHO7LliwYA58l5JAAruWGKBDbzHB4/HM6LnAcZtvB/g3btwgMTHRsr2DcdMU zptUU4nH45FZCOrwBGvP/aDVKtSUbk51+Orr6zl27BinT592bH4CsyKB2Q9CiMD4XsARrZarV6+O OIdvfFevubnZthtIM0kCCcyOwD9vBmnmGfP7/TMy88N1S9fOa2gzRQIJzMonE+C8VstwH7Waibt6 dh0qmal1AgnMzk8mQIueQ5GTkxMRM1/vJI8dt5LDncwyJycHj0d3p78FgvkBVFUdVRRlPTDtlIuP j7f9irgTrmjbma4mXMksH3vsMe666y5N+y+E+GiyBgB4X6tHenp6xKn96cTuW8l2awIJrCawnkyA M1o94uLiLEvy7DS1H25zYOeycWZmJnFxcXrNztxBACHEj4BmBsi8vDxXqf1QkzO40TGUwOhaEOs7 NADA6+EMB+22+VYd3XaTYyiB0S8wvp0AmlWeo6Oj2bp1a8Q4fEY0gV0Jrq0kwdatW4mO1i0Ed2xa Aggh2oAqrd6ShYxdq/bd7BhKYFMVxHhaDQCgmVYiMTExpDUBt6h9tzmGOTk5Mhtad2A7FQFUvVHy 8/MdF+rV19eHJRuXUx1DSUzuwPYOg6Gq6rCiKP3AI9ONkpCQQFtbG21tbYZmvt25d+26ETSVtLW1 0dvb64jFoqysLB588EG9Zi8KIf5PRgMA/FVvtIKCAukHTEpKYvPmzRGRhDEcjuGzzz5rSBNIYjEl plO6jKqq9imKkgo8NN1o8fHxDAwMSOUQ9Hg8LF26FJ/PZ7ggkhPBHxc7lo0HBgaoq6ubKKYhE/fr pIMDOCiE+HhKbDQ6vWGVL9Df309lZSXnzp1jYGAgIsC3QxMMDAxw7tw5Kisr6e/vt9L2T4vltEGj qqrdelogJiaGxYsXc+nSJd0nGBwc5ObNm0RHR4esCZx2RdsKTTAZfFlfpri4mLS0NJnZ/z/Tamed zq/JOCCyK4Q9PT0hawKn3s8PVRN88803lJeXS4Pv9/vJysqSaaqJoeaykaqqP+tFBFFRUaxatYrK ykqpBw9FEzg9OYNZTfDVV19x8uRJQ9+1Z88evWqh457/SdMEAFAU5Rt0agnNmzdP2hSYJYFbMnMY IcHAwABVVVVUVlbKVPn4hepfvny5TNMnVFUdCokAqqoOKYpSCfxGq92SJUv46aefpI9CGyGBm9Ky yJLAjM2HsRU/ScfvUSFEg16jaJmRVFX9VlGUjYBmCY9Vq1ZRVVUlU7pMmgRuA1+GBGbBj4uLo7S0 VGbD54QQ4j9lxjSSIqZUr0FsbCx79+419KK0HEO3gq/lGJoFH2Dv3r2yGVtKZceMlm0YdAhrgKe1 2sXHx5ORkUF1dbX0HzaVJnA7+FNpguTkZC5evGgK/N27d8tuFj0phDhvOQGCJGhQFOVeYINWu/F6 fXV1daZI0NHRwZkzZ1wP/mQStLa20tLSQkNDg+EM7Dt37iQjI0Om6XtCiD8ZGTva6B+jKMpJ4N8B zcXq1NRUvF4vDQ0NhkjQ0tLC9evXHZ+i1gwJurq6DKfd2759u+zVvBFgi6qqAVsJoKpqQFGUj4B/ 02u7bNkyEhMTuXLlivT4Q0NDhkKiSJaioiIeeOAB2eaZQgjDKjPazIOpqvqjoijngF/rtU1LSzOs CeZkbOYbAL9ICPG1me+JNvuAqqpeVRSlC3hURhMY9Qlms+zcudPIjezfCyHeN/td0aE8qKqqX+tt GE32CYxGB7NRdu/eLevwwdhGzyuhfJ8VqWKfQ+d6+bgsX76cffv2yVxcmHUSFxfHvn37ZJd4Cb7z 50L9XkvOIwdLz51ApwDl5AWS48ePh70crVMlJyeHoqIiI2l5y4HCYHKPmSdAkARxwHFZEgDU1tZy +PDhWQ1+cXGxzIme28EvEkJYEipZei0lqAk+QqcS6WTp6uri0KFDM1aedqbE7/dTUlJiNPfCEeBp K2a+LQQIksADvAX8TrbP6OgodXV1s0YbFBcXk5WVZfQI+EHgOSGEpdm6bLunLIR4AfizkT79/f1U VFRIHy5xm+Tl5ZGfny9zkGOqUO8vdjyTrRfVhRCFQb/AkHR0dFBeXh4x6wZZWVkUFBToVfGcToqE ELbVxrM9Z4kQYg1QbybkbG9vp6KiwrXRwvjhDZPpdkeAdUKIK3Y+Y1iS1ggh5gNlwG/N9O/p6aG6 uppTp065AvitW7eSm5sbSvLJ94C9Qoif7X7WsKauEkJsB/5utv/w8DBNTU1UVlZy+fJlR4GemZlJ Xl4efr9f5sSOljwphDgarucOe45zIUQq8C5QGMo4g4ODNDc3U1NTM2MmIicnhw0bNpCenm7F6uYJ oPT269sRR4BJRNgG/MOKscb32puamrh69SoXL160PLexx+MhOzub1atX4/f7WbhwoUwqNll5VO/4 dsQRIEiCeOB54I9Wjx0IBOjt7aWzs5P29vaJn87OTrq7u+nr65s4nBEbG0tCQgJJSUl4vV4WLVo0 8eP1elmwYIFd1dNeBN4UQvTPFAaOKHMRNAuvYmDxyOVyEHgt3OresQSYRIQ04KUIJsJB4A0hRItT HsiRFRCFECnAHjtMwwzJi8BfJ6dnmyOAHBHiAAXYD/zKZaBXMZaTR7Vq527WEWAKP+EJxu4p3uvQ x7zGWB6+Y06w7xFFgClMxBZgFwa2nm2SI4zl3j3jRBUfkQS4jQzRQBpwP2OHUZ4Cltn0dT8EAS9n LN9+ixBi2M3vz/UEmIYUsUBykBj3ACuBjODndMAHeIHxfdl+xopotzJWSvc6YwU1vwt+bgE6rDyI 4RT5f02O5nnLDJUQAAAAAElFTkSuQmCC");
        StateListDrawable states = new StateListDrawable();
        states.addState(new int[]{-16842919}, closeButtonNormalDrawable);
        states.addState(new int[]{16842919}, closeButtonPressedDrawable);
        this.mCloseButton.setImageDrawable((Drawable)states);
        this.mCloseButton.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);
        params.addRule(11, 10);
        this.mCloseButton.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mCloseButton.setPadding(padding, padding, padding, padding);
        this.mCloseButton.setBackgroundColor(0);
        if (!this.mCloseButtonIsVisible) {
            this.mCloseButton.setVisibility(4);
        }
        this.mHandler.sendEmptyMessageDelayed(0, 5000L);
        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VASTActivity.this.closeClicked();
            }
        });
        this.mRootLayout.addView((View)this.mCloseButton);
    }

    private void processClickThroughEvent() {
        Logger.logDebug(TAG, "entered processClickThroughEvent:");
        if (VASTPlayer.listener != null) {
            VASTPlayer.listener.vastClick();
        }
        String clickThroughUrl = this.mVastModel.getVideoClicks().getClickThrough();
        Logger.logDebug(TAG, "clickThrough url: " + clickThroughUrl);
        List<String> urls = this.mVastModel.getVideoClicks().getClickTracking();
        this.fireUrls(urls);
        try {
            Uri uri = Uri.parse((String)clickThroughUrl);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            ResolveInfo resolvable = this.getPackageManager().resolveActivity(intent, 64);
            if (resolvable == null) {
                Logger.logError(TAG, "Clickthrough error occurred, uri unresolvable");
                if ((double)this.mCurrentVideoPosition >= (double)this.mMediaPlayer.getCurrentPosition() * 0.99) {
                    this.mMediaPlayer.start();
                }
            } else {
                this.navigateToBrowser(clickThroughUrl);
            }
        }
        catch (NullPointerException e) {
            Logger.logError(TAG, e.getMessage(), e);
            ErrorPosting.sendError((Context)this, 7, this.creativeString, this.adGroupId);
        }
    }

    private void navigateToBrowser(String url) {
        if (Build.VERSION.SDK_INT >= 23) {
            CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder();
            CustomTabsIntent customTabsIntent = builder.build();
            customTabsIntent.launchUrl((Context)this, Uri.parse((String)url));
        } else {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.startActivity(intent);
        }
    }

    private void closeClicked() {
        Logger.logDebug(TAG, "entered closeClicked()");
        this.cleanActivityUp();
        if (!this.mIsPlayBackError) {
            this.processEvent(TRACKING_EVENTS_TYPE.close);
        }
        this.finishVAST();
        Logger.logDebug(TAG, "leaving closeClicked()");
    }

    public void onBackPressed() {
        Logger.logDebug(TAG, "entered onBackPressed");
        if (this.mIsCompleted) {
            this.closeClicked();
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Logger.logDebug(TAG, "surfaceCreated -- (SurfaceHolder callback)");
        try {
            if (this.mMediaPlayer == null) {
                this.createMediaPlayer();
            }
            this.showProgressBar();
            this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
            String url = this.mVastModel.getPickedMediaFileURL();
            Logger.logDebug(TAG, "URL for media file:" + url);
            this.mMediaPlayer.setDataSource(url);
            this.mMediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            Logger.logError(TAG, e.getMessage(), e);
            ErrorPosting.sendError((Context)this, 7, this.creativeString, this.adGroupId);
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int arg1, int arg2, int arg3) {
        Logger.logDebug(TAG, "entered surfaceChanged -- (SurfaceHolder callback)");
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Logger.logDebug(TAG, "entered surfaceDestroyed -- (SurfaceHolder callback)");
        this.cleanUpMediaPlayer();
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        Logger.logDebug(TAG, "entered onVideoSizeChanged -- (MediaPlayer callback)");
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        Logger.logDebug(TAG, "video size: " + this.mVideoWidth + "x" + this.mVideoHeight);
    }

    public void onPrepared(MediaPlayer mp) {
        Logger.logDebug(TAG, "entered onPrepared called --(MediaPlayer callback) ....about to play");
        this.calculateAspectRatio();
        this.hideProgressBar();
        if (this.mIsCompleted) {
            Logger.logDebug(TAG, "Video's finished playing. stay idle");
            return;
        }
        this.mMediaPlayer.start();
        this.startVideoProgressTracker();
        Logger.logDebug(TAG, "current location in video:" + this.mCurrentVideoPosition);
        if (this.mCurrentVideoPosition > 0) {
            Logger.logDebug(TAG, "seeking to location:" + this.mCurrentVideoPosition);
            this.mMediaPlayer.seekTo(this.mCurrentVideoPosition);
            this.processEvent(TRACKING_EVENTS_TYPE.resume);
        }
        if (!this.mIsProcessedImpressions) {
            this.processImpressions();
        }
        this.startQuartileTracker();
        if (!this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.start();
        }
        if (VASTPlayer.listener != null) {
            VASTPlayer.listener.vastStart();
        }
    }

    private void calculateAspectRatio() {
        Logger.logDebug(TAG, "entered calculateAspectRatio");
        if (this.mVideoWidth == 0 || this.mVideoHeight == 0) {
            Logger.logWarning(TAG, "mVideoWidth or mVideoHeight is 0, skipping calculateAspectRatio");
            return;
        }
        Logger.logDebug(TAG, "calculating aspect ratio");
        double widthRatio = 1.0 * (double)this.mScreenWidth / (double)this.mVideoWidth;
        double heightRatio = 1.0 * (double)this.mScreenHeight / (double)this.mVideoHeight;
        double scale = Math.min(widthRatio, heightRatio);
        int surfaceWidth = (int)(scale * (double)this.mVideoWidth);
        int surfaceHeight = (int)(scale * (double)this.mVideoHeight);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(surfaceWidth, surfaceHeight);
        params.addRule(13);
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mSurfaceHolder.setFixedSize(surfaceWidth, surfaceHeight);
        Logger.logDebug(TAG, " screen size: " + this.mScreenWidth + "x" + this.mScreenHeight);
        Logger.logDebug(TAG, " video size:  " + this.mVideoWidth + "x" + this.mVideoHeight);
        Logger.logDebug(TAG, " widthRatio:   " + widthRatio);
        Logger.logDebug(TAG, " heightRatio:   " + heightRatio);
        Logger.logDebug(TAG, "surface size: " + surfaceWidth + "x" + surfaceHeight);
    }

    private void cleanActivityUp() {
        if (this.mHandler != null) {
            Logger.logDebug(TAG, "removing all hanging callbacks");
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.cleanUpMediaPlayer();
    }

    private void cleanUpMediaPlayer() {
        Logger.logDebug(TAG, "entered cleanUpMediaPlayer ");
        if (this.mMediaPlayer != null) {
            if (this.mMediaPlayer.isPlaying()) {
                this.mMediaPlayer.stop();
            }
            this.mMediaPlayer.setOnCompletionListener(null);
            this.mMediaPlayer.setOnErrorListener(null);
            this.mMediaPlayer.setOnPreparedListener(null);
            this.mMediaPlayer.setOnVideoSizeChangedListener(null);
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        Logger.logError(TAG, "entered onError -- (MediaPlayer callback)");
        this.mIsPlayBackError = true;
        Logger.logError(TAG, "Shutting down Activity due to Media Player errors: WHAT:" + what + ": EXTRA:" + extra + ":");
        this.processErrorEvent();
        this.closeClicked();
        ErrorPosting.sendError((Context)this, 8, this.creativeString, this.adGroupId);
        return true;
    }

    private void processErrorEvent() {
        Logger.logDebug(TAG, "entered processErrorEvent");
        List<String> errorUrls = this.mVastModel.getErrorUrl();
        this.fireUrls(errorUrls);
        VASTPlayer.listener.vastError(7);
        this.finishVAST();
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        Logger.logDebug(TAG, "entered onCOMPLETION -- (MediaPlayer callback)");
        this.stopVideoProgressTracker();
        this.mCloseButton.setVisibility(0);
        if (!this.mIsPlayBackError && !this.mIsCompleted) {
            this.mIsCompleted = true;
            this.processEvent(TRACKING_EVENTS_TYPE.complete);
            if (VASTPlayer.listener != null) {
                VASTPlayer.listener.vastComplete();
            }
        }
    }

    private void overlayClicked() {
        this.processClickThroughEvent();
    }

    private void processImpressions() {
        Logger.logDebug(TAG, "entered processImpressions");
        this.mIsProcessedImpressions = true;
        List<String> impressions = this.mVastModel.getImpressions();
        this.fireUrls(impressions);
    }

    private void fireUrls(List<String> urls) {
        Logger.logDebug(TAG, "entered fireUrls");
        if (urls != null) {
            for (String url : urls) {
                Logger.logVerbose(TAG, "\tfiring url:" + url);
                HttpTools.httpGetURL(url);
                VASTPlayer.testListener.interceptRequest(url);
            }
        } else {
            Logger.logDebug(TAG, "\turl list is null");
        }
    }

    private void startQuartileTracker() {
        Logger.logDebug(TAG, "entered startQuartileTracker");
        this.stopQuartileTracker();
        if (this.mIsCompleted) {
            Logger.logDebug(TAG, "ending quartileTimer because the video has been replayed");
            return;
        }
        this.mHandler.sendEmptyMessageDelayed(1, 250L);
    }

    private void stopQuartileTracker() {
        if (this.mHandler != null && this.mHandler.hasMessages(1)) {
            Logger.logDebug(TAG, "entered stopQuartileTracker");
            this.mHandler.removeMessages(1);
        }
    }

    private void quartileTracker() {
        this.mHandler.sendEmptyMessageDelayed(1, 250L);
        int videoDuration = this.mMediaPlayer.getDuration();
        int curPos = this.mMediaPlayer.getCurrentPosition();
        if (curPos == 0) {
            return;
        }
        int percentage = 100 * curPos / videoDuration;
        if (percentage >= 25 * this.mQuartile) {
            if (this.mQuartile == 0) {
                Logger.logInfo(TAG, "Video at start: (" + percentage + "%)");
                this.processEvent(TRACKING_EVENTS_TYPE.start);
            } else if (this.mQuartile == 1) {
                Logger.logInfo(TAG, "Video at first quartile: (" + percentage + "%)");
                this.processEvent(TRACKING_EVENTS_TYPE.firstQuartile);
            } else if (this.mQuartile == 2) {
                Logger.logInfo(TAG, "Video at midpoint: (" + percentage + "%)");
                this.processEvent(TRACKING_EVENTS_TYPE.midpoint);
            } else if (this.mQuartile == 3) {
                Logger.logInfo(TAG, "Video at third quartile: (" + percentage + "%)");
                this.processEvent(TRACKING_EVENTS_TYPE.thirdQuartile);
                this.stopQuartileTracker();
            }
            ++this.mQuartile;
        }
    }

    private void videoProgressTracker() {
        this.mHandler.sendEmptyMessageDelayed(2, 250L);
        this.mVideoProgressTracker.addLast(this.mMediaPlayer.getCurrentPosition());
        if (this.mMediaPlayer == null) {
            return;
        }
        if (this.mVideoProgressTracker.size() == 20) {
            int firstPosition = this.mVideoProgressTracker.getFirst();
            int lastPosition = this.mVideoProgressTracker.getLast();
            if (lastPosition > firstPosition) {
                Logger.logVerbose(TAG, "video progressing (position:" + lastPosition + ")");
                this.mVideoProgressTracker.removeFirst();
            } else {
                Logger.logError(TAG, "detected video hang, first position: " + this.mVideoProgressTracker.getFirst() + ", last position: " + this.mVideoProgressTracker.getLast());
                this.mIsPlayBackError = true;
                this.stopVideoProgressTracker();
                this.processErrorEvent();
                ErrorPosting.sendError((Context)this, 13, this.creativeString, this.adGroupId);
                this.closeClicked();
                this.finishVAST();
            }
        }
    }

    private void startVideoProgressTracker() {
        Logger.logDebug(TAG, "entered startVideoProgressTracker");
        this.mVideoProgressTracker = new LinkedList();
        this.mHandler.sendEmptyMessageDelayed(2, 250L);
    }

    private void stopVideoProgressTracker() {
        if (this.mHandler != null && this.mHandler.hasMessages(2)) {
            Logger.logDebug(TAG, "entered stopVideoProgressTracker");
            this.mHandler.removeMessages(2);
        }
    }

    private void processEvent(TRACKING_EVENTS_TYPE eventName) {
        Logger.logInfo(TAG, "entered Processing Event: " + (Object)((Object)eventName));
        List<String> urls = this.mTrackingEventMap.get((Object)eventName);
        this.fireUrls(urls);
    }

    private void finishVAST() {
        if (VASTPlayer.listener != null) {
            VASTPlayer.listener.vastDismiss();
        }
        this.finish();
    }
}

