/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk.vast;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.xad.sdk.events.CreativeEvent;
import com.xad.sdk.listeners.TestListener;
import com.xad.sdk.utils.ErrorPosting;
import com.xad.sdk.utils.Logger;
import com.xad.sdk.vast.activity.VASTActivity;
import com.xad.sdk.vast.model.VASTModel;
import com.xad.sdk.vast.processor.VASTProcessor;
import com.xad.sdk.vast.util.DefaultMediaPicker;
import com.xad.sdk.vast.util.HttpTools;
import com.xad.sdk.vast.util.NetworkTools;
import java.io.Serializable;
import java.util.List;

public class VASTPlayer {
    private static final String TAG = "VASTPlayer";
    public static final int ERROR_NONE = 0;
    public static final int ERROR_NO_NETWORK = 1;
    public static final int ERROR_XML_OPEN_OR_READ = 2;
    public static final int ERROR_XML_PARSE = 3;
    public static final int ERROR_SCHEMA_VALIDATION = 4;
    public static final int ERROR_NO_MEDIA_FILE_OR_NO_IMPRESSION = 5;
    public static final int ERROR_EXCEEDED_WRAPPER_LIMIT = 6;
    public static final int ERROR_MEDIA_FILE_PLAYBACK = 7;
    private Context mContext;
    private CreativeEvent creativeEvent;
    public static VASTPlayerListener listener;
    public static TestListener testListener;
    private VASTModel vastModel;

    public VASTPlayer(Context context, VASTPlayerListener listener) {
        this.mContext = context;
        VASTPlayer.listener = listener;
    }

    public void loadVideoWithData(final CreativeEvent creativeEvent) {
        this.creativeEvent = creativeEvent;
        Logger.logVerbose(TAG, "loadVideoWithData\n" + creativeEvent.CreativeString);
        this.vastModel = null;
        if (NetworkTools.connectedToInternet(this.mContext)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    DefaultMediaPicker mediaPicker = new DefaultMediaPicker(VASTPlayer.this.mContext);
                    VASTProcessor processor = new VASTProcessor(mediaPicker);
                    int error = processor.process(creativeEvent.CreativeString);
                    VASTPlayer.this.vastModel = processor.getModel();
                    if (error == 0 && VASTPlayer.this.vastModel != null) {
                        VASTPlayer.this.sendReady();
                    } else {
                        if (error == 5) {
                            VASTPlayer.this.processErrorEvent();
                        }
                        VASTPlayer.this.sendError(error);
                    }
                }
            }).start();
        } else {
            this.sendError(1);
        }
    }

    private void processErrorEvent() {
        List<String> errorUrls = this.vastModel.getErrorUrl();
        this.fireUrls(errorUrls);
    }

    private void fireUrls(List<String> urls) {
        Logger.logDebug(TAG, "entered fireUrls");
        if (urls != null) {
            for (String url : urls) {
                Logger.logVerbose(TAG, "\tfiring url:" + url);
                HttpTools.httpGetURL(url);
                testListener.interceptRequest(url);
            }
        } else {
            Logger.logDebug(TAG, "\turl list is null");
        }
    }

    public void play() {
        Logger.logDebug(TAG, "play");
        if (this.vastModel != null) {
            if (NetworkTools.connectedToInternet(this.mContext)) {
                Intent vastPlayerIntent = new Intent(this.mContext, VASTActivity.class);
                Bundle extras = new Bundle();
                extras.putSerializable("com.xad.displaysdk.vastmodel", (Serializable)this.vastModel);
                extras.putString("com.xad.displaysdk.creatievstring", this.creativeEvent.CreativeString);
                extras.putString("com.xad.displaysdk.adgroupid", this.creativeEvent.adGroupId);
                vastPlayerIntent.putExtras(extras);
                this.mContext.startActivity(vastPlayerIntent);
            } else {
                this.sendError(1);
            }
        } else {
            Logger.logWarning(TAG, "vastModel is null; nothing to play");
        }
    }

    private void sendReady() {
        Logger.logDebug(TAG, "sendReady");
        if (listener != null) {
            ((Activity)this.mContext).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    listener.vastReady();
                }
            });
        }
    }

    private void sendError(final int error) {
        Logger.logDebug(TAG, "sendError");
        switch (error) {
            case 2: {
                ErrorPosting.sendError(this.mContext, 11, this.creativeEvent.CreativeString, this.creativeEvent.adGroupId);
                break;
            }
            case 3: {
                ErrorPosting.sendError(this.mContext, 10, this.creativeEvent.CreativeString, this.creativeEvent.adGroupId);
                break;
            }
            case 5: {
                ErrorPosting.sendError(this.mContext, 7, this.creativeEvent.CreativeString, this.creativeEvent.adGroupId);
                break;
            }
            case 6: {
                ErrorPosting.sendError(this.mContext, 12, this.creativeEvent.CreativeString, this.creativeEvent.adGroupId);
                break;
            }
            default: {
                ErrorPosting.sendError(this.mContext, 0);
            }
        }
        if (listener != null) {
            ((Activity)this.mContext).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    listener.vastError(error);
                }
            });
        }
    }

    public void destroy() {
        this.mContext = null;
    }

    public static interface VASTPlayerListener {
        public void vastReady();

        public void vastError(int var1);

        public void vastClick();

        public void vastStart();

        public void vastComplete();

        public void vastDismiss();
    }
}

