/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk.utils;

import android.text.TextUtils;
import okhttp3.HttpUrl;

public class UrlGenerator {
    private static final String TAG = "UrlGenerator";
    HttpUrl.Builder httpUrlBuilder;

    public UrlGenerator() {
        this.httpUrlBuilder = new HttpUrl.Builder();
    }

    public UrlGenerator(String url) {
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            throw new IllegalArgumentException("url is cant resolved");
        }
        this.httpUrlBuilder = httpUrl.newBuilder();
    }

    public UrlGenerator withHost(String serverUrl, String pathSegments) {
        this.httpUrlBuilder.host(serverUrl);
        this.httpUrlBuilder.addPathSegments(pathSegments);
        return this;
    }

    public UrlGenerator withHost(String serverUrl, int port, String pathSegments) {
        this.httpUrlBuilder.host(serverUrl);
        this.httpUrlBuilder.port(port);
        this.httpUrlBuilder.addPathSegments(pathSegments);
        return this;
    }

    public UrlGenerator withHttps() {
        this.httpUrlBuilder.scheme("https");
        return this;
    }

    public UrlGenerator withHttp() {
        this.httpUrlBuilder.scheme("http");
        return this;
    }

    public HttpUrl generateUrl() {
        return this.httpUrlBuilder.build();
    }

    public String generateUrlString() {
        return this.generateUrl().toString();
    }

    public void addParam(String key, String value) {
        if (value == null || TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        this.httpUrlBuilder.addQueryParameter(key, value);
    }
}

