/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk.utils;

import android.util.Log;
import com.xad.sdk.DisplaySdk;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Logger {
    private static Level logLevel = Level.INFO;
    private static boolean enablePostLog;
    private static String logTagPrefix;

    public static String currentTime() {
        return Logger.logTime(new Date());
    }

    private static String logTime(Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ", Locale.US);
        return dateFormatter.format(date);
    }

    private static boolean postLogIsEnabled() {
        return enablePostLog;
    }

    public static void setEnablePostLog(boolean enable) {
        enablePostLog = enable;
    }

    public static void setLogTagPrefix(String prefix) {
        logTagPrefix = prefix;
    }

    public static String getLogTagPrefix() {
        return logTagPrefix;
    }

    public static void setLevel(Level level) {
        Log.d((String)"Logger", (String)("Log level set to " + level.toString()));
        logLevel = level;
    }

    public static Level getLevel() {
        return logLevel;
    }

    public static void logError(String tag, String msg) {
        if (logLevel.ordinal() >= Level.ERROR.ordinal()) {
            Log.e((String)(logTagPrefix + tag), (String)msg);
            if (Logger.postLogIsEnabled()) {
                DisplaySdk.sharedBus().post((Object)new LogEvent(Logger.currentTime() + tag + ": (E) " + msg));
            }
        }
    }

    public static void logError(String tag, String msg, Throwable tr) {
        if (logLevel.ordinal() >= Level.ERROR.ordinal()) {
            Log.e((String)(logTagPrefix + tag), (String)msg, (Throwable)tr);
            if (Logger.postLogIsEnabled()) {
                DisplaySdk.sharedBus().post((Object)new LogEvent(Logger.currentTime() + tag + ": (E) " + msg));
            }
        }
    }

    public static void logWarning(String tag, String msg) {
        if (logLevel.ordinal() >= Level.WARNING.ordinal()) {
            Log.w((String)(logTagPrefix + tag), (String)msg);
            if (Logger.postLogIsEnabled()) {
                DisplaySdk.sharedBus().post((Object)new LogEvent(Logger.currentTime() + tag + ": (W) " + msg));
            }
        }
    }

    public static void logInfo(String tag, String msg) {
        if (logLevel.ordinal() >= Level.INFO.ordinal()) {
            Log.i((String)(logTagPrefix + tag), (String)msg);
            if (Logger.postLogIsEnabled()) {
                DisplaySdk.sharedBus().post((Object)new LogEvent(Logger.currentTime() + tag + ": (I) " + msg));
            }
        }
    }

    public static void logDebug(String tag, String msg) {
        if (logLevel.ordinal() >= Level.DEBUG.ordinal()) {
            Log.d((String)(logTagPrefix + tag), (String)msg);
            if (Logger.postLogIsEnabled()) {
                DisplaySdk.sharedBus().post((Object)new LogEvent(Logger.currentTime() + tag + ": (D) " + msg));
            }
        }
    }

    public static void logVerbose(String tag, String msg) {
        if (logLevel.ordinal() >= Level.VERBOSE.ordinal()) {
            Log.v((String)(logTagPrefix + tag), (String)msg);
            if (Logger.postLogIsEnabled()) {
                DisplaySdk.sharedBus().post((Object)new LogEvent(Logger.currentTime() + tag + ": (V) " + msg));
            }
        }
    }

    static {
        logTagPrefix = "";
    }

    public static enum Level {
        NONE("NONE"),
        ERROR("ERROR"),
        WARNING("WARNING"),
        INFO("INFO"),
        DEBUG("DEBUG"),
        VERBOSE("VERBOSE");

        public final String value;

        private Level(String value) {
            this.value = value;
        }

        public String toString() {
            switch (this) {
                case NONE: {
                    return "Logger level: None";
                }
                case ERROR: {
                    return "Logger level: Error";
                }
                case WARNING: {
                    return "Logger level: Warning";
                }
                case INFO: {
                    return "Logger level: Info";
                }
                case DEBUG: {
                    return "Logger level: Debug";
                }
                case VERBOSE: {
                    return "Logger level: Verbose";
                }
            }
            return "None";
        }
    }

    public static class LogEvent {
        public final String Log;

        public LogEvent(String log) {
            this.Log = log;
        }
    }
}

