/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.xad.sdk.utils.Logger;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class ErrorPosting {
    public static final int CONTENT_ERROR_TO_POST = 0;
    public static final int CONTENT_CANNOT_LOAD_ERROR_TO_POST = 1;
    public static final int CONTENT__EXPAND_URL_ERROR_TO_POST = 2;
    public static final int CONTENT_RESIZE_PROPERTIES_ERROR_TO_POST = 3;
    public static final int CONTENT_INJECT_JAVASCRIPT_ERROR_TO_POST = 4;
    public static final int CONTENT_PARSE_COMMAND_ERROR_TO_POST = 5;
    public static final int CONTENT_DECODING_ERROR_TO_POST = 6;
    public static final int CONTENT_VAST_NOT_VALID_ERROR_TO_POST = 7;
    public static final int CONTENT_VIDEO_PLAYBACK_ERROR_TO_POST = 8;
    public static final int CONTENT_VIDEO_DURATION_ERROR_TO_POST = 9;
    public static final int CONTENT_XML_CANNOT_PARSE_ERROR_TO_POST = 10;
    public static final int CONTENT_XML_CANNOT_OPEN_OR_READ_ERROR_TO_POST = 11;
    public static final int CONTENT_XML_EXCEEDED_WRAPPER_LIMIT_ERROR_TO_POST = 12;
    public static final int CONTENT_VIDEO_HANG_ERROR_TO_POST = 13;
    public static final int INTERNAL_ERROR_TO_POST = 14;
    public static final int SERVER_ERROR_TO_POST = 15;

    public static void sendError(Context context, int error, String payload, String adGroupId) {
        JSONObject jsonObject = new JSONObject();
        try {
            int labelStringId = context.getApplicationInfo().labelRes;
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            jsonObject.put("app", (Object)context.getString(labelStringId));
            jsonObject.put("appv", (Object)packageInfo.versionName);
            jsonObject.put("sdkv", (Object)"1.0");
            jsonObject.put("os", (Object)"android");
            jsonObject.put("err", error);
            jsonObject.put("pay", (Object)payload);
            jsonObject.put("adgroup", (Object)adGroupId);
        }
        catch (PackageManager.NameNotFoundException | JSONException e) {
            e.printStackTrace();
        }
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/x-www-form-urlencoded"), (String)jsonObject.toString());
        Request request = new Request.Builder().url("https://display.xad.com/sdk/errors").post(body).build();
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).build();
        Logger.logVerbose("ErrorPosting", "Request: " + request.toString() + "\nbody: " + jsonObject.toString());
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                Logger.logError("ErrorPosting", "Failed to send error report");
            }

            public void onResponse(Call call, Response response) throws IOException {
                Logger.logVerbose("ErrorPosting", "Response: " + response.toString());
            }
        });
    }

    public static void sendError(Context context, int error, String payload) {
        ErrorPosting.sendError(context, error, payload, "0");
    }

    public static void sendError(Context context, int error) {
        ErrorPosting.sendError(context, error, "");
    }
}

