/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.webkit.WebView;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.common.hash.Hashing;
import com.xad.sdk.AdRequest;
import com.xad.sdk.AdSize;
import com.xad.sdk.AdType;
import com.xad.sdk.utils.Logger;
import com.xad.sdk.utils.UrlGenerator;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;

public class AdUrlGenerator
extends UrlGenerator {
    private static final String TAG = "AdUrlGenerator";
    private static String userAgent;

    public AdUrlGenerator(Context context) {
        this.withHttp();
        this.addDeviceParams(context);
    }

    public AdUrlGenerator(Context context, String url) {
        super(url);
        this.addDeviceParams(context);
    }

    private void addDeviceParams(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        this.addParam("sdk", "xad_display_sdk_android");
        this.addParam("sdkv", "1.0");
        this.addParam("os", "android");
        this.addParam("osv", Integer.toString(Build.VERSION.SDK_INT));
        this.addParam("v", "1.2");
        this.addParam("sdk_conf", "jssdk");
        this.addParam("dev_model", Build.MODEL);
        this.addParam("dev_type", this.deviceType(context));
        this.addParam("carrier", tm.getNetworkOperatorName());
        this.addParam("lang", Locale.getDefault().getDisplayLanguage());
        this.addParam("devid", this.userAgent(context));
        this.addParam("wifi", wifiInfo.getSSID());
        try {
            int labelStringId = context.getApplicationInfo().labelRes;
            this.addParam("appname", context.getString(labelStringId));
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            this.addParam("appver", packageInfo.versionName);
            this.addParam("bundle", packageInfo.packageName);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    private String deviceType(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3 ? "tablet" : "phone";
    }

    private String userAgent(final Context context) {
        if (TextUtils.isEmpty((CharSequence)userAgent)) {
            Handler handler = new Handler(context.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    WebView webView = new WebView(context);
                    userAgent = webView.getSettings().getUserAgentString();
                }
            });
        }
        return userAgent != null ? userAgent : System.getProperty("http.agent");
    }

    public AdUrlGenerator withAdRequest(AdRequest adRequest) {
        if (adRequest.getVmax() > 0 && adRequest.getVmin() > 0) {
            this.addParam("vmin", Integer.toString(adRequest.getVmin()));
            this.addParam("vmax", Integer.toString(adRequest.getVmax()));
        }
        this.addParam("age", Integer.toString(adRequest.getAge()));
        this.addParam("gender", adRequest.getGender().value);
        if (adRequest.getZipCode() != null) {
            this.addParam("zip", adRequest.getZipCode());
        }
        if (adRequest.getState() != null && adRequest.getCity() != null) {
            this.addParam("loc", adRequest.getCity() + "," + adRequest.getState());
        }
        if (adRequest.getExtras() != null) {
            for (Map.Entry<String, String> entry : adRequest.getExtras().entrySet()) {
                this.addParam(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public AdUrlGenerator withFormat(AdType type) {
        switch (type) {
            case BANNER: {
                this.addParam("o_fmt", "html5,exp");
                this.addParam("api", "3");
                this.addParam("api", "5");
                this.addParam("instl", "0");
                break;
            }
            case INTERSTITIAL: {
                this.addParam("o_fmt", "html5,exp");
                this.addParam("api", "3");
                this.addParam("api", "5");
                this.addParam("instl", "1");
                break;
            }
            case REWARDED_VIDEO: {
                this.addParam("o_fmt", "video");
                this.addParam("vmime", "video/mp4");
                this.addParam("vmime", "video/mpeg-4");
                this.addParam("vmime", "video/3gpp");
                this.addParam("vmime", "video/3gp");
                this.addParam("vmime", "video/mkv");
                this.addParam("vmime", "video/webm");
                this.addParam("vlinearity", "1");
                this.addParam("vprotocol", "1");
                this.addParam("vprotocol", "2");
                this.addParam("vprotocol", "4");
                this.addParam("vprotocol", "5");
                break;
            }
        }
        return this;
    }

    public AdUrlGenerator withAdSize(@Nullable AdSize adSize) {
        if (adSize != null) {
            this.addParam("size", adSize.toString());
        } else {
            Logger.logDebug(TAG, "No adSize available for Interstitial and Video");
        }
        return this;
    }

    public AdUrlGenerator withAccessKey(@NonNull String accessKey) {
        this.addParam("k", accessKey);
        return this;
    }

    public AdUrlGenerator withLocation(@Nullable Location location) {
        if (location == null) {
            return this;
        }
        this.addParam("lat", Double.toString(location.getLatitude()));
        this.addParam("long", Double.toString(location.getLongitude()));
        if (location.hasAccuracy()) {
            this.addParam("ha", Float.toString(location.getAccuracy()));
        }
        this.addParam("alt", Double.toString(location.getAltitude()));
        if (location.hasBearing()) {
            this.addParam("course", Float.toString(location.getBearing()));
        }
        this.addParam("timestamp", Long.toString(location.getTime()));
        return this;
    }

    public AdUrlGenerator withAdvertisingInfo(AdvertisingIdClient.Info advertisingInfo) {
        this.addParam("dnt", advertisingInfo.isLimitAdTrackingEnabled() ? "1" : "0");
        this.addParam("uid", advertisingInfo.getId());
        this.addParam("uid_type", "GIDFA|RAW");
        return this;
    }

    public AdUrlGenerator withAndroidID(Context context) {
        this.addParam("dnt", "0");
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        this.addParam("uid", this.sha1(androidId));
        this.addParam("uid_type", "Android_Id|SHA1");
        return this;
    }

    private String sha1(String str) {
        return String.format(Locale.US, "%d", Hashing.sha1().hashString((CharSequence)str, Charset.defaultCharset()).asLong());
    }
}

