/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.xad.sdk.AdRequest;
import com.xad.sdk.AdSize;
import com.xad.sdk.AdType;
import com.xad.sdk.utils.UrlGenerator;

public class AdTestUrlGenerator
extends UrlGenerator {
    private static final String TAG = "AdTestUrlGenerator";
    private AdRequest.TestType testType;

    public AdTestUrlGenerator withAdTypeAndAdSize(AdType adType, @Nullable AdSize adSize) {
        if (this.testType != AdRequest.TestType.SANDBOX) {
            return this;
        }
        switch (adType) {
            case BANNER: {
                this.addParam("type", "banner");
                if (adSize == null) break;
                this.addParam("size", adSize.toString());
                break;
            }
            case INTERSTITIAL: {
                this.addParam("type", "interstitial");
                break;
            }
            case REWARDED_VIDEO: {
                this.addParam("type", "video");
                break;
            }
        }
        return this;
    }

    public AdTestUrlGenerator(String testUrl, AdRequest.TestType testType, @Nullable String channelId) {
        super(testUrl + "/" + testType.value + (testType == AdRequest.TestType.CHANNEL && channelId != null ? "/" + channelId : ""));
        this.testType = testType;
        this.addParam("no_redirect", "1");
    }

    public AdTestUrlGenerator withAccessKey(@NonNull String accessKey) {
        this.addParam("k", accessKey);
        return this;
    }
}

