/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk.mraid.internal;

import android.support.annotation.Nullable;
import com.xad.sdk.utils.Logger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class MRAIDParser {
    private static final String TAG = "MRAIDParser";

    @Nullable
    public Map<String, String> parseCommandUrl(String commandUrl) {
        String command;
        Logger.logDebug(TAG, "parseCommandUrl " + commandUrl);
        String s = commandUrl.substring(8);
        HashMap<String, String> params = new HashMap<String, String>();
        int idx = s.indexOf(63);
        if (idx != -1) {
            String[] paramArray;
            command = s.substring(0, idx);
            String paramStr = s.substring(idx + 1);
            for (String param : paramArray = paramStr.split("&")) {
                idx = param.indexOf(61);
                String key = param.substring(0, idx);
                String val = param.substring(idx + 1);
                params.put(key, val);
            }
        } else {
            command = s;
        }
        if (!this.isValidCommand(command)) {
            Logger.logWarning(TAG, "command " + command + " is unknown");
            return null;
        }
        if (!this.checkParamsForCommand(command, params)) {
            Logger.logWarning(TAG, "command URL " + commandUrl + " is missing parameters");
            return null;
        }
        HashMap<String, String> commandMap = new HashMap<String, String>();
        commandMap.put("command", command);
        commandMap.putAll(params);
        return commandMap;
    }

    private boolean isValidCommand(String command) {
        String[] commands = new String[]{"close", "createCalendarEvent", "expand", "open", "playVideo", "resize", "setOrientationProperties", "setResizeProperties", "storePicture", "useCustomClose"};
        return Arrays.asList(commands).contains(command);
    }

    private boolean checkParamsForCommand(String command, Map<String, String> params) {
        if (command.equals("createCalendarEvent")) {
            return params.containsKey("eventJSON");
        }
        if (command.equals("open") || command.equals("playVideo") || command.equals("storePicture")) {
            return params.containsKey("url");
        }
        if (command.equals("setOrientationProperties")) {
            return params.containsKey("allowOrientationChange") && params.containsKey("forceOrientation");
        }
        if (command.equals("setResizeProperties")) {
            return params.containsKey("width") && params.containsKey("height") && params.containsKey("offsetX") && params.containsKey("offsetY") && params.containsKey("customClosePosition") && params.containsKey("allowOffscreen");
        }
        if (command.equals("useCustomClose")) {
            return params.containsKey("useCustomClose");
        }
        return true;
    }
}

