/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk.mraid.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MRAIDHtmlProcessor {
    public static String processRawHtml(String rawHtml) {
        Matcher matcher;
        Pattern pattern;
        String regex;
        boolean hasBodyTag;
        StringBuffer processedHtml = new StringBuffer(rawHtml);
        boolean hasHtmlTag = rawHtml.indexOf("<html") != -1;
        boolean hasHeadTag = rawHtml.indexOf("<head") != -1;
        boolean bl = hasBodyTag = rawHtml.indexOf("<body") != -1;
        if (!hasHtmlTag && (hasHeadTag || hasBodyTag) || hasHtmlTag && !hasBodyTag) {
            return null;
        }
        String ls = System.getProperty("line.separator");
        if (!hasHtmlTag) {
            processedHtml.insert(0, "<html>" + ls + "<head>" + ls + "</head>" + ls + "<body><div align='center'>" + ls);
            processedHtml.append("</div></body>" + ls + "</html>");
        } else if (!hasHeadTag) {
            regex = "<html[^>]*>";
            pattern = Pattern.compile(regex, 2);
            matcher = pattern.matcher(processedHtml);
            int idx = 0;
            while (matcher.find(idx)) {
                processedHtml.insert(matcher.end(), ls + "<head>" + ls + "</head>");
                idx = matcher.end();
            }
        }
        String metaTag = "<meta name='viewport' content='width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no' />";
        String styleTag = "<style>" + ls + "body { margin:0; padding:0;}" + ls + "*:not(input) { -webkit-touch-callout:none; -webkit-user-select:none; -webkit-text-size-adjust:none; }" + ls + "</style>";
        String mraidScriptTag = "<script type = 'text/javascript' src = 'mraid.js' ></script>";
        regex = "<head[^>]*>";
        pattern = Pattern.compile(regex, 2);
        matcher = pattern.matcher(processedHtml);
        int idx = 0;
        while (matcher.find(idx)) {
            processedHtml.insert(matcher.end(), ls + metaTag + ls + styleTag + ls + mraidScriptTag);
            idx = matcher.end();
        }
        return processedHtml.toString();
    }

    public static String processRawHtml(String rawHtml, String mraidJS) {
        boolean hasBodyTag;
        StringBuffer processedHtml = new StringBuffer(rawHtml);
        String regex = "<script\\s+[^>]*\\bsrc\\s*=\\s*([\\\"\\'])mraid\\.js\\1[^>]*>\\s*</script>\\n*";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(processedHtml);
        if (matcher.find()) {
            processedHtml.delete(matcher.start(), matcher.end());
        }
        boolean hasHtmlTag = rawHtml.indexOf("<html") != -1;
        boolean hasHeadTag = rawHtml.indexOf("<head") != -1;
        boolean bl = hasBodyTag = rawHtml.indexOf("<body") != -1;
        if (!hasHtmlTag && (hasHeadTag || hasBodyTag) || hasHtmlTag && !hasBodyTag) {
            return null;
        }
        String ls = System.getProperty("line.separator");
        if (!hasHtmlTag) {
            processedHtml.insert(0, "<html>" + ls + "<head>" + ls + "<script>" + ls + mraidJS + ls + "</script>" + ls + "</head>" + ls + "<body><div align='center'>" + ls);
            processedHtml.append("</div></body>" + ls + "</html>");
        } else if (!hasHeadTag) {
            regex = "<html[^>]*>";
            pattern = Pattern.compile(regex, 2);
            matcher = pattern.matcher(processedHtml);
            int idx = 0;
            while (matcher.find(idx)) {
                processedHtml.insert(matcher.end(), ls + "<head>" + ls + "</head>");
                idx = matcher.end();
            }
        }
        String metaTag = "<meta name='viewport' content='width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no' />";
        String styleTag = "<style>" + ls + "body { margin:0; padding:0;}" + ls + "*:not(input) { -webkit-touch-callout:none; -webkit-user-select:none; -webkit-text-size-adjust:none; }" + ls + "</style>";
        regex = "<head[^>]*>";
        pattern = Pattern.compile(regex, 2);
        matcher = pattern.matcher(processedHtml);
        int idx = 0;
        while (matcher.find(idx)) {
            processedHtml.insert(matcher.end(), ls + metaTag + ls + styleTag);
            idx = matcher.end();
        }
        return "<!doctype html>" + processedHtml.toString();
    }
}

