/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk.mraid;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.xad.sdk.utils.Logger;
import com.xad.sdk.vast.util.Assets;
import java.util.LinkedList;

public class VideoPlayerActivity
extends Activity
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
SurfaceHolder.Callback {
    private static String TAG = "VideoPlayerActivity";
    private Handler mHandler;
    private String mVideoDataUrl;
    private static final double SKIP_INFO_PADDING_SCALE = 0.1;
    private static final double SKIP_INFO_SCALE = 0.15;
    private static final long TOOLBAR_HIDE_DELAY = 3000L;
    private static final long VIDEO_PROGRESS_TIMER_INTERVAL = 250L;
    private static final int HIDE_TOOL_BAR = 0;
    private static final int VIDEO_PROGRESS_TRACKING = 1;
    private LinkedList<Integer> mVideoProgressTracker = null;
    private final int mMaxProgressTrackingPoints = 20;
    private MediaPlayer mMediaPlayer;
    private SurfaceView mSurfaceView;
    private SurfaceHolder mSurfaceHolder;
    private RelativeLayout mOverlay;
    private RelativeLayout mRootLayout;
    private RelativeLayout mButtonPanel;
    private ImageButton mPlayPauseButton;
    private Drawable mPauseDrawable;
    private Drawable mPlayDrawable;
    private int mVideoHeight;
    private int mVideoWidth;
    private int mScreenWidth;
    private int mScreenHeight;
    private boolean mIsVideoPaused = false;
    private int mCurrentVideoPosition;
    private ProgressBar mProgressBar;
    private static final String POSITION_STATUS = "com.xad.sdk.displaysdk.videoplayactivity.position";
    private static final String PAUSE_STATUS = "com.xad.sdk.displaysdk.videoplayactivity.pause";

    protected void onCreate(Bundle savedInstanceState) {
        Logger.logDebug(TAG, "enter onCreate --(life cycle event)");
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mCurrentVideoPosition = savedInstanceState.getInt(POSITION_STATUS);
            this.mIsVideoPaused = savedInstanceState.getBoolean(PAUSE_STATUS);
        }
        int currentOrientation = this.getResources().getConfiguration().orientation;
        Logger.logDebug(TAG, "currentOrientation:" + currentOrientation);
        if (currentOrientation != 2) {
            Logger.logDebug(TAG, "Orientation is not landscape.....forcing landscape");
            this.setRequestedOrientation(0);
        } else {
            Logger.logDebug(TAG, "orientation is landscape");
            this.mVideoDataUrl = this.getIntent().getStringExtra("com.xad.displaysdk.videodataurl");
            if (TextUtils.isEmpty((CharSequence)this.mVideoDataUrl)) {
                Logger.logError(TAG, "video url is null. Stopping activity.");
                this.finish();
            } else {
                this.hideTitleStatusBars();
                this.mHandler = new Handler(new Handler.Callback(){

                    public boolean handleMessage(Message msg) {
                        switch (msg.what) {
                            case 0: {
                                VideoPlayerActivity.this.hideToolbar();
                                break;
                            }
                            case 1: {
                                VideoPlayerActivity.this.trackVideoProgress();
                            }
                        }
                        return true;
                    }
                });
                DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
                this.mScreenWidth = displayMetrics.widthPixels;
                this.mScreenHeight = displayMetrics.heightPixels;
                this.createUIComponents();
            }
        }
    }

    protected void onStart() {
        Logger.logDebug(TAG, "entered onStart --(life cycle event)");
        super.onStart();
    }

    protected void onResume() {
        Logger.logDebug(TAG, "entered on onResume --(life cycle event)");
        super.onResume();
    }

    protected void onStop() {
        Logger.logDebug(TAG, "entered on onStop --(life cycle event)");
        super.onStop();
    }

    protected void onRestart() {
        Logger.logDebug(TAG, "entered on onRestart --(life cycle event)");
        super.onRestart();
        this.createMediaPlayer();
    }

    protected void onPause() {
        Logger.logDebug(TAG, "entered on onPause --(life cycle event)");
        super.onPause();
        if (this.mMediaPlayer != null) {
            this.mCurrentVideoPosition = this.mMediaPlayer.getCurrentPosition();
        }
        this.cleanActivityUp();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(POSITION_STATUS, this.mCurrentVideoPosition);
        outState.putBoolean(PAUSE_STATUS, this.mIsVideoPaused);
    }

    protected void onDestroy() {
        Logger.logDebug(TAG, "entered on onDestroy --(life cycle event)");
        super.onDestroy();
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.mHandler = null;
    }

    private void hideTitleStatusBars() {
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
    }

    private void createUIComponents() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.createRootLayout(params);
        this.createSurface(params);
        this.createMediaPlayer();
        this.createOverlay(params);
        this.createButtonPanel(this.mScreenWidth, this.mScreenHeight);
        int size = Math.min(this.mScreenWidth, this.mScreenHeight);
        size = (int)(0.15 * (double)size);
        this.createPlayPauseButton(size);
        this.createCloseButton(size);
        this.setContentView((View)this.mRootLayout);
        this.createProgressBar();
    }

    private void createProgressBar() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(13);
        this.mProgressBar = new ProgressBar((Context)this);
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mRootLayout.addView((View)this.mProgressBar);
        this.mProgressBar.setVisibility(8);
    }

    private void showProgressBar() {
        this.mProgressBar.setVisibility(0);
    }

    private void hideProgressBar() {
        this.mProgressBar.setVisibility(8);
    }

    private void createRootLayout(RelativeLayout.LayoutParams params) {
        this.mRootLayout = new RelativeLayout((Context)this);
        this.mRootLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mRootLayout.setPadding(0, 0, 0, 0);
        this.mRootLayout.setBackgroundColor(-16777216);
    }

    private void createSurface(RelativeLayout.LayoutParams params) {
        this.mSurfaceView = new SurfaceView((Context)this);
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mSurfaceHolder = this.mSurfaceView.getHolder();
        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.mRootLayout.addView((View)this.mSurfaceView);
    }

    private void createMediaPlayer() {
        this.mMediaPlayer = new MediaPlayer();
        this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mMediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
        this.mMediaPlayer.setAudioStreamType(3);
        this.mMediaPlayer.setScreenOnWhilePlaying(true);
    }

    private void createOverlay(RelativeLayout.LayoutParams params) {
        this.mOverlay = new RelativeLayout((Context)this);
        this.mOverlay.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mOverlay.setPadding(0, 0, 0, 0);
        this.mOverlay.setBackgroundColor(0);
        this.mOverlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoPlayerActivity.this.overlayClicked();
            }
        });
        this.mRootLayout.addView((View)this.mOverlay);
    }

    private void createButtonPanel(int screenWidth, int screenHeight) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(12);
        this.mButtonPanel = new RelativeLayout((Context)this);
        this.mButtonPanel.setLayoutParams((ViewGroup.LayoutParams)params);
        int padding = Math.min(screenWidth, screenHeight);
        padding = (int)(0.1 * (double)padding);
        this.mButtonPanel.setPadding(padding, 0, padding, 0);
        this.mButtonPanel.setBackgroundColor(-16777216);
        this.mButtonPanel.setVisibility(8);
        this.mOverlay.addView((View)this.mButtonPanel);
    }

    private void createCloseButton(int size) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);
        params.addRule(11);
        ImageButton mCloseButton = new ImageButton((Context)this);
        Drawable drawable = Assets.getDrawableFromBase64(this.getResources(), "iVBORw0KGgoAAAANSUhEUgAAAC0AAAAtCAYAAAA6GuKaAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJ bWFnZVJlYWR5ccllPAAAA2hpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdp bj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6 eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0 NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJo dHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlw dGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEu MC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVz b3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1N Ok9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpGRUU5MjA4OTBDMjA2ODExODA4M0YyQ0E4QjA4 M0I1MCIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDo2MzBFQTlFQTYxMjAxMUUzQjhCRkRDNTJC NjI0NTY5OCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDo2MzBFQTlFOTYxMjAxMUUzQjhCRkRD NTJCNjI0NTY5OCIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M2IChNYWNpbnRv c2gpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6QTlBRDI1 MTgxMDIwNjgxMTgwODNGMkNBOEIwODNCNTAiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6RkVF OTIwODkwQzIwNjgxMTgwODNGMkNBOEIwODNCNTAiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRm OlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz6uekVTAAADwElEQVR42uyZXUgV QRTHvX5lGZVCWkpUWlhU+HD9qAcRNIoyQaV6sYfoQYKw8qUgK4LqWmJU9JhW0AfkQ4UFERFCL2Jh BqVkIopkaqIWpVh+bP+h/4Xltrt3Zu/erLgDP+S6Z878d3b2zDmzLk3Twv615gqJDokOiTZsySAL ZIMNYAmIBZNgFHSCFtAMWsHMbIl2gW2gDGwHUfz/CBgE4yASxIMkEMHr7eAmuAU+2BpZiLZBPmjS frUf4C7YA9aAuSCCdmJSokEi2Ao8oJP9PoNjtFcaX1VsDKjhoBPgDFiu6EPcRBF4QT+tIDNYouPB Ew70EKy2+ZT04g+B75yAYqdFLwYvKfgEH3uYQ2SBbvoudUq0WBJP6fSAg2L1rADvwBTY7IToCxR8 MkiCvaSBIdAPkgMRnUvBj4Is2Esxx7ttV7QIW81gjI/PzE6ErF2SorLBRj82Nyg8147oAnY+bWET Be7QrsqPmAw+/mGKt1rfE4xUyqIbwDhIMrm+gI9R36osBPfr7AZBjsXYdbRbryI6ifGz3sLxbs24 eXzsMn0Ee1sjiDTxnUObShXRJRJxM5ozayXcDT4aXG9jtDDzPYc3+lxF9Dk6T5N4ucyE1+o2DX1r BykSfu+BL2CRrGixnkcVkhmPJtfa/UQiPWfZZ52s6BYOEK4QY8UgMxaC34CVCv72s99vL2y4ScYq EvgxxWS9Elw3uTYECkG3gr+v/Bvje8FMtMak3qUwiBvkmFxbCPYqpvreomJGtggQb20vNw+ZRyni cJ/EmvYoLI8j7JMlu6avMeNKkHDuNonDwybCqyRFXwWTRkWGWYdyDpAnMcNGgt+CVeBUADP+CnQZ bUBWYjSWU2Y2m8Ank40jRSIc1uhqSV/E7E5zO5feXMTddbAIjbIQPSK5cRhtQBctQupB2hSoJkxH 2bHQT6o5ILlx6Ge82k960MFAME9VdCLL/BY/UUQE/8cgVWKdiiVxyY/NPt5Yhd3K5TgdlP+hymUp X+wupr62RM8Hr5mUZwRZsKjwH3CSigItbN0suXoUkh07VFPwZafOPXbS4XujrMsBztP/fb6Ijp0w lep2uhIH13A9/YqlERuMs7wtuh2wNoCjMXEAVMZaUWNEkc1zbJ2aLtNV4NPMU/IoxKpfOLf2Cp4m aYwSyk8tkPPpfHAY7ODvftAE2sAA82FxJp0AUnngnk7bHnAF1IEvs/ElIJ3CxcH6WhBnYDMFekEj aADPWGT8Fd9c4vgpI44VhxD7jTPfF+hni9CHopDo/1X0TwEGAMn4kfWfS4oUAAAAAElFTkSuQmCC");
        mCloseButton.setImageDrawable(drawable);
        mCloseButton.setLayoutParams((ViewGroup.LayoutParams)params);
        mCloseButton.setScaleType(ImageView.ScaleType.CENTER_CROP);
        mCloseButton.setPadding(0, 0, 0, 0);
        mCloseButton.setBackgroundColor(0);
        mCloseButton.setVisibility(0);
        mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoPlayerActivity.this.close();
            }
        });
        this.mButtonPanel.addView((View)mCloseButton);
    }

    private void createPlayPauseButton(int size) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);
        params.addRule(9);
        this.mPauseDrawable = Assets.getDrawableFromBase64(this.getResources(), "iVBORw0KGgoAAAANSUhEUgAAAC0AAAAtCAYAAAA6GuKaAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJ bWFnZVJlYWR5ccllPAAAA2hpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdp bj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6 eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0 NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJo dHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlw dGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEu MC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVz b3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1N Ok9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpGOUU5MjA4OTBDMjA2ODExODA4M0YyQ0E4QjA4 M0I1MCIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDpDNDMxMTM3NzYxMjAxMUUzQjhCRkRDNTJC NjI0NTY5OCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpDNDMxMTM3NjYxMjAxMUUzQjhCRkRD NTJCNjI0NTY5OCIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M2IChNYWNpbnRv c2gpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6MDM4MDEx NzQwNzIwNjgxMTgwODNBRjJCNzQzNDlDQ0IiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6RjlF OTIwODkwQzIwNjgxMTgwODNGMkNBOEIwODNCNTAiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRm OlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz7tuMs8AAADCElEQVR42uzZW0gU URzHcddVu4hlFwvTsKToZhZRPlVQgdFDQReyQui1XgLBSirwQXqLwvC1EKIgrMgKgkIfoqALimFa CEWGLRSoWG5Cptt36Le0iO7OdQdhD3wY0XHmNztzzpzz30AkEkmbbi09bRq2VOhU6Dgtw6XjrMdW bMFq5CETP9GHdrzGc/Q7PVnAwegxG8dwEhvwB53owSBGkY18lGIpwmhGA17aTm2EtqECHzGGuziA BXH2z0QJatAT+dduocjO+a3+Qw4addLbWGfjpFk4jq8YxEEvQ+fjDYZwyOYdijUP1/UBVHsReiG6 0Is1LgSOVaPgZ90MbTyPrQhhmcuBo04r+BG3QtfpgGUeBY66hhEUOw1dauHWGRdVjuWTdLxd+ltu gk7+GQ+dhn6gISrLROh2XWDthN/nRf637QmOsd/MfvFe42uxF3X4bWLI/6XtxH2Nt9ewfh5LcIxm vaDO2J17VOrNdi+J04px1GM3Cu2ENj7l+3r1JrM9Vvhyq6GXYCVafJjEhfBBEzBLoVcZkyl0+zT7 bEOJ1dCLFTrkU+hezQrTrYTOVuiwT6GNeXgOglZCj2sb9Cl0MN7wOFXoIY2vc30KPR8DWliYDt2n bZFPoY2B4JM+ONOh32MEm3x6NDZrXWnp8TA6wiu9YJLdSjRytNp5I97BTh8ekaNasT+zGzqs1Xay Wi5OoDHecBsvtNF7r6BKtytRm6Ft5sQyBWaZLA5Va9+rTipMl3WrGkyEfoeOmJEn2kbVPzrUV6Zq Rm3kPC7ii9O6xx5NzKs8XGrNQTfazCw4zB70goJXehA4Gy3oxwq36x71Cn7KxcAFeIEfVhbOVk9S q+A3VbxxEnifyhLGYnajl2Wx6OLzGwZwzkb4bXiki2/CIq9rebEr7EsIq0zWpOe9VOWuoPabiULs UL94q7CdKlraOn/A4RdFBajAYZRpJT6i2VlEQ2qW5ufGIvkpbuDJVDM4r+vTk60rjbG2WFPLDI3L 39GluvWwGycKpL6SS4VOhU6FttX+CjAAgpoINtDHo/4AAAAASUVORK5CYII=");
        this.mPlayDrawable = Assets.getDrawableFromBase64(this.getResources(), "iVBORw0KGgoAAAANSUhEUgAAAC0AAAAtCAYAAAA6GuKaAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJ bWFnZVJlYWR5ccllPAAAA2hpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdp bj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6 eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0 NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJo dHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlw dGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEu MC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVz b3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1N Ok9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpGNEU5MjA4OTBDMjA2ODExODA4M0YyQ0E4QjA4 M0I1MCIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDo2MzBFQTlFNjYxMjAxMUUzQjhCRkRDNTJC NjI0NTY5OCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDo2MzBFQTlFNTYxMjAxMUUzQjhCRkRD NTJCNjI0NTY5OCIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M2IChNYWNpbnRv c2gpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6MDI4MDEx NzQwNzIwNjgxMTgwODNBRjJCNzQzNDlDQ0IiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6RjRF OTIwODkwQzIwNjgxMTgwODNGMkNBOEIwODNCNTAiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRm OlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz77Lxw7AAADm0lEQVR42uyZXUgU URiG1dW1H0szrazwF9O0ItmEDBOW8qKopC66qKiIgiDKLkKCfgiJIArSLuyiQsoMIugiMAgqCylE CAMtgpJAS/JvLY2ldpXtPfQOLTK7e2bmjCj4wcOiO3O+d2bOfud7z0QHAoGo6RYxUdMwZkRPVsQq HCsOpIMlIIH/84I+0A1+TxXR88EWsAuUgWTgnHCMHwyDVvAINIFBK0mjTVaPRHAMVIJF4At4AdrB J+ABYuAFIBusBW6QD0ZAHajhUzAeQrRBtoOuwL94ANwgVuI8B9gA6nnud7DXRH5DosVTucyELaDY TEKyEjRxrFsg3g7RTtDAJBck76wMxznmE5CgWvRtDn5IkdhgdoBx3nmnKtGnKfiIDYI1KpjjugrR JRzsqo2CNU4xV0WkY8OVPFHD21h3i1hv9WI2mMVabDWaQRZYDUbNlLx9vHJ3hCvPB+/BfgU/0FXM WWVmeoia2gmaJRLlBP7HM1BmUXgja/gco6LXU8ROSdH+IOF+VpsVJkWXRJrboU68AjyStXOiaC0G wHmQZFC0gyvufaOixdR4KJkklGgtOjnfYwwIrwF9IE7ve71+OhVksHKoiEJwBzxlJygTbWzEsmVN wHIwF3xU3LtvZid4E+RFOLaLn5myopNEywp6bTAdDnAYtIBzbF31QmtZU2RFxwe5DrtCTMFq8BYU 63zvDVq4pJyL3wYrphfCLFwDn0NYNxFjsqK1q0y2SewQuAFqw9iuRDqfEdnp0Q98IEex2HHQAEo5 n8P5xAz+rr7J3ukeerw1CgW/BBfBcwNl0scpJCXaR+fsViBWzNdLoJHjykY5TbLHSJd3gKtZockV cQhUgxQTvcdS4ANnjC7jqcDLHkRG9BjFCtt0FxRY6PJOcqxcM86lDvziBYQ7Lo9JRBtbbrEtFe1o N3hs1m5l8jHVRki0jIbXqcByVfEGuKx4xLMcZOMkeMQCTq86Kx4xit6vmXWzOFTdVBCi33nDFsIF fljdFssC/eAdWGzDHZ5Hm/YHrFO5WSPs1yjosGCj9EgDrzgtttqxlyf27nrBT7BHgeBt4CvH22TX BqQgPWjjUHyWmhDr4m6riNeSC5gl0RoHQQ8Tt4JKJk8MMWfFlDrKWq6tmCcM+kbp6hFpY303nYiL rmSQDdcI/xa2LY2vNER0gHpwDwxM9puAiZFL4UX0fwvZWg6zU2unS/mgIpkq0TOv5GZET5X4K8AA /T7sDkDoeaAAAAAASUVORK5CYII=");
        this.mPlayPauseButton = new ImageButton((Context)this);
        this.mPlayPauseButton.setImageDrawable(this.mPauseDrawable);
        this.mPlayPauseButton.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mPlayPauseButton.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.mPlayPauseButton.setPadding(0, 0, 0, 0);
        this.mPlayPauseButton.setBackgroundColor(0);
        this.mPlayPauseButton.setEnabled(true);
        this.mPlayPauseButton.setVisibility(0);
        this.mPlayPauseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoPlayerActivity.this.playPauseButtonClicked();
            }
        });
        this.mButtonPanel.addView((View)this.mPlayPauseButton);
    }

    private void activateButtons(boolean active) {
        Logger.logDebug(TAG, "entered activateButtons:");
        if (active) {
            this.mButtonPanel.setVisibility(0);
        } else {
            this.mButtonPanel.setVisibility(8);
        }
    }

    private void close() {
        Logger.logDebug(TAG, "entered close()");
        this.cleanActivityUp();
        this.finish();
        Logger.logDebug(TAG, "leaving close()");
    }

    private void playPauseButtonClicked() {
        Logger.logDebug(TAG, "entered playPauseClicked");
        if (this.mMediaPlayer == null) {
            Logger.logError(TAG, "mMediaPlayer is null when playPauseButton was clicked");
            return;
        }
        boolean isPlaying = this.mMediaPlayer.isPlaying();
        Logger.logDebug(TAG, "isPlaying:" + isPlaying);
        if (isPlaying) {
            this.processPauseSteps();
        } else {
            this.processPlaySteps();
        }
    }

    private void processPauseSteps() {
        this.mIsVideoPaused = true;
        this.mMediaPlayer.pause();
        this.stopVideoProgressTimer();
        this.stopToolBarTimer();
        this.mPlayPauseButton.setImageDrawable(this.mPlayDrawable);
    }

    private void processPlaySteps() {
        this.mIsVideoPaused = false;
        this.mMediaPlayer.start();
        this.mPlayPauseButton.setImageDrawable(this.mPauseDrawable);
        this.startToolBarTimer();
        this.startVideoProgressTimer();
    }

    public void onBackPressed() {
        Logger.logDebug(TAG, "entered onBackPressed");
        this.close();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Logger.logDebug(TAG, "surfaceCreated -- (SurfaceHolder callback)");
        try {
            if (this.mMediaPlayer == null) {
                this.createMediaPlayer();
            }
            this.showProgressBar();
            this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
            Logger.logDebug(TAG, "URL for media file:" + this.mVideoDataUrl);
            this.mMediaPlayer.setDataSource(this.mVideoDataUrl);
            this.mMediaPlayer.prepareAsync();
        }
        catch (Exception e) {
            Logger.logError(TAG, e.getMessage());
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int arg1, int arg2, int arg3) {
        Logger.logDebug(TAG, "entered surfaceChanged -- (SurfaceHolder callback)");
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Logger.logDebug(TAG, "entered surfaceDestroyed -- (SurfaceHolder callback)");
        this.cleanUpMediaPlayer();
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        Logger.logDebug(TAG, "entered onVideoSizeChanged -- (MediaPlayer callback)");
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        Logger.logDebug(TAG, "video size: " + this.mVideoWidth + "x" + this.mVideoHeight);
    }

    public void onPrepared(MediaPlayer mp) {
        Logger.logDebug(TAG, "entered onPrepared called --(MediaPlayer callback) ....about to play");
        this.calculateAspectRatio();
        this.mMediaPlayer.start();
        this.hideProgressBar();
        if (this.mIsVideoPaused) {
            Logger.logDebug(TAG, "pausing video");
            this.processPauseSteps();
        } else {
            this.startVideoProgressTimer();
        }
        Logger.logDebug(TAG, "current location in video:" + this.mCurrentVideoPosition);
        if (this.mCurrentVideoPosition > 0) {
            Logger.logDebug(TAG, "seeking to location:" + this.mCurrentVideoPosition);
            this.mMediaPlayer.seekTo(this.mCurrentVideoPosition);
        }
        this.startToolBarTimer();
        if (!this.mMediaPlayer.isPlaying() && !this.mIsVideoPaused) {
            this.mMediaPlayer.start();
        }
    }

    private void calculateAspectRatio() {
        Logger.logDebug(TAG, "entered calculateAspectRatio");
        if (this.mVideoWidth == 0 || this.mVideoHeight == 0) {
            Logger.logWarning(TAG, "mVideoWidth or mVideoHeight is 0, skipping calculateAspectRatio");
            return;
        }
        Logger.logDebug(TAG, "calculating aspect ratio");
        double widthRatio = 1.0 * (double)this.mScreenWidth / (double)this.mVideoWidth;
        double heightRatio = 1.0 * (double)this.mScreenHeight / (double)this.mVideoHeight;
        double scale = Math.min(widthRatio, heightRatio);
        int surfaceWidth = (int)(scale * (double)this.mVideoWidth);
        int surfaceHeight = (int)(scale * (double)this.mVideoHeight);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(surfaceWidth, surfaceHeight);
        params.addRule(13);
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mSurfaceHolder.setFixedSize(surfaceWidth, surfaceHeight);
        Logger.logDebug(TAG, " screen size: " + this.mScreenWidth + "x" + this.mScreenHeight);
        Logger.logDebug(TAG, " video size:  " + this.mVideoWidth + "x" + this.mVideoHeight);
        Logger.logDebug(TAG, " widthRatio:   " + widthRatio);
        Logger.logDebug(TAG, " heightRatio:   " + heightRatio);
        Logger.logDebug(TAG, "surface size: " + surfaceWidth + "x" + surfaceHeight);
    }

    private void cleanActivityUp() {
        this.cleanUpMediaPlayer();
        this.stopVideoProgressTimer();
        this.stopToolBarTimer();
    }

    private void cleanUpMediaPlayer() {
        Logger.logDebug(TAG, "entered cleanUpMediaPlayer ");
        if (this.mMediaPlayer != null) {
            if (this.mMediaPlayer.isPlaying()) {
                this.mMediaPlayer.stop();
            }
            this.mMediaPlayer.setOnCompletionListener(null);
            this.mMediaPlayer.setOnErrorListener(null);
            this.mMediaPlayer.setOnPreparedListener(null);
            this.mMediaPlayer.setOnVideoSizeChangedListener(null);
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        Logger.logError(TAG, "entered onError -- (MediaPlayer callback)");
        Logger.logError(TAG, "Shutting down Activity due to Media Player errors: WHAT:" + what + ": EXTRA:" + extra + ":");
        this.close();
        return true;
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        Logger.logDebug(TAG, "entered onCOMPLETION -- (MediaPlayer callback)");
        this.close();
    }

    private void overlayClicked() {
        this.startToolBarTimer();
    }

    private void startToolBarTimer() {
        Logger.logDebug(TAG, "entered startToolBarTimer");
        if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            this.stopToolBarTimer();
            this.mHandler.sendEmptyMessageDelayed(0, 3000L);
            this.mButtonPanel.setVisibility(0);
        }
        if (this.mIsVideoPaused) {
            this.activateButtons(true);
        }
    }

    private void hideToolbar() {
        Logger.logDebug(TAG, "hiding buttons");
        this.mButtonPanel.setVisibility(8);
    }

    private void stopToolBarTimer() {
        if (this.mHandler != null && this.mHandler.hasMessages(0)) {
            Logger.logDebug(TAG, "entered stopToolBarTimer");
            this.mHandler.removeMessages(0);
        }
    }

    private void startVideoProgressTimer() {
        Logger.logDebug(TAG, "entered startVideoProgressTimer");
        this.mVideoProgressTracker = new LinkedList();
        this.mHandler.sendEmptyMessageDelayed(1, 250L);
    }

    private void trackVideoProgress() {
        this.mHandler.sendEmptyMessageDelayed(1, 250L);
        if (this.mMediaPlayer == null) {
            return;
        }
        this.mVideoProgressTracker.addLast(this.mMediaPlayer.getCurrentPosition());
        if (this.mVideoProgressTracker.size() == 20) {
            int firstPosition = this.mVideoProgressTracker.getFirst();
            int lastPosition = this.mVideoProgressTracker.getLast();
            if (lastPosition > firstPosition) {
                Logger.logVerbose(TAG, "video progressing (position:" + lastPosition + ")");
                this.mVideoProgressTracker.removeFirst();
            } else {
                Logger.logError(TAG, "detected video hang, first position: " + firstPosition + ", last position: " + lastPosition);
                this.stopVideoProgressTimer();
                this.close();
            }
        }
    }

    private void stopVideoProgressTimer() {
        if (this.mHandler != null && this.mHandler.hasMessages(1)) {
            Logger.logDebug(TAG, "entered stopVideoProgressTimer");
            this.mHandler.removeMessages(1);
        }
    }
}

