/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk.mraid;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.net.http.SslError;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.webkit.ConsoleMessage;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.xad.sdk.events.CreativeEvent;
import com.xad.sdk.listeners.TestListener;
import com.xad.sdk.mraid.Assets;
import com.xad.sdk.mraid.MRAIDNativeFeatureListener;
import com.xad.sdk.mraid.MRAIDViewListener;
import com.xad.sdk.mraid.internal.MRAIDHtmlProcessor;
import com.xad.sdk.mraid.internal.MRAIDNativeFeatureManager;
import com.xad.sdk.mraid.internal.MRAIDParser;
import com.xad.sdk.mraid.properties.MRAIDOrientationProperties;
import com.xad.sdk.mraid.properties.MRAIDResizeProperties;
import com.xad.sdk.utils.ErrorPosting;
import com.xad.sdk.utils.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Map;

@SuppressLint(value={"ViewConstructor"})
public class MRAIDView
extends RelativeLayout {
    private static final String TAG = "MRAIDView";
    public static final int STATE_LOADING = 0;
    public static final int STATE_DEFAULT = 1;
    public static final int STATE_EXPANDED = 2;
    public static final int STATE_RESIZED = 3;
    public static final int STATE_HIDDEN = 4;
    private static final int CLOSE_REGION_SIZE = 50;
    private WebView webView;
    private WebView webViewPart2;
    private WebView currentWebView;
    private MRAIDWebChromeClient mraidWebChromeClient;
    private MRAIDWebViewClient mraidWebViewClient;
    private RelativeLayout expandedView;
    private RelativeLayout resizedView;
    private ImageButton closeRegion;
    private Context mContext;
    private GestureDetector gestureDetector;
    private final boolean isInterstitial;
    private int state;
    private boolean isViewable;
    private boolean useCustomClose;
    private MRAIDOrientationProperties orientationProperties;
    private MRAIDResizeProperties resizeProperties;
    private MRAIDViewListener listener;
    private MRAIDNativeFeatureListener nativeFeatureListener;
    private TestListener mTestListener;
    private DisplayMetrics displayMetrics;
    private int contentViewTop;
    private int statusHeight;
    private Rect currentPosition;
    private Rect defaultPosition;
    private Size maxSize;
    private Size screenSize;
    private boolean isPageFinished;
    private boolean isLaidOut;
    private boolean isForcingFullScreen;
    private boolean isExpandingFromDefault;
    private boolean isExpandingPart2;
    private boolean isClosing;
    private View titleBar;
    private boolean isFullScreen;
    private boolean isForceNotFullScreen;
    private int origTitleBarVisibility;
    private boolean isActionBarShowing;
    private boolean isSupportActionBarShowing;
    private final int originalRequestedOrientation;
    private String mraidJs;
    private Handler handler;
    private CreativeEvent creativeEvent;

    private String getStateString() {
        switch (this.state) {
            case 0: {
                return "Loading";
            }
            case 1: {
                return "Default";
            }
            case 2: {
                return "Expanded";
            }
            case 3: {
                return "Resized";
            }
            case 4: {
                return "Hidden";
            }
        }
        return "";
    }

    public int getState() {
        return this.state;
    }

    public MRAIDView(Context context, CreativeEvent creativeEvent, MRAIDViewListener listener, MRAIDNativeFeatureListener nativeFeatureListener) {
        this(context, creativeEvent, listener, nativeFeatureListener, false);
    }

    public MRAIDView(Context context, CreativeEvent creativeEvent, MRAIDViewListener listener, MRAIDNativeFeatureListener nativeFeatureListener, boolean isInterstitial) {
        super(context);
        this.creativeEvent = creativeEvent;
        this.mContext = context;
        this.isInterstitial = isInterstitial;
        this.state = 0;
        this.isViewable = false;
        this.useCustomClose = false;
        this.orientationProperties = new MRAIDOrientationProperties();
        this.resizeProperties = new MRAIDResizeProperties();
        this.listener = listener;
        this.nativeFeatureListener = nativeFeatureListener;
        this.displayMetrics = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(this.displayMetrics);
        this.currentPosition = new Rect();
        this.defaultPosition = new Rect();
        this.maxSize = new Size();
        this.screenSize = new Size();
        this.originalRequestedOrientation = context instanceof Activity ? ((Activity)context).getRequestedOrientation() : -1;
        Logger.logDebug(TAG, "originalRequestedOrientation " + MRAIDView.getOrientationString(this.originalRequestedOrientation));
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                return true;
            }
        });
        this.handler = new Handler(Looper.getMainLooper());
        this.mraidWebChromeClient = new MRAIDWebChromeClient();
        this.mraidWebViewClient = new MRAIDWebViewClient();
        this.currentWebView = this.webView = this.createWebView();
        String data = MRAIDHtmlProcessor.processRawHtml(creativeEvent.CreativeString);
        if (TextUtils.isEmpty((CharSequence)data)) {
            Logger.logError(TAG, "Ad HTML is invalid, cannot load");
            ErrorPosting.sendError(this.mContext, 1, creativeEvent.CreativeString, creativeEvent.adGroupId);
            if (this.listener != null) {
                this.listener.mraidViewFailed(this);
            }
            return;
        }
        final String dataCopy = data;
        this.injectMraidJS(this.webView, new JavascriptInjectionHandler(){

            @Override
            public void beforeInjecting() {
            }

            @Override
            public void afterInjected() {
                MRAIDView.this.injectJavaScript(MRAIDView.this.webView, "mraid.logLevel = mraid.LogLevelEnum." + Logger.getLevel().value + ";");
                MRAIDView.this.webView.loadDataWithBaseURL("https://display-sdk.xad.com", dataCopy, "text/html", "UTF-8", null);
            }
        });
        this.addView((View)this.webView);
    }

    public void setTestListener(TestListener testListener) {
        this.mTestListener = testListener;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private WebView createWebView() {
        WebView wv = new WebView(this.mContext){
            private static final String TAG = "MRAIDView-WebView";

            protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
                super.onLayout(changed, left, top, right, bottom);
                MRAIDView.this.onLayoutWebView(this, changed, left, top, right, bottom);
            }

            public void onConfigurationChanged(Configuration newConfig) {
                super.onConfigurationChanged(newConfig);
                Logger.logDebug(TAG, "onConfigurationChanged " + (newConfig.orientation == 1 ? "portrait" : "landscape"));
                if (MRAIDView.this.isInterstitial) {
                    ((Activity)MRAIDView.this.mContext).getWindowManager().getDefaultDisplay().getMetrics(MRAIDView.this.displayMetrics);
                }
            }

            protected void onVisibilityChanged(View changedView, int visibility) {
                super.onVisibilityChanged(changedView, visibility);
                Logger.logDebug(TAG, "onVisibilityChanged " + MRAIDView.getVisibilityString(visibility));
                if (MRAIDView.this.isInterstitial) {
                    MRAIDView.this.setViewable(visibility);
                }
            }

            protected void onWindowVisibilityChanged(int visibility) {
                super.onWindowVisibilityChanged(visibility);
                int actualVisibility = this.getVisibility();
                Logger.logDebug(TAG, "onWindowVisibilityChanged " + MRAIDView.getVisibilityString(visibility) + " (actual " + MRAIDView.getVisibilityString(actualVisibility) + ")");
                if (MRAIDView.this.isInterstitial) {
                    MRAIDView.this.setViewable(actualVisibility);
                }
                if (visibility != 0) {
                    MRAIDView.this.pauseWebView(this);
                } else if (visibility == 0) {
                    MRAIDView.this.resumeWebView(this);
                }
            }

            protected void onSizeChanged(int w, int h, int ow, int oh) {
                Logger.logDebug(TAG, "W:" + w + ", H:" + h + ", OW:" + ow + ", OH:" + oh);
                super.onSizeChanged(w, h, ow, oh);
            }
        };
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        wv.setLayoutParams((ViewGroup.LayoutParams)params);
        wv.setScrollContainer(false);
        wv.setVerticalScrollBarEnabled(false);
        wv.setHorizontalScrollBarEnabled(false);
        wv.setScrollBarStyle(0x2000000);
        wv.setFocusableInTouchMode(false);
        wv.setOnTouchListener(new View.OnTouchListener(){

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: 
                    case 1: {
                        if (v.hasFocus()) break;
                        v.requestFocus();
                    }
                }
                return false;
            }
        });
        wv.getSettings().setJavaScriptEnabled(true);
        wv.setInitialScale(1);
        wv.getSettings().setUseWideViewPort(true);
        wv.getSettings().setLoadWithOverviewMode(true);
        wv.setWebChromeClient((WebChromeClient)this.mraidWebChromeClient);
        wv.setWebViewClient((WebViewClient)this.mraidWebViewClient);
        if (Build.VERSION.SDK_INT >= 21) {
            wv.getSettings().setMixedContentMode(0);
        }
        wv.getSettings().setMediaPlaybackRequiresUserGesture(false);
        if (Build.VERSION.SDK_INT <= 21) {
            wv.loadUrl("javascript:");
        }
        wv.evaluateJavascript("function alert(){}; function prompt(){}; function confirm(){}", (ValueCallback)new ValueCallback<String>(){

            public void onReceiveValue(String value) {
            }
        });
        return wv;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (this.gestureDetector.onTouchEvent(event)) {
            event.setAction(3);
        }
        return super.onTouchEvent(event);
    }

    public void clearView() {
        if (this.webView != null) {
            this.webView.setWebChromeClient(null);
            this.webView.setWebViewClient(null);
            this.webView.loadUrl("about:blank");
        }
    }

    public void destroy() {
        if (this.webView != null) {
            this.webView.setWebChromeClient(null);
            this.webView.setWebViewClient(null);
            this.webView.destroy();
            this.webView = null;
        }
        this.mContext = null;
        Logger.logDebug(TAG, "MRAID view " + (Object)((Object)this) + " is destroyed");
    }

    private void parseCommandUrl(String commandUrl) {
        Logger.logDebug(TAG, "parseCommandUrl " + commandUrl);
        MRAIDParser parser = new MRAIDParser();
        Map<String, String> commandMap = parser.parseCommandUrl(commandUrl);
        if (commandMap == null) {
            Logger.logWarning(TAG, "Can't parse command: " + commandUrl);
            ErrorPosting.sendError(this.mContext, 5, this.creativeEvent.CreativeString, this.creativeEvent.adGroupId);
            return;
        }
        String command = commandMap.get("command");
        String[] commandsWithNoParam = new String[]{"close", "resize"};
        String[] commandsWithString = new String[]{"createCalendarEvent", "expand", "open", "playVideo", "storePicture", "useCustomClose"};
        String[] commandsWithMap = new String[]{"setOrientationProperties", "setResizeProperties"};
        try {
            if (Arrays.asList(commandsWithNoParam).contains(command)) {
                Method method = ((Object)((Object)this)).getClass().getDeclaredMethod(command, new Class[0]);
                method.invoke((Object)this, new Object[0]);
            } else if (Arrays.asList(commandsWithString).contains(command)) {
                String key;
                Method method = ((Object)((Object)this)).getClass().getDeclaredMethod(command, String.class);
                switch (command) {
                    case "createCalendarEvent": {
                        key = "eventJSON";
                        break;
                    }
                    case "useCustomClose": {
                        key = "useCustomClose";
                        break;
                    }
                    default: {
                        key = "url";
                    }
                }
                String val = commandMap.get(key);
                method.invoke((Object)this, val);
            } else if (Arrays.asList(commandsWithMap).contains(command)) {
                Method method = ((Object)((Object)this)).getClass().getDeclaredMethod(command, Map.class);
                method.invoke((Object)this, commandMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void close() {
        Logger.logDebug("MRAIDView-JS callback", "close");
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (MRAIDView.this.state == 0 || MRAIDView.this.state == 1 && !MRAIDView.this.isInterstitial || MRAIDView.this.state == 4) {
                    return;
                }
                if (MRAIDView.this.state == 1 || MRAIDView.this.state == 2) {
                    MRAIDView.this.closeFromExpanded();
                } else if (MRAIDView.this.state == 3) {
                    MRAIDView.this.closeFromResized();
                }
            }
        });
    }

    private void createCalendarEvent(String eventJSON) {
        Logger.logDebug("MRAIDView-JS callback", "createCalendarEvent " + eventJSON);
        if (this.nativeFeatureListener != null) {
            this.nativeFeatureListener.mraidNativeFeatureCreateCalendarEvent(eventJSON);
        }
    }

    @TargetApi(value=11)
    private void expand(String url) {
        Logger.logDebug("MRAIDView-JS callback", "expand " + (url != null ? url : "(1-part)"));
        if (this.isInterstitial && this.state != 0 || !this.isInterstitial && this.state != 1 && this.state != 3) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            if (this.isInterstitial || this.state == 1) {
                if (this.webView.getParent() != null) {
                    ((ViewGroup)this.webView.getParent()).removeView((View)this.webView);
                } else {
                    this.removeView((View)this.webView);
                }
            } else if (this.state == 3) {
                this.removeResizeView();
            }
            this.expandHelper(this.webView);
            return;
        }
        try {
            url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            url = "https://display-sdk.xad.com" + url;
        }
        final String finalUrl = url;
        new Thread(new Runnable(){

            @Override
            public void run() {
                final String content = MRAIDView.this.getStringFromUrl(finalUrl);
                if (!TextUtils.isEmpty((CharSequence)content)) {
                    ((Activity)MRAIDView.this.mContext).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (MRAIDView.this.state == 3) {
                                MRAIDView.this.removeResizeView();
                                MRAIDView.this.addView((View)MRAIDView.this.webView);
                            }
                            MRAIDView.this.webView.setWebChromeClient(null);
                            MRAIDView.this.webView.setWebViewClient(null);
                            MRAIDView.this.webViewPart2 = MRAIDView.this.createWebView();
                            MRAIDView.this.injectMraidJS(MRAIDView.this.webViewPart2, new JavascriptInjectionHandler(){

                                @Override
                                public void beforeInjecting() {
                                }

                                @Override
                                public void afterInjected() {
                                    MRAIDView.this.injectJavaScript(MRAIDView.this.webView, "mraid.logLevel = mraid.LogLevelEnum." + Logger.getLevel().value + ";");
                                    MRAIDView.this.webViewPart2.loadDataWithBaseURL("https://display-sdk.xad.com", content, "text/html", "UTF-8", null);
                                }
                            });
                            MRAIDView.this.currentWebView = MRAIDView.this.webViewPart2;
                            MRAIDView.this.isExpandingPart2 = true;
                            MRAIDView.this.expandHelper(MRAIDView.this.currentWebView);
                        }
                    });
                } else {
                    Logger.logError(MRAIDView.TAG, "Could not load part 2 expanded content for URL: " + finalUrl);
                    ErrorPosting.sendError(MRAIDView.this.mContext, 2, ((MRAIDView)MRAIDView.this).creativeEvent.CreativeString, ((MRAIDView)MRAIDView.this).creativeEvent.adGroupId);
                }
            }
        }, "2-part-content").start();
    }

    private void open(String url) {
        try {
            url = URLDecoder.decode(url, "UTF-8");
            Logger.logDebug("MRAIDView-JS callback", "open " + url);
            if (this.nativeFeatureListener != null) {
                if (url.startsWith("sms:")) {
                    this.nativeFeatureListener.mraidNativeFeatureSendSms(url);
                } else if (url.startsWith("tel:")) {
                    this.nativeFeatureListener.mraidNativeFeatureCallTel(url);
                } else {
                    this.nativeFeatureListener.mraidNativeFeatureOpenBrowser(url);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void playVideo(String url) {
        try {
            url = URLDecoder.decode(url, "UTF-8");
            Logger.logDebug("MRAIDView-JS callback", "playVideo " + url);
            if (this.nativeFeatureListener != null) {
                this.nativeFeatureListener.mraidNativeFeaturePlayVideo(url);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void resize() {
        Logger.logDebug("MRAIDView-JS callback", "resize");
        if (this.listener == null) {
            return;
        }
        boolean isResizeOK = this.listener.mraidViewResize(this, this.resizeProperties.width, this.resizeProperties.height, this.resizeProperties.offsetX, this.resizeProperties.offsetY);
        if (!isResizeOK) {
            return;
        }
        this.state = 3;
        if (this.resizedView == null) {
            this.resizedView = new RelativeLayout(this.mContext);
            this.removeAllViews();
            this.resizedView.addView((View)this.webView);
            this.addCloseRegion((View)this.resizedView);
            FrameLayout rootView = (FrameLayout)this.getRootView().findViewById(0x1020002);
            rootView.addView((View)this.resizedView);
        }
        this.setCloseRegionPosition((View)this.resizedView);
        this.setResizedViewSize();
        this.setResizedViewPosition();
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                MRAIDView.this.fireStateChangeEvent();
            }
        });
    }

    private void setOrientationProperties(Map<String, String> properties) {
        boolean allowOrientationChange = Boolean.parseBoolean(properties.get("allowOrientationChange"));
        String forceOrientation = properties.get("forceOrientation");
        Logger.logDebug("MRAIDView-JS callback", "setOrientationProperties " + allowOrientationChange + " " + forceOrientation);
        if (this.orientationProperties.allowOrientationChange != allowOrientationChange || this.orientationProperties.forceOrientation != MRAIDOrientationProperties.forceOrientationFromString(forceOrientation)) {
            this.orientationProperties.allowOrientationChange = allowOrientationChange;
            this.orientationProperties.forceOrientation = MRAIDOrientationProperties.forceOrientationFromString(forceOrientation);
            if (this.isInterstitial || this.state == 2) {
                this.applyOrientationProperties();
            }
        }
    }

    private void setResizeProperties(Map<String, String> properties) {
        int width = 0;
        int height = 0;
        int offsetX = 0;
        int offsetY = 0;
        try {
            width = Integer.parseInt(properties.get("width"));
            height = Integer.parseInt(properties.get("height"));
            offsetX = Integer.parseInt(properties.get("offsetX"));
            offsetY = Integer.parseInt(properties.get("offsetY"));
        }
        catch (NumberFormatException e) {
            Logger.logError(TAG, "Resize properties is not correct");
            ErrorPosting.sendError(this.mContext, 3, this.creativeEvent.CreativeString, this.creativeEvent.adGroupId);
        }
        String customClosePosition = properties.get("customClosePosition");
        boolean allowOffscreen = Boolean.parseBoolean(properties.get("allowOffscreen"));
        Logger.logDebug("MRAIDView-JS callback", "setResizeProperties " + width + " " + height + " " + offsetX + " " + offsetY + " " + customClosePosition + " " + allowOffscreen);
        this.resizeProperties.width = width;
        this.resizeProperties.height = height;
        this.resizeProperties.offsetX = offsetX;
        this.resizeProperties.offsetY = offsetY;
        this.resizeProperties.customClosePosition = MRAIDResizeProperties.customClosePositionFromString(customClosePosition);
        this.resizeProperties.allowOffscreen = allowOffscreen;
    }

    private void storePicture(String url) {
        try {
            url = URLDecoder.decode(url, "UTF-8");
            Logger.logDebug("MRAIDView-JS callback", "storePicture " + url);
            if (this.nativeFeatureListener != null) {
                this.nativeFeatureListener.mraidNativeFeatureStorePicture(url);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void useCustomClose(String useCustomCloseString) {
        Logger.logDebug("MRAIDView-JS callback", "useCustomClose " + useCustomCloseString);
        boolean useCustomClose = Boolean.parseBoolean(useCustomCloseString);
        if (this.useCustomClose != useCustomClose) {
            this.useCustomClose = useCustomClose;
            if (useCustomClose) {
                this.removeDefaultCloseButton();
            } else {
                this.showDefaultCloseButton(this.closeRegion);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringFromUrl(String url) {
        if (url.startsWith("file:///")) {
            return this.getStringFromFileUrl(url);
        }
        String content = null;
        InputStream is = null;
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            int responseCode = conn.getResponseCode();
            Logger.logDebug(TAG, "response code " + responseCode);
            if (responseCode == 200) {
                int count;
                Logger.logDebug(TAG, "getContentLength " + conn.getContentLength());
                is = conn.getInputStream();
                byte[] buf = new byte[1500];
                StringBuilder sb = new StringBuilder();
                while ((count = is.read(buf)) != -1) {
                    String data = new String(buf, 0, count);
                    sb.append(data);
                }
                content = sb.toString();
                Logger.logDebug(TAG, "getStringFromUrl ok, length=" + content.length());
            }
            conn.disconnect();
        }
        catch (IOException e) {
            Logger.logError(TAG, "getStringFromUrl failed " + e.getLocalizedMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return content;
    }

    private String getStringFromFileUrl(String fileURL) {
        StringBuffer mLine = new StringBuffer("");
        String[] urlElements = fileURL.split("/");
        if (urlElements[3].equals("android_asset")) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.mContext.getAssets().open(urlElements[4])));
                String line = reader.readLine();
                mLine.append(line);
                while (line != null) {
                    line = reader.readLine();
                    mLine.append(line);
                }
                reader.close();
            }
            catch (IOException e) {
                Logger.logError(TAG, "Error fetching file: " + e.getMessage());
            }
            return mLine.toString();
        }
        Logger.logError(TAG, "Unknown location to fetch file content");
        return "";
    }

    public void showAsInterstitial() {
        this.expand(null);
    }

    private void expandHelper(WebView webView) {
        if (!this.isInterstitial) {
            this.state = 2;
        }
        this.applyOrientationProperties();
        this.forceFullScreen();
        this.expandedView = new RelativeLayout(this.mContext);
        this.expandedView.addView((View)webView);
        this.addCloseRegion((View)this.expandedView);
        this.setCloseRegionPosition((View)this.expandedView);
        ((Activity)this.mContext).addContentView((View)this.expandedView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.isExpandingFromDefault = true;
        this.fireStateChangeEvent();
        if (this.isInterstitial) {
            this.isLaidOut = true;
            this.state = 1;
            this.fireReadyEvent();
            this.fireStateChangeEvent();
        }
    }

    private void setResizedViewSize() {
        Logger.logDebug(TAG, "setResizedViewSize");
        int widthInDip = this.resizeProperties.width;
        int heightInDip = this.resizeProperties.height;
        Log.d((String)TAG, (String)("setResizedViewSize " + widthInDip + "x" + heightInDip));
        int width = (int)TypedValue.applyDimension((int)1, (float)widthInDip, (DisplayMetrics)this.displayMetrics);
        int height = (int)TypedValue.applyDimension((int)1, (float)heightInDip, (DisplayMetrics)this.displayMetrics);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(width, height);
        this.resizedView.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void setResizedViewPosition() {
        Logger.logDebug(TAG, "setResizedViewPosition");
        if (this.resizedView == null) {
            return;
        }
        int widthInDip = this.resizeProperties.width;
        int heightInDip = this.resizeProperties.height;
        int offsetXInDip = this.resizeProperties.offsetX;
        int offsetYInDip = this.resizeProperties.offsetY;
        int width = (int)TypedValue.applyDimension((int)1, (float)widthInDip, (DisplayMetrics)this.displayMetrics);
        int height = (int)TypedValue.applyDimension((int)1, (float)heightInDip, (DisplayMetrics)this.displayMetrics);
        int offsetX = (int)TypedValue.applyDimension((int)1, (float)offsetXInDip, (DisplayMetrics)this.displayMetrics);
        int offsetY = (int)TypedValue.applyDimension((int)1, (float)offsetYInDip, (DisplayMetrics)this.displayMetrics);
        int x = this.defaultPosition.left + offsetX;
        int y = this.defaultPosition.top + offsetY;
        if (!this.resizeProperties.allowOffscreen) {
            if (x + width > this.screenSize.width) {
                x = this.screenSize.width - width;
            }
            if (y + height > this.screenSize.height) {
                y = this.screenSize.height - height;
            }
            if (x < 0 || y < 0) {
                Logger.logDebug(TAG, "Resize view position or size can't be satisfied");
            }
            x = x > 0 ? x : 0;
            y = y > 0 ? y : 0;
        }
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.resizedView.getLayoutParams();
        params.leftMargin = x;
        params.topMargin = y;
        this.resizedView.setLayoutParams((ViewGroup.LayoutParams)params);
        if (x != this.currentPosition.left || y != this.currentPosition.top || width != this.currentPosition.width() || height != this.currentPosition.height()) {
            this.currentPosition.left = x;
            this.currentPosition.top = y;
            this.currentPosition.right = x + width;
            this.currentPosition.bottom = y + height;
            this.setCurrentPosition();
        }
    }

    private void closeFromExpanded() {
        if (this.state == 1 && this.isInterstitial) {
            this.state = 4;
            this.clearView();
        } else if (this.state == 2 || this.state == 3) {
            this.state = 1;
        }
        this.isClosing = true;
        this.expandedView.removeAllViews();
        FrameLayout rootView = (FrameLayout)((Activity)this.mContext).findViewById(0x1020002);
        rootView.removeView((View)this.expandedView);
        this.expandedView = null;
        this.closeRegion = null;
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                MRAIDView.this.restoreOriginalOrientation();
                MRAIDView.this.restoreOriginalScreenState();
            }
        });
        if (this.webViewPart2 == null) {
            this.addView((View)this.webView);
        } else {
            this.webViewPart2.setWebChromeClient(null);
            this.webViewPart2.setWebViewClient(null);
            this.webViewPart2.destroy();
            this.webViewPart2 = null;
            this.webView.setWebChromeClient((WebChromeClient)this.mraidWebChromeClient);
            this.webView.setWebViewClient((WebViewClient)this.mraidWebViewClient);
            this.currentWebView = this.webView;
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                MRAIDView.this.fireStateChangeEvent();
                if (MRAIDView.this.listener != null) {
                    MRAIDView.this.listener.mraidViewClose(MRAIDView.this);
                }
            }
        });
    }

    private void closeFromResized() {
        this.state = 1;
        this.isClosing = true;
        this.removeResizeView();
        this.addView((View)this.webView);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                MRAIDView.this.fireStateChangeEvent();
                if (MRAIDView.this.listener != null) {
                    MRAIDView.this.listener.mraidViewClose(MRAIDView.this);
                }
            }
        });
    }

    private void removeResizeView() {
        this.resizedView.removeAllViews();
        FrameLayout rootView = (FrameLayout)((Activity)this.mContext).findViewById(0x1020002);
        rootView.removeView((View)this.resizedView);
        this.resizedView = null;
        this.closeRegion = null;
    }

    private void forceFullScreen() {
        android.support.v7.app.ActionBar supportActionBar;
        Logger.logDebug(TAG, "forceFullScreen");
        Activity activity = (Activity)this.mContext;
        int flags = activity.getWindow().getAttributes().flags;
        this.isFullScreen = (flags & 0x400) != 0;
        this.isForceNotFullScreen = (flags & 0x800) != 0;
        this.origTitleBarVisibility = -9;
        boolean hasActionBar = false;
        boolean hasSupportActionBar = false;
        ActionBar actionBar = activity.getActionBar();
        if (actionBar != null) {
            hasActionBar = true;
            this.isActionBarShowing = actionBar.isShowing();
            actionBar.hide();
        }
        if (activity instanceof AppCompatActivity && (supportActionBar = ((AppCompatActivity)activity).getSupportActionBar()) != null) {
            hasSupportActionBar = true;
            this.isSupportActionBarShowing = supportActionBar.isShowing();
            supportActionBar.hide();
        }
        if (!hasActionBar && !hasSupportActionBar) {
            this.titleBar = null;
            try {
                this.titleBar = (View)activity.findViewById(16908310).getParent();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (this.titleBar != null) {
                this.origTitleBarVisibility = this.titleBar.getVisibility();
                this.titleBar.setVisibility(8);
            }
        }
        Logger.logDebug(TAG, "isFullScreen " + this.isFullScreen);
        Logger.logDebug(TAG, "isForceNotFullScreen " + this.isForceNotFullScreen);
        Logger.logDebug(TAG, "isActionBarShowing " + this.isActionBarShowing);
        Logger.logDebug(TAG, "isSupportActionBarShowing " + this.isSupportActionBarShowing);
        Logger.logDebug(TAG, "origTitleBarVisibility " + MRAIDView.getVisibilityString(this.origTitleBarVisibility));
        ((Activity)this.mContext).getWindow().addFlags(1024);
        ((Activity)this.mContext).getWindow().clearFlags(2048);
        this.isForcingFullScreen = !this.isFullScreen;
    }

    private void restoreOriginalScreenState() {
        Activity activity = (Activity)this.mContext;
        if (!this.isFullScreen) {
            activity.getWindow().clearFlags(1024);
        }
        if (this.isForceNotFullScreen) {
            activity.getWindow().addFlags(2048);
        }
        if (this.isActionBarShowing) {
            ActionBar actionBar = activity.getActionBar();
            actionBar.show();
        }
        if (this.isSupportActionBarShowing) {
            android.support.v7.app.ActionBar supportActionBar = ((AppCompatActivity)activity).getSupportActionBar();
            supportActionBar.show();
        }
    }

    private static String getVisibilityString(int visibility) {
        switch (visibility) {
            case 8: {
                return "GONE";
            }
            case 4: {
                return "INVISIBLE";
            }
            case 0: {
                return "VISIBLE";
            }
        }
        return "UNKNOWN";
    }

    private void addCloseRegion(View view) {
        this.closeRegion = new ImageButton(this.mContext);
        this.closeRegion.setBackgroundColor(0);
        this.closeRegion.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MRAIDView.this.close();
            }
        });
        if (view == this.expandedView && !this.useCustomClose) {
            this.showDefaultCloseButton(this.closeRegion);
        }
        ((ViewGroup)view).addView((View)this.closeRegion);
    }

    private void showDefaultCloseButton(ImageButton closeButton) {
        if (closeButton != null) {
            Drawable closeButtonNormalDrawable = Assets.getDrawableFromBase64(this.getResources(), "iVBORw0KGgoAAAANSUhEUgAAAIAAAACACAYAAADDPmHLAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goHFBQe/AkWfQAADBBJREFUeNrtXUFIW1kUPT9VqyKM 0qqYQS2tuIwwCwOl0NW46SI44PJvymxaaIesxqXdSGVWA0JdTMCFSDaxCK4cswiB0NWM3XSVStQ2 4wiDCplYnJg7C38kDZr/3v/v/f/eNxcuZKHJ/++cd9999917n4EAChG1A+gFEAZwD8B9AA+sz98C GATwDYBO61++ADgB8DeAzwAKAD4C2LE+FwEcG4bxX9DGyggA2LcsoL8D8D2AHwAMSfq5vwCsAfgd wB8AioZhnKMlnoN+h4hiRJQi/yVlPcudFjJyQe8noqdEtEPqyo71jP0txMSA3kFEU0T0jvSTd9az d7R8AAcmHsCPAF4HhMuzAH4zDOOf1rRuDnyYiBYpuLJIROEW0lev70EG/ioiKOEnGD4D3wngJxmm /vT0FIeHh9jd3UU+n7/Uvb09FItFHB0doVwuAwC6u7vR19eHcDiMkZERjI2NXero6CgGBgbQ1dUl a2n41TCMLzdx1k+Jmk6VSoUKhQIlk0kyTZPa2toIgFBta2sj0zQpmUxSoVCgSqUi0iJM3TRzv+F2 xEqlEqXTaTJNUzjYrGqaJqXTaSqVSiJIsBH47aMVMHEsZ2dnlMlkKBaL+Qb6dRqLxSiTydDZ2Zlb IsSCCHw3ES07HZGDgwOan59XDvTrdH5+ng4ODtyQYJmIuoMC/jgRnTsZhXw+76uJF7FE5PN5pyQ4 J6Jx3cF/4uTNC4UCzczMaAt8o87MzFChUHBKhCe6gh/nfdPj42OKx+OBAb5R4/E4HR8fOyFBXCfg Q7xBnWq1SslkMrDAN2oymaRqteokeBRSHfx23iPa/f19ikajNwb8mkajUdrf33dy9Nyu8sndJs/b 3KRZ38wacMqmcieM1sxnBr9cLmvt3cvYLZTLZV4StKu05qd4PPyenp4W8A3a09PDu1NIKeET8Dh8 uVyuBbaN5nI5LsdQm63e2tpaC2BGXVtbU3+LyBPkSSQSLWA5NZFIqBssssK7TLK0tNQC1KEuLS3x kGDcK/C7WWP7rZnvqSU49+QAifVUr7Xm++ITLCtxni/C23/9+jWFQiHtwYtEIhSPx2l8fNyr3UFM Fvj9rPt8Ny86Pj5Oq6url1YkEoloDX5t9q6urromAUecoF8GATZYInxugzzr6+tffWc2m9XSEhiG Qdls9qt3WV9fdx0sYowYbogGnymB0214txF8XUlQP/Mbxa0lME3T20RTIur04mDnOvB1I8FVM79R 3FoCjgOkThEE+JnlSFcm+LqQoNnMF20JGI+Sf5bu+FWrVVfn+azgq04CHvBFkCAajbImlfS7IcCi LNNf7+3zimokYDH7MkjAuBQsOgU/zJLD5zX49YEmFbaITma+SBIw5hiGpcx+JwmcIsBXhQRuZr4o EsTjcfFWwGrBIiXgs7m5SSLFr+VAxMwXRQLGANEdoZ6/k7z9jo4OevHihZNkSKVIIAP8eqt6+/Zt 7roDYTsCK7nTtmLH6eB1dXVpTQKRZv+qJW1iYsLRczFWIHWwEMA26uc24ieLBLJ9Apkz3w34HBHC KRYCvLMr1BQxmLpZAlVnfr0yFKS+cx34EV2l++zZMykDKtISqDzz0VCV7CowRBc97prW54ueWaov B7qAX1OG/gRPmxGgaRPGTCYjZW1VdTnQwew3aiaTsfvpHcd7f5mdOVSzBLrNfNR1KnEUE7BL9yqV StK3WDUSiBZeS6DjzK9Xhp5FsasI0LS8K51OexZo8dMx1HXm12s6nbZ7lFQj+Ldk7/11IEEQwOeI CdyqJ8Bws7+sVCqex9q99gmCAn5NGfoYDjOv/24zfVXfHchc87PZLBmG4fnYMRwQxZiPfv1u5CBj Ochms5ffr7PD5yJZZLGeAEWV1n+vSLC1tUVbW1uBA5/RDyjWd/doKjJ676pCgiCCD6u3MYO028b/ y+WyMrl3snyCoIFfU4Yikn4Q0YSKDqCOJPDL4XPhCE7Y7gBkxf+DthyoNPM5zgViIVxcqnit5PN5 qChv3rzB8+fPlXiWt2/f4tWrV3j//r1SY8SA3f0QLm7U1I4AqpBAVfAZsXsQwsV1qloSAACWl5fx 8uVLfPr0qQU+P3b3QER/NlskdGjj6odjqJrDd135mI38aRsEGh4e1qYs2yvHUEWH7yodHh62DwYR 0b/N/kKnrp41S+Dyto5AgF9rKGEj/4JsOn7p1p1jcnKStre3pYCfTqe1AR8AhUIhu1c6V7v/PKdE IhHMzs5iYmJCyvcTEYgIgZKgLAEyz/O9qDvwcwnQ3gmUeZ7vRd2B306g1ttAr8HXiQQs28AQgM/N loiRkRGl1/xUKoVHjx55/tvT09OYm5tDJBJRdnwYsPscAlBo9hdjY2PKgj83N4fp6WnfnkF1EjBg V2gD8FE3AqgAfj0J+vv78fjxY1SrVd0I8FG742C/1nwdfQKW42CtEkJUBV9VErAmhGiREqY6+CqS gDUlTPmkUJlBnu3tbeFnByqQgDkp1IoGKpsWLrtiZ3JyUst2NXbKnBZuEUDJwhCvqnR17VkEgYUh ypWGeV2rFzQS8JaGKVUc6metnqwyNK8PkHiLQ5UpD/e7Slf3PoaM6z9RfXm4RQLfG0SoUqKtOwm4 G0Sw+AGyW8SoWKKt63LgtEWMb02iVG3OoKNj6LhJlEUCz9vEyQRfVOq2TpbAcZs4iwCeNorUpS2L Tj6B20aRnrWK1a0njw4kcN0q1iKB9GbROph9HZcD182iLQJIbRevezcuVR1Dke3ipV0YITu272Wt nmqWQNiFERYJhF8ZE7Q+fCr5BEKvjGGNCfAcEA0NDdHKykpgwJdNgu3tbS5rJvzSKJYjYiL2a+N6 e3tpYWGBTk5OAgO+LBKcnJzQwsIC9fb2+ndtnEUAoRdHDg4OCiWBSlW6okhQA39wcND/iyNZrQBP sogoEqhYou2WBE7Al3p1LGtgiPfyaLckULk+3w0JfvnlF/Uuj2bdEfBeH++UBDo0Z3BCAl7w4dX1 8RYBOll+iTdvkJcEOnXmYCWBE7PPYfqJiDpF9RCYYvk13gghKwl0Ap+VBE7BZ4z4sUX9OEmwYfeL 5XKZu6GEHQl0BN+OBE7B7+npYSn2ICLaEF5oyOIQ8gaI7EigM/jXkcAp+BwBH/eOXxMSMKWb5HI5 1yQIAviNJPjw4YNj8HO5HCv4Maklx0S0zOq0OSXByspKYMCvaWdnJz18+JDu3r3L/b8cZyjL0mvO iaibbFrL1SSRSHC/bG9vLw0NDQUKfDeaSCRYwT8nom5PGg8Q0TjrUy0tLbWAdKhLS0s8YZJxT7tP ENET1idzYglaMz/BA/4TX1qQEFGcJ4rXAlb4mk9EFPe1Dw3LgZGb3cFNUw5v391Bj0AChMimrKwx TqBTA2qvtKenh2efT9aYq9Hqly66jGyyPnm5XFbiLkJV1DRN1ghfTTap1t1DFbGSSTd53sLvG0lV UI6DnXrwO6CiWJYgxfM2+/v7WtxKIlqj0aiTvIGUcjP/Gp9gkeetqtXqjbIGyWSSNZnjK4dPmTVf 9BaxPseQNdFUR43H46w5fGpt9bwIFjXuFHjrDlTWmZkZXg/f/yCP4LDxuZM3z+fzWu8WTNNkrdi5 LrY/jiCIdYC07HQkDg4OhFUle6Hz8/Num08ue3aw4zERYm5G5ezsjDKZjLROJW40FotRJpNhqc/3 9zxfARL0s6SX2UmpVKJ0Ou3rEmGaJqXTaZaePExpXNIyeRQlwhQJkkqlQoVCgZLJJJmmKaW3cVtb G5mmSclkkgqFAksfPh6Z8gsHw2cSdAL4CcBr0d99enqKw8ND7O7uIp/PX+re3h6KxSKOjo5QLpcB AN3d3ejr60M4HMbIyAjGxsYudXR0FAMDA+jq6pIxBLMAfjUM4wtusljLwiLdHFm8UeaegwjhgBNh 0XGhZhCXgCZEuAPgRxlLg08yC+A3wzD+aU1z/hPGKbJpXKWovLOevaOFpDg/4SnZNLP0WXasZ2yt 77KXCCuolFIA9JT1LHd0HEsjAGS4BSAM4DsA3wP4AcCQpJ/7C8AagN8B/AGgaBjGuc7jZwTUQrQD 6LWIcQ/AfQAPrM/fAhgE8A2AWvn0FwAnAP7GxVW6BVxcqLljfS4CODYM47+gjdX/V+LYxXLzNfgA AAAASUVORK5CYII=");
            Drawable closeButtonPressedDrawable = Assets.getDrawableFromBase64(this.getResources(), "iVBORw0KGgoAAAANSUhEUgAAAIAAAACACAYAAADDPmHLAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH3goHFBQxV9grJAAAEwRJREFUeNrtnXtsVVW+xz89fdBC y6mUcqA9oFIeJbWUqjg0YLoTLBpbg5HeopMMkwYSE+ZexfnLa7y65Bpn5p8ZNJeaeCcxPpLxcpEM AurQEHcvaG1AWkJLKUQh9iGlWPu0j9PH/aOnnQrt3mvvs/fp3qf9JU0OZa11dvf3u36P9fj9oohA EULEAslAGnAPsBLICH5OB3yAF4gPdukHOoFWoBm4DnwLfBf83AJ0CCECkfauoiIA7Ogg0PcDBcBT wDKbvu4H4AhQDpwHWoQQw3MECD/oKcAWYFcQ8JmUI8D7wBkhxI9zBLAP9FTgCeBl4F6HPuY14HXg mBCibY4AoYMeByjAfuBXLptcVcArgCqEGJwjgHEVvwf4Y4T4Wi8Cf3WiiYhyGPBpwEvA74hMOQi8 IYRomSPAnfb91QgGfioivOYEPyFqhoGPB563Q9UHAgF6e3vp7Oykvb194qezs5Pu7m76+voIBMbC +tjYWBISEkhKSsLr9bJo0aKJH6/Xy4IFC4iNjbXLNLwphOifdQQQQmwD/mHFWCMjI3R1ddHU1MTV q1e5ePEiIyMjlj6vx+MhOzub1atX4/f7WbhwIR6Px6rhHxVCnJwVBAiq+3eBwlDGGRwcpLm5mZqa Gi5cuDAjJM7JyWHDhg2kp6cTFxcX6nAngNJwm4WoMIO/Hfi72f7Dw8M0NTVRWVnJ5cuXHWXUMzMz ycvLw+/3Ex0dHcpQTwohjkYUAYQQ84Ey4Ldm+vf09FBdXc2pU6dc4eFt3bqV3NxcEhMTzQ7xHrBX CPGz6wkghFgD1AOGDWZ7ezsVFRUzpuKtMBH5+fksWrTIlGsDrBNCXHEtAYQQhcBxo/06OjooLy+n rq4uImK+rKwsCgoKSE5ONtO9SAhxwnUEEEK8APzZSJ/+/n4qKiqorKyMyOA/Ly+P/Px84uPjjXb9 vRDiL64ggBDCA7xlZFFndHSUuro6Dh8+PCtWgYqLi8nKyiIqytDrPwg8J4QYcSwBggcxPsLAFm1X VxeHDh2iqamJ2SR+v5+SkhIWLlxopNsR4GkrD6ZEWQh+XNDeF8j2qa2tnTWzXksb3HfffUa6lAf9 gkHHECA480/Igh8IBDh+/LhrvXs7ooWioiIjy83lQKEVmiDKAvA9wP/Kqv2Ojg7KysoYHBycQ36S xMXFsXfvXiORwhHgX0L1CaxYzH5LFvzGxkYOHDgwB/4UMjg4yIEDB2hsbJTt8lTw3Yck0SHO/heA /5BpW19fzwcffDCHtI5UV1fj8/lITU2Vaf6Qoihdqqp+HXYCBBd53pP9oz7++OM5dCWlrq4Or9fL smVSh5sfVRTlnKqqV8NGgODyrtRqzblz5zh27NgcqgaloaGBxMRE0tLSZJr/WlGUv6mqavjIWZQJ 8OcD3TL+Q3V1NUePHp1DMwTZvn07ubm5Mk1HgCSjG0hmnMAymX719fVz4FsgR48epb6+XhbLMltN QHA/X/f4VmNjY8gO3yOPPMK1a9dcD6DP52P9+vX09fXR19dn2ifIyMjA6/XqNd2gKEqNqqoNlhMg eJLnG5k4/+233zb9wlJSUnj88cfZuHEjPp+PW7du0dvb61rwFUVh06ZNzJ8/n5s3b5omQXV1NRs2 bJDZSHpaUZQyVVV/llUbsvKuXoNAIEBZWVlIL23btm1kZ2cDsG7dOgoLC41umjhCoqKiKCwsZN26 dQBkZ2ezbdu2kMYsKyubOMgaKlaGNEDwAOd+vXaffPIJLS3mj7w/88wzrF279he/83q9rFy5kpqa GlfN/MLCQlatWvWL3y9evJiUlBTTmmB4eJiurq4JUmnIGkVRKlVV/TZkAgSPbusewKutreWLL76w FHw3kiAqKoqSkpI7wJ9MjuTkZGpra02N39rayuLFi1myZIle098oivInVVWHQjUBz+s16OrqCmlX Twv8cVmxYgWlpaWONgc+n4+SkhJWrFih2W7t2rXs2LGDlJQUU99z+PBhurq6sAK7aAnHT/Ps/ujo KB9++KHsA5kC3w2aYNzhk1DPE+1DcQwbGxvJzc3VmxCP6DmEehrgVZkQxcxhjpSUFHbs2CENvpM1 we0On6xkZ2ejKIopTdDU1CR7ZvJVUxogeFHzI63O/f39vPPOO6bAVxRlwts3Kl6v1zEh4nQOn5H+ ZjXBpUuX2LRpEzExMVrNHlIU5b9VVe02qgFe0nuAioqKsIM/LuvWrUNRFHw+n+tmvpWaQBKDlwxp gOD9/MN6Cz5mHL/i4mIyMzMtASA1NRWfzzcjPkGoM98qTdDU1CSzQPSQoij/papqn6wG2KP3xeXl 5Yb/yOjoaK5cuWLaYXSKT2DU4TOiCdasWaOn0s1isUdKAwQPd2rqlfb2do4fN3zfg9HRUW7evMnQ 0BA+n4958+ZZ8uLCGR3oxfmhSH19PTU1NYYnSFtbG+vXrychIUEvIviDqqrDehpAscP2j0sgEOD8 +fN8+eWXlmuCkpISW30C2TjfLPgVFRXcuHHDVH9JTBQZE6C55NvT0xPyaV67SGDn3oFVDp8d4ANc uHCBnp4evWb7NU1AcOHnTa0RqqqqLNmmHRkZobm5maGhIdasWWPZy7QjRLTa4bMa/HFJSEjg7rvv 1mriv31h6HYN8IRW7+HhYcuvaNfU1PDZZ59ZrgmsChHtcvisBh/g1KlTDA/rJi59QssEvKwXclgt TjYHTlf7JjF6eUoTEIz9/6DV8/PPP+fWrVuWv4yRkRHbogOz5sAtav926e/v17tqdtfkNYHJGmCL Vq/BwUFb07JM1gRWihlN4MaZPy6XL1+WuXizZSoTsEurR3Nzs+0xdiAQoKqqihMnrM2HYCREdHKo JysSWO36hQkIplz/m1YPVVVpbW0lHNLS0kJvb6+l0UFqaiqJiYma5sBNDp+M5tP6b0VRXldVdXRc A6Tp2ehw3+QNd3QQSeBfuHBBJk9i2mQTcL9WSytBcGJ0YKfN//777zl06FDYwDeA2f2TCVAQ7vDP iE9w+vRpy32C0tLSiX+XlpbaZvM//fRTRkdHw/7uJDArABjfdtK83n316lVmUs6ePQtAYWGhpSTY tWvXxGe3q/2pMNMJB58C/jUqmN1DM27Yv3+/5bl3zcjGjRstJYFdMtPgw1hu41deeUWvWVwMY9W1 NNWwE8Afdww9Hg+bN282mlxpVoE/7rgHAgG9tDPJMXoRgJOuZY07hoAjSTDu8M2EzZ8OO52UM2ke xmrpTSudnZ2Oesl2OYZudvhCwO4eD2NFFaeV9vZ2R6ras2fPWr5i6Ha1bwK7lR7GKmq6jgBOIYFT wZfELiNGzwQ4mQAz7Rg6GXxJ7O6JYayWrmt8AKc4hk5z+Exil+5hrJDytNLd3e34uDvcjqETHT6T 2PliGKuiPa2YzWgxk+bg4YcfDqVah6vVvkHsvB7+WUJ92tnlFgkEAjQ1NcmcjjUl165dcw34ktjF e4gg8fl8bNmyhaVLl9oy/ujoqOPVvlHxAJpFC20qmGgL+Hbt508EzStXuipnkQR2/R5A01XUuW7k CLFzP/92CccNJKtEArtOD6B5zispKcnx4Nu1nz+dOOFquoxIYNfqATRPEEokJ5xRtW/XAc5IIIEE ds0e4LpWC5M17yLC5rudBBLYXfcA37qNAE4AfzIJnOoYSmD3rQf4zk0ECKfD53bHUAK773RNgJN8 gJlw+NxsDiSwu+4BNHO7LliwYA58l5JAAruWGKBDbzHB4/HM6LnAcZtvB/g3btwgMTHRsr2DcdMU zptUU4nH45FZCOrwBGvP/aDVKtSUbk51+Orr6zl27BinT592bH4CsyKB2Q9CiMD4XsARrZarV6+O OIdvfFevubnZthtIM0kCCcyOwD9vBmnmGfP7/TMy88N1S9fOa2gzRQIJzMonE+C8VstwH7Waibt6 dh0qmal1AgnMzk8mQIueQ5GTkxMRM1/vJI8dt5LDncwyJycHj0d3p78FgvkBVFUdVRRlPTDtlIuP j7f9irgTrmjbma4mXMksH3vsMe666y5N+y+E+GiyBgB4X6tHenp6xKn96cTuW8l2awIJrCawnkyA M1o94uLiLEvy7DS1H25zYOeycWZmJnFxcXrNztxBACHEj4BmBsi8vDxXqf1QkzO40TGUwOhaEOs7 NADA6+EMB+22+VYd3XaTYyiB0S8wvp0AmlWeo6Oj2bp1a8Q4fEY0gV0Jrq0kwdatW4mO1i0Ed2xa Aggh2oAqrd6ShYxdq/bd7BhKYFMVxHhaDQCgmVYiMTExpDUBt6h9tzmGOTk5Mhtad2A7FQFUvVHy 8/MdF+rV19eHJRuXUx1DSUzuwPYOg6Gq6rCiKP3AI9ONkpCQQFtbG21tbYZmvt25d+26ETSVtLW1 0dvb64jFoqysLB588EG9Zi8KIf5PRgMA/FVvtIKCAukHTEpKYvPmzRGRhDEcjuGzzz5rSBNIYjEl plO6jKqq9imKkgo8NN1o8fHxDAwMSOUQ9Hg8LF26FJ/PZ7ggkhPBHxc7lo0HBgaoq6ubKKYhE/fr pIMDOCiE+HhKbDQ6vWGVL9Df309lZSXnzp1jYGAgIsC3QxMMDAxw7tw5Kisr6e/vt9L2T4vltEGj qqrdelogJiaGxYsXc+nSJd0nGBwc5ObNm0RHR4esCZx2RdsKTTAZfFlfpri4mLS0NJnZ/z/Tamed zq/JOCCyK4Q9PT0hawKn3s8PVRN88803lJeXS4Pv9/vJysqSaaqJoeaykaqqP+tFBFFRUaxatYrK ykqpBw9FEzg9OYNZTfDVV19x8uRJQ9+1Z88evWqh457/SdMEAFAU5Rt0agnNmzdP2hSYJYFbMnMY IcHAwABVVVVUVlbKVPn4hepfvny5TNMnVFUdCokAqqoOKYpSCfxGq92SJUv46aefpI9CGyGBm9Ky yJLAjM2HsRU/ScfvUSFEg16jaJmRVFX9VlGUjYBmCY9Vq1ZRVVUlU7pMmgRuA1+GBGbBj4uLo7S0 VGbD54QQ4j9lxjSSIqZUr0FsbCx79+419KK0HEO3gq/lGJoFH2Dv3r2yGVtKZceMlm0YdAhrgKe1 2sXHx5ORkUF1dbX0HzaVJnA7+FNpguTkZC5evGgK/N27d8tuFj0phDhvOQGCJGhQFOVeYINWu/F6 fXV1daZI0NHRwZkzZ1wP/mQStLa20tLSQkNDg+EM7Dt37iQjI0Om6XtCiD8ZGTva6B+jKMpJ4N8B zcXq1NRUvF4vDQ0NhkjQ0tLC9evXHZ+i1gwJurq6DKfd2759u+zVvBFgi6qqAVsJoKpqQFGUj4B/ 02u7bNkyEhMTuXLlivT4Q0NDhkKiSJaioiIeeOAB2eaZQgjDKjPazIOpqvqjoijngF/rtU1LSzOs CeZkbOYbAL9ICPG1me+JNvuAqqpeVRSlC3hURhMY9Qlms+zcudPIjezfCyHeN/td0aE8qKqqX+tt GE32CYxGB7NRdu/eLevwwdhGzyuhfJ8VqWKfQ+d6+bgsX76cffv2yVxcmHUSFxfHvn37ZJd4Cb7z 50L9XkvOIwdLz51ApwDl5AWS48ePh70crVMlJyeHoqIiI2l5y4HCYHKPmSdAkARxwHFZEgDU1tZy +PDhWQ1+cXGxzIme28EvEkJYEipZei0lqAk+QqcS6WTp6uri0KFDM1aedqbE7/dTUlJiNPfCEeBp K2a+LQQIksADvAX8TrbP6OgodXV1s0YbFBcXk5WVZfQI+EHgOSGEpdm6bLunLIR4AfizkT79/f1U VFRIHy5xm+Tl5ZGfny9zkGOqUO8vdjyTrRfVhRCFQb/AkHR0dFBeXh4x6wZZWVkUFBToVfGcToqE ELbVxrM9Z4kQYg1QbybkbG9vp6KiwrXRwvjhDZPpdkeAdUKIK3Y+Y1iS1ggh5gNlwG/N9O/p6aG6 uppTp065AvitW7eSm5sbSvLJ94C9Qoif7X7WsKauEkJsB/5utv/w8DBNTU1UVlZy+fJlR4GemZlJ Xl4efr9f5sSOljwphDgarucOe45zIUQq8C5QGMo4g4ODNDc3U1NTM2MmIicnhw0bNpCenm7F6uYJ oPT269sRR4BJRNgG/MOKscb32puamrh69SoXL160PLexx+MhOzub1atX4/f7WbhwoUwqNll5VO/4 dsQRIEiCeOB54I9Wjx0IBOjt7aWzs5P29vaJn87OTrq7u+nr65s4nBEbG0tCQgJJSUl4vV4WLVo0 8eP1elmwYIFd1dNeBN4UQvTPFAaOKHMRNAuvYmDxyOVyEHgt3OresQSYRIQ04KUIJsJB4A0hRItT HsiRFRCFECnAHjtMwwzJi8BfJ6dnmyOAHBHiAAXYD/zKZaBXMZaTR7Vq527WEWAKP+EJxu4p3uvQ x7zGWB6+Y06w7xFFgClMxBZgFwa2nm2SI4zl3j3jRBUfkQS4jQzRQBpwP2OHUZ4Cltn0dT8EAS9n LN9+ixBi2M3vz/UEmIYUsUBykBj3ACuBjODndMAHeIHxfdl+xopotzJWSvc6YwU1vwt+bgE6rDyI 4RT5f02O5nnLDJUQAAAAAElFTkSuQmCC");
            StateListDrawable states = new StateListDrawable();
            states.addState(new int[]{-16842919}, closeButtonNormalDrawable);
            states.addState(new int[]{16842919}, closeButtonPressedDrawable);
            closeButton.setImageDrawable((Drawable)states);
            closeButton.setScaleType(ImageView.ScaleType.CENTER_CROP);
        }
    }

    private void removeDefaultCloseButton() {
        if (this.closeRegion != null) {
            this.closeRegion.setImageResource(17170445);
        }
    }

    private void setCloseRegionPosition(View view) {
        int size = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.displayMetrics);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);
        if (view == this.expandedView) {
            params.addRule(10);
            params.addRule(11);
        } else if (view == this.resizedView) {
            switch (this.resizeProperties.customClosePosition) {
                case 0: 
                case 4: {
                    params.addRule(9);
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    params.addRule(14);
                    break;
                }
                case 2: 
                case 6: {
                    params.addRule(11);
                }
            }
            switch (this.resizeProperties.customClosePosition) {
                case 0: 
                case 1: 
                case 2: {
                    params.addRule(10);
                    break;
                }
                case 3: {
                    params.addRule(15);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    params.addRule(12);
                }
            }
        }
        this.closeRegion.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void injectMraidJs(WebView wv) {
        this.injectMraidJS(wv, null);
    }

    private void injectMraidJS(WebView webView, JavascriptInjectionHandler handler) {
        if (Build.VERSION.SDK_INT <= 21) {
            webView.loadUrl("javascript:");
        }
        this.injectJavaScript(webView, this.getMraidJs(), handler);
    }

    private String getMraidJs() {
        if (TextUtils.isEmpty((CharSequence)this.mraidJs)) {
            try {
                this.mraidJs = Assets.readFromAssets(this.mContext, "mraid.js");
                Logger.logDebug(TAG, "Found mraid.js, length: " + this.mraidJs.length());
            }
            catch (IOException e) {
                Logger.logError(TAG, "Can't find mraid.js");
                e.printStackTrace();
            }
        }
        return this.mraidJs;
    }

    private void injectJavaScriptInCurrentWebView(String js) {
        this.injectJavaScript(this.currentWebView, js);
    }

    private void injectJavaScript(@Nullable WebView webView, String js) {
        if (webView == null) {
            Logger.logDebug(TAG, "WebView is destroyed, while MRAIDView is not");
            return;
        }
        Logger.logDebug(TAG, "evaluating js: " + js);
        this.injectJavaScript(webView, js, null);
    }

    private void injectJavaScript(@Nullable WebView webView, String js, final JavascriptInjectionHandler handler) {
        if (webView == null) {
            Logger.logDebug(TAG, "WebView is destroyed, while MRAIDView is not");
            return;
        }
        Logger.logDebug(TAG, "evaluating js: " + js);
        if (handler != null) {
            handler.beforeInjecting();
        }
        if (!TextUtils.isEmpty((CharSequence)js)) {
            webView.evaluateJavascript(js, (ValueCallback)new ValueCallback<String>(){

                public void onReceiveValue(String value) {
                    if (handler != null) {
                        handler.afterInjected();
                    }
                }
            });
        }
    }

    private void fireReadyEvent() {
        Logger.logDebug(TAG, "fireReadyEvent");
        this.injectJavaScriptInCurrentWebView("mraid.fireReadyEvent();");
    }

    @SuppressLint(value={"DefaultLocale"})
    private void fireStateChangeEvent() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        Logger.logDebug(TAG, "fireStateChangeEvent - " + stackTraceElements[3].getMethodName());
        String[] stateArray = new String[]{"loading", "default", "expanded", "resized", "hidden"};
        this.injectJavaScriptInCurrentWebView("mraid.fireStateChangeEvent('" + stateArray[this.state] + "');");
    }

    private void fireViewableChangeEvent() {
        Logger.logDebug(TAG, "fireViewableChangeEvent");
        this.injectJavaScriptInCurrentWebView("mraid.fireViewableChangeEvent(" + this.isViewable + ");");
    }

    private int px2dip(int pixels) {
        return pixels * 160 / this.displayMetrics.densityDpi;
    }

    private void setCurrentPosition() {
        int x = this.currentPosition.left;
        int y = this.currentPosition.top;
        int width = this.currentPosition.width();
        int height = this.currentPosition.height();
        Logger.logDebug(TAG, "setCurrentPosition [" + x + "," + y + "] (" + width + "x" + height + ")");
        this.injectJavaScriptInCurrentWebView("mraid.setCurrentPosition(" + this.px2dip(x) + "," + this.px2dip(y) + "," + this.px2dip(width) + "," + this.px2dip(height) + ");");
    }

    private void setDefaultPosition() {
        int x = this.defaultPosition.left;
        int y = this.defaultPosition.top;
        int width = this.defaultPosition.width();
        int height = this.defaultPosition.height();
        Logger.logDebug(TAG, "setDefaultPosition [" + x + "," + y + "] (" + width + "x" + height + ")");
        this.injectJavaScriptInCurrentWebView("mraid.setDefaultPosition(" + this.px2dip(x) + "," + this.px2dip(y) + "," + this.px2dip(width) + "," + this.px2dip(height) + ");");
    }

    private void setMaxSize() {
        Logger.logDebug(TAG, "setMaxSize");
        int width = this.maxSize.width;
        int height = this.maxSize.height;
        Logger.logDebug(TAG, "setMaxSize " + width + "x" + height);
        this.injectJavaScriptInCurrentWebView("mraid.setMaxSize(" + this.px2dip(width) + "," + this.px2dip(height) + ");");
    }

    private void setScreenSize() {
        Logger.logDebug(TAG, "setScreenSize");
        int width = this.screenSize.width;
        int height = this.screenSize.height;
        Logger.logDebug(TAG, "setScreenSize " + width + "x" + height);
        this.injectJavaScriptInCurrentWebView("mraid.setScreenSize(" + this.px2dip(width) + "," + this.px2dip(height) + ");");
    }

    private void setSupportedServices() {
        Logger.logDebug(TAG, "setSupportedServices");
        this.injectJavaScriptInCurrentWebView("mraid.setSupports(mraid.SUPPORTED_FEATURES.CALENDAR, " + MRAIDNativeFeatureManager.isCalendarSupported(this.mContext) + ");");
        this.injectJavaScriptInCurrentWebView("mraid.setSupports(mraid.SUPPORTED_FEATURES.INLINEVIDEO, " + MRAIDNativeFeatureManager.isInlineVideoSupported() + ");");
        this.injectJavaScriptInCurrentWebView("mraid.setSupports(mraid.SUPPORTED_FEATURES.SMS, " + MRAIDNativeFeatureManager.isSmsSupported(this.mContext) + ");");
        this.injectJavaScriptInCurrentWebView("mraid.setSupports(mraid.SUPPORTED_FEATURES.STOREPICTURE, " + MRAIDNativeFeatureManager.isStorePictureSupported(this.mContext) + ");");
        this.injectJavaScriptInCurrentWebView("mraid.setSupports(mraid.SUPPORTED_FEATURES.TEL, " + MRAIDNativeFeatureManager.isTelSupported(this.mContext) + ");");
    }

    @TargetApi(value=11)
    private void pauseWebView(WebView webView) {
        Logger.logDebug(TAG, "pauseWebView " + webView.toString());
        webView.onPause();
    }

    @TargetApi(value=11)
    private void resumeWebView(WebView webView) {
        Logger.logDebug(TAG, "resumeWebView " + webView.toString());
        webView.onResume();
    }

    private void handleWebViewStartRendering(WebView webView) {
        this.handleWebPageLoaded();
    }

    private void handleWebPageLoaded() {
        Logger.logDebug(TAG, "State: " + this.getStateString());
        if (this.state == 0) {
            this.isPageFinished = true;
            this.injectJavaScriptInCurrentWebView("mraid.setPlacementType('" + (this.isInterstitial ? "interstitial" : "inline") + "');");
            this.setSupportedServices();
            if (this.isLaidOut) {
                this.setScreenSize();
                this.setMaxSize();
                this.setCurrentPosition();
                this.setDefaultPosition();
                if (this.isInterstitial) {
                    this.showAsInterstitial();
                } else {
                    this.state = 1;
                    this.fireStateChangeEvent();
                    this.fireReadyEvent();
                    if (this.isViewable) {
                        this.fireViewableChangeEvent();
                    }
                }
            }
            if (this.listener != null) {
                this.listener.mraidViewLoaded(this);
            }
        }
        if (this.isExpandingPart2) {
            this.isExpandingPart2 = false;
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    MRAIDView.this.injectJavaScriptInCurrentWebView("mraid.setPlacementType('" + (MRAIDView.this.isInterstitial ? "interstitial" : "inline") + "');");
                    MRAIDView.this.setSupportedServices();
                    MRAIDView.this.setScreenSize();
                    MRAIDView.this.setDefaultPosition();
                    Logger.logDebug(MRAIDView.TAG, "calling fireStateChangeEvent 2");
                    MRAIDView.this.fireStateChangeEvent();
                    MRAIDView.this.fireReadyEvent();
                    if (MRAIDView.this.isViewable) {
                        MRAIDView.this.fireViewableChangeEvent();
                    }
                }
            });
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Logger.logDebug(TAG, "onConfigurationChanged " + (newConfig.orientation == 1 ? "portrait" : "landscape"));
        ((Activity)this.mContext).getWindowManager().getDefaultDisplay().getMetrics(this.displayMetrics);
    }

    protected void onAttachedToWindow() {
        Logger.logDebug(TAG, "onAttachedToWindow");
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        Logger.logDebug(TAG, "onDetachedFromWindow");
        super.onDetachedFromWindow();
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        Logger.logDebug(TAG, "onVisibilityChanged " + MRAIDView.getVisibilityString(visibility));
        this.setViewable(visibility);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        int actualVisibility = this.getVisibility();
        Logger.logDebug(TAG, "onWindowVisibilityChanged " + MRAIDView.getVisibilityString(visibility) + " (actual " + MRAIDView.getVisibilityString(actualVisibility) + ")");
        this.setViewable(actualVisibility);
    }

    private void setViewable(int visibility) {
        boolean isCurrentlyViewable;
        boolean bl = isCurrentlyViewable = visibility == 0;
        if (isCurrentlyViewable != this.isViewable) {
            this.isViewable = isCurrentlyViewable;
            if (this.isPageFinished && this.isLaidOut) {
                this.fireViewableChangeEvent();
            }
        }
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        Logger.logWarning(TAG, "onLayout (" + this.state + ") " + changed + " " + left + " " + top + " " + right + " " + bottom);
        if (this.isForcingFullScreen) {
            Logger.logDebug(TAG, "onLayout ignored");
            return;
        }
        if (this.state == 2 || this.state == 3) {
            this.calculateScreenSize();
            this.calculateMaxSize();
        }
        if (this.isClosing) {
            this.isClosing = false;
            this.currentPosition = new Rect(this.defaultPosition);
            this.setCurrentPosition();
        } else {
            this.calculatePosition(false);
        }
        if (this.state == 3 && changed) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    MRAIDView.this.setResizedViewPosition();
                }
            });
        }
        this.isLaidOut = true;
        if (this.state == 0 && this.isPageFinished && !this.isInterstitial) {
            this.state = 1;
            this.fireStateChangeEvent();
            this.fireReadyEvent();
            if (this.isViewable) {
                this.fireViewableChangeEvent();
            }
        }
    }

    private void onLayoutWebView(WebView wv, boolean changed, int left, int top, int right, int bottom) {
        boolean isCurrent = wv == this.currentWebView;
        Logger.logWarning(TAG, "onLayoutWebView " + (wv == this.webView ? "1 " : "2 ") + isCurrent + " (" + this.state + ") " + changed + " " + left + " " + top + " " + right + " " + bottom);
        if (!isCurrent) {
            Logger.logDebug(TAG, "onLayoutWebView ignored, not current");
            return;
        }
        if (this.isForcingFullScreen) {
            Logger.logDebug(TAG, "onLayoutWebView ignored, isForcingFullScreen");
            this.isForcingFullScreen = false;
            return;
        }
        if (this.state == 0 || this.state == 1) {
            this.calculateScreenSize();
            this.calculateMaxSize();
        }
        if (!this.isClosing) {
            this.calculatePosition(true);
            if (this.isInterstitial && !this.defaultPosition.equals((Object)this.currentPosition)) {
                this.defaultPosition = new Rect(this.currentPosition);
                this.setDefaultPosition();
            }
        }
        if (this.isExpandingFromDefault) {
            this.isExpandingFromDefault = false;
            if (this.isInterstitial) {
                this.state = 1;
                this.isLaidOut = true;
            }
            if (!this.isExpandingPart2) {
                Logger.logDebug(TAG, "calling fireStateChangeEvent 1");
                this.fireStateChangeEvent();
            }
            if (this.isInterstitial && this.isViewable) {
                this.fireViewableChangeEvent();
            }
            if (this.listener != null) {
                this.listener.mraidViewExpand(this);
            }
        }
    }

    private void calculateScreenSize() {
        int orientation = this.getResources().getConfiguration().orientation;
        boolean isPortrait = orientation == 1;
        Logger.logDebug(TAG, "calculateScreenSize orientation " + (isPortrait ? "portrait" : "landscape"));
        int width = this.displayMetrics.widthPixels;
        int height = this.displayMetrics.heightPixels;
        Logger.logDebug(TAG, "calculateScreenSize screen size " + width + "x" + height);
        if (width != this.screenSize.width || height != this.screenSize.height) {
            this.screenSize.width = width;
            this.screenSize.height = height;
            if (this.isPageFinished) {
                this.setScreenSize();
            }
        }
    }

    private void calculateMaxSize() {
        Rect frame = new Rect();
        Window window = ((Activity)this.mContext).getWindow();
        window.getDecorView().getWindowVisibleDisplayFrame(frame);
        Logger.logDebug(TAG, "calculateMaxSize frame [" + frame.left + "," + frame.top + "][" + frame.right + "," + frame.bottom + "] (" + frame.width() + "x" + frame.height() + ")");
        this.statusHeight = frame.top;
        this.contentViewTop = window.findViewById(0x1020002).getTop();
        int titleHeight = this.contentViewTop - this.statusHeight;
        Logger.logDebug(TAG, "calculateMaxSize statusHeight " + this.statusHeight);
        Logger.logDebug(TAG, "calculateMaxSize titleHeight " + titleHeight);
        Logger.logDebug(TAG, "calculateMaxSize contentViewTop " + this.contentViewTop);
        int width = frame.width();
        int height = this.screenSize.height - this.contentViewTop;
        Logger.logDebug(TAG, "calculateMaxSize max size " + width + "x" + height);
        if (width != this.maxSize.width || height != this.maxSize.height) {
            this.maxSize.width = width;
            this.maxSize.height = height;
            if (this.isPageFinished) {
                this.setMaxSize();
            }
        }
    }

    private void calculatePosition(boolean isCurrentWebView) {
        Rect position;
        int[] location = new int[2];
        MRAIDView view = isCurrentWebView ? this.currentWebView : this;
        String name = isCurrentWebView ? "current" : "default";
        view.getLocationOnScreen(location);
        int x = location[0];
        int y = location[1];
        Logger.logDebug(TAG, "calculatePosition " + name + " locationOnScreen [" + x + "," + y + "]");
        Logger.logDebug(TAG, "calculatePosition " + name + " contentViewTop " + this.contentViewTop);
        y = y - this.contentViewTop - this.statusHeight;
        int width = view.getWidth();
        int height = view.getHeight();
        Logger.logDebug(TAG, "calculatePosition " + name + " position [" + x + "," + y + "] (" + width + "x" + height + ")");
        Rect rect = position = isCurrentWebView ? this.currentPosition : this.defaultPosition;
        if (x != position.left || y != position.top || width != position.width() || height != position.height()) {
            if (isCurrentWebView) {
                this.currentPosition = new Rect(x, y, x + width, y + height);
            } else {
                this.defaultPosition = new Rect(x, y, x + width, y + height);
            }
            if (this.isPageFinished) {
                if (isCurrentWebView) {
                    this.setCurrentPosition();
                } else {
                    this.setDefaultPosition();
                }
            }
        }
    }

    private static String getOrientationString(int orientation) {
        switch (orientation) {
            case -1: {
                return "UNSPECIFIED";
            }
            case 0: {
                return "LANDSCAPE";
            }
            case 1: {
                return "PORTRAIT";
            }
        }
        return "UNKNOWN";
    }

    private void applyOrientationProperties() {
        Logger.logDebug(TAG, "applyOrientationProperties " + this.orientationProperties.allowOrientationChange + " " + this.orientationProperties.forceOrientationString());
        Activity activity = (Activity)this.mContext;
        int currentOrientation = this.getResources().getConfiguration().orientation;
        boolean isCurrentPortrait = currentOrientation == 1;
        Logger.logDebug(TAG, "currentOrientation " + (isCurrentPortrait ? "portrait" : "landscape"));
        int orientation = this.originalRequestedOrientation;
        orientation = this.orientationProperties.forceOrientation == 0 ? 1 : (this.orientationProperties.forceOrientation == 1 ? 0 : (this.orientationProperties.allowOrientationChange ? -1 : (isCurrentPortrait ? 1 : 0)));
        activity.setRequestedOrientation(orientation);
    }

    private void restoreOriginalOrientation() {
        Logger.logDebug(TAG, "restoreOriginalOrientation");
        Activity activity = (Activity)this.mContext;
        int currentRequestedOrientation = activity.getRequestedOrientation();
        if (currentRequestedOrientation != this.originalRequestedOrientation) {
            activity.setRequestedOrientation(this.originalRequestedOrientation);
        }
    }

    public void removeAllViewFromParent() {
        if (this.currentWebView != null) {
            ((ViewGroup)this.currentWebView.getParent()).removeView((View)this.currentWebView);
        }
    }

    private class MRAIDWebViewClient
    extends WebViewClient {
        private MRAIDWebViewClient() {
        }

        public void onPageFinished(WebView view, String url) {
            Logger.logDebug(MRAIDView.TAG, "onPageFinished: " + url);
            super.onPageFinished(view, url);
            MRAIDView.this.handleWebViewStartRendering(view);
        }

        @RequiresApi(value=24)
        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            if (Build.VERSION.SDK_INT >= 23) {
                Logger.logDebug(MRAIDView.TAG, "onReceivedError: " + error.getDescription() + " with request: " + request.toString());
                super.onReceivedError(view, request, error);
            }
        }

        @TargetApi(value=23)
        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            if (Build.VERSION.SDK_INT < 23) {
                Logger.logDebug(MRAIDView.TAG, "onReceivedError: " + description + " with failingUrl: " + failingUrl);
                super.onReceivedError(view, errorCode, description, failingUrl);
            }
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            Logger.logError(MRAIDView.TAG, "Http error: " + error.toString());
            super.onReceivedSslError(view, handler, error);
        }

        @TargetApi(value=23)
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (Build.VERSION.SDK_INT >= 24) {
                return false;
            }
            Logger.logDebug(MRAIDView.TAG, "shouldOverrideUrlLoading: " + url);
            if (MRAIDView.this.mTestListener != null && MRAIDView.this.mTestListener.interceptRequest(url)) {
                return true;
            }
            if (url.startsWith("mraid://")) {
                MRAIDView.this.parseCommandUrl(url);
            } else if (url.startsWith("console.log")) {
                Logger.logDebug(MRAIDView.TAG, "JS-Console: " + url.substring(14));
            } else {
                MRAIDView.this.open(url);
            }
            return true;
        }

        @RequiresApi(value=24)
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            if (Build.VERSION.SDK_INT < 24) {
                return false;
            }
            String url = request.getUrl().toString();
            Logger.logDebug(MRAIDView.TAG, "shouldOverrideUrlLoading: " + url);
            if (MRAIDView.this.mTestListener != null && MRAIDView.this.mTestListener.interceptRequest(url)) {
                return true;
            }
            if (url.startsWith("mraid://")) {
                MRAIDView.this.parseCommandUrl(url);
            } else if (url.startsWith("console.log")) {
                Logger.logDebug(MRAIDView.TAG, "JS-Console: " + url.substring(14));
            } else {
                MRAIDView.this.open(url);
            }
            return true;
        }

        @TargetApi(value=24)
        public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
            if (url.endsWith("mraid.js")) {
                String mraidJSSrc = "javascript:" + MRAIDView.this.getMraidJs();
                ByteArrayInputStream data = new ByteArrayInputStream(mraidJSSrc.getBytes());
                return new WebResourceResponse("text/javascript", "UTF-8", (InputStream)data);
            }
            if (Build.VERSION.SDK_INT == 25) {
                return super.shouldInterceptRequest(view, url);
            }
            Logger.logDebug(MRAIDView.TAG, "shouldInterceptRequest 24: " + url);
            if (MRAIDView.this.mTestListener != null) {
                MRAIDView.this.mTestListener.interceptRequest(url);
            }
            return super.shouldInterceptRequest(view, url);
        }

        @RequiresApi(value=25)
        public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
            String url = request.getUrl().toString();
            if (url.endsWith("mraid.js")) {
                String mraidJSSrc = "javascript:" + MRAIDView.this.getMraidJs();
                ByteArrayInputStream data = new ByteArrayInputStream(mraidJSSrc.getBytes());
                return new WebResourceResponse("text/javascript", "UTF-8", (InputStream)data);
            }
            if (Build.VERSION.SDK_INT < 25) {
                return super.shouldInterceptRequest(view, request);
            }
            Logger.logDebug(MRAIDView.TAG, "shouldInterceptRequest 25: " + url);
            if (MRAIDView.this.mTestListener != null) {
                MRAIDView.this.mTestListener.interceptRequest(url);
            }
            return super.shouldInterceptRequest(view, request);
        }
    }

    private class MRAIDWebChromeClient
    extends WebChromeClient {
        private MRAIDWebChromeClient() {
        }

        public boolean onConsoleMessage(ConsoleMessage cm) {
            if (cm == null || cm.message() == null) {
                return false;
            }
            Logger.logInfo("JS console", cm.message() + (cm.sourceId() == null ? "" : " at " + cm.sourceId()) + ":" + cm.lineNumber());
            return true;
        }

        public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
            Logger.logDebug("JS alert", message);
            return this.handlePopups(result);
        }

        public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
            Logger.logDebug("JS confirm", message);
            return this.handlePopups(result);
        }

        public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
            Logger.logDebug("JS prompt", message);
            return this.handlePopups((JsResult)result);
        }

        private boolean handlePopups(JsResult result) {
            return false;
        }
    }

    private final class Size {
        public int width;
        public int height;

        private Size() {
        }
    }

    private static interface JavascriptInjectionHandler {
        public void beforeInjecting();

        public void afterInjected();
    }
}

