/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.support.customtabs.CustomTabsIntent;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import com.xad.sdk.mraid.VideoPlayerActivity;
import com.xad.sdk.utils.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class MRAIDNativeFeatureProvider {
    private static final String TAG = "MRAIDNativeFeatureProvider";

    public static void callTel(Context context, String url) {
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.CALL_PHONE") != 0) {
            MRAIDNativeFeatureProvider.callTelWithoutPermission(context, url);
        } else {
            MRAIDNativeFeatureProvider.callTelWithPermission(context, url);
        }
    }

    private static void callTelWithoutPermission(Context context, String url) {
        Intent intent = new Intent("android.intent.action.DIAL", Uri.parse((String)url));
        context.startActivity(intent);
    }

    private static void callTelWithPermission(Context context, String url) {
        Intent intent = new Intent("android.intent.action.CALL", Uri.parse((String)url));
        context.startActivity(intent);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static void createCalendarEvent(Context context, String eventJSON) {
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_CALENDAR") != 0) {
            Logger.logError(TAG, "No permission to create calender event");
        }
        try {
            eventJSON = eventJSON.replace("\\", "").replace("\"{", "{").replace("}\"", "}");
            JSONObject jsonObject = new JSONObject(eventJSON);
            String description = jsonObject.optString("description", "Untitled");
            String location = jsonObject.optString("location", "unknown");
            String summary = jsonObject.optString("summary");
            String[] patterns = new String[]{"yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mm:ssZ"};
            String[] dateStrings = new String[]{jsonObject.getString("start"), jsonObject.optString("end")};
            long startTime = 0L;
            long endTime = 0L;
            block4: for (int i = 0; i < dateStrings.length; ++i) {
                if (TextUtils.isEmpty((CharSequence)dateStrings[i])) continue;
                dateStrings[i] = dateStrings[i].replaceAll("([+-]\\d\\d):(\\d\\d)$", "$1$2");
                for (String pattern : patterns) {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                        if (i == 0) {
                            startTime = sdf.parse(dateStrings[i]).getTime();
                            continue block4;
                        }
                        endTime = sdf.parse(dateStrings[i]).getTime();
                        continue block4;
                    }
                    catch (ParseException e) {
                    }
                }
            }
            Intent intent = new Intent("android.intent.action.INSERT").setType("vnd.android.cursor.item/event");
            intent.putExtra("title", description);
            intent.putExtra("description", summary);
            intent.putExtra("eventLocation", location);
            if (startTime > 0L) {
                intent.putExtra("beginTime", startTime);
            }
            if (endTime > 0L) {
                intent.putExtra("endTime", endTime);
            }
            context.startActivity(intent);
        }
        catch (JSONException e) {
            Logger.logError(TAG, "Error parsing JSON: " + e.getLocalizedMessage());
        }
    }

    public static void playVideo(Context context, String url) {
        Intent intent = new Intent(context, VideoPlayerActivity.class);
        intent.putExtra("com.xad.displaysdk.videodataurl", url);
        context.startActivity(intent);
    }

    public static void openBrowser(Context context, String url) {
        if (context instanceof Activity && Build.VERSION.SDK_INT >= 23) {
            CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder();
            CustomTabsIntent customTabsIntent = builder.build();
            customTabsIntent.launchUrl(context, Uri.parse((String)url));
        } else {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            context.startActivity(intent);
        }
    }

    public static void storePicture(final Context context, final String url) {
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            Logger.logError(TAG, "No permission to store image");
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MRAIDNativeFeatureProvider.storePictureInGallery(context, url);
                }
                catch (Exception e) {
                    Logger.logError(MRAIDNativeFeatureProvider.TAG, e.getLocalizedMessage());
                }
            }
        }).start();
    }

    public static void sendSms(Context context, String url) {
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.SEND_SMS") != 0) {
            MRAIDNativeFeatureProvider.sendSmsWithoutPermission(context, url);
        } else {
            MRAIDNativeFeatureProvider.sendSmsWithPermission(context, url);
        }
    }

    private static void sendSmsWithoutPermission(Context context, String url) {
        Intent intent = new Intent("android.intent.action.SENDTO", Uri.parse((String)url));
        context.startActivity(intent);
    }

    private static void sendSmsWithPermission(Context context, String url) {
        Intent intent = new Intent("android.intent.action.SENDTO", Uri.parse((String)url));
        context.startActivity(intent);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private static void storePictureInGallery(Context context, String url) {
        SimpleDateFormat gmtDateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
        String s = MRAIDNativeFeatureProvider.getAlbumDir() + "/img" + gmtDateFormat.format(new Date()) + ".png";
        Logger.logInfo(TAG, "Saving image into: " + s);
        File f = new File(s);
        try {
            InputStream is = new URL(url).openStream();
            FileOutputStream os = new FileOutputStream(f);
            MRAIDNativeFeatureProvider.copyStream(is, os);
            MediaScannerConnection.scanFile((Context)context, (String[])new String[]{f.getAbsolutePath()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                public void onScanCompleted(String path, Uri uri) {
                    Logger.logDebug(MRAIDNativeFeatureProvider.TAG, "File saves successfully to " + path);
                }
            });
            Logger.logInfo(TAG, "Saved image successfully");
        }
        catch (MalformedURLException e) {
            Logger.logError(TAG, "Not able to save image due to invalid URL: " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            Logger.logError(TAG, "Unable to save image: " + e.getLocalizedMessage());
        }
    }

    private static void copyStream(InputStream is, OutputStream os) {
        int buffer_size = 1024;
        try {
            int count;
            byte[] bytes = new byte[1024];
            while ((count = is.read(bytes, 0, 1024)) != -1) {
                os.write(bytes, 0, count);
            }
        }
        catch (Exception ex) {
            Logger.logInfo(TAG, "Error saving picture: " + ex.getLocalizedMessage());
        }
    }

    @Nullable
    private static File getAlbumDir() {
        File storageDir = null;
        if ("mounted".equals(Environment.getExternalStorageState())) {
            storageDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), "xAd");
            if (!storageDir.mkdirs() && !storageDir.exists()) {
                Logger.logInfo(TAG, "Failed to create camera directory");
                return null;
            }
        } else {
            Logger.logInfo(TAG, "External storage is not mounted READ/WRITE.");
        }
        return storageDir;
    }
}

