/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk;

import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.xad.sdk.utils.Logger;

public class LocationProvider
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static final String TAG = "LocationProvider";
    private LocationListener mLocationListener;
    private Context mContext;
    private LocationRequest mLocationRequest;
    private GoogleApiClient mGoogleApiClient;

    protected LocationProvider(Context context, LocationListener listener) {
        this.mLocationListener = listener;
        this.mContext = context.getApplicationContext();
    }

    protected void initProvider(long interval, long fastestInterval, float smallestDisplacementMeters) {
        this.mGoogleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
        this.mLocationRequest = LocationRequest.create();
        this.mLocationRequest.setPriority(100);
        this.mLocationRequest.setFastestInterval(fastestInterval);
        this.mLocationRequest.setInterval(interval);
        this.mLocationRequest.setSmallestDisplacement(smallestDisplacementMeters);
        this.mGoogleApiClient.connect();
    }

    public void destroy() {
        if (this.googleApiClientIsValid()) {
            this.removeLocationUpdate();
            this.mGoogleApiClient.disconnect();
        } else {
            Logger.logDebug(TAG, "GoogleApiClient has been already disconnected");
        }
        this.mGoogleApiClient = null;
        this.mContext = null;
        this.mLocationListener = null;
    }

    private boolean locationPermissionGranted() {
        if (this.mContext == null) {
            return false;
        }
        return Build.VERSION.SDK_INT < 23 || ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    public void onConnected(Bundle connectionHint) {
        Logger.logDebug(TAG, "Connected to GoogleApiClient, location service will start soon");
        this.requestLocationUpdate();
    }

    @Nullable
    public Location getLastLocation() {
        if (this.locationPermissionGranted() && this.googleApiClientIsValid()) {
            return LocationServices.FusedLocationApi.getLastLocation(this.mGoogleApiClient);
        }
        Logger.logError(TAG, "Location permission is disabled. Need explicitly ask user to grant location permission");
        return null;
    }

    public void removeLocationUpdate() {
        if (this.googleApiClientIsValid()) {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.mGoogleApiClient, this.mLocationListener);
        }
        Logger.logDebug(TAG, "Location update is disabled.");
    }

    public void requestLocationUpdate() {
        if (this.locationPermissionGranted() && this.googleApiClientIsValid()) {
            LocationServices.FusedLocationApi.requestLocationUpdates(this.mGoogleApiClient, this.mLocationRequest, this.mLocationListener);
        } else {
            Logger.logError(TAG, "Location permission is disabled. Need explicitly ask user to grant location permission");
        }
        Logger.logDebug(TAG, "Location update is enabled.");
    }

    public void onConnectionSuspended(int cause) {
        Logger.logInfo(TAG, "Connection suspended with error code: " + cause);
    }

    public void onConnectionFailed(@NonNull ConnectionResult result) {
        Logger.logError(TAG, "Fail to connect to google api client with code: " + result.getErrorCode());
    }

    private boolean googleApiClientIsValid() {
        return this.mGoogleApiClient != null && this.mGoogleApiClient.isConnected();
    }
}

