/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.WindowManager;
import com.xad.sdk.AdRequest;
import com.xad.sdk.AdType;
import com.xad.sdk.DisplaySdk;
import com.xad.sdk.IAdViewBase;
import com.xad.sdk.MRAIDNativeFeatureProvider;
import com.xad.sdk.events.AdViewRequestEvent;
import com.xad.sdk.events.CreativeEvent;
import com.xad.sdk.events.ErrorEvent;
import com.xad.sdk.listeners.InterstitialAdListener;
import com.xad.sdk.listeners.TestListener;
import com.xad.sdk.mraid.MRAIDNativeFeatureListener;
import com.xad.sdk.mraid.MRAIDView;
import com.xad.sdk.mraid.MRAIDViewListener;
import com.xad.sdk.utils.Logger;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class InterstitialAd
implements IAdViewBase,
MRAIDViewListener,
MRAIDNativeFeatureListener {
    public static final String TAG = "InterstitialAd";
    private Context mContext;
    private InterstitialAdListener mListener;
    private String accessKey;
    private AdRequest adRequest;
    private MRAIDView mMraidViewAsInterstitial;
    private boolean isReady = false;
    private boolean hasFailed = false;
    private boolean hasBeenRequest = false;
    private TestListener mTestListener;

    @Deprecated
    public InterstitialAd(Context context) {
        this.mContext = context;
        DisplaySdk.sharedInstance().init(context);
        IAdViewBase.AdViewUtils.registerOnBus(this);
    }

    public InterstitialAd(Context context, @NonNull String accessKey) {
        this(context);
        this.accessKey = accessKey;
    }

    public void setAccessKey(String id2) {
        this.accessKey = id2;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAdListener(InterstitialAdListener listener) {
        this.mListener = listener;
    }

    public InterstitialAdListener getAdListener() {
        return this.mListener;
    }

    public void setAdRequest(AdRequest adRequest) {
        this.adRequest = adRequest;
    }

    public AdRequest getAdRequest() {
        return this.adRequest;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setTestListener(TestListener testListener) {
        this.mTestListener = testListener;
    }

    public void loadAd() {
        if (TextUtils.isEmpty((CharSequence)this.accessKey)) {
            throw new IllegalArgumentException("Access key must be set before load ad");
        }
        if (this.adRequest == null) {
            throw new IllegalArgumentException("AdRequest must be set before load ad");
        }
        if (this.hasBeenRequest) {
            Logger.logWarning(TAG, "Interstitial ad objects can only be used once even with different requests.");
            return;
        }
        this.hasBeenRequest = true;
        DisplaySdk.sharedBus().post((Object)new AdViewRequestEvent(this, null, this.accessKey, this.adRequest, AdType.INTERSTITIAL));
        Logger.logDebug(TAG, "An request for Interstitial is posted ");
    }

    public void show() {
        if (this.mMraidViewAsInterstitial == null || !this.isReady()) {
            Logger.logWarning(TAG, "Interstitial is not ready. Please wait until you receive \"onAdLoaded\" callback");
            return;
        }
        if (this.hasFailed) {
            Logger.logWarning(TAG, "Failed to load interstitial. Internal error");
            this.mListener.onInterstitialFailedToShow(this);
            return;
        }
        this.mMraidViewAsInterstitial.showAsInterstitial();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onCreativeEventReceived(CreativeEvent event) {
        if (event.Requester != this) {
            return;
        }
        this.mMraidViewAsInterstitial = new MRAIDView(this.mContext, event, this, this, true);
        this.mMraidViewAsInterstitial.setTestListener(this.mTestListener);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onErrorEventReceived(ErrorEvent errorEvent) {
        if (errorEvent.Requester != this) {
            return;
        }
        if (this.mListener != null) {
            this.mListener.onAdFetchFailed(this, errorEvent.Error);
        }
    }

    @Override
    public void resume() {
        IAdViewBase.AdViewUtils.registerOnBus(this);
    }

    @Override
    public void destroy() {
        if (this.mMraidViewAsInterstitial != null) {
            this.mMraidViewAsInterstitial.removeAllViewFromParent();
            this.mMraidViewAsInterstitial.destroy();
            this.mMraidViewAsInterstitial = null;
        }
        this.mContext = null;
        Logger.logDebug(TAG, "Interstitial " + this + " is destroyed");
    }

    @Override
    public void pause() {
        IAdViewBase.AdViewUtils.unregisterOnBus(this);
    }

    public void disableOrientation() {
        int orientation;
        if (this.mContext == null || !(this.mContext instanceof Activity)) {
            return;
        }
        int rotation = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
        switch (rotation) {
            case 0: {
                orientation = 1;
                break;
            }
            case 1: {
                orientation = 0;
                break;
            }
            case 2: {
                orientation = 9;
                break;
            }
            case 3: {
                orientation = 8;
                break;
            }
            default: {
                orientation = 1;
            }
        }
        ((Activity)this.mContext).setRequestedOrientation(orientation);
    }

    public void enableOrientation() {
        if (this.mContext == null) {
            return;
        }
        ((Activity)this.mContext).setRequestedOrientation(-1);
    }

    @Override
    public void mraidViewLoaded(MRAIDView mraidView) {
        Logger.logDebug(TAG, "Interstitial Loaded");
        this.isReady = true;
        if (this.mListener != null) {
            this.mListener.onAdLoaded(this);
        }
    }

    @Override
    public void mraidViewFailed(MRAIDView mraidView) {
        Logger.logDebug(TAG, " Interstitial Failed");
        this.hasFailed = true;
    }

    @Override
    public void mraidViewExpand(MRAIDView mraidView) {
        Logger.logDebug(TAG, "Interstitial showed");
        if (this.mListener != null) {
            this.mListener.onInterstitialShown(this);
        }
        this.disableOrientation();
    }

    @Override
    public void mraidViewClose(MRAIDView mraidView) {
        Logger.logDebug(TAG, "mraidViewClose");
        this.isReady = false;
        this.mMraidViewAsInterstitial = null;
        if (this.mListener != null) {
            this.mListener.onAdClosed(this);
        }
        this.enableOrientation();
    }

    @Override
    public boolean mraidViewResize(MRAIDView mraidView, int width, int height, int offsetX, int offsetY) {
        return false;
    }

    @Override
    public void mraidNativeFeatureCallTel(String url) {
        MRAIDNativeFeatureProvider.callTel(this.mContext, url);
        if (this.mListener != null) {
            this.mListener.onAdLeftApplication(this);
        }
    }

    @Override
    public void mraidNativeFeatureCreateCalendarEvent(String eventJSON) {
        MRAIDNativeFeatureProvider.createCalendarEvent(this.mContext, eventJSON);
    }

    @Override
    public void mraidNativeFeaturePlayVideo(String url) {
        MRAIDNativeFeatureProvider.playVideo(this.mContext, url);
    }

    @Override
    public void mraidNativeFeatureOpenBrowser(String url) {
        MRAIDNativeFeatureProvider.openBrowser(this.mContext, url);
        if (this.mListener != null) {
            this.mListener.onAdOpened(this);
        }
    }

    @Override
    public void mraidNativeFeatureStorePicture(String url) {
        MRAIDNativeFeatureProvider.storePicture(this.mContext, url);
    }

    @Override
    public void mraidNativeFeatureSendSms(String url) {
        MRAIDNativeFeatureProvider.sendSms(this.mContext, url);
        if (this.mListener != null) {
            this.mListener.onAdLeftApplication(this);
        }
    }
}

