/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk;

import android.content.Context;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.location.LocationListener;
import com.xad.sdk.ErrorCode;
import com.xad.sdk.LocationProvider;
import com.xad.sdk.events.AdViewRequestEvent;
import com.xad.sdk.events.CreativeEvent;
import com.xad.sdk.events.ErrorEvent;
import com.xad.sdk.utils.AdTestUrlGenerator;
import com.xad.sdk.utils.AdUrlGenerator;
import com.xad.sdk.utils.ErrorPosting;
import com.xad.sdk.utils.Logger;
import com.xad.sdk.utils.UrlGenerator;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class DisplaySdk
implements LocationListener {
    public static final String TAG = "DisplaySdk";
    private Context mContext;
    private LocationProvider mLocationProvider;

    public void onLocationChanged(Location location) {
        Logger.logDebug(TAG, "Location updates: " + location.toString());
    }

    public static DisplaySdk sharedInstance() {
        return InstanceLoader.sInstance;
    }

    public static EventBus sharedBus() {
        return InstanceLoader.displayEventBus;
    }

    public Context getApplicationContext() {
        return this.mContext;
    }

    private DisplaySdk() {
        InstanceLoader.displayEventBus = EventBus.builder().logNoSubscriberMessages(false).eventInheritance(false).build();
        Logger.logDebug(TAG, "DisplaySdk instance is created");
    }

    public void init(Context context) {
        this.registerOnBus();
        if (this.mContext == null) {
            Logger.logDebug(TAG, "Init DisplaySdk");
            DisplaySdk.sharedInstance().mContext = context.getApplicationContext();
            this.mLocationProvider = new LocationProvider(this.mContext, this);
            this.mLocationProvider.initProvider(10000L, 5000L, 3.0f);
        }
    }

    @Subscribe(threadMode=ThreadMode.ASYNC)
    public void onAdViewRequestEventReceived(AdViewRequestEvent adViewRequestEvent) {
        UrlGenerator generator;
        if (adViewRequestEvent.AdRequest.isTesting()) {
            generator = new AdTestUrlGenerator("https://testchannel.xad.com", adViewRequestEvent.AdRequest.getTestType(), adViewRequestEvent.AdRequest.getTestChannelId()).withAdTypeAndAdSize(adViewRequestEvent.Type, adViewRequestEvent.AdSize);
        } else {
            generator = new AdUrlGenerator(this.mContext, "https://display.xad.com/rest/banner").withFormat(adViewRequestEvent.Type).withAdRequest(adViewRequestEvent.AdRequest).withAdSize(adViewRequestEvent.AdSize).withAccessKey(adViewRequestEvent.AccessKey);
            try {
                AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
                ((AdUrlGenerator)generator).withAdvertisingInfo(info);
            }
            catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException e) {
                Logger.logWarning(TAG, "Google Play Service is not available, instead will use Android ID as user ID");
                ((AdUrlGenerator)generator).withAndroidID(this.mContext);
                e.printStackTrace();
            }
            Location currentLocation = this.mLocationProvider.getLastLocation();
            if (currentLocation != null) {
                ((AdUrlGenerator)generator).withLocation(currentLocation);
            }
        }
        String requestUrl = generator.generateUrlString();
        CreativeEvent creativeEvent = this.fetchAdCreative(adViewRequestEvent, requestUrl);
        if (creativeEvent != null) {
            DisplaySdk.sharedBus().post((Object)creativeEvent);
        }
        Logger.logDebug(TAG, "Creative has been successfully fetched and posted");
    }

    @Nullable
    private CreativeEvent fetchAdCreative(AdViewRequestEvent adViewRequestEvent, String url) {
        Logger.logDebug(TAG, "Request url is: " + url);
        if (!this.isNetworkAvailable()) {
            Logger.logError(TAG, "Network is not available, please try later when there is established network connection");
            DisplaySdk.sharedBus().post((Object)new ErrorEvent(adViewRequestEvent.Requester, ErrorCode.NETWORK_ERROR));
            return null;
        }
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).build();
        Request request = new Request.Builder().url(url).build();
        try {
            Response response = client.newCall(request).execute();
            Logger.logDebug(TAG, "Response code: " + response.code());
            if (!response.isSuccessful()) {
                response.body().close();
                DisplaySdk.sharedBus().post((Object)new ErrorEvent(adViewRequestEvent.Requester, ErrorCode.BAD_REQUEST));
                ErrorPosting.sendError(this.mContext, 15, "Status code: " + response.code());
                return null;
            }
            String responseBody = response.body().string();
            if (TextUtils.isEmpty((CharSequence)responseBody)) {
                Logger.logWarning(TAG, "No ad matched for current request");
                DisplaySdk.sharedBus().post((Object)new ErrorEvent(adViewRequestEvent.Requester, ErrorCode.NO_INVENTORY));
                return null;
            }
            Logger.logInfo(TAG, "Creative: " + responseBody);
            CreativeEvent creativeEvent = new CreativeEvent(adViewRequestEvent.Requester, responseBody);
            creativeEvent.adGroupId = adViewRequestEvent.AdRequest.isTesting() ? response.header("x-channel-id") : response.header("x-xad-ad-ref");
            Logger.logDebug(TAG, "Ad Group Id: " + creativeEvent.adGroupId);
            return creativeEvent;
        }
        catch (IOException e) {
            DisplaySdk.sharedBus().post((Object)new ErrorEvent(adViewRequestEvent.Requester, ErrorCode.NETWORK_ERROR));
            e.printStackTrace();
            return null;
        }
    }

    public void resume() {
        this.registerOnBus();
        this.mLocationProvider.requestLocationUpdate();
    }

    public void pause() {
        this.mLocationProvider.removeLocationUpdate();
        this.unregisterOnBus();
    }

    public void destroy() {
        Logger.logDebug(TAG, "DisplaySdk instance is destroyed");
        this.unregisterOnBus();
        this.mLocationProvider.destroy();
        this.mContext = null;
    }

    private void registerOnBus() {
        if (!DisplaySdk.sharedBus().isRegistered((Object)this)) {
            DisplaySdk.sharedBus().register((Object)this);
        }
    }

    private void unregisterOnBus() {
        if (DisplaySdk.sharedBus().isRegistered((Object)this)) {
            DisplaySdk.sharedBus().unregister((Object)this);
        }
    }

    private boolean isNetworkAvailable() {
        if (this.mContext == null) {
            return false;
        }
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnectedOrConnecting();
    }

    private static class InstanceLoader {
        private static DisplaySdk sInstance = new DisplaySdk();
        private static EventBus displayEventBus;

        private InstanceLoader() {
        }
    }
}

