/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.xad.sdk.AdRequest;
import com.xad.sdk.AdSize;
import com.xad.sdk.AdType;
import com.xad.sdk.DisplaySdk;
import com.xad.sdk.ErrorCode;
import com.xad.sdk.IAdViewBase;
import com.xad.sdk.MRAIDNativeFeatureProvider;
import com.xad.sdk.R;
import com.xad.sdk.RefreshInterval;
import com.xad.sdk.events.AdViewRequestEvent;
import com.xad.sdk.events.CreativeEvent;
import com.xad.sdk.events.ErrorEvent;
import com.xad.sdk.listeners.BannerViewListener;
import com.xad.sdk.listeners.TestListener;
import com.xad.sdk.mraid.MRAIDNativeFeatureListener;
import com.xad.sdk.mraid.MRAIDView;
import com.xad.sdk.mraid.MRAIDViewListener;
import com.xad.sdk.utils.Logger;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class BannerView
extends RelativeLayout
implements IAdViewBase,
MRAIDNativeFeatureListener,
MRAIDViewListener {
    private static final String TAG = "BannerView";
    private static final int REFRESH_MESSAGE = 0;
    private Context mContext;
    private BannerViewListener mListener;
    private AdSize adSize;
    private String accessKey;
    private AdRequest adRequest;
    private RefreshInterval adInterval = RefreshInterval.MEDIUM;
    private Handler mRefreshHandler;
    private HandlerThread mRefreshThread;
    private boolean hasBeenRequested = false;
    private MRAIDView mraidView;
    private TestListener mTestListener;

    public BannerView(Context context, AdSize adSize, String accessKey) {
        this(context, null);
        this.adSize = adSize;
        this.accessKey = accessKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BannerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.XAdAttrs);
            try {
                this.accessKey = ta.getString(R.styleable.XAdAttrs_AccessKey);
                int sizeEnum = ta.getInteger(R.styleable.XAdAttrs_AdSize, 0);
                this.adSize = AdSize.values()[sizeEnum];
                int intervalEnum = ta.getInteger(R.styleable.XAdAttrs_AdInterval, 0);
                this.adInterval = RefreshInterval.values()[intervalEnum];
            }
            finally {
                ta.recycle();
            }
        }
        DisplaySdk.sharedInstance().init(context);
        IAdViewBase.AdViewUtils.registerOnBus(this);
        this.startRefreshThread();
    }

    public void setRefresh(RefreshInterval interval) {
        this.adInterval = interval;
    }

    public RefreshInterval getRefresh() {
        return this.adInterval;
    }

    public void setSize(AdSize adSize) {
        this.adSize = adSize;
    }

    public AdSize getAdSize() {
        return this.adSize;
    }

    public void setAccessKey(String id) {
        this.accessKey = id;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAdListener(BannerViewListener listener) {
        this.mListener = listener;
    }

    public BannerViewListener getAdListener() {
        return this.mListener;
    }

    public void setAdRequest(AdRequest adRequest) {
        this.adRequest = adRequest;
    }

    public AdRequest getAdRequest() {
        return this.adRequest;
    }

    public void setTestListener(TestListener testListener) {
        this.mTestListener = testListener;
    }

    public void loadAd() {
        if (this.adSize == null) {
            throw new IllegalArgumentException("AdSize must be set before load ad");
        }
        if (this.accessKey == null || "".equals(this.accessKey)) {
            throw new IllegalArgumentException("Publisher key must be set before load ad");
        }
        if (this.adRequest == null) {
            throw new IllegalArgumentException("AdRequest must be set before load ad");
        }
        if (this.hasBeenRequested) {
            Logger.logWarning(TAG, "Banner will auto refresh with certain time, please don't load request multiple times.");
            return;
        }
        this.hasBeenRequested = true;
        this.raiseAdRequest();
    }

    private void raiseAdRequest() {
        DisplaySdk.sharedBus().post((Object)new AdViewRequestEvent(this, this.adSize, this.accessKey, this.adRequest, AdType.BANNER));
        Logger.logDebug(TAG, "An request for Banner is posted");
        this.fireNextAdRequestTask();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onCreativeEventReceived(CreativeEvent event) {
        if (event.Requester != this) {
            return;
        }
        int width = this.adSize.getWidthInPixels(this.mContext);
        int height = this.adSize.getHeightInPixels(this.mContext);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(width, height);
        params.addRule(13);
        this.mraidView = new MRAIDView(this.mContext, event, this, this);
        this.mraidView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mraidView.setTestListener(this.mTestListener);
        this.removeAllViews();
        this.addView((View)this.mraidView);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onErrorEventReceived(ErrorEvent errorEvent) {
        if (errorEvent.Requester != this) {
            return;
        }
        if (this.mListener != null) {
            this.mListener.onAdFetchFailed(this, errorEvent.Error);
        }
    }

    private void fireNextAdRequestTask() {
        long elapsedTime = this.adInterval.getRefreshIntervalInSeconds();
        if (elapsedTime < 0L) {
            return;
        }
        Message msg = this.mRefreshHandler.obtainMessage(0);
        this.mRefreshHandler.sendMessageDelayed(msg, elapsedTime);
    }

    private void startRefreshThread() {
        this.mRefreshThread = new HandlerThread("RefreshThread");
        this.mRefreshThread.start();
        this.mRefreshHandler = new Handler(this.mRefreshThread.getLooper(), new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                if (msg.what == 0) {
                    BannerView.this.raiseAdRequest();
                    return true;
                }
                return false;
            }
        });
    }

    private void stopRefreshThread() {
        if (this.mRefreshHandler == null) {
            return;
        }
        this.mRefreshHandler.removeCallbacksAndMessages(null);
        this.mRefreshHandler = null;
        this.mRefreshThread.quitSafely();
    }

    @Override
    public void resume() {
        IAdViewBase.AdViewUtils.registerOnBus(this);
        if (this.mRefreshHandler != null && !this.mRefreshHandler.hasMessages(0)) {
            this.fireNextAdRequestTask();
        }
    }

    @Override
    public void destroy() {
        this.stopRefreshThread();
        if (this.mraidView != null) {
            this.removeView((View)this.mraidView);
            this.mraidView.removeAllViewFromParent();
            this.mraidView.destroy();
            this.mraidView = null;
        }
        this.mContext = null;
        Logger.logDebug(TAG, "BannerView " + this + " is destroyed");
    }

    @Override
    public void pause() {
        if (this.mRefreshHandler != null && this.mRefreshHandler.hasMessages(0)) {
            this.mRefreshHandler.removeMessages(0);
        }
        IAdViewBase.AdViewUtils.unregisterOnBus(this);
    }

    @Override
    public void mraidViewLoaded(MRAIDView mraidView) {
        Logger.logDebug(TAG, "Ad is loaded");
        if (this.mListener != null) {
            this.mListener.onAdLoaded(this);
        }
    }

    @Override
    public void mraidViewFailed(MRAIDView mraidView) {
        Logger.logError(TAG, "Fail to load ad");
        if (this.mListener != null) {
            this.mListener.onAdFetchFailed(this, ErrorCode.UNKNOWN);
        }
    }

    @Override
    public void mraidViewExpand(MRAIDView mraidView) {
        Logger.logDebug(TAG, "Ad is expanded");
        if (this.mListener != null) {
            this.mListener.onAdOpened(this);
        }
    }

    @Override
    public void mraidViewClose(MRAIDView mraidView) {
        Logger.logDebug(TAG, "Ad is closed");
        if (this.mListener != null) {
            this.mListener.onAdClosed(this);
        }
    }

    @Override
    public boolean mraidViewResize(MRAIDView mraidView, int width, int height, int offsetX, int offsetY) {
        Logger.logDebug(TAG, "Ad is resizing");
        return true;
    }

    @Override
    public void mraidNativeFeatureCallTel(String url) {
        MRAIDNativeFeatureProvider.callTel(this.mContext, url);
        if (this.mListener != null) {
            this.mListener.onAdLeftApplication(this);
        }
    }

    @Override
    public void mraidNativeFeatureCreateCalendarEvent(String eventJSON) {
        MRAIDNativeFeatureProvider.createCalendarEvent(this.mContext, eventJSON);
    }

    @Override
    public void mraidNativeFeaturePlayVideo(String url) {
        MRAIDNativeFeatureProvider.playVideo(this.mContext, url);
    }

    @Override
    public void mraidNativeFeatureOpenBrowser(String url) {
        Logger.logDebug(TAG, "Launching Landing page.");
        MRAIDNativeFeatureProvider.openBrowser(this.mContext, url);
        if (this.mListener != null) {
            this.mListener.onAdOpened(this);
        }
    }

    @Override
    public void mraidNativeFeatureStorePicture(String url) {
        MRAIDNativeFeatureProvider.storePicture(this.mContext, url);
    }

    @Override
    public void mraidNativeFeatureSendSms(String url) {
        MRAIDNativeFeatureProvider.sendSms(this.mContext, url);
        if (this.mListener != null) {
            this.mListener.onAdLeftApplication(this);
        }
    }
}

