/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.WindowManager;

public enum AdSize {
    BANNER(320, 50),
    NARROW_BANNER(300, 50),
    MEDIUM_RECTANGLE(300, 250),
    LEADER_BOARD(728, 90);

    int height;
    int width;

    private AdSize(int width, int height) {
        this.height = height;
        this.width = width;
    }

    public static AdSize createAdSizeFromAdMobAdSize(com.google.android.gms.ads.AdSize adSize) {
        if (com.google.android.gms.ads.AdSize.BANNER.equals((Object)adSize)) {
            return BANNER;
        }
        if (com.google.android.gms.ads.AdSize.MEDIUM_RECTANGLE.equals((Object)adSize)) {
            return MEDIUM_RECTANGLE;
        }
        if (com.google.android.gms.ads.AdSize.LEADERBOARD.equals((Object)adSize)) {
            return LEADER_BOARD;
        }
        throw new IllegalArgumentException("This ad size(" + adSize.toString() + ") is not supported by xAd display sdk, please contact xAd for more detail about ad size");
    }

    public int getWidthInPixels(Context context) {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(metrics);
        return (int)TypedValue.applyDimension((int)1, (float)this.width, (DisplayMetrics)metrics);
    }

    public int getHeightInPixels(Context context) {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(metrics);
        return (int)TypedValue.applyDimension((int)1, (float)this.height, (DisplayMetrics)metrics);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public String toString() {
        return this.width + "x" + this.height;
    }
}

