/*
 * Decompiled with CFR 0.152.
 */
package com.xad.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AdRequest {
    public static final Month JAN = new Month(0);
    public static final Month FEB = new Month(1);
    public static final Month MAR = new Month(2);
    public static final Month ARP = new Month(3);
    public static final Month MAY = new Month(4);
    public static final Month JUN = new Month(5);
    public static final Month JUL = new Month(6);
    public static final Month AUG = new Month(7);
    public static final Month SEP = new Month(8);
    public static final Month OCT = new Month(9);
    public static final Month NOV = new Month(10);
    public static final Month DEC = new Month(11);
    private Calendar birthday;
    private Gender gender;
    private String zipCode;
    private String city;
    private String state;
    private Map<String, String> extras;
    protected int vmin;
    protected int vmax;
    private boolean isTestMode;
    private TestType testType;
    private String testChannelId;

    public Gender getGender() {
        return this.gender;
    }

    public boolean isTesting() {
        return this.isTestMode;
    }

    public int getAge() {
        int mob = this.birthday.get(2);
        int dob = this.birthday.get(5);
        int yob = this.birthday.get(1);
        Calendar calToday = Calendar.getInstance();
        int todayYear = calToday.get(1);
        int todayMonth = calToday.get(2);
        int todayDay = calToday.get(5);
        int age = todayYear - yob;
        if (mob > todayMonth || mob == todayMonth && dob > todayDay) {
            --age;
        }
        return age;
    }

    public Calendar getBirthday() {
        return this.birthday;
    }

    @Nullable
    public String getZipCode() {
        return this.zipCode;
    }

    @Nullable
    public String getCity() {
        return this.city;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    @Nullable
    public Map<String, String> getExtras() {
        return this.extras == null ? null : Collections.unmodifiableMap(this.extras);
    }

    public int getVmin() {
        return this.vmin;
    }

    public int getVmax() {
        return this.vmax;
    }

    @NonNull
    TestType getTestType() {
        return this.testType;
    }

    @Nullable
    String getTestChannelId() {
        return this.testChannelId;
    }

    private AdRequest(Builder builder) {
        this.birthday = builder.birthday;
        this.gender = builder.gender;
        this.isTestMode = builder.isTestMode;
        this.zipCode = builder.zipCode;
        this.city = builder.city;
        this.state = builder.state;
        this.extras = builder.extras;
        this.vmin = builder.vmin;
        this.vmax = builder.vmax;
        this.testChannelId = builder.testChannelId;
        this.testType = builder.testType;
    }

    public static class Builder {
        private Calendar birthday = Calendar.getInstance();
        private Gender gender = Gender.UNKNOWN;
        private String zipCode;
        private String city;
        private String state;
        private Map<String, String> extras;
        private int vmin = -1;
        private int vmax = -1;
        private boolean isTestMode = false;
        private TestType testType = TestType.SANDBOX;
        private String testChannelId;

        public Builder setVideoDuration(int vmin, int vmax) {
            this.vmin = vmin;
            this.vmax = vmax;
            return this;
        }

        public Builder setTestMode(boolean useTesting) {
            this.isTestMode = useTesting;
            return this;
        }

        public Builder setTestType(TestType testType, String testChannelId) {
            this.testType = testType;
            this.testChannelId = testChannelId;
            return this;
        }

        @Deprecated
        public Builder setAge(int age) {
            Calendar calObj = Calendar.getInstance();
            calObj.set(1, calObj.get(1) - age);
            this.birthday = calObj;
            return this;
        }

        public Builder setGender(@NonNull Gender gender) {
            this.gender = gender;
            return this;
        }

        public Builder setBirthday(Calendar birthday) {
            this.birthday = birthday;
            return this;
        }

        public Builder setBirthday(int year, Month month, int day) {
            Calendar calObj = Calendar.getInstance();
            calObj.set(year, month.getMonthInteger(), day);
            this.birthday = calObj;
            return this;
        }

        public Builder setZipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public Builder setCity(String city) {
            this.city = city;
            return this;
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public Builder addExtras(String key, String value) {
            if (this.extras == null) {
                this.extras = new HashMap<String, String>();
            }
            this.extras.put(key, value);
            return this;
        }

        public AdRequest build() {
            return new AdRequest(this);
        }
    }

    private static final class Month {
        private final int monthInt;

        private Month(int m) {
            this.monthInt = m;
        }

        int getMonthInteger() {
            return this.monthInt;
        }
    }

    public static enum Gender {
        MALE("M"),
        FEMALE("F"),
        UNKNOWN("U");

        public String value;

        private Gender(String value) {
            this.value = value;
        }
    }

    public static enum TestType {
        SANDBOX("sandbox"),
        CHANNEL("channel");

        public String value;

        private TestType(String value) {
            this.value = value;
        }
    }
}

