/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.impl.xs;

import mf.org.apache.xerces.impl.xs.SchemaGrammar;
import mf.org.apache.xerces.impl.xs.XMLSchemaLoader;
import mf.org.apache.xerces.impl.xs.XSAnnotationImpl;
import mf.org.apache.xerces.impl.xs.XSAttributeDecl;
import mf.org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import mf.org.apache.xerces.impl.xs.XSElementDecl;
import mf.org.apache.xerces.impl.xs.XSGroupDecl;
import mf.org.apache.xerces.impl.xs.XSNotationDecl;
import mf.org.apache.xerces.impl.xs.util.XSGrammarPool;
import mf.org.apache.xerces.xni.grammars.Grammar;
import mf.org.apache.xerces.xni.grammars.XMLGrammarDescription;
import mf.org.apache.xerces.xni.grammars.XSGrammar;
import mf.org.apache.xerces.xni.parser.XMLInputSource;
import mf.org.apache.xerces.xs.LSInputList;
import mf.org.apache.xerces.xs.StringList;
import mf.org.apache.xerces.xs.XSLoader;
import mf.org.apache.xerces.xs.XSModel;
import mf.org.apache.xerces.xs.XSNamedMap;
import mf.org.apache.xerces.xs.XSObject;
import mf.org.apache.xerces.xs.XSObjectList;
import mf.org.apache.xerces.xs.XSTypeDefinition;
import mf.org.w3c.dom.DOMConfiguration;
import mf.org.w3c.dom.DOMException;
import mf.org.w3c.dom.DOMStringList;
import mf.org.w3c.dom.ls.LSInput;

public final class XSLoaderImpl
implements XSLoader,
DOMConfiguration {
    private final XSGrammarPool fGrammarPool = new XSGrammarMerger();
    private final XMLSchemaLoader fSchemaLoader = new XMLSchemaLoader();

    public XSLoaderImpl() {
        this.fSchemaLoader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", this.fGrammarPool);
    }

    @Override
    public DOMConfiguration getConfig() {
        return this;
    }

    @Override
    public XSModel loadURIList(StringList uriList) {
        int length = uriList.getLength();
        try {
            this.fGrammarPool.clear();
            int i = 0;
            while (i < length) {
                this.fSchemaLoader.loadGrammar(new XMLInputSource(null, uriList.item(i), null));
                ++i;
            }
            return this.fGrammarPool.toXSModel();
        }
        catch (Exception e) {
            this.fSchemaLoader.reportDOMFatalError(e);
            return null;
        }
    }

    @Override
    public XSModel loadInputList(LSInputList is) {
        int length = is.getLength();
        try {
            this.fGrammarPool.clear();
            int i = 0;
            while (i < length) {
                this.fSchemaLoader.loadGrammar(this.fSchemaLoader.dom2xmlInputSource(is.item(i)));
                ++i;
            }
            return this.fGrammarPool.toXSModel();
        }
        catch (Exception e) {
            this.fSchemaLoader.reportDOMFatalError(e);
            return null;
        }
    }

    @Override
    public XSModel loadURI(String uri) {
        try {
            this.fGrammarPool.clear();
            return ((XSGrammar)this.fSchemaLoader.loadGrammar(new XMLInputSource(null, uri, null))).toXSModel();
        }
        catch (Exception e) {
            this.fSchemaLoader.reportDOMFatalError(e);
            return null;
        }
    }

    @Override
    public XSModel load(LSInput is) {
        try {
            this.fGrammarPool.clear();
            return ((XSGrammar)this.fSchemaLoader.loadGrammar(this.fSchemaLoader.dom2xmlInputSource(is))).toXSModel();
        }
        catch (Exception e) {
            this.fSchemaLoader.reportDOMFatalError(e);
            return null;
        }
    }

    @Override
    public void setParameter(String name, Object value) throws DOMException {
        this.fSchemaLoader.setParameter(name, value);
    }

    @Override
    public Object getParameter(String name) throws DOMException {
        return this.fSchemaLoader.getParameter(name);
    }

    @Override
    public boolean canSetParameter(String name, Object value) {
        return this.fSchemaLoader.canSetParameter(name, value);
    }

    @Override
    public DOMStringList getParameterNames() {
        return this.fSchemaLoader.getParameterNames();
    }

    private static final class XSGrammarMerger
    extends XSGrammarPool {
        @Override
        public void putGrammar(Grammar grammar) {
            SchemaGrammar cachedGrammar = this.toSchemaGrammar(super.getGrammar(grammar.getGrammarDescription()));
            if (cachedGrammar != null) {
                SchemaGrammar newGrammar = this.toSchemaGrammar(grammar);
                if (newGrammar != null) {
                    this.mergeSchemaGrammars(cachedGrammar, newGrammar);
                }
            } else {
                super.putGrammar(grammar);
            }
        }

        private SchemaGrammar toSchemaGrammar(Grammar grammar) {
            return grammar instanceof SchemaGrammar ? (SchemaGrammar)grammar : null;
        }

        private void mergeSchemaGrammars(SchemaGrammar cachedGrammar, SchemaGrammar newGrammar) {
            XSObject decl;
            XSNamedMap map = newGrammar.getComponents((short)2);
            int length = map.getLength();
            int i = 0;
            while (i < length) {
                decl = (XSElementDecl)map.item(i);
                if (cachedGrammar.getGlobalElementDecl(((XSElementDecl)decl).getName()) == null) {
                    cachedGrammar.addGlobalElementDecl((XSElementDecl)decl);
                }
                ++i;
            }
            map = newGrammar.getComponents((short)1);
            length = map.getLength();
            i = 0;
            while (i < length) {
                decl = (XSAttributeDecl)map.item(i);
                if (cachedGrammar.getGlobalAttributeDecl(((XSAttributeDecl)decl).getName()) == null) {
                    cachedGrammar.addGlobalAttributeDecl((XSAttributeDecl)decl);
                }
                ++i;
            }
            map = newGrammar.getComponents((short)3);
            length = map.getLength();
            i = 0;
            while (i < length) {
                decl = (XSTypeDefinition)map.item(i);
                if (cachedGrammar.getGlobalTypeDecl(decl.getName()) == null) {
                    cachedGrammar.addGlobalTypeDecl((XSTypeDefinition)decl);
                }
                ++i;
            }
            map = newGrammar.getComponents((short)5);
            length = map.getLength();
            i = 0;
            while (i < length) {
                decl = (XSAttributeGroupDecl)map.item(i);
                if (cachedGrammar.getGlobalAttributeGroupDecl(((XSAttributeGroupDecl)decl).getName()) == null) {
                    cachedGrammar.addGlobalAttributeGroupDecl((XSAttributeGroupDecl)decl);
                }
                ++i;
            }
            map = newGrammar.getComponents((short)7);
            length = map.getLength();
            i = 0;
            while (i < length) {
                decl = (XSGroupDecl)map.item(i);
                if (cachedGrammar.getGlobalGroupDecl(((XSGroupDecl)decl).getName()) == null) {
                    cachedGrammar.addGlobalGroupDecl((XSGroupDecl)decl);
                }
                ++i;
            }
            map = newGrammar.getComponents((short)11);
            length = map.getLength();
            i = 0;
            while (i < length) {
                decl = (XSNotationDecl)map.item(i);
                if (cachedGrammar.getGlobalNotationDecl(((XSNotationDecl)decl).getName()) == null) {
                    cachedGrammar.addGlobalNotationDecl((XSNotationDecl)decl);
                }
                ++i;
            }
            XSObjectList annotations = newGrammar.getAnnotations();
            length = annotations.getLength();
            int i2 = 0;
            while (i2 < length) {
                cachedGrammar.addAnnotation((XSAnnotationImpl)annotations.item(i2));
                ++i2;
            }
        }

        @Override
        public boolean containsGrammar(XMLGrammarDescription desc) {
            return false;
        }

        @Override
        public Grammar getGrammar(XMLGrammarDescription desc) {
            return null;
        }

        @Override
        public Grammar retrieveGrammar(XMLGrammarDescription desc) {
            return null;
        }

        @Override
        public Grammar[] retrieveInitialGrammarSet(String grammarType) {
            return new Grammar[0];
        }
    }
}

