/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.impl.xs;

import mf.org.apache.xerces.impl.dv.ValidatedInfo;
import mf.org.apache.xerces.impl.xs.XSAttributeDecl;
import mf.org.apache.xerces.impl.xs.XSAttributeUseImpl;
import mf.org.apache.xerces.impl.xs.XSConstraints;
import mf.org.apache.xerces.impl.xs.XSWildcardDecl;
import mf.org.apache.xerces.impl.xs.util.XSObjectListImpl;
import mf.org.apache.xerces.xs.XSAnnotation;
import mf.org.apache.xerces.xs.XSAttributeGroupDefinition;
import mf.org.apache.xerces.xs.XSAttributeUse;
import mf.org.apache.xerces.xs.XSNamespaceItem;
import mf.org.apache.xerces.xs.XSObjectList;
import mf.org.apache.xerces.xs.XSWildcard;

public class XSAttributeGroupDecl
implements XSAttributeGroupDefinition {
    public String fName = null;
    public String fTargetNamespace = null;
    int fAttrUseNum = 0;
    private static final int INITIAL_SIZE = 5;
    XSAttributeUseImpl[] fAttributeUses = new XSAttributeUseImpl[5];
    public XSWildcardDecl fAttributeWC = null;
    public String fIDAttrName = null;
    public XSObjectList fAnnotations;
    protected XSObjectListImpl fAttrUses = null;
    private XSNamespaceItem fNamespaceItem = null;

    public String addAttributeUse(XSAttributeUseImpl attrUse) {
        if (attrUse.fUse != 2 && attrUse.fAttrDecl.fType.isIDType()) {
            if (this.fIDAttrName == null) {
                this.fIDAttrName = attrUse.fAttrDecl.fName;
            } else {
                return this.fIDAttrName;
            }
        }
        if (this.fAttrUseNum == this.fAttributeUses.length) {
            this.fAttributeUses = XSAttributeGroupDecl.resize(this.fAttributeUses, this.fAttrUseNum * 2);
        }
        this.fAttributeUses[this.fAttrUseNum++] = attrUse;
        return null;
    }

    public void replaceAttributeUse(XSAttributeUse oldUse, XSAttributeUseImpl newUse) {
        int i = 0;
        while (i < this.fAttrUseNum) {
            if (this.fAttributeUses[i] == oldUse) {
                this.fAttributeUses[i] = newUse;
            }
            ++i;
        }
    }

    public XSAttributeUse getAttributeUse(String namespace, String name) {
        int i = 0;
        while (i < this.fAttrUseNum) {
            if (this.fAttributeUses[i].fAttrDecl.fTargetNamespace == namespace && this.fAttributeUses[i].fAttrDecl.fName == name) {
                return this.fAttributeUses[i];
            }
            ++i;
        }
        return null;
    }

    public XSAttributeUse getAttributeUseNoProhibited(String namespace, String name) {
        int i = 0;
        while (i < this.fAttrUseNum) {
            if (this.fAttributeUses[i].fAttrDecl.fTargetNamespace == namespace && this.fAttributeUses[i].fAttrDecl.fName == name && this.fAttributeUses[i].fUse != 2) {
                return this.fAttributeUses[i];
            }
            ++i;
        }
        return null;
    }

    public void removeProhibitedAttrs() {
        if (this.fAttrUseNum == 0) {
            return;
        }
        int count = 0;
        XSAttributeUseImpl[] uses = new XSAttributeUseImpl[this.fAttrUseNum];
        int i = 0;
        while (i < this.fAttrUseNum) {
            if (this.fAttributeUses[i].fUse != 2) {
                uses[count++] = this.fAttributeUses[i];
            }
            ++i;
        }
        this.fAttributeUses = uses;
        this.fAttrUseNum = count;
    }

    public Object[] validRestrictionOf(String typeName, XSAttributeGroupDecl baseGroup) {
        Object[] errorArgs = null;
        XSAttributeUseImpl attrUse = null;
        XSAttributeDecl attrDecl = null;
        XSAttributeUseImpl baseAttrUse = null;
        XSAttributeDecl baseAttrDecl = null;
        int i = 0;
        while (i < this.fAttrUseNum) {
            attrUse = this.fAttributeUses[i];
            attrDecl = attrUse.fAttrDecl;
            baseAttrUse = (XSAttributeUseImpl)baseGroup.getAttributeUse(attrDecl.fTargetNamespace, attrDecl.fName);
            if (baseAttrUse != null) {
                if (baseAttrUse.getRequired() && !attrUse.getRequired()) {
                    errorArgs = new Object[]{typeName, attrDecl.fName, attrUse.fUse == 0 ? "optional" : "prohibited", "derivation-ok-restriction.2.1.1"};
                    return errorArgs;
                }
                if (attrUse.fUse != 2) {
                    short thisConstType;
                    baseAttrDecl = baseAttrUse.fAttrDecl;
                    if (!XSConstraints.checkSimpleDerivationOk(attrDecl.fType, baseAttrDecl.fType, baseAttrDecl.fType.getFinal())) {
                        errorArgs = new Object[]{typeName, attrDecl.fName, attrDecl.fType.getName(), baseAttrDecl.fType.getName(), "derivation-ok-restriction.2.1.2"};
                        return errorArgs;
                    }
                    short baseConsType = baseAttrUse.fConstraintType != 0 ? baseAttrUse.fConstraintType : baseAttrDecl.getConstraintType();
                    short s = thisConstType = attrUse.fConstraintType != 0 ? attrUse.fConstraintType : attrDecl.getConstraintType();
                    if (baseConsType == 2) {
                        ValidatedInfo thisFixedValue;
                        if (thisConstType != 2) {
                            errorArgs = new Object[]{typeName, attrDecl.fName, "derivation-ok-restriction.2.1.3.a"};
                            return errorArgs;
                        }
                        ValidatedInfo baseFixedValue = baseAttrUse.fDefault != null ? baseAttrUse.fDefault : baseAttrDecl.fDefault;
                        ValidatedInfo validatedInfo = thisFixedValue = attrUse.fDefault != null ? attrUse.fDefault : attrDecl.fDefault;
                        if (!baseFixedValue.actualValue.equals(thisFixedValue.actualValue)) {
                            errorArgs = new Object[]{typeName, attrDecl.fName, thisFixedValue.stringValue(), baseFixedValue.stringValue(), "derivation-ok-restriction.2.1.3.b"};
                            return errorArgs;
                        }
                    }
                }
            } else {
                if (baseGroup.fAttributeWC == null) {
                    errorArgs = new Object[]{typeName, attrDecl.fName, "derivation-ok-restriction.2.2.a"};
                    return errorArgs;
                }
                if (!baseGroup.fAttributeWC.allowNamespace(attrDecl.fTargetNamespace)) {
                    errorArgs = new Object[]{typeName, attrDecl.fName, attrDecl.fTargetNamespace == null ? "" : attrDecl.fTargetNamespace, "derivation-ok-restriction.2.2.b"};
                    return errorArgs;
                }
            }
            ++i;
        }
        i = 0;
        while (i < baseGroup.fAttrUseNum) {
            baseAttrUse = baseGroup.fAttributeUses[i];
            if (baseAttrUse.fUse == 1) {
                baseAttrDecl = baseAttrUse.fAttrDecl;
                if (this.getAttributeUse(baseAttrDecl.fTargetNamespace, baseAttrDecl.fName) == null) {
                    errorArgs = new Object[]{typeName, baseAttrUse.fAttrDecl.fName, "derivation-ok-restriction.3"};
                    return errorArgs;
                }
            }
            ++i;
        }
        if (this.fAttributeWC != null) {
            if (baseGroup.fAttributeWC == null) {
                errorArgs = new Object[]{typeName, "derivation-ok-restriction.4.1"};
                return errorArgs;
            }
            if (!this.fAttributeWC.isSubsetOf(baseGroup.fAttributeWC)) {
                errorArgs = new Object[]{typeName, "derivation-ok-restriction.4.2"};
                return errorArgs;
            }
            if (this.fAttributeWC.weakerProcessContents(baseGroup.fAttributeWC)) {
                errorArgs = new Object[]{typeName, this.fAttributeWC.getProcessContentsAsString(), baseGroup.fAttributeWC.getProcessContentsAsString(), "derivation-ok-restriction.4.3"};
                return errorArgs;
            }
        }
        return null;
    }

    static final XSAttributeUseImpl[] resize(XSAttributeUseImpl[] oldArray, int newSize) {
        XSAttributeUseImpl[] newArray = new XSAttributeUseImpl[newSize];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newSize));
        return newArray;
    }

    public void reset() {
        this.fName = null;
        this.fTargetNamespace = null;
        int i = 0;
        while (i < this.fAttrUseNum) {
            this.fAttributeUses[i] = null;
            ++i;
        }
        this.fAttrUseNum = 0;
        this.fAttributeWC = null;
        this.fAnnotations = null;
        this.fIDAttrName = null;
    }

    @Override
    public short getType() {
        return 5;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getNamespace() {
        return this.fTargetNamespace;
    }

    @Override
    public XSObjectList getAttributeUses() {
        if (this.fAttrUses == null) {
            this.fAttrUses = new XSObjectListImpl(this.fAttributeUses, this.fAttrUseNum);
        }
        return this.fAttrUses;
    }

    @Override
    public XSWildcard getAttributeWildcard() {
        return this.fAttributeWC;
    }

    @Override
    public XSAnnotation getAnnotation() {
        return this.fAnnotations != null ? (XSAnnotation)this.fAnnotations.item(0) : null;
    }

    @Override
    public XSObjectList getAnnotations() {
        return this.fAnnotations != null ? this.fAnnotations : XSObjectListImpl.EMPTY_LIST;
    }

    @Override
    public XSNamespaceItem getNamespaceItem() {
        return this.fNamespaceItem;
    }

    void setNamespaceItem(XSNamespaceItem namespaceItem) {
        this.fNamespaceItem = namespaceItem;
    }
}

