/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.dom;

import mf.org.apache.xerces.dom.DeferredDocumentImpl;
import mf.org.apache.xerces.dom.DeferredNode;
import mf.org.apache.xerces.dom.ElementDefinitionImpl;
import mf.org.apache.xerces.dom.NamedNodeMapImpl;

public class DeferredElementDefinitionImpl
extends ElementDefinitionImpl
implements DeferredNode {
    static final long serialVersionUID = 6703238199538041591L;
    protected transient int fNodeIndex;

    DeferredElementDefinitionImpl(DeferredDocumentImpl ownerDocument, int nodeIndex) {
        super(ownerDocument, null);
        this.fNodeIndex = nodeIndex;
        this.needsSyncData(true);
        this.needsSyncChildren(true);
    }

    @Override
    public int getNodeIndex() {
        return this.fNodeIndex;
    }

    @Override
    protected void synchronizeData() {
        this.needsSyncData(false);
        DeferredDocumentImpl ownerDocument = (DeferredDocumentImpl)this.ownerDocument;
        this.name = ownerDocument.getNodeName(this.fNodeIndex);
    }

    @Override
    protected void synchronizeChildren() {
        boolean orig = this.ownerDocument.getMutationEvents();
        this.ownerDocument.setMutationEvents(false);
        this.needsSyncChildren(false);
        DeferredDocumentImpl ownerDocument = (DeferredDocumentImpl)this.ownerDocument;
        this.attributes = new NamedNodeMapImpl(ownerDocument);
        int nodeIndex = ownerDocument.getLastChild(this.fNodeIndex);
        while (nodeIndex != -1) {
            DeferredNode attr = ownerDocument.getNodeObject(nodeIndex);
            this.attributes.setNamedItem(attr);
            nodeIndex = ownerDocument.getPrevSibling(nodeIndex);
        }
        ownerDocument.setMutationEvents(orig);
    }
}

