/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.dom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import mf.org.apache.xerces.dom.AttrImpl;
import mf.org.apache.xerces.dom.AttributeMap;
import mf.org.apache.xerces.dom.CoreDOMImplementationImpl;
import mf.org.apache.xerces.dom.CoreDocumentImpl;
import mf.org.apache.xerces.dom.DOMConfigurationImpl;
import mf.org.apache.xerces.dom.DOMErrorImpl;
import mf.org.apache.xerces.dom.DOMLocatorImpl;
import mf.org.apache.xerces.dom.DOMMessageFormatter;
import mf.org.apache.xerces.dom.ElementImpl;
import mf.org.apache.xerces.dom.ElementNSImpl;
import mf.org.apache.xerces.dom.EntityReferenceImpl;
import mf.org.apache.xerces.dom.PSVIAttrNSImpl;
import mf.org.apache.xerces.dom.PSVIElementNSImpl;
import mf.org.apache.xerces.dom.TextImpl;
import mf.org.apache.xerces.impl.Constants;
import mf.org.apache.xerces.impl.RevalidationHandler;
import mf.org.apache.xerces.impl.dtd.XMLDTDLoader;
import mf.org.apache.xerces.impl.dtd.XMLDTDValidator;
import mf.org.apache.xerces.impl.dv.XSSimpleType;
import mf.org.apache.xerces.impl.xs.util.SimpleLocator;
import mf.org.apache.xerces.util.AugmentationsImpl;
import mf.org.apache.xerces.util.NamespaceSupport;
import mf.org.apache.xerces.util.SymbolTable;
import mf.org.apache.xerces.util.XML11Char;
import mf.org.apache.xerces.util.XMLChar;
import mf.org.apache.xerces.util.XMLSymbols;
import mf.org.apache.xerces.xni.Augmentations;
import mf.org.apache.xerces.xni.NamespaceContext;
import mf.org.apache.xerces.xni.QName;
import mf.org.apache.xerces.xni.XMLAttributes;
import mf.org.apache.xerces.xni.XMLDocumentHandler;
import mf.org.apache.xerces.xni.XMLLocator;
import mf.org.apache.xerces.xni.XMLResourceIdentifier;
import mf.org.apache.xerces.xni.XMLString;
import mf.org.apache.xerces.xni.XNIException;
import mf.org.apache.xerces.xni.parser.XMLComponent;
import mf.org.apache.xerces.xni.parser.XMLDocumentSource;
import mf.org.apache.xerces.xs.AttributePSVI;
import mf.org.apache.xerces.xs.ElementPSVI;
import mf.org.apache.xerces.xs.XSTypeDefinition;
import mf.org.w3c.dom.Attr;
import mf.org.w3c.dom.CDATASection;
import mf.org.w3c.dom.Comment;
import mf.org.w3c.dom.DOMErrorHandler;
import mf.org.w3c.dom.Document;
import mf.org.w3c.dom.DocumentType;
import mf.org.w3c.dom.Element;
import mf.org.w3c.dom.Entity;
import mf.org.w3c.dom.NamedNodeMap;
import mf.org.w3c.dom.Node;
import mf.org.w3c.dom.NodeList;
import mf.org.w3c.dom.ProcessingInstruction;
import mf.org.w3c.dom.Text;

public class DOMNormalizer
implements XMLDocumentHandler {
    protected static final boolean DEBUG_ND = false;
    protected static final boolean DEBUG = false;
    protected static final boolean DEBUG_EVENTS = false;
    protected static final String PREFIX = "NS";
    protected DOMConfigurationImpl fConfiguration = null;
    protected CoreDocumentImpl fDocument = null;
    protected final XMLAttributesProxy fAttrProxy = new XMLAttributesProxy();
    protected final QName fQName = new QName();
    protected RevalidationHandler fValidationHandler;
    protected SymbolTable fSymbolTable;
    protected DOMErrorHandler fErrorHandler;
    private final DOMErrorImpl fError = new DOMErrorImpl();
    protected boolean fNamespaceValidation = false;
    protected boolean fPSVI = false;
    protected final NamespaceContext fNamespaceContext = new NamespaceSupport();
    protected final NamespaceContext fLocalNSBinder = new NamespaceSupport();
    protected final ArrayList fAttributeList = new ArrayList(5);
    protected final DOMLocatorImpl fLocator = new DOMLocatorImpl();
    protected Node fCurrentNode = null;
    private final QName fAttrQName = new QName();
    final XMLString fNormalizedValue = new XMLString(new char[16], 0, 0);
    public static final RuntimeException abort = new RuntimeException();
    public static final XMLString EMPTY_STRING = new XMLString();
    private boolean fAllWhitespace = false;

    protected void normalizeDocument(CoreDocumentImpl document, DOMConfigurationImpl config) {
        this.fDocument = document;
        this.fConfiguration = config;
        this.fAllWhitespace = false;
        this.fNamespaceValidation = false;
        String xmlVersion = this.fDocument.getXmlVersion();
        String schemaType = null;
        String[] schemaLocations = null;
        this.fSymbolTable = (SymbolTable)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/symbol-table");
        this.fNamespaceContext.reset();
        this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, null);
        if ((this.fConfiguration.features & 0x40) != 0) {
            String schemaLang = (String)this.fConfiguration.getProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
            if (schemaLang != null && schemaLang.equals(Constants.NS_XMLSCHEMA)) {
                schemaType = "http://www.w3.org/2001/XMLSchema";
                this.fValidationHandler = CoreDOMImplementationImpl.singleton.getValidator(schemaType, xmlVersion);
                this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema", true);
                this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                this.fNamespaceValidation = true;
                this.fPSVI = (this.fConfiguration.features & 0x80) != 0;
            } else {
                schemaType = "http://www.w3.org/TR/REC-xml";
                if (schemaLang != null) {
                    schemaLocations = (String[])this.fConfiguration.getProperty("http://java.sun.com/xml/jaxp/properties/schemaSource");
                }
                this.fConfiguration.setDTDValidatorFactory(xmlVersion);
                this.fValidationHandler = CoreDOMImplementationImpl.singleton.getValidator(schemaType, xmlVersion);
                this.fPSVI = false;
            }
            this.fConfiguration.setFeature("http://xml.org/sax/features/validation", true);
            this.fDocument.clearIdentifiers();
            if (this.fValidationHandler != null) {
                ((XMLComponent)((Object)this.fValidationHandler)).reset(this.fConfiguration);
            }
        } else {
            this.fValidationHandler = null;
        }
        this.fErrorHandler = (DOMErrorHandler)this.fConfiguration.getParameter("error-handler");
        if (this.fValidationHandler != null) {
            this.fValidationHandler.setDocumentHandler(this);
            this.fValidationHandler.startDocument(new SimpleLocator(this.fDocument.fDocumentURI, this.fDocument.fDocumentURI, -1, -1), this.fDocument.encoding, this.fNamespaceContext, null);
            this.fValidationHandler.xmlDecl(this.fDocument.getXmlVersion(), this.fDocument.getXmlEncoding(), this.fDocument.getXmlStandalone() ? "yes" : "no", null);
        }
        try {
            if (schemaType == "http://www.w3.org/TR/REC-xml") {
                this.processDTD(xmlVersion, schemaLocations != null ? schemaLocations[0] : null);
            }
            Node kid = this.fDocument.getFirstChild();
            while (kid != null) {
                Node next = kid.getNextSibling();
                if ((kid = this.normalizeNode(kid)) != null) {
                    next = kid;
                }
                kid = next;
            }
            if (this.fValidationHandler != null) {
                this.fValidationHandler.endDocument(null);
                this.fValidationHandler.setDocumentHandler(null);
                CoreDOMImplementationImpl.singleton.releaseValidator(schemaType, xmlVersion, this.fValidationHandler);
                this.fValidationHandler = null;
            }
        }
        catch (RuntimeException e) {
            if (this.fValidationHandler != null) {
                this.fValidationHandler.setDocumentHandler(null);
                CoreDOMImplementationImpl.singleton.releaseValidator(schemaType, xmlVersion, this.fValidationHandler);
                this.fValidationHandler = null;
            }
            if (e == abort) {
                return;
            }
            throw e;
        }
    }

    protected Node normalizeNode(Node node) {
        short type = node.getNodeType();
        this.fLocator.fRelatedNode = node;
        switch (type) {
            case 10: {
                break;
            }
            case 1: {
                int i;
                AttributeMap attributes;
                boolean wellformed;
                if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0 && this.fDocument.isXMLVersionChanged() && !(wellformed = this.fNamespaceValidation ? CoreDocumentImpl.isValidQName(node.getPrefix(), node.getLocalName(), this.fDocument.isXML11Version()) : CoreDocumentImpl.isXMLName(node.getNodeName(), this.fDocument.isXML11Version()))) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Element", node.getNodeName()});
                    DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)2, "wf-invalid-character-in-node-name");
                }
                this.fNamespaceContext.pushContext();
                this.fLocalNSBinder.reset();
                ElementImpl elem = (ElementImpl)node;
                if (elem.needsSyncChildren()) {
                    elem.synchronizeChildren();
                }
                AttributeMap attributeMap = attributes = elem.hasAttributes() ? (AttributeMap)elem.getAttributes() : null;
                if ((this.fConfiguration.features & 1) != 0) {
                    this.namespaceFixUp(elem, attributes);
                    if ((this.fConfiguration.features & 0x200) == 0 && attributes != null) {
                        i = 0;
                        while (i < attributes.getLength()) {
                            Attr att = (Attr)attributes.getItem(i);
                            if (XMLSymbols.PREFIX_XMLNS.equals(att.getPrefix()) || XMLSymbols.PREFIX_XMLNS.equals(att.getName())) {
                                elem.removeAttributeNode(att);
                                --i;
                            }
                            ++i;
                        }
                    }
                } else if (attributes != null) {
                    i = 0;
                    while (i < attributes.getLength()) {
                        Attr attr = (Attr)attributes.item(i);
                        attr.normalize();
                        if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0) {
                            DOMNormalizer.isAttrValueWF(this.fErrorHandler, this.fError, this.fLocator, attributes, attr, attr.getValue(), this.fDocument.isXML11Version());
                            if (this.fDocument.isXMLVersionChanged() && !(wellformed = this.fNamespaceValidation ? CoreDocumentImpl.isValidQName(node.getPrefix(), node.getLocalName(), this.fDocument.isXML11Version()) : CoreDocumentImpl.isXMLName(node.getNodeName(), this.fDocument.isXML11Version()))) {
                                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Attr", node.getNodeName()});
                                DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)2, "wf-invalid-character-in-node-name");
                            }
                        }
                        ++i;
                    }
                }
                if (this.fValidationHandler != null) {
                    this.fAttrProxy.setAttributes(attributes, this.fDocument, elem);
                    this.updateQName(elem, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.startElement(this.fQName, this.fAttrProxy, null);
                }
                Node kid = elem.getFirstChild();
                while (kid != null) {
                    Node next = kid.getNextSibling();
                    if ((kid = this.normalizeNode(kid)) != null) {
                        next = kid;
                    }
                    kid = next;
                }
                if (this.fValidationHandler != null) {
                    this.updateQName(elem, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.endElement(this.fQName, null);
                }
                this.fNamespaceContext.popContext();
                break;
            }
            case 8: {
                if ((this.fConfiguration.features & 0x20) == 0) {
                    Node nextSibling;
                    Node prevSibling = node.getPreviousSibling();
                    Node parent = node.getParentNode();
                    parent.removeChild(node);
                    if (prevSibling == null || prevSibling.getNodeType() != 3 || (nextSibling = prevSibling.getNextSibling()) == null || nextSibling.getNodeType() != 3) break;
                    ((TextImpl)nextSibling).insertData(0, prevSibling.getNodeValue());
                    parent.removeChild(prevSibling);
                    return nextSibling;
                }
                if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0) {
                    String commentdata = ((Comment)node).getData();
                    DOMNormalizer.isCommentWF(this.fErrorHandler, this.fError, this.fLocator, commentdata, this.fDocument.isXML11Version());
                }
                if (this.fValidationHandler == null) break;
                this.fValidationHandler.comment(EMPTY_STRING, null);
                break;
            }
            case 5: {
                if ((this.fConfiguration.features & 4) == 0) {
                    Node next;
                    Node prevSibling = node.getPreviousSibling();
                    Node parent = node.getParentNode();
                    ((EntityReferenceImpl)node).setReadOnly(false, true);
                    this.expandEntityRef(parent, node);
                    parent.removeChild(node);
                    Node node2 = next = prevSibling != null ? prevSibling.getNextSibling() : parent.getFirstChild();
                    if (prevSibling != null && next != null && prevSibling.getNodeType() == 3 && next.getNodeType() == 3) {
                        return prevSibling;
                    }
                    return next;
                }
                if (!this.fDocument.errorChecking || (this.fConfiguration.features & 0x100) == 0 || !this.fDocument.isXMLVersionChanged()) break;
                CoreDocumentImpl.isXMLName(node.getNodeName(), this.fDocument.isXML11Version());
                break;
            }
            case 4: {
                if ((this.fConfiguration.features & 8) == 0) {
                    Node prevSibling = node.getPreviousSibling();
                    if (prevSibling != null && prevSibling.getNodeType() == 3) {
                        ((Text)prevSibling).appendData(node.getNodeValue());
                        node.getParentNode().removeChild(node);
                        return prevSibling;
                    }
                    Text text = this.fDocument.createTextNode(node.getNodeValue());
                    Node parent = node.getParentNode();
                    node = parent.replaceChild(text, node);
                    return text;
                }
                if (this.fValidationHandler != null) {
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.startCDATA(null);
                    this.fValidationHandler.characterData(node.getNodeValue(), null);
                    this.fValidationHandler.endCDATA(null);
                }
                String value = node.getNodeValue();
                if ((this.fConfiguration.features & 0x10) != 0) {
                    int index;
                    Node parent = node.getParentNode();
                    if (this.fDocument.errorChecking) {
                        DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, node.getNodeValue(), this.fDocument.isXML11Version());
                    }
                    while ((index = value.indexOf("]]>")) >= 0) {
                        node.setNodeValue(value.substring(0, index + 2));
                        value = value.substring(index + 2);
                        Node firstSplitNode = node;
                        CDATASection newChild = this.fDocument.createCDATASection(value);
                        parent.insertBefore(newChild, node.getNextSibling());
                        node = newChild;
                        this.fLocator.fRelatedNode = firstSplitNode;
                        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "cdata-sections-splitted", null);
                        DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)1, "cdata-sections-splitted");
                    }
                    break;
                }
                if (!this.fDocument.errorChecking) break;
                DOMNormalizer.isCDataWF(this.fErrorHandler, this.fError, this.fLocator, value, this.fDocument.isXML11Version());
                break;
            }
            case 3: {
                int nextType;
                Node next = node.getNextSibling();
                if (next != null && next.getNodeType() == 3) {
                    ((Text)node).appendData(next.getNodeValue());
                    node.getParentNode().removeChild(next);
                    return node;
                }
                if (node.getNodeValue().length() == 0) {
                    node.getParentNode().removeChild(node);
                    break;
                }
                int n = nextType = next != null ? (int)next.getNodeType() : -1;
                if (nextType != -1 && ((this.fConfiguration.features & 4) == 0 && nextType == 6 || (this.fConfiguration.features & 0x20) == 0 && nextType == 8 || (this.fConfiguration.features & 8) == 0 && nextType == 4)) break;
                if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0) {
                    DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, node.getNodeValue(), this.fDocument.isXML11Version());
                }
                if (this.fValidationHandler == null) break;
                this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                this.fCurrentNode = node;
                this.fValidationHandler.characterData(node.getNodeValue(), null);
                if (this.fNamespaceValidation) break;
                if (this.fAllWhitespace) {
                    this.fAllWhitespace = false;
                    ((TextImpl)node).setIgnorableWhitespace(true);
                    break;
                }
                ((TextImpl)node).setIgnorableWhitespace(false);
                break;
            }
            case 7: {
                if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0) {
                    ProcessingInstruction pinode = (ProcessingInstruction)node;
                    String target = pinode.getTarget();
                    boolean wellformed = this.fDocument.isXML11Version() ? XML11Char.isXML11ValidName(target) : XMLChar.isValidName(target);
                    if (!wellformed) {
                        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Element", node.getNodeName()});
                        DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)2, "wf-invalid-character-in-node-name");
                    }
                    DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, pinode.getData(), this.fDocument.isXML11Version());
                }
                if (this.fValidationHandler == null) break;
                this.fValidationHandler.processingInstruction(((ProcessingInstruction)node).getTarget(), EMPTY_STRING, null);
            }
        }
        return null;
    }

    private void processDTD(String xmlVersion, String schemaLocation) {
        block13: {
            String rootName = null;
            String publicId = null;
            String systemId = schemaLocation;
            String baseSystemId = this.fDocument.getDocumentURI();
            String internalSubset = null;
            DocumentType docType = this.fDocument.getDoctype();
            if (docType != null) {
                rootName = docType.getName();
                publicId = docType.getPublicId();
                if (systemId == null || systemId.length() == 0) {
                    systemId = docType.getSystemId();
                }
                internalSubset = docType.getInternalSubset();
            } else {
                Element elem = this.fDocument.getDocumentElement();
                if (elem == null) {
                    return;
                }
                rootName = elem.getNodeName();
                if (systemId == null || systemId.length() == 0) {
                    return;
                }
            }
            XMLDTDLoader loader = null;
            try {
                try {
                    this.fValidationHandler.doctypeDecl(rootName, publicId, systemId, null);
                    loader = CoreDOMImplementationImpl.singleton.getDTDLoader(xmlVersion);
                    loader.setFeature("http://xml.org/sax/features/validation", true);
                    loader.setEntityResolver(this.fConfiguration.getEntityResolver());
                    loader.setErrorHandler(this.fConfiguration.getErrorHandler());
                    loader.loadGrammarWithContext((XMLDTDValidator)this.fValidationHandler, rootName, publicId, systemId, baseSystemId, internalSubset);
                }
                catch (IOException iOException) {
                    if (loader != null) {
                        CoreDOMImplementationImpl.singleton.releaseDTDLoader(xmlVersion, loader);
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (loader != null) {
                    CoreDOMImplementationImpl.singleton.releaseDTDLoader(xmlVersion, loader);
                }
                throw throwable;
            }
            if (loader != null) {
                CoreDOMImplementationImpl.singleton.releaseDTDLoader(xmlVersion, loader);
            }
        }
    }

    protected final void expandEntityRef(Node parent, Node reference) {
        Node kid = reference.getFirstChild();
        while (kid != null) {
            Node next = kid.getNextSibling();
            parent.insertBefore(kid, reference);
            kid = next;
        }
    }

    protected final void namespaceFixUp(ElementImpl element, AttributeMap attributes) {
        String prefix;
        String value;
        String uri;
        Attr attr;
        if (attributes != null) {
            int k = 0;
            while (k < attributes.getLength()) {
                attr = (Attr)attributes.getItem(k);
                uri = attr.getNamespaceURI();
                if (uri != null && uri.equals(NamespaceContext.XMLNS_URI)) {
                    value = attr.getNodeValue();
                    if (value == null) {
                        value = XMLSymbols.EMPTY_STRING;
                    }
                    if (this.fDocument.errorChecking && value.equals(NamespaceContext.XMLNS_URI)) {
                        this.fLocator.fRelatedNode = attr;
                        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "CantBindXMLNS", null);
                        DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)2, "CantBindXMLNS");
                    } else {
                        prefix = attr.getPrefix();
                        prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
                        String localpart = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (prefix == XMLSymbols.PREFIX_XMLNS) {
                            if ((value = this.fSymbolTable.addSymbol(value)).length() != 0) {
                                this.fNamespaceContext.declarePrefix(localpart, value);
                            }
                        } else {
                            this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, (value = this.fSymbolTable.addSymbol(value)).length() != 0 ? value : null);
                        }
                    }
                }
                ++k;
            }
        }
        uri = element.getNamespaceURI();
        prefix = element.getPrefix();
        if (uri != null) {
            uri = this.fSymbolTable.addSymbol(uri);
            String string = prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
            if (this.fNamespaceContext.getURI(prefix) != uri) {
                this.addNamespaceDecl(prefix, uri, element);
                this.fLocalNSBinder.declarePrefix(prefix, uri);
                this.fNamespaceContext.declarePrefix(prefix, uri);
            }
        } else if (element.getLocalName() == null) {
            if (this.fNamespaceValidation) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalElementName", new Object[]{element.getNodeName()});
                DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)3, "NullLocalElementName");
            } else {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalElementName", new Object[]{element.getNodeName()});
                DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)2, "NullLocalElementName");
            }
        } else {
            uri = this.fNamespaceContext.getURI(XMLSymbols.EMPTY_STRING);
            if (uri != null && uri.length() > 0) {
                this.addNamespaceDecl(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING, element);
                this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, null);
                this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, null);
            }
        }
        if (attributes != null) {
            attributes.cloneMap(this.fAttributeList);
            int i = 0;
            while (i < this.fAttributeList.size()) {
                attr = (Attr)this.fAttributeList.get(i);
                this.fLocator.fRelatedNode = attr;
                attr.normalize();
                value = attr.getValue();
                uri = attr.getNamespaceURI();
                if (value == null) {
                    value = XMLSymbols.EMPTY_STRING;
                }
                if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0) {
                    boolean wellformed;
                    DOMNormalizer.isAttrValueWF(this.fErrorHandler, this.fError, this.fLocator, attributes, attr, value, this.fDocument.isXML11Version());
                    if (this.fDocument.isXMLVersionChanged() && !(wellformed = this.fNamespaceValidation ? CoreDocumentImpl.isValidQName(attr.getPrefix(), attr.getLocalName(), this.fDocument.isXML11Version()) : CoreDocumentImpl.isXMLName(attr.getNodeName(), this.fDocument.isXML11Version()))) {
                        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Attr", attr.getNodeName()});
                        DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)2, "wf-invalid-character-in-node-name");
                    }
                }
                if (uri != null) {
                    prefix = attr.getPrefix();
                    prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
                    this.fSymbolTable.addSymbol(attr.getLocalName());
                    if (uri == null || !uri.equals(NamespaceContext.XMLNS_URI)) {
                        ((AttrImpl)attr).setIdAttribute(false);
                        uri = this.fSymbolTable.addSymbol(uri);
                        String declaredURI = this.fNamespaceContext.getURI(prefix);
                        if (prefix == XMLSymbols.EMPTY_STRING || declaredURI != uri) {
                            String declaredPrefix = this.fNamespaceContext.getPrefix(uri);
                            if (declaredPrefix != null && declaredPrefix != XMLSymbols.EMPTY_STRING) {
                                prefix = declaredPrefix;
                            } else {
                                if (prefix == XMLSymbols.EMPTY_STRING || this.fLocalNSBinder.getURI(prefix) != null) {
                                    int counter = 1;
                                    prefix = this.fSymbolTable.addSymbol(PREFIX + counter++);
                                    while (this.fLocalNSBinder.getURI(prefix) != null) {
                                        prefix = this.fSymbolTable.addSymbol(PREFIX + counter++);
                                    }
                                }
                                this.addNamespaceDecl(prefix, uri, element);
                                value = this.fSymbolTable.addSymbol(value);
                                this.fLocalNSBinder.declarePrefix(prefix, value);
                                this.fNamespaceContext.declarePrefix(prefix, uri);
                            }
                            attr.setPrefix(prefix);
                        }
                    }
                } else {
                    ((AttrImpl)attr).setIdAttribute(false);
                    if (attr.getLocalName() == null) {
                        if (this.fNamespaceValidation) {
                            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalAttrName", new Object[]{attr.getNodeName()});
                            DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)3, "NullLocalAttrName");
                        } else {
                            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalAttrName", new Object[]{attr.getNodeName()});
                            DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)2, "NullLocalAttrName");
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected final void addNamespaceDecl(String prefix, String uri, ElementImpl element) {
        if (prefix == XMLSymbols.EMPTY_STRING) {
            element.setAttributeNS(NamespaceContext.XMLNS_URI, XMLSymbols.PREFIX_XMLNS, uri);
        } else {
            element.setAttributeNS(NamespaceContext.XMLNS_URI, "xmlns:" + prefix, uri);
        }
    }

    public static final void isCDataWF(DOMErrorHandler errorHandler, DOMErrorImpl error, DOMLocatorImpl locator, String datavalue, boolean isXML11Version) {
        if (datavalue == null || datavalue.length() == 0) {
            return;
        }
        char[] dataarray = datavalue.toCharArray();
        int datalength = dataarray.length;
        if (isXML11Version) {
            int i = 0;
            while (i < datalength) {
                int count;
                char c;
                if (XML11Char.isXML11Invalid(c = dataarray[i++])) {
                    char c2;
                    if (XMLChar.isHighSurrogate(c) && i < datalength && XMLChar.isLowSurrogate(c2 = dataarray[i++]) && XMLChar.isSupplemental(XMLChar.supplemental(c, c2))) continue;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInCDSect", new Object[]{Integer.toString(c, 16)});
                    DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
                    continue;
                }
                if (c != ']' || (count = i) >= datalength || dataarray[count] != ']') continue;
                while (++count < datalength && dataarray[count] == ']') {
                }
                if (count >= datalength || dataarray[count] != '>') continue;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "CDEndInContent", null);
                DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
            }
        } else {
            int i = 0;
            while (i < datalength) {
                int count;
                char c;
                if (XMLChar.isInvalid(c = dataarray[i++])) {
                    char c2;
                    if (XMLChar.isHighSurrogate(c) && i < datalength && XMLChar.isLowSurrogate(c2 = dataarray[i++]) && XMLChar.isSupplemental(XMLChar.supplemental(c, c2))) continue;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInCDSect", new Object[]{Integer.toString(c, 16)});
                    DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
                    continue;
                }
                if (c != ']' || (count = i) >= datalength || dataarray[count] != ']') continue;
                while (++count < datalength && dataarray[count] == ']') {
                }
                if (count >= datalength || dataarray[count] != '>') continue;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "CDEndInContent", null);
                DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
            }
        }
    }

    public static final void isXMLCharWF(DOMErrorHandler errorHandler, DOMErrorImpl error, DOMLocatorImpl locator, String datavalue, boolean isXML11Version) {
        if (datavalue == null || datavalue.length() == 0) {
            return;
        }
        char[] dataarray = datavalue.toCharArray();
        int datalength = dataarray.length;
        if (isXML11Version) {
            int i = 0;
            while (i < datalength) {
                char ch2;
                char ch;
                if (!XML11Char.isXML11Invalid(dataarray[i++]) || XMLChar.isHighSurrogate(ch = dataarray[i - 1]) && i < datalength && XMLChar.isLowSurrogate(ch2 = dataarray[i++]) && XMLChar.isSupplemental(XMLChar.supplemental(ch, ch2))) continue;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "InvalidXMLCharInDOM", new Object[]{Integer.toString(dataarray[i - 1], 16)});
                DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
            }
        } else {
            int i = 0;
            while (i < datalength) {
                char ch2;
                char ch;
                if (!XMLChar.isInvalid(dataarray[i++]) || XMLChar.isHighSurrogate(ch = dataarray[i - 1]) && i < datalength && XMLChar.isLowSurrogate(ch2 = dataarray[i++]) && XMLChar.isSupplemental(XMLChar.supplemental(ch, ch2))) continue;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "InvalidXMLCharInDOM", new Object[]{Integer.toString(dataarray[i - 1], 16)});
                DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
            }
        }
    }

    public static final void isCommentWF(DOMErrorHandler errorHandler, DOMErrorImpl error, DOMLocatorImpl locator, String datavalue, boolean isXML11Version) {
        if (datavalue == null || datavalue.length() == 0) {
            return;
        }
        char[] dataarray = datavalue.toCharArray();
        int datalength = dataarray.length;
        if (isXML11Version) {
            int i = 0;
            while (i < datalength) {
                char c;
                if (XML11Char.isXML11Invalid(c = dataarray[i++])) {
                    char c2;
                    if (XMLChar.isHighSurrogate(c) && i < datalength && XMLChar.isLowSurrogate(c2 = dataarray[i++]) && XMLChar.isSupplemental(XMLChar.supplemental(c, c2))) continue;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInComment", new Object[]{Integer.toString(dataarray[i - 1], 16)});
                    DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
                    continue;
                }
                if (c != '-' || i >= datalength || dataarray[i] != '-') continue;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "DashDashInComment", null);
                DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
            }
        } else {
            int i = 0;
            while (i < datalength) {
                char c;
                if (XMLChar.isInvalid(c = dataarray[i++])) {
                    char c2;
                    if (XMLChar.isHighSurrogate(c) && i < datalength && XMLChar.isLowSurrogate(c2 = dataarray[i++]) && XMLChar.isSupplemental(XMLChar.supplemental(c, c2))) continue;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInComment", new Object[]{Integer.toString(dataarray[i - 1], 16)});
                    DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
                    continue;
                }
                if (c != '-' || i >= datalength || dataarray[i] != '-') continue;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "DashDashInComment", null);
                DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
            }
        }
    }

    public static final void isAttrValueWF(DOMErrorHandler errorHandler, DOMErrorImpl error, DOMLocatorImpl locator, NamedNodeMap attributes, Attr a, String value, boolean xml11Version) {
        if (a instanceof AttrImpl && ((AttrImpl)a).hasStringValue()) {
            DOMNormalizer.isXMLCharWF(errorHandler, error, locator, value, xml11Version);
        } else {
            NodeList children = a.getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                Node child = children.item(j);
                if (child.getNodeType() == 5) {
                    DocumentType docType;
                    Document owner = a.getOwnerDocument();
                    Entity ent = null;
                    if (owner != null && (docType = owner.getDoctype()) != null) {
                        NamedNodeMap entities = docType.getEntities();
                        ent = (Entity)entities.getNamedItemNS("*", child.getNodeName());
                    }
                    if (ent == null) {
                        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "UndeclaredEntRefInAttrValue", new Object[]{a.getNodeName()});
                        DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "UndeclaredEntRefInAttrValue");
                    }
                } else {
                    DOMNormalizer.isXMLCharWF(errorHandler, error, locator, child.getNodeValue(), xml11Version);
                }
                ++j;
            }
        }
    }

    public static final void reportDOMError(DOMErrorHandler errorHandler, DOMErrorImpl error, DOMLocatorImpl locator, String message, short severity, String type) {
        if (errorHandler != null) {
            error.reset();
            error.fMessage = message;
            error.fSeverity = severity;
            error.fLocator = locator;
            error.fType = type;
            error.fRelatedData = locator.fRelatedNode;
            if (!errorHandler.handleError(error)) {
                throw abort;
            }
        }
        if (severity == 3) {
            throw abort;
        }
    }

    protected final void updateQName(Node node, QName qname) {
        String prefix = node.getPrefix();
        String namespace = node.getNamespaceURI();
        String localName = node.getLocalName();
        qname.prefix = prefix != null && prefix.length() != 0 ? this.fSymbolTable.addSymbol(prefix) : null;
        qname.localpart = localName != null ? this.fSymbolTable.addSymbol(localName) : null;
        qname.rawname = this.fSymbolTable.addSymbol(node.getNodeName());
        qname.uri = namespace != null ? this.fSymbolTable.addSymbol(namespace) : null;
    }

    final String normalizeAttributeValue(String value, Attr attr) {
        if (!attr.getSpecified()) {
            return value;
        }
        int end = value.length();
        if (this.fNormalizedValue.ch.length < end) {
            this.fNormalizedValue.ch = new char[end];
        }
        this.fNormalizedValue.length = 0;
        boolean normalized = false;
        int i = 0;
        while (i < end) {
            char c = value.charAt(i);
            if (c == '\t' || c == '\n') {
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = 32;
                normalized = true;
            } else if (c == '\r') {
                normalized = true;
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = 32;
                int next = i + 1;
                if (next < end && value.charAt(next) == '\n') {
                    i = next;
                }
            } else {
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = c;
            }
            ++i;
        }
        if (normalized) {
            value = this.fNormalizedValue.toString();
            attr.setValue(value);
        }
        return value;
    }

    @Override
    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
    }

    @Override
    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
    }

    @Override
    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
    }

    @Override
    public void comment(XMLString text, Augmentations augs) throws XNIException {
    }

    @Override
    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
    }

    @Override
    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        Element currentElement = (Element)this.fCurrentNode;
        int attrCount = attributes.getLength();
        int i = 0;
        while (i < attrCount) {
            AttributePSVI attrPSVI;
            attributes.getName(i, this.fAttrQName);
            Attr attr = null;
            attr = currentElement.getAttributeNodeNS(this.fAttrQName.uri, this.fAttrQName.localpart);
            if (attr == null) {
                attr = currentElement.getAttributeNode(this.fAttrQName.rawname);
            }
            if ((attrPSVI = (AttributePSVI)attributes.getAugmentations(i).getItem("ATTRIBUTE_PSVI")) != null) {
                String normalizedValue;
                XSTypeDefinition decl = attrPSVI.getMemberTypeDefinition();
                boolean id = false;
                if (decl != null) {
                    id = ((XSSimpleType)decl).isIDType();
                } else {
                    decl = attrPSVI.getTypeDefinition();
                    if (decl != null) {
                        id = ((XSSimpleType)decl).isIDType();
                    }
                }
                if (id) {
                    ((ElementImpl)currentElement).setIdAttributeNode(attr, true);
                }
                if (this.fPSVI) {
                    ((PSVIAttrNSImpl)attr).setPSVI(attrPSVI);
                }
                ((AttrImpl)attr).setType(decl);
                if ((this.fConfiguration.features & 2) != 0 && (normalizedValue = attrPSVI.getSchemaNormalizedValue()) != null) {
                    boolean specified = attr.getSpecified();
                    attr.setValue(normalizedValue);
                    if (!specified) {
                        ((AttrImpl)attr).setSpecified(specified);
                    }
                }
            } else {
                String type = null;
                boolean isDeclared = Boolean.TRUE.equals(attributes.getAugmentations(i).getItem("ATTRIBUTE_DECLARED"));
                if (isDeclared && "ID".equals(type = attributes.getType(i))) {
                    ((ElementImpl)currentElement).setIdAttributeNode(attr, true);
                }
                ((AttrImpl)attr).setType(type);
            }
            ++i;
        }
    }

    @Override
    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.startElement(element, attributes, augs);
        this.endElement(element, augs);
    }

    @Override
    public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
    }

    @Override
    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
    }

    @Override
    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
    }

    @Override
    public void characters(XMLString text, Augmentations augs) throws XNIException {
    }

    @Override
    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        this.fAllWhitespace = true;
    }

    @Override
    public void endElement(QName element, Augmentations augs) throws XNIException {
        ElementPSVI elementPSVI;
        if (augs != null && (elementPSVI = (ElementPSVI)augs.getItem("ELEMENT_PSVI")) != null) {
            ElementImpl elementNode = (ElementImpl)this.fCurrentNode;
            if (this.fPSVI) {
                ((PSVIElementNSImpl)this.fCurrentNode).setPSVI(elementPSVI);
            }
            if (elementNode instanceof ElementNSImpl) {
                XSTypeDefinition type = elementPSVI.getMemberTypeDefinition();
                if (type == null) {
                    type = elementPSVI.getTypeDefinition();
                }
                ((ElementNSImpl)elementNode).setType(type);
            }
            String normalizedValue = elementPSVI.getSchemaNormalizedValue();
            if ((this.fConfiguration.features & 2) != 0) {
                if (normalizedValue != null) {
                    elementNode.setTextContent(normalizedValue);
                }
            } else {
                String text = elementNode.getTextContent();
                if (text.length() == 0 && normalizedValue != null) {
                    elementNode.setTextContent(normalizedValue);
                }
            }
            return;
        }
        if (this.fCurrentNode instanceof ElementNSImpl) {
            ((ElementNSImpl)this.fCurrentNode).setType(null);
        }
    }

    @Override
    public void startCDATA(Augmentations augs) throws XNIException {
    }

    @Override
    public void endCDATA(Augmentations augs) throws XNIException {
    }

    @Override
    public void endDocument(Augmentations augs) throws XNIException {
    }

    @Override
    public void setDocumentSource(XMLDocumentSource source) {
    }

    @Override
    public XMLDocumentSource getDocumentSource() {
        return null;
    }

    protected final class XMLAttributesProxy
    implements XMLAttributes {
        protected AttributeMap fAttributes;
        protected CoreDocumentImpl fDocument;
        protected ElementImpl fElement;
        protected final Vector fDTDTypes = new Vector(5);
        protected final Vector fAugmentations = new Vector(5);

        protected XMLAttributesProxy() {
        }

        public void setAttributes(AttributeMap attributes, CoreDocumentImpl doc, ElementImpl elem) {
            this.fDocument = doc;
            this.fAttributes = attributes;
            this.fElement = elem;
            if (attributes != null) {
                int length = attributes.getLength();
                this.fDTDTypes.setSize(length);
                this.fAugmentations.setSize(length);
                int i = 0;
                while (i < length) {
                    this.fAugmentations.setElementAt(new AugmentationsImpl(), i);
                    ++i;
                }
            } else {
                this.fDTDTypes.setSize(0);
                this.fAugmentations.setSize(0);
            }
        }

        @Override
        public int addAttribute(QName qname, String attrType, String attrValue) {
            int index = this.fElement.getXercesAttribute(qname.uri, qname.localpart);
            if (index < 0) {
                AttrImpl attr = (AttrImpl)((CoreDocumentImpl)this.fElement.getOwnerDocument()).createAttributeNS(qname.uri, qname.rawname, qname.localpart);
                attr.setNodeValue(attrValue);
                index = this.fElement.setXercesAttributeNode(attr);
                this.fDTDTypes.insertElementAt(attrType, index);
                this.fAugmentations.insertElementAt(new AugmentationsImpl(), index);
                attr.setSpecified(false);
            }
            return index;
        }

        @Override
        public void removeAllAttributes() {
        }

        @Override
        public void removeAttributeAt(int attrIndex) {
        }

        @Override
        public int getLength() {
            return this.fAttributes != null ? this.fAttributes.getLength() : 0;
        }

        @Override
        public int getIndex(String qName) {
            return -1;
        }

        @Override
        public int getIndex(String uri, String localPart) {
            return -1;
        }

        @Override
        public void setName(int attrIndex, QName attrName) {
        }

        @Override
        public void getName(int attrIndex, QName attrName) {
            if (this.fAttributes != null) {
                DOMNormalizer.this.updateQName((Node)this.fAttributes.getItem(attrIndex), attrName);
            }
        }

        @Override
        public String getPrefix(int index) {
            if (this.fAttributes != null) {
                Node node = (Node)this.fAttributes.getItem(index);
                String prefix = node.getPrefix();
                prefix = prefix != null && prefix.length() != 0 ? DOMNormalizer.this.fSymbolTable.addSymbol(prefix) : null;
                return prefix;
            }
            return null;
        }

        @Override
        public String getURI(int index) {
            if (this.fAttributes != null) {
                Node node = (Node)this.fAttributes.getItem(index);
                String namespace = node.getNamespaceURI();
                namespace = namespace != null ? DOMNormalizer.this.fSymbolTable.addSymbol(namespace) : null;
                return namespace;
            }
            return null;
        }

        @Override
        public String getLocalName(int index) {
            if (this.fAttributes != null) {
                Node node = (Node)this.fAttributes.getItem(index);
                String localName = node.getLocalName();
                localName = localName != null ? DOMNormalizer.this.fSymbolTable.addSymbol(localName) : null;
                return localName;
            }
            return null;
        }

        @Override
        public String getQName(int index) {
            if (this.fAttributes != null) {
                Node node = (Node)this.fAttributes.getItem(index);
                String rawname = DOMNormalizer.this.fSymbolTable.addSymbol(node.getNodeName());
                return rawname;
            }
            return null;
        }

        @Override
        public void setType(int attrIndex, String attrType) {
            this.fDTDTypes.setElementAt(attrType, attrIndex);
        }

        @Override
        public String getType(int index) {
            String type = (String)this.fDTDTypes.elementAt(index);
            return type != null ? this.getReportableType(type) : "CDATA";
        }

        @Override
        public String getType(String qName) {
            return "CDATA";
        }

        @Override
        public String getType(String uri, String localName) {
            return "CDATA";
        }

        private String getReportableType(String type) {
            if (type.charAt(0) == '(') {
                return "NMTOKEN";
            }
            return type;
        }

        @Override
        public void setValue(int attrIndex, String attrValue) {
            if (this.fAttributes != null) {
                AttrImpl attr = (AttrImpl)this.fAttributes.getItem(attrIndex);
                boolean specified = attr.getSpecified();
                attr.setValue(attrValue);
                attr.setSpecified(specified);
            }
        }

        @Override
        public String getValue(int index) {
            return this.fAttributes != null ? this.fAttributes.item(index).getNodeValue() : "";
        }

        @Override
        public String getValue(String qName) {
            return null;
        }

        @Override
        public String getValue(String uri, String localName) {
            if (this.fAttributes != null) {
                Node node = this.fAttributes.getNamedItemNS(uri, localName);
                return node != null ? node.getNodeValue() : null;
            }
            return null;
        }

        @Override
        public void setNonNormalizedValue(int attrIndex, String attrValue) {
        }

        @Override
        public String getNonNormalizedValue(int attrIndex) {
            return null;
        }

        @Override
        public void setSpecified(int attrIndex, boolean specified) {
            AttrImpl attr = (AttrImpl)this.fAttributes.getItem(attrIndex);
            attr.setSpecified(specified);
        }

        @Override
        public boolean isSpecified(int attrIndex) {
            return ((Attr)this.fAttributes.getItem(attrIndex)).getSpecified();
        }

        @Override
        public Augmentations getAugmentations(int attributeIndex) {
            return (Augmentations)this.fAugmentations.elementAt(attributeIndex);
        }

        @Override
        public Augmentations getAugmentations(String uri, String localPart) {
            return null;
        }

        @Override
        public Augmentations getAugmentations(String qName) {
            return null;
        }

        @Override
        public void setAugmentations(int attrIndex, Augmentations augs) {
            this.fAugmentations.setElementAt(augs, attrIndex);
        }
    }
}

