/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.html.dom;

import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Locale;
import mf.org.apache.html.dom.HTMLBodyElementImpl;
import mf.org.apache.html.dom.HTMLCollectionImpl;
import mf.org.apache.html.dom.HTMLElementImpl;
import mf.org.apache.html.dom.HTMLHeadElementImpl;
import mf.org.apache.html.dom.HTMLHtmlElementImpl;
import mf.org.apache.html.dom.HTMLTitleElementImpl;
import mf.org.apache.html.dom.NameNodeListImpl;
import mf.org.apache.html.dom.ObjectFactory;
import mf.org.apache.xerces.dom.DocumentImpl;
import mf.org.apache.xerces.dom.ElementImpl;
import mf.org.w3c.dom.Attr;
import mf.org.w3c.dom.DOMException;
import mf.org.w3c.dom.Element;
import mf.org.w3c.dom.Node;
import mf.org.w3c.dom.NodeList;
import mf.org.w3c.dom.html.HTMLBodyElement;
import mf.org.w3c.dom.html.HTMLCollection;
import mf.org.w3c.dom.html.HTMLDocument;
import mf.org.w3c.dom.html.HTMLElement;
import mf.org.w3c.dom.html.HTMLFrameSetElement;
import mf.org.w3c.dom.html.HTMLHeadElement;
import mf.org.w3c.dom.html.HTMLHtmlElement;
import mf.org.w3c.dom.html.HTMLTitleElement;

public class HTMLDocumentImpl
extends DocumentImpl
implements HTMLDocument {
    private static final long serialVersionUID = 4285791750126227180L;
    private HTMLCollectionImpl _anchors;
    private HTMLCollectionImpl _forms;
    private HTMLCollectionImpl _images;
    private HTMLCollectionImpl _links;
    private HTMLCollectionImpl _applets;
    private StringWriter _writer;
    private static Hashtable _elementTypesHTML;
    private static final Class[] _elemClassSigHTML;

    static {
        _elemClassSigHTML = new Class[]{HTMLDocumentImpl.class, String.class};
    }

    public HTMLDocumentImpl() {
        HTMLDocumentImpl.populateElementTypes();
    }

    @Override
    public synchronized Element getDocumentElement() {
        Node html = this.getFirstChild();
        while (html != null) {
            if (html instanceof HTMLHtmlElement) {
                return (HTMLElement)html;
            }
            html = html.getNextSibling();
        }
        html = new HTMLHtmlElementImpl(this, "HTML");
        Node child = this.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            html.appendChild(child);
            child = next;
        }
        this.appendChild(html);
        return (HTMLElement)html;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HTMLElement getHead() {
        Node head;
        Element html;
        Element element = html = this.getDocumentElement();
        synchronized (element) {
            head = html.getFirstChild();
            while (head != null && !(head instanceof HTMLHeadElement)) {
                head = head.getNextSibling();
            }
            if (head != null) {
                Node node = head;
                synchronized (node) {
                    Node child = html.getFirstChild();
                    while (child != null && child != head) {
                        Node next = child.getNextSibling();
                        head.insertBefore(child, head.getFirstChild());
                        child = next;
                    }
                }
                return (HTMLElement)head;
            }
            head = new HTMLHeadElementImpl(this, "HEAD");
            html.insertBefore(head, html.getFirstChild());
        }
        return (HTMLElement)head;
    }

    @Override
    public synchronized String getTitle() {
        HTMLElement head = this.getHead();
        NodeList list = head.getElementsByTagName("TITLE");
        if (list.getLength() > 0) {
            Node title = list.item(0);
            return ((HTMLTitleElement)title).getText();
        }
        return "";
    }

    @Override
    public synchronized void setTitle(String newTitle) {
        HTMLElement head = this.getHead();
        NodeList list = head.getElementsByTagName("TITLE");
        if (list.getLength() > 0) {
            Node title = list.item(0);
            if (title.getParentNode() != head) {
                head.appendChild(title);
            }
            ((HTMLTitleElement)title).setText(newTitle);
        } else {
            HTMLTitleElementImpl title = new HTMLTitleElementImpl(this, "TITLE");
            ((HTMLTitleElement)title).setText(newTitle);
            head.appendChild(title);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HTMLElement getBody() {
        Node body;
        Element html = this.getDocumentElement();
        HTMLElement head = this.getHead();
        Element element = html;
        synchronized (element) {
            body = head.getNextSibling();
            while (body != null && !(body instanceof HTMLBodyElement) && !(body instanceof HTMLFrameSetElement)) {
                body = body.getNextSibling();
            }
            if (body != null) {
                Node node = body;
                synchronized (node) {
                    Node child = head.getNextSibling();
                    while (child != null && child != body) {
                        Node next = child.getNextSibling();
                        body.insertBefore(child, body.getFirstChild());
                        child = next;
                    }
                }
                return (HTMLElement)body;
            }
            body = new HTMLBodyElementImpl(this, "BODY");
            html.appendChild(body);
        }
        return (HTMLElement)body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setBody(HTMLElement newBody) {
        HTMLElement hTMLElement = newBody;
        synchronized (hTMLElement) {
            Element html = this.getDocumentElement();
            HTMLElement head = this.getHead();
            Element element = html;
            synchronized (element) {
                NodeList list = this.getElementsByTagName("BODY");
                if (list.getLength() > 0) {
                    Node body;
                    Node node = body = list.item(0);
                    synchronized (node) {
                        Node child = head;
                        while (child != null) {
                            if (child instanceof Element) {
                                if (child != body) {
                                    html.insertBefore(newBody, child);
                                } else {
                                    html.replaceChild(newBody, body);
                                }
                                return;
                            }
                            child = child.getNextSibling();
                        }
                        html.appendChild(newBody);
                    }
                    return;
                }
                html.appendChild(newBody);
            }
        }
    }

    @Override
    public synchronized Element getElementById(String elementId) {
        Element idElement = super.getElementById(elementId);
        if (idElement != null) {
            return idElement;
        }
        return this.getElementById(elementId, this);
    }

    @Override
    public NodeList getElementsByName(String elementName) {
        return new NameNodeListImpl(this, elementName);
    }

    @Override
    public final NodeList getElementsByTagName(String tagName) {
        return super.getElementsByTagName(tagName.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public final NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        if (namespaceURI != null && namespaceURI.length() > 0) {
            return super.getElementsByTagNameNS(namespaceURI, localName.toUpperCase(Locale.ENGLISH));
        }
        return super.getElementsByTagName(localName.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName, String localpart) throws DOMException {
        return this.createElementNS(namespaceURI, qualifiedName);
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) {
        if (namespaceURI == null || namespaceURI.length() == 0) {
            return this.createElement(qualifiedName);
        }
        return super.createElementNS(namespaceURI, qualifiedName);
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        Class elemClass = (Class)_elementTypesHTML.get(tagName = tagName.toUpperCase(Locale.ENGLISH));
        if (elemClass != null) {
            try {
                Constructor cnst = elemClass.getConstructor(_elemClassSigHTML);
                return (Element)cnst.newInstance(this, tagName);
            }
            catch (Exception except) {
                throw new IllegalStateException("HTM15 Tag '" + tagName + "' associated with an Element class that failed to construct.\n" + tagName);
            }
        }
        return new HTMLElementImpl(this, tagName);
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return super.createAttribute(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public String getReferrer() {
        return null;
    }

    @Override
    public String getDomain() {
        return null;
    }

    @Override
    public String getURL() {
        return null;
    }

    @Override
    public String getCookie() {
        return null;
    }

    @Override
    public void setCookie(String cookie) {
    }

    @Override
    public HTMLCollection getImages() {
        if (this._images == null) {
            this._images = new HTMLCollectionImpl(this.getBody(), 3);
        }
        return this._images;
    }

    @Override
    public HTMLCollection getApplets() {
        if (this._applets == null) {
            this._applets = new HTMLCollectionImpl(this.getBody(), 4);
        }
        return this._applets;
    }

    @Override
    public HTMLCollection getLinks() {
        if (this._links == null) {
            this._links = new HTMLCollectionImpl(this.getBody(), 5);
        }
        return this._links;
    }

    @Override
    public HTMLCollection getForms() {
        if (this._forms == null) {
            this._forms = new HTMLCollectionImpl(this.getBody(), 2);
        }
        return this._forms;
    }

    @Override
    public HTMLCollection getAnchors() {
        if (this._anchors == null) {
            this._anchors = new HTMLCollectionImpl(this.getBody(), 1);
        }
        return this._anchors;
    }

    @Override
    public void open() {
        if (this._writer == null) {
            this._writer = new StringWriter();
        }
    }

    @Override
    public void close() {
        if (this._writer != null) {
            this._writer = null;
        }
    }

    @Override
    public void write(String text) {
        if (this._writer != null) {
            this._writer.write(text);
        }
    }

    @Override
    public void writeln(String text) {
        if (this._writer != null) {
            this._writer.write(String.valueOf(text) + "\n");
        }
    }

    @Override
    public Node cloneNode(boolean deep) {
        HTMLDocumentImpl newdoc = new HTMLDocumentImpl();
        this.callUserDataHandlers(this, newdoc, (short)1);
        this.cloneNode(newdoc, deep);
        return newdoc;
    }

    @Override
    protected boolean canRenameElements(String newNamespaceURI, String newNodeName, ElementImpl el) {
        Class oldClass;
        if (el.getNamespaceURI() != null) {
            return newNamespaceURI != null;
        }
        Class newClass = (Class)_elementTypesHTML.get(newNodeName.toUpperCase(Locale.ENGLISH));
        return newClass == (oldClass = (Class)_elementTypesHTML.get(el.getTagName()));
    }

    private Element getElementById(String elementId, Node node) {
        Node child = node.getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                if (elementId.equals(((Element)child).getAttribute("id"))) {
                    return (Element)child;
                }
                Element result = this.getElementById(elementId, child);
                if (result != null) {
                    return result;
                }
            }
            child = child.getNextSibling();
        }
        return null;
    }

    private static synchronized void populateElementTypes() {
        if (_elementTypesHTML != null) {
            return;
        }
        _elementTypesHTML = new Hashtable(63);
        HTMLDocumentImpl.populateElementType("A", "HTMLAnchorElementImpl");
        HTMLDocumentImpl.populateElementType("APPLET", "HTMLAppletElementImpl");
        HTMLDocumentImpl.populateElementType("AREA", "HTMLAreaElementImpl");
        HTMLDocumentImpl.populateElementType("BASE", "HTMLBaseElementImpl");
        HTMLDocumentImpl.populateElementType("BASEFONT", "HTMLBaseFontElementImpl");
        HTMLDocumentImpl.populateElementType("BLOCKQUOTE", "HTMLQuoteElementImpl");
        HTMLDocumentImpl.populateElementType("BODY", "HTMLBodyElementImpl");
        HTMLDocumentImpl.populateElementType("BR", "HTMLBRElementImpl");
        HTMLDocumentImpl.populateElementType("BUTTON", "HTMLButtonElementImpl");
        HTMLDocumentImpl.populateElementType("DEL", "HTMLModElementImpl");
        HTMLDocumentImpl.populateElementType("DIR", "HTMLDirectoryElementImpl");
        HTMLDocumentImpl.populateElementType("DIV", "HTMLDivElementImpl");
        HTMLDocumentImpl.populateElementType("DL", "HTMLDListElementImpl");
        HTMLDocumentImpl.populateElementType("FIELDSET", "HTMLFieldSetElementImpl");
        HTMLDocumentImpl.populateElementType("FONT", "HTMLFontElementImpl");
        HTMLDocumentImpl.populateElementType("FORM", "HTMLFormElementImpl");
        HTMLDocumentImpl.populateElementType("FRAME", "HTMLFrameElementImpl");
        HTMLDocumentImpl.populateElementType("FRAMESET", "HTMLFrameSetElementImpl");
        HTMLDocumentImpl.populateElementType("HEAD", "HTMLHeadElementImpl");
        HTMLDocumentImpl.populateElementType("H1", "HTMLHeadingElementImpl");
        HTMLDocumentImpl.populateElementType("H2", "HTMLHeadingElementImpl");
        HTMLDocumentImpl.populateElementType("H3", "HTMLHeadingElementImpl");
        HTMLDocumentImpl.populateElementType("H4", "HTMLHeadingElementImpl");
        HTMLDocumentImpl.populateElementType("H5", "HTMLHeadingElementImpl");
        HTMLDocumentImpl.populateElementType("H6", "HTMLHeadingElementImpl");
        HTMLDocumentImpl.populateElementType("HR", "HTMLHRElementImpl");
        HTMLDocumentImpl.populateElementType("HTML", "HTMLHtmlElementImpl");
        HTMLDocumentImpl.populateElementType("IFRAME", "HTMLIFrameElementImpl");
        HTMLDocumentImpl.populateElementType("IMG", "HTMLImageElementImpl");
        HTMLDocumentImpl.populateElementType("INPUT", "HTMLInputElementImpl");
        HTMLDocumentImpl.populateElementType("INS", "HTMLModElementImpl");
        HTMLDocumentImpl.populateElementType("ISINDEX", "HTMLIsIndexElementImpl");
        HTMLDocumentImpl.populateElementType("LABEL", "HTMLLabelElementImpl");
        HTMLDocumentImpl.populateElementType("LEGEND", "HTMLLegendElementImpl");
        HTMLDocumentImpl.populateElementType("LI", "HTMLLIElementImpl");
        HTMLDocumentImpl.populateElementType("LINK", "HTMLLinkElementImpl");
        HTMLDocumentImpl.populateElementType("MAP", "HTMLMapElementImpl");
        HTMLDocumentImpl.populateElementType("MENU", "HTMLMenuElementImpl");
        HTMLDocumentImpl.populateElementType("META", "HTMLMetaElementImpl");
        HTMLDocumentImpl.populateElementType("OBJECT", "HTMLObjectElementImpl");
        HTMLDocumentImpl.populateElementType("OL", "HTMLOListElementImpl");
        HTMLDocumentImpl.populateElementType("OPTGROUP", "HTMLOptGroupElementImpl");
        HTMLDocumentImpl.populateElementType("OPTION", "HTMLOptionElementImpl");
        HTMLDocumentImpl.populateElementType("P", "HTMLParagraphElementImpl");
        HTMLDocumentImpl.populateElementType("PARAM", "HTMLParamElementImpl");
        HTMLDocumentImpl.populateElementType("PRE", "HTMLPreElementImpl");
        HTMLDocumentImpl.populateElementType("Q", "HTMLQuoteElementImpl");
        HTMLDocumentImpl.populateElementType("SCRIPT", "HTMLScriptElementImpl");
        HTMLDocumentImpl.populateElementType("SELECT", "HTMLSelectElementImpl");
        HTMLDocumentImpl.populateElementType("STYLE", "HTMLStyleElementImpl");
        HTMLDocumentImpl.populateElementType("TABLE", "HTMLTableElementImpl");
        HTMLDocumentImpl.populateElementType("CAPTION", "HTMLTableCaptionElementImpl");
        HTMLDocumentImpl.populateElementType("TD", "HTMLTableCellElementImpl");
        HTMLDocumentImpl.populateElementType("TH", "HTMLTableCellElementImpl");
        HTMLDocumentImpl.populateElementType("COL", "HTMLTableColElementImpl");
        HTMLDocumentImpl.populateElementType("COLGROUP", "HTMLTableColElementImpl");
        HTMLDocumentImpl.populateElementType("TR", "HTMLTableRowElementImpl");
        HTMLDocumentImpl.populateElementType("TBODY", "HTMLTableSectionElementImpl");
        HTMLDocumentImpl.populateElementType("THEAD", "HTMLTableSectionElementImpl");
        HTMLDocumentImpl.populateElementType("TFOOT", "HTMLTableSectionElementImpl");
        HTMLDocumentImpl.populateElementType("TEXTAREA", "HTMLTextAreaElementImpl");
        HTMLDocumentImpl.populateElementType("TITLE", "HTMLTitleElementImpl");
        HTMLDocumentImpl.populateElementType("UL", "HTMLUListElementImpl");
    }

    private static void populateElementType(String tagName, String className) {
        try {
            _elementTypesHTML.put(tagName, ObjectFactory.findProviderClass("org.apache.html.dom." + className, HTMLDocumentImpl.class.getClassLoader(), true));
        }
        catch (Exception except) {
            throw new RuntimeException("HTM019 OpenXML Error: Could not find or execute class " + className + " implementing HTML element " + tagName + "\n" + className + "\t" + tagName);
        }
    }
}

