/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.utils;

import android.util.Log;

public class LoggerUtils {
    private static final String beforeTagName = "Groobee-";
    private static final int maxTagLength = 80 - "Groobee-".length();
    private static int LOG_LEVEL = 4;

    public static void setLogLevel(int logLevel) {
        LOG_LEVEL = logLevel;
    }

    public static int getLogLevel() {
        return LOG_LEVEL;
    }

    public static String getClassLogTag(Class classForTag) {
        String className = classForTag.getName().replace(classForTag.getPackage().getName() + ".", "");
        int tagLength = className.length();
        String tagName = tagLength <= maxTagLength ? beforeTagName + className : beforeTagName + className.substring(maxTagLength);
        return tagName;
    }

    public static int v(String tagName, String msg) {
        return LoggerUtils.getLogLevel() <= 2 ? Log.v((String)tagName, (String)msg) : 0;
    }

    public static int v(String tagName, String msg, Throwable tr) {
        return LoggerUtils.getLogLevel() <= 2 ? Log.v((String)tagName, (String)msg, (Throwable)tr) : 0;
    }

    public static int d(String tagName, String msg) {
        return LoggerUtils.getLogLevel() <= 3 ? Log.d((String)tagName, (String)msg) : 0;
    }

    public static int d(String tagName, String msg, Throwable tr) {
        return LoggerUtils.getLogLevel() <= 3 ? Log.d((String)tagName, (String)msg, (Throwable)tr) : 0;
    }

    public static int i(String tagName, String msg) {
        return LoggerUtils.getLogLevel() <= 4 ? Log.i((String)tagName, (String)msg) : 0;
    }

    public static int i(String tagName, String msg, Throwable tr) {
        return LoggerUtils.getLogLevel() <= 4 ? Log.i((String)tagName, (String)msg, (Throwable)tr) : 0;
    }

    public static int w(String tagName, String msg) {
        return LoggerUtils.getLogLevel() <= 5 ? Log.w((String)tagName, (String)msg) : 0;
    }

    public static int w(String tagName, String msg, Throwable tr) {
        return LoggerUtils.getLogLevel() <= 5 ? Log.w((String)tagName, (String)msg, (Throwable)tr) : 0;
    }

    public static int e(String tagName, String msg) {
        return LoggerUtils.getLogLevel() <= 6 ? Log.e((String)tagName, (String)msg) : 0;
    }

    public static int e(String tagName, String msg, Throwable tr) {
        return LoggerUtils.getLogLevel() <= 6 ? Log.e((String)tagName, (String)msg, (Throwable)tr) : 0;
    }
}

