/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import com.groobee.message.push.utils.UriUtils;
import com.groobee.message.utils.LoggerUtils;
import java.util.List;
import java.util.Random;

public final class IntentUtils {
    private static final String TAG = LoggerUtils.getClassLogTag(IntentUtils.class);
    private static final Random random = new Random();

    public static int getRequestCode() {
        return random.nextInt();
    }

    public static void sendComponent(Context context, Intent intent) {
        List receivers = context.getPackageManager().queryBroadcastReceivers(intent, 0);
        if (receivers == null) {
            LoggerUtils.d(TAG, "No components found for the following intent: " + intent.getAction());
        } else {
            for (ResolveInfo resolveInfo : receivers) {
                Intent it = new Intent(intent);
                ComponentName var6 = new ComponentName(resolveInfo.activityInfo.applicationInfo.packageName, resolveInfo.activityInfo.name);
                it.setComponent(var6);
                context.sendBroadcast(it);
            }
        }
    }

    public static Intent setActivity(Context context, String ActivityName, Bundle extras) {
        Intent it = null;
        if (UriUtils.isActivityRegisteredInManifest(context, ActivityName)) {
            it = new Intent().setClassName(context, ActivityName).setFlags(0x10000000).putExtras(extras);
        } else {
            LoggerUtils.i(TAG, "Not Found Activity: " + ActivityName);
        }
        return it;
    }
}

