/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.push.utils;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.core.app.NotificationCompat;
import com.groobee.message.Groobee;
import com.groobee.message.GroobeeFirebaseReceiver;
import com.groobee.message.common.Channel;
import com.groobee.message.providers.GroobeeConfigProvider;
import com.groobee.message.push.actions.ActionFactory;
import com.groobee.message.push.actions.UriAction;
import com.groobee.message.push.factorys.GroobeeNotificationFactory;
import com.groobee.message.push.factorys.GroobeeNotificationStyleFactory;
import com.groobee.message.push.interfaces.InterfaceGroobeeNotificationFactory;
import com.groobee.message.push.utils.UriUtils;
import com.groobee.message.utils.IntentUtils;
import com.groobee.message.utils.LoggerUtils;
import com.groobee.message.utils.StringUtils;

public class GroobeeNotificationUtils {
    private static final String TAG = LoggerUtils.getClassLogTag(GroobeeNotificationUtils.class);
    public static final String PUSH_NOTIFICATION_OPENED_SUFFIX = ".intent.PUSH_NOTIFICATION_OPENED";
    public static final String PUSH_NOTIFICATION_RECEIVED_SUFFIX = ".intent.PUSH_NOTIFICATION_RECEIVED";
    public static final String PUSH_NOTIFICATION_DELETED_SUFFIX = ".intent.PUSH_NOTIFICATION_DELETED";

    public static void handleCancelNotificationAction(Context context, Intent intent) {
        try {
            if (intent.hasExtra("nid")) {
                int notificationId = intent.getIntExtra("nid", -1);
                LoggerUtils.d(TAG, "Cancelling notification action with id: " + notificationId);
                NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                notificationManager.cancel("push_notification_tag", notificationId);
            }
        }
        catch (Exception e) {
            LoggerUtils.e(TAG, "Exception occurred handling cancel notification intent.", e);
        }
    }

    public static void handleNotificationOpened(Context context, Intent intent) {
        try {
            GroobeeNotificationUtils.logNotificationOpened(context, intent);
            GroobeeNotificationUtils.sendNotificationOpenedBroadcast(context, intent);
            GroobeeConfigProvider groobeeConfigProvider = new GroobeeConfigProvider(context);
            if (groobeeConfigProvider.getHandlePushDeepLinks() || groobeeConfigProvider.getPushMoveActivityEnabled()) {
                GroobeeNotificationUtils.notificationOpenedIntent(context, intent, groobeeConfigProvider.getPushMoveActivityEnabled());
            }
        }
        catch (Exception e) {
            LoggerUtils.e(TAG, "Exception occurred attempting to handle notification opened intent.", e);
        }
    }

    public static void handleNotificationDeleted(Context context, Intent intent) {
        try {
            LoggerUtils.d(TAG, "Sending notification deleted broadcast");
            GroobeeNotificationUtils.sendPushActionIntent(context, PUSH_NOTIFICATION_DELETED_SUFFIX, intent.getExtras());
        }
        catch (Exception e) {
            LoggerUtils.e(TAG, "Exception occurred attempting to handle notification delete intent.", e);
        }
    }

    public static void notificationOpenedIntent(Context context, Intent intent, boolean isActMoveEnabled) {
        Bundle extras = intent.getBundleExtra("extra");
        if (extras == null) {
            extras = new Bundle();
        }
        extras.putString("cid", intent.getStringExtra("cid"));
        String deepLink = intent.getStringExtra("uri");
        if (!StringUtils.isNullOrBlank(deepLink)) {
            LoggerUtils.d(TAG, "Found a deep link " + deepLink);
            extras.putString("uri", deepLink);
            UriAction uriAction = ActionFactory.createUriActionFromUrlString(deepLink, extras, Channel.PUSH);
            uriAction.execute(context);
            return;
        }
        if (isActMoveEnabled) {
            UriAction uriAction = ActionFactory.createUriActionFromActMove(intent, true, Channel.PUSH);
            uriAction.execute(context);
            return;
        }
        LoggerUtils.d(TAG, "Push notification had no deep link. Opening main activity.");
        context.startActivity(UriUtils.getMainActivityIntent(context, extras));
    }

    public static void logPushDeliveryEvent(Context context, Bundle pushExtras) {
        if (pushExtras != null) {
            String campaignId = pushExtras.getString("cid");
            if (!StringUtils.isNullOrBlank(campaignId)) {
                Groobee.getInstance().logPushDeliveryEvent(campaignId);
            } else {
                LoggerUtils.d(TAG, "Could not log push delivery event due to null or blank campaign id in push extras bundle: " + pushExtras);
            }
        } else {
            LoggerUtils.d(TAG, "Could not log push delivery event due to null push extras bundle.");
        }
    }

    public static String getOrCreateNotificationChannelId(Context context, GroobeeConfigProvider groobeeConfigProvider, Bundle notificationExtras) {
        String channelIdFromExtras = GroobeeNotificationUtils.getNonBlankStringFromBundle(notificationExtras, "pn_cid");
        String defaultChannelId = "default_notification_channel";
        if (Build.VERSION.SDK_INT < 26) {
            return channelIdFromExtras != null ? channelIdFromExtras : defaultChannelId;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (channelIdFromExtras != null) {
            if (notificationManager.getNotificationChannel(channelIdFromExtras) != null) {
                LoggerUtils.d(TAG, "Found notification channel in extras with id: " + channelIdFromExtras);
                return channelIdFromExtras;
            }
            LoggerUtils.d(TAG, "Notification channel from extras is invalid. No channel found with id: " + channelIdFromExtras);
        }
        if (notificationManager.getNotificationChannel(defaultChannelId) == null) {
            LoggerUtils.d(TAG, "sdk default notification channel does not exist on device; creating");
            NotificationChannel channel = new NotificationChannel(defaultChannelId, (CharSequence)groobeeConfigProvider.getDefaultNotificationChannelName(), 3);
            channel.setDescription(groobeeConfigProvider.getDefaultNotificationChannelDescription());
            notificationManager.createNotificationChannel(channel);
        }
        return defaultChannelId;
    }

    private static String getNonBlankStringFromBundle(Bundle bundle, String key) {
        String stringValue;
        if (bundle != null && !StringUtils.isNullOrBlank(stringValue = bundle.getString(key, null))) {
            return stringValue;
        }
        return null;
    }

    public static void cancelNotification(Context context, int notificationId) {
        try {
            LoggerUtils.d(TAG, "Cancelling notification action with id: " + notificationId);
            Intent cancelNotificationIntent = new Intent("com.groobee.action.CANCEL_NOTIFICATION").setClass(context, GroobeeNotificationUtils.getNotificationReceiverClass());
            cancelNotificationIntent.putExtra("nid", notificationId);
            IntentUtils.sendComponent(context, cancelNotificationIntent);
        }
        catch (Exception e) {
            LoggerUtils.e(TAG, "Exception occurred attempting to cancel notification.", e);
        }
    }

    static void sendNotificationOpenedBroadcast(Context context, Intent intent) {
        LoggerUtils.d(TAG, "Sending notification opened broadcast");
        GroobeeNotificationUtils.sendPushActionIntent(context, PUSH_NOTIFICATION_OPENED_SUFFIX, intent.getExtras());
    }

    private static void logNotificationOpened(Context context, Intent intent) {
        Groobee.getInstance().logPushNotificationOpened(intent);
    }

    public static int getNotificationId(Bundle notificationExtras) {
        if (notificationExtras != null) {
            if (notificationExtras.containsKey("n")) {
                try {
                    int notificationId = Integer.parseInt(notificationExtras.getString("n"));
                    LoggerUtils.d(TAG, "Using notification id provided in the message's extras bundle: " + notificationId);
                    return notificationId;
                }
                catch (NumberFormatException e) {
                    LoggerUtils.e(TAG, "Unable to parse notification id provided in the message's extras bundle. Using default notification id instead: -1", e);
                    return -1;
                }
            }
            String messageKey = notificationExtras.getString("title", "") + notificationExtras.getString("body", "");
            int notificationId = messageKey.hashCode();
            LoggerUtils.d(TAG, "Message without notification id provided in the extras bundle received. Using a hash of the message: " + notificationId);
            return notificationId;
        }
        LoggerUtils.d(TAG, "Message without extras bundle received. Using default notification id: ");
        return -1;
    }

    public static InterfaceGroobeeNotificationFactory getActiveNotificationFactory() {
        InterfaceGroobeeNotificationFactory customGroobeeNotificationFactory = Groobee.getCustomGroobeeNotificationFactory();
        if (customGroobeeNotificationFactory == null) {
            return GroobeeNotificationFactory.getInstance();
        }
        return customGroobeeNotificationFactory;
    }

    public static void setContentTitle(NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (notificationExtras != null) {
            LoggerUtils.d(TAG, "Setting title for notification");
            String title = notificationExtras.getString("title");
            notificationBuilder.setContentTitle((CharSequence)title);
        }
    }

    public static void setContentText(NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (notificationExtras != null) {
            LoggerUtils.d(TAG, "Setting content for notification");
            String content = notificationExtras.getString("body");
            notificationBuilder.setContentText((CharSequence)content);
        }
    }

    public static void setTicker(NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (notificationExtras != null) {
            LoggerUtils.d(TAG, "Setting ticker for notification");
            notificationBuilder.setTicker((CharSequence)notificationExtras.getString("title"));
        }
    }

    public static void setContentIntent(Context context, NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        try {
            PendingIntent pushOpenedPendingIntent = GroobeeNotificationUtils.getPushActionPendingIntent(context, "com.groobee.action.PUSH_CLICKED", notificationExtras);
            notificationBuilder.setContentIntent(pushOpenedPendingIntent);
        }
        catch (Exception e) {
            LoggerUtils.e(TAG, "Error setting content intent.", e);
        }
    }

    public static void setDeleteIntent(Context context, NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        LoggerUtils.d(TAG, "Setting delete intent.");
        try {
            PendingIntent pushDeletedPendingIntent = GroobeeNotificationUtils.getPushActionPendingIntent(context, "com.groobee.action.PUSH_DELETED", notificationExtras);
            notificationBuilder.setDeleteIntent(pushDeletedPendingIntent);
        }
        catch (Exception e) {
            LoggerUtils.e(TAG, "Error setting delete intent.", e);
        }
    }

    public static int setSmallIcon(GroobeeConfigProvider groobeeConfigProvider, NotificationCompat.Builder notificationBuilder) {
        int smallNotificationIconResourceId = groobeeConfigProvider.getSmallNotificationIconResourceId();
        if (smallNotificationIconResourceId == 0) {
            LoggerUtils.d(TAG, "Small notification icon resource was not found. Will use the app icon when displaying notifications.");
            smallNotificationIconResourceId = groobeeConfigProvider.getApplicationIconResourceId();
        } else {
            LoggerUtils.d(TAG, "Setting small icon for notification via resource id");
        }
        notificationBuilder.setSmallIcon(smallNotificationIconResourceId);
        return smallNotificationIconResourceId;
    }

    public static boolean setLargeIcon(Context context, GroobeeConfigProvider groobeeConfigProvider, NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        try {
            if (notificationExtras != null && notificationExtras.containsKey("l_icon")) {
                LoggerUtils.d(TAG, "Setting large icon for notification");
                String bitmapUrl = notificationExtras.getString("l_icon");
                Bitmap largeNotificationBitmap = Groobee.getInstance().getImageLoader().getBitmap(bitmapUrl);
                notificationBuilder.setLargeIcon(largeNotificationBitmap);
                return true;
            }
            LoggerUtils.d(TAG, "Large icon bitmap url not present in extras. Attempting to use resource id instead.");
            int largeNotificationIconResourceId = groobeeConfigProvider.getLargeNotificationIconResourceId();
            if (largeNotificationIconResourceId != 0) {
                Bitmap largeNotificationBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)largeNotificationIconResourceId);
                notificationBuilder.setLargeIcon(largeNotificationBitmap);
                return true;
            }
            LoggerUtils.d(TAG, "Large icon resource id not present for notification");
        }
        catch (Exception e) {
            LoggerUtils.e(TAG, "Error setting large notification icon", e);
        }
        LoggerUtils.d(TAG, "Large icon not set for notification");
        return false;
    }

    public static void setSound(NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (notificationExtras != null && notificationExtras.containsKey("s")) {
            String soundUri = notificationExtras.getString("s");
            if (soundUri != null) {
                if (soundUri.equals("d")) {
                    LoggerUtils.d(TAG, "Setting default sound for notification.");
                    notificationBuilder.setDefaults(1);
                } else {
                    LoggerUtils.d(TAG, "Setting sound for notification via uri.");
                    notificationBuilder.setSound(Uri.parse((String)soundUri));
                }
            }
        } else {
            LoggerUtils.d(TAG, "Sound key not present in notification extras. Not setting sound for notification.");
        }
    }

    public static void setSummaryText(NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (notificationExtras != null && notificationExtras.containsKey("sub_txt")) {
            String summaryText = notificationExtras.getString("sub_txt");
            if (summaryText != null) {
                LoggerUtils.d(TAG, "Setting summary text for notification");
                notificationBuilder.setSubText((CharSequence)summaryText);
            }
        } else {
            LoggerUtils.d(TAG, "Summary text not present in notification extras. Not setting summary text for notification.");
        }
    }

    public static void setStyle(Context context, NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (notificationExtras != null) {
            LoggerUtils.d(TAG, "Setting style for notification");
            NotificationCompat.Style style = GroobeeNotificationStyleFactory.getBigNotificationStyle(context, notificationExtras, notificationBuilder);
            notificationBuilder.setStyle(style);
        }
    }

    public static void setAccentColor(GroobeeConfigProvider groobeeConfigProvider, NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (notificationExtras != null && notificationExtras.containsKey("ac_color")) {
                LoggerUtils.d(TAG, "Using accent color for notification from extras bundle");
                notificationBuilder.setColor(Color.parseColor((String)notificationExtras.getString("ac_color")));
            } else {
                LoggerUtils.d(TAG, "Using default accent color for notification");
                notificationBuilder.setColor(groobeeConfigProvider.getDefaultNotificationAccentColor());
            }
        }
    }

    public static void setCategory(NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (notificationExtras != null && notificationExtras.containsKey("p_ct")) {
                LoggerUtils.d(TAG, "Setting category for notification");
                String notificationCategory = notificationExtras.getString("p_ct");
                notificationBuilder.setCategory(notificationCategory);
            } else {
                LoggerUtils.d(TAG, "Category not present in notification extras. Not setting category for notification.");
            }
        } else {
            LoggerUtils.d(TAG, "Notification category not supported on this android version. Not setting category for notification.");
        }
    }

    public static void setVisibility(NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        block6: {
            if (Build.VERSION.SDK_INT >= 21) {
                if (notificationExtras != null && notificationExtras.containsKey("p_vs")) {
                    try {
                        int visibility = Integer.parseInt(notificationExtras.getString("p_vs"));
                        if (GroobeeNotificationUtils.isValidNotificationVisibility(visibility)) {
                            LoggerUtils.d(TAG, "Setting visibility for notification");
                            notificationBuilder.setVisibility(visibility);
                            break block6;
                        }
                        LoggerUtils.e(TAG, "Received invalid notification visibility " + visibility);
                    }
                    catch (Exception e) {
                        LoggerUtils.e(TAG, "Failed to parse visibility from notificationExtras", e);
                    }
                }
            } else {
                LoggerUtils.d(TAG, "Notification visibility not supported on this android version. Not setting visibility for notification.");
            }
        }
    }

    public static void setNotificationBadgeNumber(NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        String extrasBadgeCount;
        if (Build.VERSION.SDK_INT >= 26 && !StringUtils.isNullOrBlank(extrasBadgeCount = notificationExtras.getString("pn_bc", null))) {
            try {
                int badgeCount = Integer.parseInt(extrasBadgeCount);
                notificationBuilder.setNumber(badgeCount);
            }
            catch (NumberFormatException e) {
                LoggerUtils.e(TAG, "Caught exception while setting number on notification.", e);
            }
        }
    }

    private static PendingIntent getPushActionPendingIntent(Context context, String action, Bundle notificationExtras) {
        Intent pushActionIntent = new Intent(action).setClass(context, GroobeeNotificationUtils.getNotificationReceiverClass());
        if (notificationExtras != null) {
            pushActionIntent.putExtras(notificationExtras);
        }
        return PendingIntent.getBroadcast((Context)context, (int)IntentUtils.getRequestCode(), (Intent)pushActionIntent, (int)0x40000000);
    }

    public static Class<?> getNotificationReceiverClass() {
        return GroobeeFirebaseReceiver.class;
    }

    public static boolean isValidNotificationVisibility(int visibility) {
        return visibility == -1 || visibility == 0 || visibility == 1;
    }

    private static void sendPushActionIntent(Context context, String actionSuffix, Bundle notificationExtras) {
        String pushAction = context.getPackageName() + actionSuffix;
        Intent pushIntent = new Intent(pushAction);
        if (notificationExtras != null) {
            pushIntent.putExtras(notificationExtras);
        }
        IntentUtils.sendComponent(context, pushIntent);
    }
}

