/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.push.utils;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.core.app.NotificationCompat;
import com.groobee.message.Groobee;
import com.groobee.message.push.utils.GroobeeNotificationUtils;
import com.groobee.message.utils.IntentUtils;
import com.groobee.message.utils.LoggerUtils;
import com.groobee.message.utils.StringUtils;

public class GroobeeNotificationActionUtils {
    private static final String TAG = LoggerUtils.getClassLogTag(GroobeeNotificationActionUtils.class);

    public static void addNotificationActions(Context context, NotificationCompat.Builder notificationBuilder, Bundle notificationExtras) {
        try {
            if (notificationExtras == null) {
                LoggerUtils.w(TAG, "Notification extras were null. Doing nothing.");
                return;
            }
            int actionIndex = 0;
            while (!StringUtils.isNullOrBlank(GroobeeNotificationActionUtils.getActionFieldAtIndex(actionIndex, notificationExtras, "pa_type_tp"))) {
                GroobeeNotificationActionUtils.addNotificationAction(context, notificationBuilder, notificationExtras, actionIndex);
                ++actionIndex;
            }
        }
        catch (Exception e) {
            LoggerUtils.e(TAG, "Caught exception while adding notification action buttons.", e);
        }
    }

    public static void handleNotificationActionClicked(Context context, Intent intent) {
        try {
            String actionType = intent.getStringExtra("push_action_type");
            if (StringUtils.isNullOrBlank(actionType)) {
                LoggerUtils.w(TAG, "Notification action button type was blank or null. Doing nothing.");
                return;
            }
            int notificationId = intent.getIntExtra("nid", -1);
            GroobeeNotificationActionUtils.logNotificationActionClicked(context, intent, actionType);
            if (actionType.equals("pa_uri") || actionType.equals("pa_open")) {
                GroobeeNotificationUtils.cancelNotification(context, notificationId);
                context.sendBroadcast(new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
                if (actionType.equals("pa_uri") && intent.getExtras().containsKey("push_action_uri")) {
                    intent.putExtra("uri", intent.getStringExtra("push_action_uri"));
                    if (intent.getExtras().containsKey("push_action_use_webview")) {
                        intent.putExtra("push_use_webview", intent.getStringExtra("push_action_use_webview"));
                    }
                } else {
                    intent.removeExtra("uri");
                }
                GroobeeNotificationUtils.sendNotificationOpenedBroadcast(context, intent);
            } else if (actionType.equals("pa_none")) {
                GroobeeNotificationUtils.cancelNotification(context, notificationId);
            } else {
                LoggerUtils.w(TAG, "Unknown notification action button clicked. Doing nothing.");
            }
        }
        catch (Exception e) {
            LoggerUtils.e(TAG, "Caught exception while handling notification action button click.", e);
        }
    }

    private static void addNotificationAction(Context context, NotificationCompat.Builder notificationBuilder, Bundle notificationExtras, int actionIndex) {
        Bundle notificationActionExtras = new Bundle(notificationExtras);
        String actionType = GroobeeNotificationActionUtils.getActionFieldAtIndex(actionIndex, notificationExtras, "pa_type_tp");
        notificationActionExtras.putInt("push_action_index", actionIndex);
        notificationActionExtras.putString("push_action_type", actionType);
        notificationActionExtras.putString("push_action_id", GroobeeNotificationActionUtils.getActionFieldAtIndex(actionIndex, notificationExtras, "pa_id_tp"));
        notificationActionExtras.putString("push_action_uri", GroobeeNotificationActionUtils.getActionFieldAtIndex(actionIndex, notificationExtras, "pa_uri_tp"));
        notificationActionExtras.putString("push_action_use_webview", GroobeeNotificationActionUtils.getActionFieldAtIndex(actionIndex, notificationExtras, "push_action_use_webview_tp"));
        if (actionType.equals("pa_none")) {
            LoggerUtils.v(TAG, "Adding notification action with type: " + actionType + " . Setting intent class to notification receiver.");
            Intent sendIntent = new Intent("com.groobee.action.PUSH_ACTION_CLICKED").setClass(context, GroobeeNotificationUtils.getNotificationReceiverClass());
            sendIntent.putExtras(notificationActionExtras);
            PendingIntent pendingSendIntent = PendingIntent.getBroadcast((Context)context, (int)IntentUtils.getRequestCode(), (Intent)sendIntent, (int)0x8000000);
            String actionText = GroobeeNotificationActionUtils.getActionFieldAtIndex(actionIndex, notificationExtras, "pa_txt_tp");
            NotificationCompat.Action.Builder notificationActionBuilder = new NotificationCompat.Action.Builder(0, (CharSequence)actionText, pendingSendIntent);
            notificationActionBuilder.addExtras(new Bundle(notificationActionExtras));
            notificationBuilder.addAction(notificationActionBuilder.build());
        }
    }

    private static void logNotificationActionClicked(Context context, Intent intent, String actionType) {
        String campaignId = intent.getStringExtra("cid");
        String actionButtonId = intent.getStringExtra("push_action_id");
        Groobee.getInstance().logPushNotificationActionClicked(campaignId, actionButtonId, actionType);
    }

    public static String getActionFieldAtIndex(int actionIndex, Bundle notificationExtras, String actionFieldKeyTemplate) {
        return GroobeeNotificationActionUtils.getActionFieldAtIndex(actionIndex, notificationExtras, actionFieldKeyTemplate, "");
    }

    public static String getActionFieldAtIndex(int actionIndex, Bundle notificationExtras, String actionFieldKeyTemplate, String defaultValue) {
        String actionFieldKey = actionFieldKeyTemplate.replace("*", String.valueOf(actionIndex));
        String actionFieldValue = notificationExtras.getString(actionFieldKey);
        if (actionFieldValue == null) {
            return defaultValue;
        }
        return actionFieldValue;
    }
}

