/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.push.factorys;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.DisplayMetrics;
import androidx.core.app.NotificationCompat;
import com.groobee.message.Groobee;
import com.groobee.message.utils.DisplayUtils;
import com.groobee.message.utils.LoggerUtils;
import com.groobee.message.utils.StringUtils;

public class GroobeeNotificationStyleFactory {
    private static final String TAG = LoggerUtils.getClassLogTag(GroobeeNotificationStyleFactory.class);
    public static final int BIG_PICTURE_STYLE_IMAGE_HEIGHT = 192;

    public static NotificationCompat.Style getBigNotificationStyle(Context context, Bundle notificationExtras, NotificationCompat.Builder notificationBuilder) {
        NotificationCompat.BigTextStyle style = null;
        if (notificationExtras != null && notificationExtras.containsKey("img_url")) {
            LoggerUtils.d(TAG, "Rendering push notification with BigPictureStyle");
            style = GroobeeNotificationStyleFactory.getBigPictureNotificationStyle(context, notificationExtras);
        }
        if (style == null) {
            LoggerUtils.d(TAG, "Rendering push notification with BigTextStyle");
            style = GroobeeNotificationStyleFactory.getBigTextNotificationStyle(notificationExtras);
        }
        return style;
    }

    public static NotificationCompat.BigPictureStyle getBigLargeIconNotificationStyle(Context context, Bundle notificationExtras) {
        NotificationCompat.BigPictureStyle bigPictureNotificationStyle;
        if (notificationExtras == null || !notificationExtras.containsKey("b_l_icon")) {
            return null;
        }
        String imageUrl = notificationExtras.getString("b_l_icon");
        if (StringUtils.isNullOrBlank(imageUrl)) {
            return null;
        }
        Bitmap imageBitmap = Groobee.getInstance().getImageLoader().getBitmap(imageUrl);
        if (imageBitmap == null) {
            LoggerUtils.d(TAG, "Failed to download image bitmap for big picture notification style. Url: " + imageUrl);
            return null;
        }
        try {
            if (imageBitmap.getWidth() > imageBitmap.getHeight()) {
                DisplayMetrics displayMetrics = DisplayUtils.getDefaultScreenDisplayMetrics(context);
                int bigPictureHeightPixels = DisplayUtils.getPixelsFromDensityAndDp(displayMetrics.densityDpi, 192);
                int bigPictureWidthPixels = 2 * bigPictureHeightPixels;
                if (bigPictureWidthPixels > displayMetrics.widthPixels) {
                    bigPictureWidthPixels = displayMetrics.widthPixels;
                }
                try {
                    imageBitmap = Bitmap.createScaledBitmap((Bitmap)imageBitmap, (int)bigPictureWidthPixels, (int)bigPictureHeightPixels, (boolean)true);
                }
                catch (Exception e) {
                    LoggerUtils.e(TAG, "Failed to scale image bitmap, using original.", e);
                }
            }
            if (imageBitmap == null) {
                LoggerUtils.i(TAG, "Bitmap download failed for push notification. No image will be included with the notification.");
                return null;
            }
            bigPictureNotificationStyle = new NotificationCompat.BigPictureStyle();
            bigPictureNotificationStyle.bigLargeIcon(imageBitmap);
            GroobeeNotificationStyleFactory.setBigPictureSummaryAndTitle(bigPictureNotificationStyle, notificationExtras);
        }
        catch (Exception e) {
            LoggerUtils.e(TAG, "Failed to create Big Picture Style.", e);
            bigPictureNotificationStyle = null;
        }
        return bigPictureNotificationStyle;
    }

    public static NotificationCompat.BigPictureStyle getBigPictureNotificationStyle(Context context, Bundle notificationExtras) {
        NotificationCompat.BigPictureStyle bigPictureNotificationStyle;
        if (notificationExtras == null || !notificationExtras.containsKey("img_url")) {
            return null;
        }
        String imageUrl = notificationExtras.getString("img_url");
        if (StringUtils.isNullOrBlank(imageUrl)) {
            return null;
        }
        Bitmap imageBitmap = Groobee.getInstance().getImageLoader().getBitmap(imageUrl);
        if (imageBitmap == null) {
            LoggerUtils.d(TAG, "Failed to download image bitmap for big picture notification style. Url: " + imageUrl);
            return null;
        }
        try {
            if (imageBitmap.getWidth() > imageBitmap.getHeight()) {
                DisplayMetrics displayMetrics = DisplayUtils.getDefaultScreenDisplayMetrics(context);
                int bigPictureHeightPixels = DisplayUtils.getPixelsFromDensityAndDp(displayMetrics.densityDpi, 192);
                int bigPictureWidthPixels = 2 * bigPictureHeightPixels;
                if (bigPictureWidthPixels > displayMetrics.widthPixels) {
                    bigPictureWidthPixels = displayMetrics.widthPixels;
                }
                try {
                    imageBitmap = Bitmap.createScaledBitmap((Bitmap)imageBitmap, (int)bigPictureWidthPixels, (int)bigPictureHeightPixels, (boolean)true);
                }
                catch (Exception e) {
                    LoggerUtils.e(TAG, "Failed to scale image bitmap, using original.", e);
                }
            }
            if (imageBitmap == null) {
                LoggerUtils.i(TAG, "Bitmap download failed for push notification. No image will be included with the notification.");
                return null;
            }
            bigPictureNotificationStyle = new NotificationCompat.BigPictureStyle();
            bigPictureNotificationStyle.bigPicture(imageBitmap);
            if (notificationExtras.containsKey("b_l_icon")) {
                bigPictureNotificationStyle.bigLargeIcon(Groobee.getInstance().getImageLoader().getBitmap(notificationExtras.getString("b_l_icon")));
            }
            GroobeeNotificationStyleFactory.setBigPictureSummaryAndTitle(bigPictureNotificationStyle, notificationExtras);
        }
        catch (Exception e) {
            LoggerUtils.e(TAG, "Failed to create Big Picture Style.", e);
            bigPictureNotificationStyle = null;
        }
        return bigPictureNotificationStyle;
    }

    static void setBigPictureSummaryAndTitle(NotificationCompat.BigPictureStyle bigPictureNotificationStyle, Bundle notificationExtras) {
        String summaryText;
        String bigSummary = null;
        String bigTitle = null;
        if (notificationExtras.containsKey("b_body")) {
            bigSummary = notificationExtras.getString("b_body");
        }
        if (notificationExtras.containsKey("b_title")) {
            bigTitle = notificationExtras.getString("b_title");
        }
        if (bigSummary != null) {
            bigPictureNotificationStyle.setSummaryText((CharSequence)bigSummary);
        }
        if (bigTitle != null) {
            bigPictureNotificationStyle.setBigContentTitle((CharSequence)bigTitle);
        }
        if ((summaryText = notificationExtras.getString("sub_txt")) == null && bigSummary == null) {
            String contentText = notificationExtras.getString("body");
            bigPictureNotificationStyle.setSummaryText((CharSequence)contentText);
        }
    }

    public static NotificationCompat.BigTextStyle getBigTextNotificationStyle(Bundle notificationExtras) {
        if (notificationExtras != null) {
            NotificationCompat.BigTextStyle bigTextNotificationStyle = new NotificationCompat.BigTextStyle();
            String pushContent = notificationExtras.getString("body");
            bigTextNotificationStyle.bigText((CharSequence)pushContent);
            String bigSummary = null;
            String bigTitle = null;
            if (notificationExtras.containsKey("b_body")) {
                bigSummary = notificationExtras.getString("b_body");
            }
            if (notificationExtras.containsKey("b_title")) {
                bigTitle = notificationExtras.getString("b_title");
            }
            if (bigSummary != null) {
                bigTextNotificationStyle.setSummaryText((CharSequence)bigSummary);
            }
            if (bigTitle != null) {
                bigTextNotificationStyle.setBigContentTitle((CharSequence)bigTitle);
            }
            return bigTextNotificationStyle;
        }
        return null;
    }
}

