/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.push.actions;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import com.groobee.message.common.Channel;
import com.groobee.message.providers.GroobeeConfigProvider;
import com.groobee.message.push.actions.IAction;
import com.groobee.message.push.utils.UriUtils;
import com.groobee.message.utils.FileUtils;
import com.groobee.message.utils.LoggerUtils;
import com.groobee.message.utils.StringUtils;
import java.util.List;

public class UriAction
implements IAction {
    private static final String TAG = LoggerUtils.getClassLogTag(UriAction.class);
    private final Bundle mExtras;
    private final Channel mChannel;
    private Uri mUri;
    private boolean isActMoveEnabled = false;
    private Intent intent;

    public UriAction(Uri uri, Bundle extras, Channel channel) {
        this.mUri = uri;
        this.mExtras = extras;
        this.mChannel = channel;
    }

    public UriAction(boolean isActMoveEnabled, Intent intent, Channel channel) {
        this.isActMoveEnabled = isActMoveEnabled;
        this.intent = intent;
        this.mChannel = channel;
        this.mExtras = intent.getExtras();
    }

    public UriAction(UriAction originalUriAction) {
        this.mUri = originalUriAction.mUri;
        this.mExtras = originalUriAction.mExtras;
        this.mChannel = originalUriAction.mChannel;
    }

    @Override
    public Channel getChannel() {
        return this.mChannel;
    }

    @Override
    public void execute(Context context) {
        if (!this.isActMoveEnabled) {
            if (FileUtils.isLocalUri(this.mUri)) {
                LoggerUtils.d(TAG, "Not executing local Uri: " + this.mUri);
                return;
            }
            LoggerUtils.d(TAG, "Executing Uri action from channel " + (Object)((Object)this.mChannel) + ": " + this.mUri + ". Extras: " + this.mExtras);
            if (!FileUtils.REMOTE_SCHEMES.contains(this.mUri.getScheme())) {
                if (this.mChannel.equals((Object)Channel.PUSH)) {
                    this.openUriWithActionViewFromPush(context, this.mUri, this.mExtras);
                } else {
                    this.openUriWithActionView(context, this.mUri, this.mExtras);
                }
            }
        } else if (this.mChannel.equals((Object)Channel.PUSH)) {
            this.openActWithActionViewFromPush(context, this.intent, this.mExtras);
        }
    }

    public void setUri(Uri uri) {
        this.mUri = uri;
    }

    public Uri getUri() {
        return this.mUri;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    protected void openUriWithActionView(Context context, Uri uri, Bundle extras) {
        Intent intent = this.getActionViewIntent(context, uri, extras);
        intent.setFlags(0x34000000);
        if (intent.resolveActivity(context.getPackageManager()) != null) {
            context.startActivity(intent);
        } else {
            LoggerUtils.w(TAG, "Could not find appropriate activity to open for deep link " + uri + ".");
        }
    }

    protected void openUriWithActionViewFromPush(Context context, Uri uri, Bundle extras) {
        GroobeeConfigProvider configurationProvider = new GroobeeConfigProvider(context);
        try {
            Intent uriIntent = this.getActionViewIntent(context, uri, extras);
            context.startActivities(this.getIntentArrayWithConfiguredBackStack(context, extras, uriIntent, configurationProvider));
        }
        catch (ActivityNotFoundException e) {
            LoggerUtils.w(TAG, "Could not find appropriate activity to open for deep link " + uri, e);
        }
    }

    protected void openActWithActionViewFromPush(Context context, Intent intent, Bundle extras) {
        GroobeeConfigProvider configurationProvider = new GroobeeConfigProvider(context);
        try {
            context.startActivities(this.getIntentArrayWithConfiguredBackStack(context, extras, intent, configurationProvider));
        }
        catch (ActivityNotFoundException e) {
            LoggerUtils.w(TAG, "Could not find appropriate activity to open ", e);
        }
    }

    protected Intent getActionViewIntent(Context context, Uri uri, Bundle extras) {
        List resolveInfos;
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(uri);
        if (extras != null) {
            intent.putExtras(extras);
        }
        if ((resolveInfos = context.getPackageManager().queryIntentActivities(intent, 0)).size() > 1) {
            for (ResolveInfo resolveInfo : resolveInfos) {
                if (!resolveInfo.activityInfo.packageName.equals(context.getPackageName())) continue;
                LoggerUtils.d(TAG, "Setting deep link activity to " + resolveInfo.activityInfo.packageName + ".");
                intent.setPackage(resolveInfo.activityInfo.packageName);
                break;
            }
        }
        return intent;
    }

    protected Intent[] getIntentArrayWithConfiguredBackStack(Context context, Bundle extras, Intent targetIntent, GroobeeConfigProvider configurationProvider) {
        Intent rootIntent = null;
        if (configurationProvider.getPushMoveActivityEnabled()) {
            String pushDeepLinkBackStackActivityClassName = configurationProvider.getPushMoveActivityClassName();
            if (StringUtils.isNullOrBlank(pushDeepLinkBackStackActivityClassName)) {
                LoggerUtils.i(TAG, "Adding main activity intent to back stack while opening uri from push");
                rootIntent = UriUtils.getMainActivityIntent(context, extras);
            } else if (UriUtils.isActivityRegisteredInManifest(context, pushDeepLinkBackStackActivityClassName)) {
                LoggerUtils.i(TAG, "Adding custom back stack activity while opening uri from push: " + pushDeepLinkBackStackActivityClassName);
                rootIntent = new Intent().setClassName(context, pushDeepLinkBackStackActivityClassName).setFlags(0x10000000).putExtras(extras);
            } else {
                LoggerUtils.i(TAG, "Not adding unregistered activity to the back stack while opening uri from push: " + pushDeepLinkBackStackActivityClassName);
            }
        } else {
            LoggerUtils.i(TAG, "Not adding back stack activity while opening uri from push due to disabled configuration setting.");
        }
        if (rootIntent == null) {
            targetIntent.setFlags(0x10000000);
            return new Intent[]{targetIntent};
        }
        return new Intent[]{rootIntent, targetIntent};
    }
}

