/*
 * Decompiled with CFR 0.152.
 */
package com.groobee.message.providers;

import android.content.Context;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import com.groobee.message.providers.RuntimeConfigProvider;
import com.groobee.message.utils.LoggerUtils;
import com.groobee.message.utils.PackageUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TemporaryConfigProvider {
    private static final String TAG = LoggerUtils.getClassLogTag(TemporaryConfigProvider.class);
    private final Context context;
    protected final Map<String, Object> mConfigTemp;
    protected final RuntimeConfigProvider runtimeConfigProvider;

    public TemporaryConfigProvider(Context context) {
        this.context = context;
        this.mConfigTemp = Collections.synchronizedMap(new HashMap());
        this.runtimeConfigProvider = new RuntimeConfigProvider(context);
    }

    protected String getStringValue(String key, String defaultValue) {
        String result;
        if (this.mConfigTemp.containsKey(key)) {
            result = (String)this.mConfigTemp.get(key);
        } else if (this.runtimeConfigProvider.contains(key)) {
            result = this.runtimeConfigProvider.getData(key, defaultValue);
            this.mConfigTemp.put(key, result);
            LoggerUtils.d(TAG, "Using runtime override value for key: " + key + " and value: " + result);
        } else {
            result = this.readStringResourceValue(key, defaultValue);
            this.mConfigTemp.put(key, result);
            LoggerUtils.d(TAG, "Defaulting to using xml value for key: " + key + " and value: " + result);
        }
        return result;
    }

    protected int getIntValue(String key, int defaultValue) {
        int result;
        if (this.mConfigTemp.containsKey(key)) {
            result = (Integer)this.mConfigTemp.get(key);
        } else if (this.runtimeConfigProvider.contains(key)) {
            result = this.runtimeConfigProvider.getData(key, defaultValue);
            this.mConfigTemp.put(key, result);
            LoggerUtils.d(TAG, "Using runtime override value for key: " + key + " and value: " + result);
        } else {
            result = this.readIntegerResourceValue(key, defaultValue);
            this.mConfigTemp.put(key, result);
            LoggerUtils.d(TAG, "Defaulting to using xml value for key: " + key + " and value: " + result);
        }
        return result;
    }

    protected boolean getBooleanValue(String key, boolean defaultValue) {
        boolean result;
        if (this.mConfigTemp.containsKey(key)) {
            result = (Boolean)this.mConfigTemp.get(key);
        } else if (this.runtimeConfigProvider.contains(key)) {
            result = this.runtimeConfigProvider.getData(key, defaultValue);
            this.mConfigTemp.put(key, result);
            LoggerUtils.d(TAG, "Using runtime override value for key: " + key + " and value: " + result);
        } else {
            result = this.readBooleanResourceValue(key, defaultValue);
            this.mConfigTemp.put(key, result);
            LoggerUtils.d(TAG, "Defaulting to using xml value for key: " + key + " and value: " + result);
        }
        return result;
    }

    protected Set<String> getStringSetValue(String key, Set<String> defaultValue) {
        Set<String> result;
        if (this.mConfigTemp.containsKey(key)) {
            result = (Set<String>)this.mConfigTemp.get(key);
        } else if (this.runtimeConfigProvider.contains(key)) {
            result = this.runtimeConfigProvider.getData(key, defaultValue);
            this.mConfigTemp.put(key, result);
            LoggerUtils.d(TAG, "Using runtime override value for key: " + key + " and value: " + result);
        } else {
            String[] array = this.readStringArrayResourceValue(key, new String[0]);
            result = array.length == 0 ? defaultValue : new HashSet<String>(Arrays.asList(array));
            this.mConfigTemp.put(key, result);
            LoggerUtils.d(TAG, "Defaulting to using xml value for key: " + key + " and value: " + result);
        }
        return result;
    }

    @ColorInt
    @Nullable
    protected Integer getColorValue(String key) {
        Integer result;
        if (this.mConfigTemp.containsKey(key)) {
            result = (Integer)this.mConfigTemp.get(key);
        } else if (this.runtimeConfigProvider.contains(key)) {
            result = this.runtimeConfigProvider.getData(key, 0);
            this.mConfigTemp.put(key, result);
            LoggerUtils.d(TAG, "Using runtime override value for key: " + key + " and value: " + result);
        } else {
            result = this.readColorResourceValue(key);
            if (result != null) {
                this.mConfigTemp.put(key, result);
                LoggerUtils.d(TAG, "Defaulting to using xml value for key: " + key + " and value: " + result);
            }
        }
        return result;
    }

    protected int readIntegerResourceValue(String key, int defaultValue) {
        try {
            if (key == null) {
                return defaultValue;
            }
            int identifier = this.context.getResources().getIdentifier(key, "integer", PackageUtils.getResourcePackageName(this.context));
            if (identifier == 0) {
                LoggerUtils.d(TAG, "Unable to find the xml integer configuration value with key " + key + ". Using default value '" + defaultValue + "'.");
                return defaultValue;
            }
            return this.context.getResources().getInteger(identifier);
        }
        catch (Exception e) {
            LoggerUtils.d(TAG, "Unexpected exception retrieving the xml integer configuration value with key " + key + ". Using default value " + defaultValue + "'.");
            return defaultValue;
        }
    }

    @ColorInt
    protected Integer readColorResourceValue(String key) {
        try {
            if (key == null) {
                return null;
            }
            int identifier = this.context.getResources().getIdentifier(key, "color", PackageUtils.getResourcePackageName(this.context));
            if (identifier == 0) {
                LoggerUtils.d(TAG, "Unable to find the xml color configuration value with key " + key);
                return null;
            }
            return this.context.getResources().getColor(identifier);
        }
        catch (Exception e) {
            LoggerUtils.e(TAG, "Unexpected exception retrieving the xml color configuration value with key " + key + ".", e);
            return null;
        }
    }

    protected boolean readBooleanResourceValue(String key, boolean defaultValue) {
        try {
            if (key == null) {
                return defaultValue;
            }
            int identifier = this.context.getResources().getIdentifier(key, "bool", PackageUtils.getResourcePackageName(this.context));
            if (identifier == 0) {
                LoggerUtils.d(TAG, "Unable to find the xml boolean configuration value with key " + key + ". Using default value '" + defaultValue + "'.");
                return defaultValue;
            }
            return this.context.getResources().getBoolean(identifier);
        }
        catch (Exception e) {
            LoggerUtils.d(TAG, "Unexpected exception retrieving the xml boolean configuration value with key " + key + ". Using default value " + defaultValue + "'.");
            return defaultValue;
        }
    }

    protected String readStringResourceValue(String key, String defaultValue) {
        try {
            if (key == null) {
                return defaultValue;
            }
            int identifier = this.context.getResources().getIdentifier(key, "string", PackageUtils.getResourcePackageName(this.context));
            if (identifier == 0) {
                LoggerUtils.d(TAG, "Unable to find the xml string configuration value with key " + key + ". Using default value '" + defaultValue + "'.");
                return defaultValue;
            }
            return this.context.getResources().getString(identifier);
        }
        catch (Exception e) {
            LoggerUtils.d(TAG, "Unexpected exception retrieving the xml string configuration value with key " + key + ". Using default value " + defaultValue + "'.");
            return defaultValue;
        }
    }

    protected String[] readStringArrayResourceValue(String key, String[] defaultValue) {
        try {
            if (key == null) {
                return defaultValue;
            }
            int identifier = this.context.getResources().getIdentifier(key, "array", PackageUtils.getResourcePackageName(this.context));
            if (identifier == 0) {
                LoggerUtils.d(TAG, "Unable to find the xml string array configuration value with key " + key + ". Using default value '" + Arrays.toString(defaultValue) + "'.");
                return defaultValue;
            }
            return this.context.getResources().getStringArray(identifier);
        }
        catch (Exception e) {
            LoggerUtils.d(TAG, "Unexpected exception retrieving the xml string array configuration value with key " + key + ". Using default value " + Arrays.toString(defaultValue) + "'.");
            return defaultValue;
        }
    }
}

